/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stylebook.printers;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.apache.stylebook.AbstractComponent;
import org.apache.stylebook.CreationContext;
import org.apache.stylebook.CreationException;
import org.apache.stylebook.Printer;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Entity;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Notation;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public class HTMLPrinter
extends AbstractComponent
implements Printer {
    static final String ENCODING = "UTF8";

    public void print(Document document, CreationContext creationContext, OutputStream outputStream) throws CreationException, IOException {
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream, ENCODING));
        this.printDocument(document, bufferedWriter);
        bufferedWriter.flush();
    }

    private void printNodeList(NodeList nodeList, BufferedWriter bufferedWriter) throws IOException {
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node = nodeList.item(n);
            switch (node.getNodeType()) {
                case 2: {
                    this.printAttribute((Attr)node, bufferedWriter);
                    break;
                }
                case 4: {
                    this.printCDATASection((CDATASection)node, bufferedWriter);
                    break;
                }
                case 8: {
                    this.printComment((Comment)node, bufferedWriter);
                    break;
                }
                case 11: {
                    this.printDocumentFragment((DocumentFragment)node, bufferedWriter);
                    break;
                }
                case 9: {
                    this.printDocument((Document)node, bufferedWriter);
                    break;
                }
                case 10: {
                    this.printDocumentType((DocumentType)node, bufferedWriter);
                    break;
                }
                case 1: {
                    this.printElement((Element)node, bufferedWriter);
                    break;
                }
                case 6: {
                    this.printEntity((Entity)node, bufferedWriter);
                    break;
                }
                case 5: {
                    this.printEntityReference((EntityReference)node, bufferedWriter);
                    break;
                }
                case 12: {
                    this.printNotation((Notation)node, bufferedWriter);
                    break;
                }
                case 7: {
                    this.printProcessingInstruction((ProcessingInstruction)node, bufferedWriter);
                    break;
                }
                case 3: {
                    this.printText((Text)node, bufferedWriter);
                }
            }
            ++n;
        }
    }

    private void printAttribute(Attr attr, BufferedWriter bufferedWriter) throws IOException {
        bufferedWriter.write(attr.getName() + "=\"" + attr.getValue() + "\"");
    }

    private void printCDATASection(CDATASection cDATASection, BufferedWriter bufferedWriter) throws IOException {
        this.printString(cDATASection.getData(), bufferedWriter);
    }

    private void printComment(Comment comment, BufferedWriter bufferedWriter) throws IOException {
        bufferedWriter.write("<!--" + comment.getData() + "-->");
    }

    private void printDocumentFragment(DocumentFragment documentFragment, BufferedWriter bufferedWriter) throws IOException {
        bufferedWriter.write("<!-- Document Fragment Node -->");
    }

    private void printDocument(Document document, BufferedWriter bufferedWriter) throws IOException {
        this.printNodeList(document.getChildNodes(), bufferedWriter);
    }

    private void printDocumentType(DocumentType documentType, BufferedWriter bufferedWriter) throws IOException {
        bufferedWriter.write("<!-- DOCTYPE " + documentType.getName() + " -->");
    }

    private void printElement(Element element, BufferedWriter bufferedWriter) throws IOException {
        String string = element.getTagName().toUpperCase();
        bufferedWriter.write("<" + string);
        NamedNodeMap namedNodeMap = element.getAttributes();
        if (null != namedNodeMap && namedNodeMap.getLength() > 0) {
            int n = 0;
            while (n < namedNodeMap.getLength()) {
                bufferedWriter.write(32);
                this.printAttribute((Attr)namedNodeMap.item(n), bufferedWriter);
                ++n;
            }
        }
        bufferedWriter.write(">");
        if (null != element.getChildNodes() && element.getChildNodes().getLength() > 0) {
            this.printNodeList(element.getChildNodes(), bufferedWriter);
        }
        if (string.equals("AREA")) {
            return;
        }
        if (string.equals("BASE")) {
            return;
        }
        if (string.equals("BASEFONT")) {
            return;
        }
        if (string.equals("BR")) {
            return;
        }
        if (string.equals("COL")) {
            return;
        }
        if (string.equals("FRAME")) {
            return;
        }
        if (string.equals("HR")) {
            return;
        }
        if (string.equals("IMG")) {
            return;
        }
        if (string.equals("INPUT")) {
            return;
        }
        if (string.equals("ISINDEX")) {
            return;
        }
        if (string.equals("LINK")) {
            return;
        }
        if (string.equals("META")) {
            return;
        }
        if (string.equals("PARAM")) {
            return;
        }
        bufferedWriter.write("</" + string + ">");
    }

    private void printEntity(Entity entity, BufferedWriter bufferedWriter) throws IOException {
        bufferedWriter.write("<!-- Entity Node -->");
    }

    private void printEntityReference(EntityReference entityReference, BufferedWriter bufferedWriter) throws IOException {
        this.printString(entityReference.getFirstChild().getNodeValue(), bufferedWriter);
    }

    private void printNotation(Notation notation, BufferedWriter bufferedWriter) throws IOException {
        bufferedWriter.write("<!-- Notation Node -->");
    }

    private void printProcessingInstruction(ProcessingInstruction processingInstruction, BufferedWriter bufferedWriter) throws IOException {
        bufferedWriter.write("<!-- PI:" + processingInstruction.getTarget() + " " + processingInstruction.getData() + "-->");
    }

    private void printText(Text text, BufferedWriter bufferedWriter) throws IOException {
        this.printString(text.getData(), bufferedWriter);
    }

    private void printString(String string, BufferedWriter bufferedWriter) throws IOException {
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c == '\n') {
                bufferedWriter.write("\n");
            } else if (c == '\"') {
                bufferedWriter.write("&quot;");
            } else if (c == '&') {
                bufferedWriter.write("&amp;");
            } else if (c == '<') {
                bufferedWriter.write("&lt;");
            } else if (c == '>') {
                bufferedWriter.write("&gt;");
            } else if (c == '\u20ac') {
                bufferedWriter.write("&euro;");
            } else if (c >= '\u00a0' && c <= '\u00ff') {
                switch (c) {
                    case '\u00a0': {
                        bufferedWriter.write("&nbsp;");
                        break;
                    }
                    case '\u00a1': {
                        bufferedWriter.write("&iexcl;");
                        break;
                    }
                    case '\u00a2': {
                        bufferedWriter.write("&cent;");
                        break;
                    }
                    case '\u00a3': {
                        bufferedWriter.write("&pound;");
                        break;
                    }
                    case '\u00a4': {
                        bufferedWriter.write("&curren;");
                        break;
                    }
                    case '\u00a5': {
                        bufferedWriter.write("&yen;");
                        break;
                    }
                    case '\u00a6': {
                        bufferedWriter.write("&brvbar;");
                        break;
                    }
                    case '\u00a7': {
                        bufferedWriter.write("&sect;");
                        break;
                    }
                    case '\u00a8': {
                        bufferedWriter.write("&uml;");
                        break;
                    }
                    case '\u00a9': {
                        bufferedWriter.write("&copy;");
                        break;
                    }
                    case '\u00aa': {
                        bufferedWriter.write("&ordf;");
                        break;
                    }
                    case '\u00ab': {
                        bufferedWriter.write("&laquo;");
                        break;
                    }
                    case '\u00ac': {
                        bufferedWriter.write("&not;");
                        break;
                    }
                    case '\u00ad': {
                        bufferedWriter.write("&shy;");
                        break;
                    }
                    case '\u00ae': {
                        bufferedWriter.write("&reg;");
                        break;
                    }
                    case '\u00af': {
                        bufferedWriter.write("&macr;");
                        break;
                    }
                    case '\u00b0': {
                        bufferedWriter.write("&deg;");
                        break;
                    }
                    case '\u00b1': {
                        bufferedWriter.write("&plusmn;");
                        break;
                    }
                    case '\u00b2': {
                        bufferedWriter.write("&sup2;");
                        break;
                    }
                    case '\u00b3': {
                        bufferedWriter.write("&sup3;");
                        break;
                    }
                    case '\u00b4': {
                        bufferedWriter.write("&acute;");
                        break;
                    }
                    case '\u00b5': {
                        bufferedWriter.write("&micro;");
                        break;
                    }
                    case '\u00b6': {
                        bufferedWriter.write("&para;");
                        break;
                    }
                    case '\u00b7': {
                        bufferedWriter.write("&middot;");
                        break;
                    }
                    case '\u00b8': {
                        bufferedWriter.write("&cedil;");
                        break;
                    }
                    case '\u00b9': {
                        bufferedWriter.write("&sup1;");
                        break;
                    }
                    case '\u00ba': {
                        bufferedWriter.write("&ordm;");
                        break;
                    }
                    case '\u00bb': {
                        bufferedWriter.write("&raquo;");
                        break;
                    }
                    case '\u00bc': {
                        bufferedWriter.write("&frac14;");
                        break;
                    }
                    case '\u00bd': {
                        bufferedWriter.write("&frac12;");
                        break;
                    }
                    case '\u00be': {
                        bufferedWriter.write("&frac34;");
                        break;
                    }
                    case '\u00bf': {
                        bufferedWriter.write("&iquest;");
                        break;
                    }
                    case '\u00c0': {
                        bufferedWriter.write("&Agrave;");
                        break;
                    }
                    case '\u00c1': {
                        bufferedWriter.write("&Aacute;");
                        break;
                    }
                    case '\u00c2': {
                        bufferedWriter.write("&Acirc;");
                        break;
                    }
                    case '\u00c3': {
                        bufferedWriter.write("&Atilde;");
                        break;
                    }
                    case '\u00c4': {
                        bufferedWriter.write("&Auml;");
                        break;
                    }
                    case '\u00c5': {
                        bufferedWriter.write("&Aring;");
                        break;
                    }
                    case '\u00c6': {
                        bufferedWriter.write("&AElig;");
                        break;
                    }
                    case '\u00c7': {
                        bufferedWriter.write("&Ccedil;");
                        break;
                    }
                    case '\u00c8': {
                        bufferedWriter.write("&Egrave;");
                        break;
                    }
                    case '\u00c9': {
                        bufferedWriter.write("&Eacute;");
                        break;
                    }
                    case '\u00ca': {
                        bufferedWriter.write("&Ecirc;");
                        break;
                    }
                    case '\u00cb': {
                        bufferedWriter.write("&Euml;");
                        break;
                    }
                    case '\u00cc': {
                        bufferedWriter.write("&Igrave;");
                        break;
                    }
                    case '\u00cd': {
                        bufferedWriter.write("&Iacute;");
                        break;
                    }
                    case '\u00ce': {
                        bufferedWriter.write("&Icirc;");
                        break;
                    }
                    case '\u00cf': {
                        bufferedWriter.write("&Iuml;");
                        break;
                    }
                    case '\u00d0': {
                        bufferedWriter.write("&ETH;");
                        break;
                    }
                    case '\u00d1': {
                        bufferedWriter.write("&Ntilde;");
                        break;
                    }
                    case '\u00d2': {
                        bufferedWriter.write("&Ograve;");
                        break;
                    }
                    case '\u00d3': {
                        bufferedWriter.write("&Oacute;");
                        break;
                    }
                    case '\u00d4': {
                        bufferedWriter.write("&Ocirc;");
                        break;
                    }
                    case '\u00d5': {
                        bufferedWriter.write("&Otilde;");
                        break;
                    }
                    case '\u00d6': {
                        bufferedWriter.write("&Ouml;");
                        break;
                    }
                    case '\u00d7': {
                        bufferedWriter.write("&times;");
                        break;
                    }
                    case '\u00d8': {
                        bufferedWriter.write("&Oslash;");
                        break;
                    }
                    case '\u00d9': {
                        bufferedWriter.write("&Ugrave;");
                        break;
                    }
                    case '\u00da': {
                        bufferedWriter.write("&Uacute;");
                        break;
                    }
                    case '\u00db': {
                        bufferedWriter.write("&Ucirc;");
                        break;
                    }
                    case '\u00dc': {
                        bufferedWriter.write("&Uuml;");
                        break;
                    }
                    case '\u00dd': {
                        bufferedWriter.write("&Yacute;");
                        break;
                    }
                    case '\u00de': {
                        bufferedWriter.write("&THORN;");
                        break;
                    }
                    case '\u00df': {
                        bufferedWriter.write("&szlig;");
                        break;
                    }
                    case '\u00e0': {
                        bufferedWriter.write("&agrave;");
                        break;
                    }
                    case '\u00e1': {
                        bufferedWriter.write("&aacute;");
                        break;
                    }
                    case '\u00e2': {
                        bufferedWriter.write("&acirc;");
                        break;
                    }
                    case '\u00e3': {
                        bufferedWriter.write("&atilde;");
                        break;
                    }
                    case '\u00e4': {
                        bufferedWriter.write("&auml;");
                        break;
                    }
                    case '\u00e5': {
                        bufferedWriter.write("&aring;");
                        break;
                    }
                    case '\u00e6': {
                        bufferedWriter.write("&aelig;");
                        break;
                    }
                    case '\u00e7': {
                        bufferedWriter.write("&ccedil;");
                        break;
                    }
                    case '\u00e8': {
                        bufferedWriter.write("&egrave;");
                        break;
                    }
                    case '\u00e9': {
                        bufferedWriter.write("&eacute;");
                        break;
                    }
                    case '\u00ea': {
                        bufferedWriter.write("&ecirc;");
                        break;
                    }
                    case '\u00eb': {
                        bufferedWriter.write("&euml;");
                        break;
                    }
                    case '\u00ec': {
                        bufferedWriter.write("&igrave;");
                        break;
                    }
                    case '\u00ed': {
                        bufferedWriter.write("&iacute;");
                        break;
                    }
                    case '\u00ee': {
                        bufferedWriter.write("&icirc;");
                        break;
                    }
                    case '\u00ef': {
                        bufferedWriter.write("&iuml;");
                        break;
                    }
                    case '\u00f0': {
                        bufferedWriter.write("&eth;");
                        break;
                    }
                    case '\u00f1': {
                        bufferedWriter.write("&ntilde;");
                        break;
                    }
                    case '\u00f2': {
                        bufferedWriter.write("&ograve;");
                        break;
                    }
                    case '\u00f3': {
                        bufferedWriter.write("&oacute;");
                        break;
                    }
                    case '\u00f4': {
                        bufferedWriter.write("&ocirc;");
                        break;
                    }
                    case '\u00f5': {
                        bufferedWriter.write("&otilde;");
                        break;
                    }
                    case '\u00f6': {
                        bufferedWriter.write("&ouml;");
                        break;
                    }
                    case '\u00f7': {
                        bufferedWriter.write("&divide;");
                        break;
                    }
                    case '\u00f8': {
                        bufferedWriter.write("&oslash;");
                        break;
                    }
                    case '\u00f9': {
                        bufferedWriter.write("&ugrave;");
                        break;
                    }
                    case '\u00fa': {
                        bufferedWriter.write("&uacute;");
                        break;
                    }
                    case '\u00fb': {
                        bufferedWriter.write("&ucirc;");
                        break;
                    }
                    case '\u00fc': {
                        bufferedWriter.write("&uuml;");
                        break;
                    }
                    case '\u00fd': {
                        bufferedWriter.write("&yacute;");
                        break;
                    }
                    case '\u00fe': {
                        bufferedWriter.write("&thorn;");
                        break;
                    }
                    case '\u00ff': {
                        bufferedWriter.write("&yuml;");
                    }
                }
            } else {
                bufferedWriter.write(c);
            }
            ++n;
        }
    }
}

