/*
 * Decompiled with CFR 0.152.
 */
package xalanjdoc;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.PackageDoc;
import com.sun.tools.doclets.DirectoryManager;
import com.sun.tools.doclets.DocletAbortException;
import com.sun.tools.doclets.SourcePath;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import xalanjdoc.AbstractPackageWriter;
import xalanjdoc.ConfigurationStandard;
import xalanjdoc.HtmlStandardWriter;
import xalanjdoc.Standard;

public class PackageWriter
extends AbstractPackageWriter {
    protected PackageDoc prev;
    protected PackageDoc next;

    public PackageWriter(String path, String filename, PackageDoc packagedoc, PackageDoc prev, PackageDoc next) throws IOException, DocletAbortException {
        super(path, filename, packagedoc);
        this.prev = prev;
        this.next = next;
    }

    protected void copyDocFiles(String path) throws DocletAbortException {
        SourcePath sourcePath = new SourcePath(Standard.configuration().sourcepath);
        String docfilesdir = String.valueOf(path) + "/" + "doc-files";
        File sourcedir = sourcePath.getDirectory(docfilesdir);
        if (sourcedir == null) {
            return;
        }
        String destname = HtmlStandardWriter.destdir;
        if (destname.length() > 0 && !destname.endsWith("/")) {
            destname = String.valueOf(destname) + "/";
        }
        String src = sourcedir.toString();
        String dest = String.valueOf(destname) + path + "/" + "doc-files";
        try {
            File srcdir = new File(src);
            File destdir = new File(dest);
            DirectoryManager.createDirectory((String)dest);
            String[] files = srcdir.list();
            int i = 0;
            while (i < files.length) {
                File srcfile = new File(srcdir, files[i]);
                File destfile = new File(destdir, files[i]);
                if (srcfile.isFile()) {
                    this.notice("doclet.Copying_File_0_To_Dir_1", srcfile.toString(), destdir.toString());
                    Standard.copyFile(destfile, srcfile);
                }
                ++i;
            }
        }
        catch (SecurityException securityException) {
            throw new DocletAbortException();
        }
        catch (IOException iOException) {
            throw new DocletAbortException();
        }
    }

    public static void generate(PackageDoc pkg, PackageDoc prev, PackageDoc next) throws DocletAbortException {
        String path = DirectoryManager.getDirectoryPath((PackageDoc)pkg);
        String filename = "package-summary.html";
        try {
            PackageWriter packgen = new PackageWriter(path, filename, pkg, prev, next);
            packgen.generatePackageFile();
            ((PrintWriter)((Object)packgen)).close();
            packgen.copyDocFiles(path);
        }
        catch (IOException exc) {
            Standard.configuration();
            ConfigurationStandard.standardmessage.error("doclet.exception_encountered", exc.toString(), filename);
            throw new DocletAbortException();
        }
    }

    protected void generateClassKindListing(ClassDoc[] arr, String label) {
        if (arr.length > 0) {
            Arrays.sort(arr);
            this.tableIndexSummary();
            this.printFirstRow(label);
            int i = 0;
            while (i < arr.length) {
                boolean deprecated;
                boolean bl = deprecated = arr[i].tags("deprecated").length > 0;
                if (!(Standard.configuration().nodeprecated && deprecated || !this.isCoreClass(arr[i]))) {
                    this.trBgcolorStyle("white", "TableRowColor");
                    this.summaryRow(15);
                    this.bold();
                    this.printClassLinkForSameDir(arr[i]);
                    this.boldEnd();
                    this.summaryRowEnd();
                    this.summaryRow(0);
                    if (deprecated) {
                        this.boldText("doclet.Deprecated");
                        this.space();
                        this.printSummaryDeprecatedComment(arr[i].tags("deprecated")[0]);
                    } else {
                        this.printSummaryComment((Doc)arr[i]);
                    }
                    this.summaryRowEnd();
                    this.trEnd();
                }
                ++i;
            }
            this.tableEnd();
            ((PrintWriter)((Object)this)).println("&nbsp;");
            this.p();
        }
    }

    protected void generateClassListing() {
        this.generateClassKindListing(this.packagedoc.interfaces(), this.getText("doclet.Interface_Summary"));
        this.generateClassKindListing(this.packagedoc.ordinaryClasses(), this.getText("doclet.Class_Summary"));
        this.generateClassKindListing(this.packagedoc.exceptions(), this.getText("doclet.Exception_Summary"));
        this.generateClassKindListing(this.packagedoc.errors(), this.getText("doclet.Error_Summary"));
    }

    protected void navLinkClassUse() {
        this.navCellStart();
        this.printHyperLink("package-use.html", "", this.getText("doclet.navClassUse"), true, "NavBarFont1");
        this.navCellEnd();
    }

    protected void navLinkNext() {
        if (this.next == null) {
            this.printText("doclet.Next_Package");
        } else {
            String path = DirectoryManager.getRelativePath((String)this.packagedoc.name(), (String)this.next.name());
            this.printHyperLink(String.valueOf(path) + "package-summary.html", "", this.getText("doclet.Next_Package"), true);
        }
    }

    protected void navLinkPrevious() {
        if (this.prev == null) {
            this.printText("doclet.Prev_Package");
        } else {
            String path = DirectoryManager.getRelativePath((String)this.packagedoc.name(), (String)this.prev.name());
            this.printHyperLink(String.valueOf(path) + "package-summary.html", "", this.getText("doclet.Prev_Package"), true);
        }
    }

    protected void navLinkTree() {
        this.navCellStart();
        this.printHyperLink("package-tree.html", "", this.getText("doclet.Tree"), true, "NavBarFont1");
        this.navCellEnd();
    }

    protected void printFirstRow(String label) {
        this.tableHeaderStart("#CCCCFF");
        this.bold(label);
        this.tableHeaderEnd();
    }

    protected void printPackageComment() {
        if (this.packagedoc.inlineTags().length > 0) {
            this.anchor("package_description");
            this.h2(this.getText("doclet.Package_Description", this.packagedoc.name()));
            this.p();
            this.printInlineComment((Doc)this.packagedoc);
            this.p();
        }
    }

    protected void printPackageDescription() throws IOException {
        this.printPackageComment();
        this.generateTagInfo((Doc)this.packagedoc);
    }

    protected void printPackageFooter() {
        this.hr();
        this.navLinks(false);
        this.printBottom();
    }

    protected void printPackageHeader(String heading) {
        this.navLinks(true);
        this.hr();
        this.h2(String.valueOf(this.getText("doclet.Package")) + " " + heading);
        if (this.packagedoc.inlineTags().length > 0) {
            this.printSummaryComment((Doc)this.packagedoc);
            this.p();
            this.bold(this.getText("doclet.See"));
            this.br();
            this.printNbsps();
            this.printHyperLink("", "package_description", this.getText("doclet.Description"), true);
            this.p();
        }
    }
}

