/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.serialize;

import java.io.OutputStream;
import java.io.Writer;
import org.apache.xml.serialize.BaseMarkupSerializer;
import org.apache.xml.serialize.ElementState;
import org.apache.xml.serialize.HTMLdtd;
import org.apache.xml.serialize.OutputFormat;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.AttributeList;
import org.xml.sax.Attributes;

public class HTMLSerializer
extends BaseMarkupSerializer {
    private static boolean _xhtml;
    public static String XHTMLNamespace;

    static {
        XHTMLNamespace = "";
    }

    public HTMLSerializer() {
        this(false, new OutputFormat("html", null, false));
    }

    public HTMLSerializer(OutputStream outputStream, OutputFormat outputFormat) {
        this(false, outputFormat != null ? outputFormat : new OutputFormat("html", null, false));
        this.setOutputByteStream(outputStream);
    }

    public HTMLSerializer(Writer writer, OutputFormat outputFormat) {
        this(false, outputFormat != null ? outputFormat : new OutputFormat("html", null, false));
        this.setOutputCharStream(writer);
    }

    public HTMLSerializer(OutputFormat outputFormat) {
        this(false, outputFormat != null ? outputFormat : new OutputFormat("html", null, false));
    }

    protected HTMLSerializer(boolean bl, OutputFormat outputFormat) {
        super(outputFormat);
        _xhtml = bl;
    }

    protected void characters(String string) {
        ElementState elementState = this.content();
        elementState.doCData = false;
        super.characters(string);
    }

    public void characters(char[] cArray, int n, int n2) {
        ElementState elementState = this.content();
        elementState.doCData = false;
        super.characters(cArray, n, n2);
    }

    public void endElement(String string) {
        this.endElement(null, null, string);
    }

    public void endElement(String string, String string2, String string3) {
        this._printer.unindent();
        ElementState elementState = this.getElementState();
        String string4 = elementState.namespaceURI == null ? elementState.rawName : (elementState.namespaceURI.equals(XHTMLNamespace) ? elementState.localName : null);
        if (_xhtml) {
            if (elementState.empty) {
                this._printer.printText(" />");
            } else {
                if (elementState.inCData) {
                    this._printer.printText("]]>");
                }
                this._printer.printText("</");
                this._printer.printText(elementState.rawName.toLowerCase());
                this._printer.printText('>');
            }
        } else {
            if (elementState.empty) {
                this._printer.printText('>');
            }
            if (string4 == null || !HTMLdtd.isOnlyOpening(string4)) {
                if (this._indenting && !elementState.preserveSpace && elementState.afterElement) {
                    this._printer.breakLine();
                }
                if (elementState.inCData) {
                    this._printer.printText("]]>");
                }
                this._printer.printText("</");
                this._printer.printText(elementState.rawName);
                this._printer.printText('>');
            }
        }
        elementState = this.leaveElementState();
        if (string4 == null || !string4.equalsIgnoreCase("A") && !string4.equalsIgnoreCase("TD")) {
            elementState.afterElement = true;
        }
        elementState.empty = false;
        if (this.isDocumentState()) {
            this._printer.flush();
        }
    }

    protected String escapeURI(String string) {
        int n = string.indexOf("\"");
        if (n >= 0) {
            return string.substring(0, n);
        }
        return string;
    }

    protected String getEntityRef(char c) {
        return HTMLdtd.fromChar(c);
    }

    protected void serializeElement(Element element) {
        String string = element.getTagName();
        ElementState elementState = this.getElementState();
        if (this.isDocumentState()) {
            if (!this._started) {
                this.startDocument(string);
            }
        } else {
            if (elementState.empty) {
                this._printer.printText('>');
            }
            if (this._indenting && !elementState.preserveSpace && (elementState.empty || elementState.afterElement)) {
                this._printer.breakLine();
            }
        }
        boolean bl = elementState.preserveSpace;
        this._printer.printText('<');
        if (_xhtml) {
            this._printer.printText(string.toLowerCase());
        } else {
            this._printer.printText(string);
        }
        this._printer.indent();
        NamedNodeMap namedNodeMap = element.getAttributes();
        if (namedNodeMap != null) {
            int n = 0;
            while (n < namedNodeMap.getLength()) {
                Attr attr = (Attr)namedNodeMap.item(n);
                String string2 = attr.getName().toLowerCase();
                String string3 = attr.getValue();
                if (attr.getSpecified()) {
                    this._printer.printSpace();
                    if (_xhtml) {
                        if (string3 == null) {
                            this._printer.printText(string2);
                            this._printer.printText("=\"\"");
                        } else {
                            this._printer.printText(string2);
                            this._printer.printText("=\"");
                            this.printEscaped(string3);
                            this._printer.printText('\"');
                        }
                    } else if (string3 == null || string3.length() == 0) {
                        this._printer.printText(string2);
                    } else if (HTMLdtd.isURI(string, string2)) {
                        this._printer.printText(string2);
                        this._printer.printText("=\"");
                        this._printer.printText(this.escapeURI(string3));
                        this._printer.printText('\"');
                    } else if (HTMLdtd.isBoolean(string, string2)) {
                        this._printer.printText(string2);
                    } else {
                        this._printer.printText(string2);
                        this._printer.printText("=\"");
                        this.printEscaped(string3);
                        this._printer.printText('\"');
                    }
                }
                ++n;
            }
        }
        if (HTMLdtd.isPreserveSpace(string)) {
            bl = true;
        }
        if (element.hasChildNodes() || !HTMLdtd.isEmptyTag(string)) {
            elementState = this.enterElementState(null, null, string, bl);
            if (string.equalsIgnoreCase("A") || string.equalsIgnoreCase("TD")) {
                elementState.empty = false;
                this._printer.printText('>');
            }
            if (string.equalsIgnoreCase("SCRIPT") || string.equalsIgnoreCase("STYLE")) {
                if (_xhtml) {
                    elementState.doCData = true;
                } else {
                    elementState.unescaped = true;
                }
            }
            Node node = element.getFirstChild();
            while (node != null) {
                this.serializeNode(node);
                node = node.getNextSibling();
            }
            this.endElement(null, null, string);
        } else {
            this._printer.unindent();
            if (_xhtml) {
                this._printer.printText(" />");
            } else {
                this._printer.printText('>');
            }
            elementState.afterElement = true;
            elementState.empty = false;
            if (this.isDocumentState()) {
                this._printer.flush();
            }
        }
    }

    public void setOutputFormat(OutputFormat outputFormat) {
        super.setOutputFormat(outputFormat != null ? outputFormat : new OutputFormat("html", null, false));
    }

    protected void startDocument(String string) {
        this._printer.leaveDTD();
        if (!this._started) {
            if (this._docTypePublicId == null && this._docTypeSystemId == null) {
                if (_xhtml) {
                    this._docTypePublicId = "-//W3C//DTD XHTML 1.0 Strict//EN";
                    this._docTypeSystemId = "http://www.w3.org/TR/WD-html-in-xml/DTD/xhtml1-strict.dtd";
                } else {
                    this._docTypePublicId = "-//W3C//DTD HTML 4.0//EN";
                    this._docTypeSystemId = "http://www.w3.org/TR/WD-html-in-xml/DTD/xhtml1-strict.dtd";
                }
            }
            if (!this._format.getOmitDocumentType()) {
                if (!(this._docTypePublicId == null || _xhtml && this._docTypeSystemId == null)) {
                    this._printer.printText("<!DOCTYPE HTML PUBLIC ");
                    this.printDoctypeURL(this._docTypePublicId);
                    if (this._docTypeSystemId != null) {
                        if (this._indenting) {
                            this._printer.breakLine();
                            this._printer.printText("                      ");
                        } else {
                            this._printer.printText(' ');
                        }
                        this.printDoctypeURL(this._docTypeSystemId);
                    }
                    this._printer.printText('>');
                    this._printer.breakLine();
                } else if (this._docTypeSystemId != null) {
                    this._printer.printText("<!DOCTYPE HTML SYSTEM ");
                    this.printDoctypeURL(this._docTypeSystemId);
                    this._printer.printText('>');
                    this._printer.breakLine();
                }
            }
        }
        this._started = true;
        this.serializePreRoot();
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) {
        String string4;
        String string5;
        Object object;
        boolean bl = false;
        if (this._printer == null) {
            throw new IllegalStateException("SER002 No writer supplied for serializer");
        }
        ElementState elementState = this.getElementState();
        if (this.isDocumentState()) {
            if (!this._started) {
                this.startDocument(string2 == null ? string3 : string2);
            }
        } else {
            if (elementState.empty) {
                this._printer.printText('>');
            }
            if (this._indenting && !elementState.preserveSpace && (elementState.empty || elementState.afterElement)) {
                this._printer.breakLine();
            }
        }
        boolean bl2 = elementState.preserveSpace;
        if (string3 == null) {
            string3 = string2;
            if (string != null && ((String)(object = this.getPrefix(string))).length() > 0) {
                string3 = String.valueOf(object) + ":" + string2;
            }
            bl = true;
        }
        String string6 = string == null ? string3 : (string.equals(XHTMLNamespace) ? string2 : null);
        this._printer.printText('<');
        if (_xhtml) {
            this._printer.printText(string3.toLowerCase());
        } else {
            this._printer.printText(string3);
        }
        this._printer.indent();
        if (attributes != null) {
            int n = 0;
            while (n < attributes.getLength()) {
                this._printer.printSpace();
                string5 = attributes.getQName(n).toLowerCase();
                string4 = attributes.getValue(n);
                if (_xhtml || string != null) {
                    if (string4 == null) {
                        this._printer.printText(string5);
                        this._printer.printText("=\"\"");
                    } else {
                        this._printer.printText(string5);
                        this._printer.printText("=\"");
                        this.printEscaped(string4);
                        this._printer.printText('\"');
                    }
                } else if (string4 == null || string4.length() == 0) {
                    this._printer.printText(string5);
                } else if (HTMLdtd.isURI(string3, string5)) {
                    this._printer.printText(string5);
                    this._printer.printText("=\"");
                    this._printer.printText(this.escapeURI(string4));
                    this._printer.printText('\"');
                } else if (HTMLdtd.isBoolean(string3, string5)) {
                    this._printer.printText(string5);
                } else {
                    this._printer.printText(string5);
                    this._printer.printText("=\"");
                    this.printEscaped(string4);
                    this._printer.printText('\"');
                }
                ++n;
            }
        }
        if (string6 != null && HTMLdtd.isPreserveSpace(string6)) {
            bl2 = true;
        }
        if (bl) {
            object = this._prefixes.keys();
            while (object.hasMoreElements()) {
                this._printer.printSpace();
                string4 = (String)object.nextElement();
                string5 = (String)this._prefixes.get(string4);
                if (string5.length() == 0) {
                    this._printer.printText("xmlns=\"");
                    this.printEscaped(string4);
                    this._printer.printText('\"');
                    continue;
                }
                this._printer.printText("xmlns:");
                this._printer.printText(string5);
                this._printer.printText("=\"");
                this.printEscaped(string4);
                this._printer.printText('\"');
            }
        }
        elementState = this.enterElementState(string, string2, string3, bl2);
        if (string6 != null && (string6.equalsIgnoreCase("A") || string6.equalsIgnoreCase("TD"))) {
            elementState.empty = false;
            this._printer.printText('>');
        }
        if (string6 != null && (string3.equalsIgnoreCase("SCRIPT") || string3.equalsIgnoreCase("STYLE"))) {
            if (_xhtml) {
                elementState.doCData = true;
            } else {
                elementState.unescaped = true;
            }
        }
    }

    public void startElement(String string, AttributeList attributeList) {
        if (this._printer == null) {
            throw new IllegalStateException("SER002 No writer supplied for serializer");
        }
        ElementState elementState = this.getElementState();
        if (this.isDocumentState()) {
            if (!this._started) {
                this.startDocument(string);
            }
        } else {
            if (elementState.empty) {
                this._printer.printText('>');
            }
            if (this._indenting && !elementState.preserveSpace && (elementState.empty || elementState.afterElement)) {
                this._printer.breakLine();
            }
        }
        boolean bl = elementState.preserveSpace;
        this._printer.printText('<');
        if (_xhtml) {
            this._printer.printText(string.toLowerCase());
        } else {
            this._printer.printText(string);
        }
        this._printer.indent();
        if (attributeList != null) {
            int n = 0;
            while (n < attributeList.getLength()) {
                this._printer.printSpace();
                String string2 = attributeList.getName(n).toLowerCase();
                String string3 = attributeList.getValue(n);
                if (_xhtml) {
                    if (string3 == null) {
                        this._printer.printText(string2);
                        this._printer.printText("=\"\"");
                    } else {
                        this._printer.printText(string2);
                        this._printer.printText("=\"");
                        this.printEscaped(string3);
                        this._printer.printText('\"');
                    }
                } else if (string3 == null || string3.length() == 0) {
                    this._printer.printText(string2);
                } else if (HTMLdtd.isURI(string, string2)) {
                    this._printer.printText(string2);
                    this._printer.printText("=\"");
                    this._printer.printText(this.escapeURI(string3));
                    this._printer.printText('\"');
                } else if (HTMLdtd.isBoolean(string, string2)) {
                    this._printer.printText(string2);
                } else {
                    this._printer.printText(string2);
                    this._printer.printText("=\"");
                    this.printEscaped(string3);
                    this._printer.printText('\"');
                }
                ++n;
            }
        }
        if (HTMLdtd.isPreserveSpace(string)) {
            bl = true;
        }
        elementState = this.enterElementState(null, null, string, bl);
        if (string.equalsIgnoreCase("A") || string.equalsIgnoreCase("TD")) {
            elementState.empty = false;
            this._printer.printText('>');
        }
        if (string.equalsIgnoreCase("SCRIPT") || string.equalsIgnoreCase("STYLE")) {
            if (_xhtml) {
                elementState.doCData = true;
            } else {
                elementState.unescaped = true;
            }
        }
    }
}

