/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.FileSet;

public class UpToDate
extends MatchingTask {
    private String _property;
    private File _targetFile;
    private Vector sourceFileSets = new Vector();

    public void addSrcfiles(FileSet fs) {
        this.sourceFileSets.addElement(fs);
    }

    public void execute() throws BuildException {
        if (this.sourceFileSets.size() == 0) {
            throw new BuildException("At least one <srcfiles> element must be set");
        }
        if (this._targetFile == null) {
            throw new BuildException("The targetfile attribute must be set");
        }
        if (!this._targetFile.exists()) {
            return;
        }
        Enumeration enumeration = this.sourceFileSets.elements();
        boolean upToDate = true;
        while (upToDate && enumeration.hasMoreElements()) {
            FileSet fs = (FileSet)enumeration.nextElement();
            DirectoryScanner ds = fs.getDirectoryScanner(this.project);
            boolean bl = upToDate = upToDate && this.scanDir(fs.getDir(this.project), this._targetFile, ds.getIncludedFiles());
        }
        if (upToDate) {
            this.project.setProperty(this._property, "true");
            this.log("File \"" + this._targetFile.getAbsolutePath() + "\" is up to date.", 3);
        }
    }

    protected boolean scanDir(File srcDir, File destFile, String[] files) {
        long now;
        long destLastModified = destFile.lastModified();
        if (destLastModified > (now = new Date().getTime())) {
            this.log("Warning: destfile modified in the future: " + destFile.getPath(), 1);
        }
        int i = 0;
        while (i < files.length) {
            File srcFile = new File(srcDir, files[i]);
            long srcLastModified = srcFile.lastModified();
            if (srcLastModified > now) {
                this.log("Warning: file modified in the future: " + files[i], 1);
            }
            if (srcLastModified > destLastModified) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void setProperty(String property) {
        this._property = property;
    }

    public void setTargetFile(File file) {
        this._targetFile = file;
    }
}

