/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.jclasslib.bytecode;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.gjt.jclasslib.bytecode.MatchOffsetPair;
import org.gjt.jclasslib.bytecode.PaddedInstruction;
import org.gjt.jclasslib.io.ByteCodeInput;
import org.gjt.jclasslib.io.ByteCodeOutput;

public class LookupSwitchInstruction
extends PaddedInstruction {
    private int defaultOffset;
    private List matchOffsetPairs = new ArrayList();

    public LookupSwitchInstruction(int n) {
        super(n);
    }

    public int getSize() {
        return super.getSize() + 8 + 8 * this.matchOffsetPairs.size();
    }

    public int getDefaultOffset() {
        return this.defaultOffset;
    }

    public void setDefaultOffset(int n) {
        this.defaultOffset = n;
    }

    public List getMatchOffsetPairs() {
        return this.matchOffsetPairs;
    }

    public void setMatchOffsetPairs(List list) {
        this.matchOffsetPairs = list;
    }

    public void read(ByteCodeInput byteCodeInput) throws IOException {
        super.read(byteCodeInput);
        this.matchOffsetPairs.clear();
        this.defaultOffset = byteCodeInput.readInt();
        int n = byteCodeInput.readInt();
        int n2 = 0;
        while (n2 < n) {
            int n3 = byteCodeInput.readInt();
            int n4 = byteCodeInput.readInt();
            this.matchOffsetPairs.add(new MatchOffsetPair(n3, n4));
            ++n2;
        }
    }

    public void write(ByteCodeOutput byteCodeOutput) throws IOException {
        super.write(byteCodeOutput);
        byteCodeOutput.writeInt(this.defaultOffset);
        int n = this.matchOffsetPairs.size();
        byteCodeOutput.writeInt(n);
        int n2 = 0;
        while (n2 < n) {
            MatchOffsetPair matchOffsetPair = (MatchOffsetPair)this.matchOffsetPairs.get(n2);
            byteCodeOutput.writeInt(matchOffsetPair.getMatch());
            byteCodeOutput.writeInt(matchOffsetPair.getOffset());
            ++n2;
        }
    }
}

