/*
 * Decompiled with CFR 0.152.
 */
package jde.debugger;

import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.InvocationException;
import com.sun.jdi.NativeMethodException;
import com.sun.jdi.StackFrame;
import com.sun.jdi.Value;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import jde.debugger.JDEException;
import jde.debugger.JDENumberFormatException;
import jde.debugger.expr.ExpressionParser;
import jde.debugger.expr.ParseException;

public class Etc {
    public static void dump(Object object) {
        if (object instanceof Collection) {
            Iterator iterator = ((Collection)object).iterator();
            while (iterator.hasNext()) {
                System.out.println(iterator.next());
            }
        } else if (object instanceof Object[]) {
            Object[] objectArray = (Object[])object;
            int n = 0;
            while (n < objectArray.length) {
                Etc.dump(objectArray[n]);
                ++n;
            }
        } else {
            System.out.println(object);
        }
    }

    public static Long safeGetLong(Object object, String string) throws JDEException {
        try {
            return new Long(object.toString());
        }
        catch (NumberFormatException numberFormatException) {
            throw new JDENumberFormatException(string);
        }
    }

    public static int safeGetint(Object object, String string) throws JDEException {
        try {
            return Integer.parseInt(object.toString());
        }
        catch (NumberFormatException numberFormatException) {
            throw new JDENumberFormatException(string);
        }
    }

    public static Value evaluate(String string, final StackFrame stackFrame) throws JDEException {
        try {
            ExpressionParser.GetFrame getFrame = null;
            getFrame = new ExpressionParser.GetFrame(){

                public StackFrame get() throws IncompatibleThreadStateException {
                    return stackFrame;
                }
            };
            return ExpressionParser.evaluate(string, stackFrame.virtualMachine(), getFrame);
        }
        catch (NativeMethodException nativeMethodException) {
            throw new JDEException("Can't access local variables in native methods");
        }
        catch (ParseException parseException) {
            throw new JDEException(parseException.toString());
        }
        catch (InvocationException invocationException) {
            throw new JDEException("Exception in expression: " + invocationException.exception().referenceType().name());
        }
        catch (InvalidTypeException invalidTypeException) {
            throw new JDEException("Expression contains invalid type");
        }
        catch (IncompatibleThreadStateException incompatibleThreadStateException) {
            throw new JDEException("This expression cannot be evaluated at an arbitrary location");
        }
        catch (ClassNotLoadedException classNotLoadedException) {
            throw new JDEException("A required class for the evaluation hasn't been loaded");
        }
    }

    public static Object getThreadFromArgs(List list) throws JDEException {
        String string = null;
        int n = -1;
        int n2 = 0;
        while (n2 < list.size()) {
            String string2 = list.get(n2).toString().toLowerCase();
            if (string2.equals("on_thread_id") || string2.equals("on_thread_name") || string2.equals("-tid") || string2.equals("-tname")) {
                n = n2;
                string = list.remove(n).toString();
                break;
            }
            ++n2;
        }
        if (string == null) {
            return null;
        }
        if (string.equals("on_thread_id") || string.equals("-tid")) {
            if (n == list.size()) {
                throw new JDEException("Missing argument to 'on_thread_id'");
            }
            try {
                return new Long(list.remove(n).toString());
            }
            catch (NumberFormatException numberFormatException) {
                throw new JDENumberFormatException("'on_thread_id' argument");
            }
        }
        if (string.equals("on_thread_name") || string.equals("-tname")) {
            if (n == list.size()) {
                throw new JDEException("Missing argument to 'on_thread_name'");
            }
            return list.remove(n).toString();
        }
        throw new JDEException("Should not happen! Contact maintainer");
    }

    public static String getExprFromArgs(List list) throws JDEException {
        String string = null;
        int n = -1;
        int n2 = 0;
        while (n2 < list.size()) {
            String string2 = list.get(n2).toString().toLowerCase();
            if (string2.equals("if") || string2.equals("-e")) {
                n = n2;
                string = list.remove(n).toString();
                break;
            }
            ++n2;
        }
        if (string == null) {
            return null;
        }
        if (string.equals("if") || string.equals("-e")) {
            if (n == list.size()) {
                throw new JDEException("Missing argument to 'if'");
            }
            return list.remove(n).toString();
        }
        throw new JDEException("Should not happen! Contact maintainer");
    }

    public static List getClassFiltersFromArgs(List list) throws JDEException {
        Object object;
        String string = null;
        int n = -1;
        int n2 = 0;
        while (n2 < list.size()) {
            object = list.get(n2).toString().toLowerCase();
            if (((String)object).equals("class_filters") || ((String)object).equals("-cf")) {
                n = n2;
                string = list.remove(n).toString();
                break;
            }
            ++n2;
        }
        if (string == null) {
            return null;
        }
        if (string.equals("class_filters") || string.equals("-cf")) {
            if (n == list.size()) {
                throw new JDEException("Missing argument to 'class_filters'");
            }
            object = new ArrayList();
            StringTokenizer stringTokenizer = new StringTokenizer(list.remove(n).toString(), " \t\n\r\f,");
            while (stringTokenizer.hasMoreTokens()) {
                object.add(stringTokenizer.nextToken());
            }
            return object;
        }
        throw new JDEException("Should not happen! Contact maintainer");
    }

    public static List getClassExFiltersFromArgs(List list) throws JDEException {
        Object object;
        String string = null;
        int n = -1;
        int n2 = 0;
        while (n2 < list.size()) {
            object = list.get(n2).toString().toLowerCase();
            if (((String)object).equals("class_exclusion_filters") || ((String)object).equals("-cef")) {
                n = n2;
                string = list.remove(n).toString();
                break;
            }
            ++n2;
        }
        if (string == null) {
            return null;
        }
        if (string.equals("class_exclusion_filters") || string.equals("-cef")) {
            if (n == list.size()) {
                throw new JDEException("Missing argument to 'class_exclusion_filters'");
            }
            object = new ArrayList();
            StringTokenizer stringTokenizer = new StringTokenizer(list.remove(n).toString(), " \t\n\r\f,");
            while (stringTokenizer.hasMoreTokens()) {
                object.add(stringTokenizer.nextToken());
            }
            return object;
        }
        throw new JDEException("Should not happen! Contact maintainer");
    }

    public static int getSuspendPolicyFromArgs(List list) throws JDEException {
        String string;
        String string2 = null;
        int n = -1;
        int n2 = 0;
        while (n2 < list.size()) {
            string = list.get(n2).toString().toLowerCase();
            if (string.equals("using_suspend_policy") || string.equals("-sp")) {
                n = n2;
                string2 = list.remove(n).toString();
                break;
            }
            ++n2;
        }
        if (string2 == null) {
            return 2;
        }
        if (string2.equals("using_suspend_policy") || string2.equals("-sp")) {
            if (n == list.size()) {
                throw new JDEException("Missing argument to 'using_suspend_policy'");
            }
            string = list.remove(n).toString().toLowerCase();
            if (string.equals("all")) {
                return 2;
            }
            if (string.equals("thread")) {
                return 1;
            }
            if (string.equals("none")) {
                return 0;
            }
            throw new JDEException("Invalid suspend policy '" + string + "'");
        }
        throw new JDEException("Should not happen! Contact maintainer");
    }

    public static Long getObjectIDFromArgs(List list) throws JDEException {
        String string = null;
        int n = -1;
        int n2 = 0;
        while (n2 < list.size()) {
            String string2 = list.get(n2).toString().toLowerCase();
            if (string2.equals("if_object_id") || string2.equals("-oid")) {
                n = n2;
                string = list.remove(n).toString();
                break;
            }
            ++n2;
        }
        if (string == null) {
            return null;
        }
        if (string.equals("if_object_id") || string.equals("-oid")) {
            if (n == list.size()) {
                throw new JDEException("Missing argument to 'if_object_id'");
            }
            try {
                return new Long(list.remove(n).toString());
            }
            catch (NumberFormatException numberFormatException) {
                throw new JDENumberFormatException("'if_object_id' argument");
            }
        }
        throw new JDEException("Should not happen! Contact maintainer");
    }
}

