/*
	GXAnim : A GTK frontend to XAnim
	by Robert Warren
	(c) 1999

	This program is covered under the General Public License.
	See COPYING file for licensing information.
	
	===============================================

	windows.c

	create and define screen objects 

*/

#include "header.h"

void make_top_win (main_win *window, xcontrol *control) 
{
	/* main window defines */

	window->window = gtk_window_new (GTK_WINDOW_TOPLEVEL);

	gtk_widget_set_usize(GTK_WIDGET(window->window), 300,135); 
	gtk_window_set_title (GTK_WINDOW(window->window), MAINTITLE);
	gtk_container_border_width (GTK_CONTAINER (window->window), 10);

	
	/* main interface defines */
	
	window->vertbox = gtk_vbox_new(FALSE, 0);
	window->hbox1 = gtk_hbox_new(FALSE, 0);
	window->hbox2 = gtk_hbox_new(FALSE, 0);
	window->hbox3 = gtk_hbox_new(FALSE, 0);

	window->lefttable = gtk_table_new(4, 2, FALSE);
	window->rightbox = gtk_vbox_new(FALSE, 0);
	window->righttable = gtk_hbox_new(FALSE, 0);

	gtk_container_add(GTK_CONTAINER(window->window), window->vertbox);
    

	gtk_box_pack_start(GTK_BOX(window->vertbox), window->hbox1, FALSE, FALSE, 0);
	gtk_box_pack_start(GTK_BOX(window->vertbox), window->hbox2, FALSE, FALSE, 0);
	gtk_box_pack_start(GTK_BOX(window->vertbox), window->hbox3, FALSE, FALSE, 0);
	gtk_box_pack_start(GTK_BOX(window->hbox2), window->lefttable, FALSE, FALSE, 0);
	gtk_box_pack_end(GTK_BOX(window->hbox2), window->rightbox, FALSE, FALSE, 0); 


	/* interface table populations  */

	gtk_container_border_width(GTK_CONTAINER(window->hbox2), 10);
	
	window->playbtn = gtk_button_new_with_label(" Play ");
	window->stopbtn = gtk_button_new_with_label(" Stop ");
	window->forwardbtn = gtk_button_new_with_label("  >>  ");
	window->backbtn = gtk_button_new_with_label("  <<  ");
	window->mutebtn = gtk_button_new_with_label(" Mute ");
	window->pausebtn = gtk_button_new_with_label("  ][  ");
	window->restartbtn = gtk_button_new_with_label(" Next ");
	window->aboutbtn = gtk_button_new_with_label("  ??  ");

	gtk_table_attach_defaults(GTK_TABLE(window->lefttable), window->backbtn, 0, 1, 0, 1);
	gtk_table_attach_defaults(GTK_TABLE(window->lefttable), window->playbtn, 1, 2, 0, 1);
	gtk_table_attach_defaults(GTK_TABLE(window->lefttable), window->stopbtn, 2, 3, 0, 1);
	gtk_table_attach_defaults(GTK_TABLE(window->lefttable), window->forwardbtn, 3, 4, 0, 1);

	gtk_table_attach_defaults(GTK_TABLE(window->lefttable), window->mutebtn, 0, 1, 1, 2);
	gtk_table_attach_defaults(GTK_TABLE(window->lefttable), window->pausebtn, 1, 2, 1, 2);
	gtk_table_attach_defaults(GTK_TABLE(window->lefttable), window->restartbtn, 2, 3, 1, 2);
	gtk_table_attach_defaults(GTK_TABLE(window->lefttable), window->aboutbtn, 3, 4, 1, 2);

	window->playtip = gtk_tooltips_new();
	gtk_tooltips_set_tip(window->playtip, window->playbtn, "Play or Restart Clip", _NULL);

	window->stoptip = gtk_tooltips_new();
	gtk_tooltips_set_tip(window->stoptip, window->stopbtn, "Stop Clip", _NULL);

	window->backtip = gtk_tooltips_new();
	gtk_tooltips_set_tip(window->backtip, window->backbtn, "Rewind", _NULL);

	window->forwardtip = gtk_tooltips_new();
	gtk_tooltips_set_tip(window->forwardtip, window->forwardbtn, "Forward", _NULL);

	window->abouttip = gtk_tooltips_new();
	gtk_tooltips_set_tip(window->abouttip, window->aboutbtn, "About...", _NULL);

	window->mutetip = gtk_tooltips_new();
	gtk_tooltips_set_tip(window->mutetip, window->mutebtn, "Mute Volume", _NULL);

	window->pausetip = gtk_tooltips_new();
	gtk_tooltips_set_tip(window->pausetip, window->pausebtn, "Pause", _NULL);

	
	/* file selection mechanism */

	window->filebutton = gtk_button_new_with_label("Open");
	gtk_box_pack_start(GTK_BOX(window->hbox1), window->filebutton, FALSE, FALSE, 0);

	window->opentip = gtk_tooltips_new();
	gtk_tooltips_set_tip(window->opentip, window->filebutton, "Open a Clip", _NULL);

	

	/* console buttons */

	window->dbfbtn = gtk_button_new_with_label("DB");
	window->quitbtn = gtk_button_new_with_label("     Exit     ");
	window->prefbtn = gtk_button_new_with_label("Prefs");
	
	gtk_box_pack_start(GTK_BOX(window->righttable), window->prefbtn, TRUE, TRUE, 0);
	gtk_box_pack_start(GTK_BOX(window->righttable), window->dbfbtn, TRUE, TRUE, 0);

	gtk_box_pack_start(GTK_BOX(window->rightbox), window->righttable, FALSE, TRUE, 0);
	gtk_box_pack_start(GTK_BOX(window->rightbox), window->quitbtn, FALSE, TRUE, 0);

	window->prefstip = gtk_tooltips_new();
	gtk_tooltips_set_tip(window->prefstip, window->prefbtn, "Preferences", _NULL);

	window->exittip = gtk_tooltips_new();
	gtk_tooltips_set_tip(window->exittip, window->quitbtn, "Exit GXAnim", _NULL);
	

	/* name entry combo pulldown */

	window->combo = gtk_combo_new();
	window->history_list = _NULL;
	window->history_list = load_history(window->history_list);

	if (window->history_list) {
		gtk_combo_set_popdown_strings(GTK_COMBO(control->main->combo), (GList *) window->history_list);
	}
	

	if (control->movie->name) {
		gtk_entry_set_text (GTK_ENTRY(GTK_COMBO(window->combo)->entry), control->movie->name);
	} else
		gtk_entry_set_text (GTK_ENTRY(GTK_COMBO(window->combo)->entry), "");

	gtk_box_pack_end(GTK_BOX(window->hbox1), window->combo, TRUE, TRUE, 5);

	

	/* volume bar */

	window->vollabel = gtk_label_new ("Vol : ");
	window->voladjust = gtk_adjustment_new(VOLUME, 0.0, 100.0, 5.0, 5.0,  0.0);
	window->volumebar = gtk_hscale_new(GTK_ADJUSTMENT(window->voladjust));

	gtk_scale_set_digits(GTK_SCALE(window->volumebar), 0);
	gtk_box_pack_start(GTK_BOX(window->hbox3), window->vollabel, FALSE, TRUE, 0);
	gtk_box_pack_start(GTK_BOX(window->hbox3), window->volumebar, FALSE, TRUE, 0);

	window->volumetip = gtk_tooltips_new();
	gtk_tooltips_set_tip(window->volumetip, window->volumebar, "Set Volume", _NULL);

	gtk_signal_connect(GTK_OBJECT(window->voladjust), 
		"value_changed",
		GTK_SIGNAL_FUNC(set_volume),
		(gpointer) control);

	

	/* status bar */

	window->statbox = gtk_vbox_new(FALSE, 0);
	window->statbar = gtk_statusbar_new();

	gtk_box_pack_end(GTK_BOX(window->statbox), window->statbar, TRUE, FALSE, 0);
	gtk_box_pack_end(GTK_BOX(window->hbox3), window->statbox, TRUE, TRUE, 10);

	window->context_id = gtk_statusbar_get_context_id(GTK_STATUSBAR(window->statbar), "GXanimStat");
	
	
	/* button signal connects */

	gtk_signal_connect (GTK_OBJECT(window->window),
		"delete_event", 
		(GtkSignalFunc) quit_event, 
		control);

	gtk_signal_connect (GTK_OBJECT(window->window),
		"destroy_event",
		(GtkSignalFunc) quit_event,
		control);

	gtk_signal_connect(GTK_OBJECT(window->quitbtn), 
		"clicked", 
		(GtkSignalFunc) quit_event,
		(gpointer) control);

	gtk_signal_connect(GTK_OBJECT(window->playbtn),
		"clicked",
		(GtkSignalFunc) set_play,
		(gpointer) control);

	gtk_signal_connect(GTK_OBJECT(window->stopbtn),
		"clicked",
		(GtkSignalFunc) stopxanim,
		(gpointer) control);

	gtk_signal_connect(GTK_OBJECT(window->mutebtn),
		"clicked",
		(GtkSignalFunc) mute_sound,
		(gpointer) control);

	gtk_signal_connect(GTK_OBJECT(window->pausebtn),
		"clicked",
		(GtkSignalFunc) pause_frame,
		(gpointer) control);

	gtk_signal_connect(GTK_OBJECT(window->forwardbtn),
		"clicked",
		(GtkSignalFunc) frame_up,
		(gpointer) control);

	gtk_signal_connect(GTK_OBJECT(window->backbtn),
		"clicked",
		(GtkSignalFunc) frame_back, 
		(gpointer) control);

	gtk_signal_connect (GTK_OBJECT(window->filebutton), 
		"clicked",
		(GtkSignalFunc) showfile, 
		(gpointer) control);

	gtk_signal_connect (GTK_OBJECT(window->prefbtn),
		"clicked",
		(GtkSignalFunc) show_window,
		GTK_OBJECT(control->pref->window));

	gtk_signal_connect (GTK_OBJECT(window->aboutbtn),
		"clicked",
		(GtkSignalFunc) show_window,
		GTK_OBJECT(control->about->window));


	
	gtk_widget_show_all (window->window);

	return;
}


/* file select screen */

GtkWidget *make_filesel (GtkWidget *window, xcontrol *control) 
{

	window = gtk_file_selection_new("Open A Movie File");
	
	gtk_signal_connect (GTK_OBJECT(window),
		"destroy",
		GTK_SIGNAL_FUNC(quit_event),
		control);

	gtk_signal_connect_object (GTK_OBJECT(
		GTK_FILE_SELECTION(window)),
		"delete_event",
		(GtkSignalFunc) gtk_widget_hide,
		(gpointer) GTK_FILE_SELECTION(window));

	gtk_signal_connect (GTK_OBJECT(
		GTK_FILE_SELECTION(window)->ok_button), 
		"clicked", 
		(GtkSignalFunc) getfile,
		(gpointer) control);

	gtk_signal_connect_object (GTK_OBJECT(
		GTK_FILE_SELECTION(window)->cancel_button),
		"clicked", 
		(GtkSignalFunc) gtk_widget_hide,
		(gpointer) GTK_FILE_SELECTION(window));

	gtk_widget_realize(window);
	return window;
}


/* movie screen */

GtkWidget *make_screen (screen_win *window, xcontrol *control)
{
	window->window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	window->vertbox = gtk_vbox_new(TRUE, 0);
	window->screen = gtk_movie_new();


	gtk_container_add(GTK_CONTAINER(window->window), window->screen);
	
	gtk_signal_connect (GTK_OBJECT(window->screen),
		"clicked",
		(GtkSignalFunc) hide_window_action,
		control->main->window);

	gtk_signal_connect (GTK_OBJECT(window->window),
		"destroy",
		GTK_SIGNAL_FUNC(quit_event),
		control);

	gtk_signal_connect (GTK_OBJECT(window->window),
		"delete_event",
		GTK_SIGNAL_FUNC(hide_window_event),
		window->window);

	gtk_widget_realize (window->window);


	return (window->window);
}


/* preferences window */

void make_prefs(prefs_win *window, xcontrol *control)
{

	/* Basic window build */
	
	window->window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_widget_set_usize(GTK_WIDGET(window->window), 400, 250); 
	gtk_window_set_title(GTK_WINDOW(window->window), "Preferences");

	gtk_signal_connect (GTK_OBJECT(window->window),
		"destroy",
		GTK_SIGNAL_FUNC(quit_event),
		control);

	gtk_signal_connect (GTK_OBJECT(window->window),
		"delete_event", 
		GTK_SIGNAL_FUNC(hide_window_event), 
		window->window);

	window->vertbox = gtk_vbox_new(FALSE,0);
	gtk_container_add(GTK_CONTAINER(window->window), window->vertbox);
	
	window->hsep1 = gtk_hseparator_new();
	window->hsep2 = gtk_hseparator_new();
	window->hsep3 = gtk_hseparator_new();
	window->hsep4 = gtk_hseparator_new();
	window->hsep5 = gtk_hseparator_new();


	window->hbox2 = gtk_hbox_new(FALSE, 20);
	window->vbox4 = gtk_vbox_new(TRUE, 0);
	

	window->label7 = gtk_label_new("XAnim Binary");
	window->label8 = gtk_label_new("Default Dir");
	window->label6 = gtk_label_new("Gamma Correct");
	window->label4 = gtk_label_new("Scaling");

	gtk_box_pack_start(GTK_BOX(window->vbox4), window->label4, FALSE, FALSE, 0);
	gtk_box_pack_start(GTK_BOX(window->vbox4), window->label6, FALSE, FALSE, 0);
	gtk_box_pack_start(GTK_BOX(window->vbox4), window->label8, FALSE, FALSE, 0);
	gtk_box_pack_start(GTK_BOX(window->vbox4), window->label7, FALSE, FALSE, 0);


	window->vbox5 = gtk_vbox_new(TRUE, 0);

	window->binentry = gtk_entry_new_with_max_length (150);
	window->direntry = gtk_entry_new_with_max_length (150);
	window->gammaadj = gtk_adjustment_new(GAMMA, 1.0, 3.0, 0.1, 0.1,  0.0);
	window->gammabar = gtk_hscale_new(GTK_ADJUSTMENT(window->gammaadj));
	window->scaleadj = gtk_adjustment_new(SCALE, 0.5, 3.0, 0.1, 0.1,  0.0);
	window->scalebar = gtk_hscale_new(GTK_ADJUSTMENT(window->scaleadj));

	gtk_box_pack_start(GTK_BOX(window->vbox5), window->scalebar, FALSE, FALSE, 0);
	gtk_box_pack_start(GTK_BOX(window->vbox5), window->gammabar, FALSE, FALSE, 0);
	gtk_box_pack_start(GTK_BOX(window->vbox5), window->direntry, FALSE, FALSE, 0);
	gtk_box_pack_start(GTK_BOX(window->vbox5), window->binentry, FALSE, FALSE, 0);

	gtk_box_pack_start(GTK_BOX(window->hbox2), window->vbox4, FALSE, TRUE, 25);
	gtk_box_pack_start(GTK_BOX(window->hbox2), window->vbox5, TRUE, TRUE, 20);

	window->hbox4 = gtk_hbox_new(TRUE, 15);
	window->vbox2 = gtk_vbox_new(TRUE, 0);

	window->holdbox = gtk_check_button_new_with_label("Hold on last frame?");
	window->syncbox = gtk_check_button_new_with_label("Sync frame to audio?");
	window->verbbox = gtk_check_button_new_with_label("Verbose mode?");

	gtk_box_pack_start(GTK_BOX(window->vbox2), window->holdbox, FALSE, TRUE, 0);
	gtk_box_pack_start(GTK_BOX(window->vbox2), window->syncbox, FALSE, TRUE, 0);
	gtk_box_pack_start(GTK_BOX(window->vbox2), window->verbbox, FALSE, TRUE, 0);

	window->vbox3 = gtk_vbox_new(TRUE, 0);
	window->floydbox = gtk_check_button_new_with_label("Floyd-Steinberg dither?");
	window->playbox = gtk_check_button_new_with_label("Play on Start?");

	gtk_box_pack_start(GTK_BOX(window->vbox3), window->floydbox, FALSE, TRUE, 0);
	gtk_box_pack_start(GTK_BOX(window->vbox3), window->playbox, FALSE, TRUE, 0);

	gtk_box_pack_end(GTK_BOX(window->hbox4), window->vbox2, FALSE, TRUE, 15);
	gtk_box_pack_end(GTK_BOX(window->hbox4), window->vbox3, FALSE, TRUE, 15);
	

	/* Console buttons */
	
	window->hbox8 = gtk_hbox_new(TRUE, 0);	
	window->defaultbtn = gtk_button_new_with_label("Reset");
	window->okbtn = gtk_button_new_with_label("Done");	
	window->applybtn = gtk_button_new_with_label("Apply");

	gtk_box_pack_start(GTK_BOX(window->hbox8), window->defaultbtn, FALSE, TRUE, 5);
	gtk_box_pack_start(GTK_BOX(window->hbox8), window->applybtn, FALSE, TRUE, 5);
	gtk_box_pack_start(GTK_BOX(window->hbox8), window->okbtn, FALSE, TRUE, 5);
	

	/* final assembly */

	gtk_box_pack_start(GTK_BOX(window->vertbox), window->hsep3, FALSE, FALSE, 5);
	gtk_box_pack_start(GTK_BOX(window->vertbox), window->hbox2, FALSE, FALSE, 0);
	
	gtk_box_pack_start(GTK_BOX(window->vertbox), window->hsep2, FALSE, FALSE, 0);
	gtk_box_pack_start(GTK_BOX(window->vertbox), window->hbox4, FALSE, FALSE, 0);

	gtk_box_pack_start(GTK_BOX(window->vertbox), window->hsep1, FALSE, FALSE, 0);
	gtk_box_pack_start(GTK_BOX(window->vertbox), window->hbox8, FALSE, FALSE, 10);

	
	/* signals */

	gtk_signal_connect_object (GTK_OBJECT(window->okbtn), 
		"clicked",
		(GtkSignalFunc) gtk_widget_hide_all,
		(gpointer) GTK_OBJECT(window->window));
	
	gtk_signal_connect (GTK_OBJECT(window->applybtn),
		"clicked",
		GTK_SIGNAL_FUNC(save_config),
		(gpointer) control);

	gtk_signal_connect (GTK_OBJECT(window->defaultbtn),
		"clicked",
		GTK_SIGNAL_FUNC(set_defaults),
		(gpointer) control);

	return;
}

void exit_pref(GtkWidget *widget, xcontrol *control)
{
	gtk_widget_hide_all(GTK_WIDGET(control->pref->window)); 
	get_prefs(_NULL, control);
	return;
}


void make_about (about_win *window, xcontrol *control)
{
	window->window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_widget_set_usize(GTK_WIDGET(window->window), 200, 130);
	gtk_window_set_title(GTK_WINDOW(window->window), "About");

	window->hsep1 = gtk_hseparator_new();
	window->hsep2 = gtk_hseparator_new();
	window->hsep3 = gtk_hseparator_new();

	gtk_signal_connect (GTK_OBJECT(window->window),
		"destroy",
		GTK_SIGNAL_FUNC(quit_event),
		control);

	gtk_signal_connect (GTK_OBJECT(window->window),
		"delete_event", 
		GTK_SIGNAL_FUNC(hide_window_event), 
		window->window);

	window->vertbox = gtk_vbox_new(FALSE, 0);
	gtk_container_add(GTK_CONTAINER(window->window), window->vertbox);

	window->label1 = gtk_label_new("GXanim 0.50   (11/19/1999)");
	window->label2 = gtk_label_new("(c) 1999 by Rob Warren");
	window->label3 = gtk_label_new("Email: aleris@iag.net");
	window->label4 = gtk_label_new("http://www.iag.net/~aleris");

	window->label5 = gtk_label_new("Currently Playing..");
	window->okbtn = gtk_button_new_with_label("Ok");
	
	gtk_box_pack_start(GTK_BOX(window->vertbox), window->hsep1, FALSE, FALSE, 5);
	gtk_box_pack_start(GTK_BOX(window->vertbox), window->label1, FALSE, FALSE, 1);
	gtk_box_pack_start(GTK_BOX(window->vertbox), window->label2, FALSE, FALSE, 1);
	gtk_box_pack_start(GTK_BOX(window->vertbox), window->label3, FALSE, FALSE, 1);
	gtk_box_pack_start(GTK_BOX(window->vertbox), window->label4, FALSE, FALSE, 1);
	gtk_box_pack_start(GTK_BOX(window->vertbox), window->hsep2, FALSE, FALSE, 5);


	/* gtk_box_pack_start(GTK_BOX(window->vertbox), window->hsep3, FALSE, FALSE, 5); */
	gtk_box_pack_start(GTK_BOX(window->vertbox), window->okbtn, FALSE, TRUE, 10);

	gtk_signal_connect_object (GTK_OBJECT(window->okbtn),
		"clicked",
		GTK_SIGNAL_FUNC(gtk_widget_hide_all),
		(gpointer) GTK_WIDGET(window->window));

	gtk_widget_realize(window->window);
	return;
}


