// Emacs style mode select   -*- C++ -*-
//-----------------------------------------------------------------------------
//
// $Id: info.h,v 1.7 2001/08/07 00:53:33 hurdler Exp $
//
// Copyright (C) 1993-1996 by id Software, Inc.
// Portions Copyright (C) 1998-2000 by DooM Legacy Team.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
//
// $Log: info.h,v $
// Revision 1.7  2001/08/07 00:53:33  hurdler
// lil' change
//
// Revision 1.6  2001/01/25 22:15:42  bpereira
// added heretic support
//
// Revision 1.5  2000/11/02 17:50:07  stroggonmeth
// Big 3Dfloors & FraggleScript commit!!
//
// Revision 1.4  2000/10/21 08:43:29  bpereira
// no message
//
// Revision 1.3  2000/04/04 00:32:46  stroggonmeth
// Initial Boom compatability plus few misc changes all around.
//
// Revision 1.2  2000/02/27 00:42:10  hurdler
// fix CR+LF problem
//
// Revision 1.1.1.1  2000/02/22 20:32:32  hurdler
// Initial import into CVS (v1.29 pr3)
//
//
// DESCRIPTION:
//      Thing frame/state LUT,
//      generated by multigen utilitiy.
//      This one is the original DOOM version, preserved.
//
//-----------------------------------------------------------------------------

#ifndef __INFO__
#define __INFO__

// Needed for action function pointer handling.
#include "d_think.h"

typedef enum
{
    SPR_TROO, // 0
    SPR_SHTG,
    SPR_PUNG,
    SPR_PISG,
    SPR_PISF,
    SPR_SHTF,
    SPR_SHT2,
    SPR_CHGG,
    SPR_CHGF,
    SPR_MISG,
    SPR_MISF, // 10
    SPR_SAWG,
    SPR_PLSG,
    SPR_PLSF,
    SPR_BFGG,
    SPR_BFGF,
    SPR_BLUD,
    SPR_PUFF,
    SPR_BAL1,
    SPR_BAL2,
    SPR_PLSS, // 20
    SPR_PLSE,
    SPR_MISL,
    SPR_BFS1,
    SPR_BFE1,
    SPR_BFE2,
    SPR_TFOG,
    SPR_IFOG,
    SPR_PLAY,
    SPR_POSS,
    SPR_SPOS, // 30
    SPR_VILE,
    SPR_FIRE,
    SPR_FATB,
    SPR_FBXP,
    SPR_SKEL,
    SPR_MANF,
    SPR_FATT,
    SPR_CPOS,
    SPR_SARG,
    SPR_HEAD, // 40
    SPR_BAL7,
    SPR_BOSS,
    SPR_BOS2,
    SPR_SKUL,
    SPR_SPID,
    SPR_BSPI,
    SPR_APLS,
    SPR_APBX,
    SPR_CYBR,
    SPR_PAIN, // 50
    SPR_SSWV,
    SPR_KEEN,
    SPR_BBRN,
    SPR_BOSF,
    SPR_ARM1,
    SPR_ARM2,
    SPR_BAR1,
    SPR_BEXP,
    SPR_FCAN,
    SPR_BON1, // 60
    SPR_BON2,
    SPR_BKEY,
    SPR_RKEY,
    SPR_YKEY,
    SPR_BSKU,
    SPR_RSKU,
    SPR_YSKU,
    SPR_STIM,
    SPR_MEDI,
    SPR_SOUL, // 70
    SPR_PINV,
    SPR_PSTR,
    SPR_PINS,
    SPR_MEGA,
    SPR_SUIT,
    SPR_PMAP,
    SPR_PVIS,
    SPR_CLIP,
    SPR_AMMO,
    SPR_ROCK, // 80
    SPR_BROK,
    SPR_CELL,
    SPR_CELP,
    SPR_SHEL,
    SPR_SBOX,
    SPR_BPAK,
    SPR_BFUG,
    SPR_MGUN,
    SPR_CSAW,
    SPR_LAUN, // 90
    SPR_PLAS,
    SPR_SHOT,
    SPR_SGN2,
    SPR_COLU,
    SPR_SMT2,
    SPR_GOR1,
    SPR_POL2,
    SPR_POL5,
    SPR_POL4,
    SPR_POL3, // 100
    SPR_POL1,
    SPR_POL6,
    SPR_GOR2,
    SPR_GOR3,
    SPR_GOR4,
    SPR_GOR5,
    SPR_SMIT,
    SPR_COL1,
    SPR_COL2,
    SPR_COL3, // 110
    SPR_COL4,
    SPR_CAND,
    SPR_CBRA,
    SPR_COL6,
    SPR_TRE1,
    SPR_TRE2,
    SPR_ELEC,
    SPR_CEYE,
    SPR_FSKU,
    SPR_COL5, // 120
    SPR_TBLU,
    SPR_TGRN,
    SPR_TRED,
    SPR_SMBT,
    SPR_SMGT,
    SPR_SMRT,
    SPR_HDB1,
    SPR_HDB2,
    SPR_HDB3,
    SPR_HDB4, // 130
    SPR_HDB5,
    SPR_HDB6,
    SPR_POB1,
    SPR_POB2,
    SPR_BRS1,
    SPR_TLMP,
    SPR_TLP2,
    //Fab:
    SPR_SMOK,
    SPR_SPLA,
    SPR_TNT1, // 140  SoM: 3/8/2000: add invisible sprite

    // heretic stuff

SPR_IMPX,
SPR_ACLO,
SPR_PTN1,
SPR_SHLD,
SPR_SHD2,
SPR_BAGH,
SPR_SPMP,
SPR_INVS,
SPR_PTN2,
SPR_SOAR,
SPR_INVU,
SPR_PWBK,
SPR_EGGC,
SPR_EGGM,
SPR_FX01,
SPR_SPHL,
SPR_TRCH,
SPR_FBMB,
SPR_XPL1,
SPR_ATLP,
SPR_PPOD,
SPR_AMG1,
SPR_SPSH,
SPR_LVAS,
SPR_SLDG,
SPR_SKH1,
SPR_SKH2,
SPR_SKH3,
SPR_SKH4,
SPR_CHDL,
SPR_SRTC,
SPR_SMPL,
SPR_STGS,
SPR_STGL,
SPR_STCS,
SPR_STCL,
SPR_KFR1,
SPR_BARL,
SPR_BRPL,
SPR_MOS1,
SPR_MOS2,
SPR_WTRH,
SPR_HCOR,
SPR_KGZ1,
SPR_KGZB,
SPR_KGZG,
SPR_KGZY,
SPR_VLCO,
SPR_VFBL,
SPR_VTFB,
SPR_SFFI,
SPR_TGLT,
SPR_TELE,
SPR_STFF,
SPR_PUF3,
SPR_PUF4,
SPR_BEAK,
SPR_WGNT,
SPR_GAUN,
SPR_PUF1,
SPR_WBLS,
SPR_BLSR,
SPR_FX18,
SPR_FX17,
SPR_WMCE,
SPR_MACE,
SPR_FX02,
SPR_WSKL,
SPR_HROD,
SPR_FX00,
SPR_FX20,
SPR_FX21,
SPR_FX22,
SPR_FX23,
SPR_GWND,
SPR_PUF2,
SPR_WPHX,
SPR_PHNX,
SPR_FX04,
SPR_FX08,
SPR_FX09,
SPR_WBOW,
SPR_CRBW,
SPR_FX03,
//SPR_BLOD,
//SPR_PLAY,
SPR_FDTH,
SPR_BSKL,
SPR_CHKN,
SPR_MUMM,
SPR_FX15,
SPR_BEAS,
SPR_FRB1,
SPR_SNKE,
SPR_SNFX,
SPR_HHEAD,
SPR_FX05,
SPR_FX06,
SPR_FX07,
SPR_CLNK,
SPR_WZRD,
SPR_FX11,
SPR_FX10,
SPR_KNIG,
SPR_SPAX,
SPR_RAXE,
SPR_SRCR,
SPR_FX14,
SPR_SOR2,
SPR_SDTH,
SPR_FX16,
SPR_MNTR,
SPR_FX12,
SPR_FX13,
SPR_AKYY,
SPR_BKYY,
SPR_CKYY,
SPR_AMG2,
SPR_AMM1,
SPR_AMM2,
SPR_AMC1,
SPR_AMC2,
SPR_AMS1,
SPR_AMS2,
SPR_AMP1,
SPR_AMP2,
SPR_AMB1,
SPR_AMB2,

    NUMSPRITES

} spritenum_t;

typedef enum
{
    S_NULL,
    S_LIGHTDONE,
    S_PUNCH,
    S_PUNCHDOWN,
    S_PUNCHUP,
    S_PUNCH1,
    S_PUNCH2,
    S_PUNCH3,
    S_PUNCH4,
    S_PUNCH5,
    S_PISTOL,
    S_PISTOLDOWN,
    S_PISTOLUP,
    S_PISTOL1,
    S_PISTOL2,
    S_PISTOL3,
    S_PISTOL4,
    S_PISTOLFLASH,
    S_SGUN,
    S_SGUNDOWN,
    S_SGUNUP,
    S_SGUN1,
    S_SGUN2,
    S_SGUN3,
    S_SGUN4,
    S_SGUN5,
    S_SGUN6,
    S_SGUN7,
    S_SGUN8,
    S_SGUN9,
    S_SGUNFLASH1,
    S_SGUNFLASH2,
    S_DSGUN,
    S_DSGUNDOWN,
    S_DSGUNUP,
    S_DSGUN1,
    S_DSGUN2,
    S_DSGUN3,
    S_DSGUN4,
    S_DSGUN5,
    S_DSGUN6,
    S_DSGUN7,
    S_DSGUN8,
    S_DSGUN9,
    S_DSGUN10,
    S_DSNR1,
    S_DSNR2,
    S_DSGUNFLASH1,
    S_DSGUNFLASH2,
    S_CHAIN,
    S_CHAINDOWN,
    S_CHAINUP,
    S_CHAIN1,
    S_CHAIN2,
    S_CHAIN3,
    S_CHAINFLASH1,
    S_CHAINFLASH2,
    S_MISSILE,
    S_MISSILEDOWN,
    S_MISSILEUP,
    S_MISSILE1,
    S_MISSILE2,
    S_MISSILE3,
    S_MISSILEFLASH1,
    S_MISSILEFLASH2,
    S_MISSILEFLASH3,
    S_MISSILEFLASH4,
    S_SAW,
    S_SAWB,
    S_SAWDOWN,
    S_SAWUP,
    S_SAW1,
    S_SAW2,
    S_SAW3,
    S_PLASMA,
    S_PLASMADOWN,
    S_PLASMAUP,
    S_PLASMA1,
    S_PLASMA2,
    S_PLASMAFLASH1,
    S_PLASMAFLASH2,
    S_BFG,
    S_BFGDOWN,
    S_BFGUP,
    S_BFG1,
    S_BFG2,
    S_BFG3,
    S_BFG4,
    S_BFGFLASH1,
    S_BFGFLASH2,
    S_BLOOD1,
    S_BLOOD2,
    S_BLOOD3,
    S_PUFF1,
    S_PUFF2,
    S_PUFF3,
    S_PUFF4,
    S_TBALL1,
    S_TBALL2,
    S_TBALLX1,
    S_TBALLX2,
    S_TBALLX3,
    S_RBALL1,
    S_RBALL2,
    S_RBALLX1,
    S_RBALLX2,
    S_RBALLX3,
    S_PLASBALL,
    S_PLASBALL2,
    S_PLASEXP,
    S_PLASEXP2,
    S_PLASEXP3,
    S_PLASEXP4,
    S_PLASEXP5,
    S_ROCKET,
    S_BFGSHOT,
    S_BFGSHOT2,
    S_BFGLAND,
    S_BFGLAND2,
    S_BFGLAND3,
    S_BFGLAND4,
    S_BFGLAND5,
    S_BFGLAND6,
    S_BFGEXP,
    S_BFGEXP2,
    S_BFGEXP3,
    S_BFGEXP4,
    S_EXPLODE1,
    S_EXPLODE2,
    S_EXPLODE3,
    S_TFOG,
    S_TFOG01,
    S_TFOG02,
    S_TFOG2,
    S_TFOG3,
    S_TFOG4,
    S_TFOG5,
    S_TFOG6,
    S_TFOG7,
    S_TFOG8,
    S_TFOG9,
    S_TFOG10,
    S_IFOG,
    S_IFOG01,
    S_IFOG02,
    S_IFOG2,
    S_IFOG3,
    S_IFOG4,
    S_IFOG5,
    S_PLAY,
    S_PLAY_RUN1,
    S_PLAY_RUN2,
    S_PLAY_RUN3,
    S_PLAY_RUN4,
    S_PLAY_ATK1,
    S_PLAY_ATK2,
    S_PLAY_PAIN,
    S_PLAY_PAIN2,
    S_PLAY_DIE1,
    S_PLAY_DIE2,
    S_PLAY_DIE3,
    S_PLAY_DIE4,
    S_PLAY_DIE5,
    S_PLAY_DIE6,
    S_PLAY_DIE7,
    S_PLAY_XDIE1,
    S_PLAY_XDIE2,
    S_PLAY_XDIE3,
    S_PLAY_XDIE4,
    S_PLAY_XDIE5,
    S_PLAY_XDIE6,
    S_PLAY_XDIE7,
    S_PLAY_XDIE8,
    S_PLAY_XDIE9,
    S_POSS_STND,
    S_POSS_STND2,
    S_POSS_RUN1,
    S_POSS_RUN2,
    S_POSS_RUN3,
    S_POSS_RUN4,
    S_POSS_RUN5,
    S_POSS_RUN6,
    S_POSS_RUN7,
    S_POSS_RUN8,
    S_POSS_ATK1,
    S_POSS_ATK2,
    S_POSS_ATK3,
    S_POSS_PAIN,
    S_POSS_PAIN2,
    S_POSS_DIE1,
    S_POSS_DIE2,
    S_POSS_DIE3,
    S_POSS_DIE4,
    S_POSS_DIE5,
    S_POSS_XDIE1,
    S_POSS_XDIE2,
    S_POSS_XDIE3,
    S_POSS_XDIE4,
    S_POSS_XDIE5,
    S_POSS_XDIE6,
    S_POSS_XDIE7,
    S_POSS_XDIE8,
    S_POSS_XDIE9,
    S_POSS_RAISE1,
    S_POSS_RAISE2,
    S_POSS_RAISE3,
    S_POSS_RAISE4,
    S_SPOS_STND,
    S_SPOS_STND2,
    S_SPOS_RUN1,
    S_SPOS_RUN2,
    S_SPOS_RUN3,
    S_SPOS_RUN4,
    S_SPOS_RUN5,
    S_SPOS_RUN6,
    S_SPOS_RUN7,
    S_SPOS_RUN8,
    S_SPOS_ATK1,
    S_SPOS_ATK2,
    S_SPOS_ATK3,
    S_SPOS_PAIN,
    S_SPOS_PAIN2,
    S_SPOS_DIE1,
    S_SPOS_DIE2,
    S_SPOS_DIE3,
    S_SPOS_DIE4,
    S_SPOS_DIE5,
    S_SPOS_XDIE1,
    S_SPOS_XDIE2,
    S_SPOS_XDIE3,
    S_SPOS_XDIE4,
    S_SPOS_XDIE5,
    S_SPOS_XDIE6,
    S_SPOS_XDIE7,
    S_SPOS_XDIE8,
    S_SPOS_XDIE9,
    S_SPOS_RAISE1,
    S_SPOS_RAISE2,
    S_SPOS_RAISE3,
    S_SPOS_RAISE4,
    S_SPOS_RAISE5,
    S_VILE_STND,
    S_VILE_STND2,
    S_VILE_RUN1,
    S_VILE_RUN2,
    S_VILE_RUN3,
    S_VILE_RUN4,
    S_VILE_RUN5,
    S_VILE_RUN6,
    S_VILE_RUN7,
    S_VILE_RUN8,
    S_VILE_RUN9,
    S_VILE_RUN10,
    S_VILE_RUN11,
    S_VILE_RUN12,
    S_VILE_ATK1,
    S_VILE_ATK2,
    S_VILE_ATK3,
    S_VILE_ATK4,
    S_VILE_ATK5,
    S_VILE_ATK6,
    S_VILE_ATK7,
    S_VILE_ATK8,
    S_VILE_ATK9,
    S_VILE_ATK10,
    S_VILE_ATK11,
    S_VILE_HEAL1,
    S_VILE_HEAL2,
    S_VILE_HEAL3,
    S_VILE_PAIN,
    S_VILE_PAIN2,
    S_VILE_DIE1,
    S_VILE_DIE2,
    S_VILE_DIE3,
    S_VILE_DIE4,
    S_VILE_DIE5,
    S_VILE_DIE6,
    S_VILE_DIE7,
    S_VILE_DIE8,
    S_VILE_DIE9,
    S_VILE_DIE10,
    S_FIRE1,
    S_FIRE2,
    S_FIRE3,
    S_FIRE4,
    S_FIRE5,
    S_FIRE6,
    S_FIRE7,
    S_FIRE8,
    S_FIRE9,
    S_FIRE10,
    S_FIRE11,
    S_FIRE12,
    S_FIRE13,
    S_FIRE14,
    S_FIRE15,
    S_FIRE16,
    S_FIRE17,
    S_FIRE18,
    S_FIRE19,
    S_FIRE20,
    S_FIRE21,
    S_FIRE22,
    S_FIRE23,
    S_FIRE24,
    S_FIRE25,
    S_FIRE26,
    S_FIRE27,
    S_FIRE28,
    S_FIRE29,
    S_FIRE30,
    S_SMOKE1,
    S_SMOKE2,
    S_SMOKE3,
    S_SMOKE4,
    S_SMOKE5,
    S_TRACER,
    S_TRACER2,
    S_TRACEEXP1,
    S_TRACEEXP2,
    S_TRACEEXP3,
    S_SKEL_STND,
    S_SKEL_STND2,
    S_SKEL_RUN1,
    S_SKEL_RUN2,
    S_SKEL_RUN3,
    S_SKEL_RUN4,
    S_SKEL_RUN5,
    S_SKEL_RUN6,
    S_SKEL_RUN7,
    S_SKEL_RUN8,
    S_SKEL_RUN9,
    S_SKEL_RUN10,
    S_SKEL_RUN11,
    S_SKEL_RUN12,
    S_SKEL_FIST1,
    S_SKEL_FIST2,
    S_SKEL_FIST3,
    S_SKEL_FIST4,
    S_SKEL_MISS1,
    S_SKEL_MISS2,
    S_SKEL_MISS3,
    S_SKEL_MISS4,
    S_SKEL_PAIN,
    S_SKEL_PAIN2,
    S_SKEL_DIE1,
    S_SKEL_DIE2,
    S_SKEL_DIE3,
    S_SKEL_DIE4,
    S_SKEL_DIE5,
    S_SKEL_DIE6,
    S_SKEL_RAISE1,
    S_SKEL_RAISE2,
    S_SKEL_RAISE3,
    S_SKEL_RAISE4,
    S_SKEL_RAISE5,
    S_SKEL_RAISE6,
    S_FATSHOT1,
    S_FATSHOT2,
    S_FATSHOTX1,
    S_FATSHOTX2,
    S_FATSHOTX3,
    S_FATT_STND,
    S_FATT_STND2,
    S_FATT_RUN1,
    S_FATT_RUN2,
    S_FATT_RUN3,
    S_FATT_RUN4,
    S_FATT_RUN5,
    S_FATT_RUN6,
    S_FATT_RUN7,
    S_FATT_RUN8,
    S_FATT_RUN9,
    S_FATT_RUN10,
    S_FATT_RUN11,
    S_FATT_RUN12,
    S_FATT_ATK1,
    S_FATT_ATK2,
    S_FATT_ATK3,
    S_FATT_ATK4,
    S_FATT_ATK5,
    S_FATT_ATK6,
    S_FATT_ATK7,
    S_FATT_ATK8,
    S_FATT_ATK9,
    S_FATT_ATK10,
    S_FATT_PAIN,
    S_FATT_PAIN2,
    S_FATT_DIE1,
    S_FATT_DIE2,
    S_FATT_DIE3,
    S_FATT_DIE4,
    S_FATT_DIE5,
    S_FATT_DIE6,
    S_FATT_DIE7,
    S_FATT_DIE8,
    S_FATT_DIE9,
    S_FATT_DIE10,
    S_FATT_RAISE1,
    S_FATT_RAISE2,
    S_FATT_RAISE3,
    S_FATT_RAISE4,
    S_FATT_RAISE5,
    S_FATT_RAISE6,
    S_FATT_RAISE7,
    S_FATT_RAISE8,
    S_CPOS_STND,
    S_CPOS_STND2,
    S_CPOS_RUN1,
    S_CPOS_RUN2,
    S_CPOS_RUN3,
    S_CPOS_RUN4,
    S_CPOS_RUN5,
    S_CPOS_RUN6,
    S_CPOS_RUN7,
    S_CPOS_RUN8,
    S_CPOS_ATK1,
    S_CPOS_ATK2,
    S_CPOS_ATK3,
    S_CPOS_ATK4,
    S_CPOS_PAIN,
    S_CPOS_PAIN2,
    S_CPOS_DIE1,
    S_CPOS_DIE2,
    S_CPOS_DIE3,
    S_CPOS_DIE4,
    S_CPOS_DIE5,
    S_CPOS_DIE6,
    S_CPOS_DIE7,
    S_CPOS_XDIE1,
    S_CPOS_XDIE2,
    S_CPOS_XDIE3,
    S_CPOS_XDIE4,
    S_CPOS_XDIE5,
    S_CPOS_XDIE6,
    S_CPOS_RAISE1,
    S_CPOS_RAISE2,
    S_CPOS_RAISE3,
    S_CPOS_RAISE4,
    S_CPOS_RAISE5,
    S_CPOS_RAISE6,
    S_CPOS_RAISE7,
    S_TROO_STND,
    S_TROO_STND2,
    S_TROO_RUN1,
    S_TROO_RUN2,
    S_TROO_RUN3,
    S_TROO_RUN4,
    S_TROO_RUN5,
    S_TROO_RUN6,
    S_TROO_RUN7,
    S_TROO_RUN8,
    S_TROO_ATK1,
    S_TROO_ATK2,
    S_TROO_ATK3,
    S_TROO_PAIN,
    S_TROO_PAIN2,
    S_TROO_DIE1,
    S_TROO_DIE2,
    S_TROO_DIE3,
    S_TROO_DIE4,
    S_TROO_DIE5,
    S_TROO_XDIE1,
    S_TROO_XDIE2,
    S_TROO_XDIE3,
    S_TROO_XDIE4,
    S_TROO_XDIE5,
    S_TROO_XDIE6,
    S_TROO_XDIE7,
    S_TROO_XDIE8,
    S_TROO_RAISE1,
    S_TROO_RAISE2,
    S_TROO_RAISE3,
    S_TROO_RAISE4,
    S_TROO_RAISE5,
    S_SARG_STND,
    S_SARG_STND2,
    S_SARG_RUN1,
    S_SARG_RUN2,
    S_SARG_RUN3,
    S_SARG_RUN4,
    S_SARG_RUN5,
    S_SARG_RUN6,
    S_SARG_RUN7,
    S_SARG_RUN8,
    S_SARG_ATK1,
    S_SARG_ATK2,
    S_SARG_ATK3,
    S_SARG_PAIN,
    S_SARG_PAIN2,
    S_SARG_DIE1,
    S_SARG_DIE2,
    S_SARG_DIE3,
    S_SARG_DIE4,
    S_SARG_DIE5,
    S_SARG_DIE6,
    S_SARG_RAISE1,
    S_SARG_RAISE2,
    S_SARG_RAISE3,
    S_SARG_RAISE4,
    S_SARG_RAISE5,
    S_SARG_RAISE6,
    S_HEAD_STND,
    S_HEAD_RUN1,
    S_HEAD_ATK1,
    S_HEAD_ATK2,
    S_HEAD_ATK3,
    S_HEAD_PAIN,
    S_HEAD_PAIN2,
    S_HEAD_PAIN3,
    S_HEAD_DIE1,
    S_HEAD_DIE2,
    S_HEAD_DIE3,
    S_HEAD_DIE4,
    S_HEAD_DIE5,
    S_HEAD_DIE6,
    S_HEAD_RAISE1,
    S_HEAD_RAISE2,
    S_HEAD_RAISE3,
    S_HEAD_RAISE4,
    S_HEAD_RAISE5,
    S_HEAD_RAISE6,
    S_BRBALL1,
    S_BRBALL2,
    S_BRBALLX1,
    S_BRBALLX2,
    S_BRBALLX3,
    S_BOSS_STND,
    S_BOSS_STND2,
    S_BOSS_RUN1,
    S_BOSS_RUN2,
    S_BOSS_RUN3,
    S_BOSS_RUN4,
    S_BOSS_RUN5,
    S_BOSS_RUN6,
    S_BOSS_RUN7,
    S_BOSS_RUN8,
    S_BOSS_ATK1,
    S_BOSS_ATK2,
    S_BOSS_ATK3,
    S_BOSS_PAIN,
    S_BOSS_PAIN2,
    S_BOSS_DIE1,
    S_BOSS_DIE2,
    S_BOSS_DIE3,
    S_BOSS_DIE4,
    S_BOSS_DIE5,
    S_BOSS_DIE6,
    S_BOSS_DIE7,
    S_BOSS_RAISE1,
    S_BOSS_RAISE2,
    S_BOSS_RAISE3,
    S_BOSS_RAISE4,
    S_BOSS_RAISE5,
    S_BOSS_RAISE6,
    S_BOSS_RAISE7,
    S_BOS2_STND,
    S_BOS2_STND2,
    S_BOS2_RUN1,
    S_BOS2_RUN2,
    S_BOS2_RUN3,
    S_BOS2_RUN4,
    S_BOS2_RUN5,
    S_BOS2_RUN6,
    S_BOS2_RUN7,
    S_BOS2_RUN8,
    S_BOS2_ATK1,
    S_BOS2_ATK2,
    S_BOS2_ATK3,
    S_BOS2_PAIN,
    S_BOS2_PAIN2,
    S_BOS2_DIE1,
    S_BOS2_DIE2,
    S_BOS2_DIE3,
    S_BOS2_DIE4,
    S_BOS2_DIE5,
    S_BOS2_DIE6,
    S_BOS2_DIE7,
    S_BOS2_RAISE1,
    S_BOS2_RAISE2,
    S_BOS2_RAISE3,
    S_BOS2_RAISE4,
    S_BOS2_RAISE5,
    S_BOS2_RAISE6,
    S_BOS2_RAISE7,
    S_SKULL_STND,
    S_SKULL_STND2,
    S_SKULL_RUN1,
    S_SKULL_RUN2,
    S_SKULL_ATK1,
    S_SKULL_ATK2,
    S_SKULL_ATK3,
    S_SKULL_ATK4,
    S_SKULL_PAIN,
    S_SKULL_PAIN2,
    S_SKULL_DIE1,
    S_SKULL_DIE2,
    S_SKULL_DIE3,
    S_SKULL_DIE4,
    S_SKULL_DIE5,
    S_SKULL_DIE6,
    S_SPID_STND,
    S_SPID_STND2,
    S_SPID_RUN1,
    S_SPID_RUN2,
    S_SPID_RUN3,
    S_SPID_RUN4,
    S_SPID_RUN5,
    S_SPID_RUN6,
    S_SPID_RUN7,
    S_SPID_RUN8,
    S_SPID_RUN9,
    S_SPID_RUN10,
    S_SPID_RUN11,
    S_SPID_RUN12,
    S_SPID_ATK1,
    S_SPID_ATK2,
    S_SPID_ATK3,
    S_SPID_ATK4,
    S_SPID_PAIN,
    S_SPID_PAIN2,
    S_SPID_DIE1,
    S_SPID_DIE2,
    S_SPID_DIE3,
    S_SPID_DIE4,
    S_SPID_DIE5,
    S_SPID_DIE6,
    S_SPID_DIE7,
    S_SPID_DIE8,
    S_SPID_DIE9,
    S_SPID_DIE10,
    S_SPID_DIE11,
    S_BSPI_STND,
    S_BSPI_STND2,
    S_BSPI_SIGHT,
    S_BSPI_RUN1,
    S_BSPI_RUN2,
    S_BSPI_RUN3,
    S_BSPI_RUN4,
    S_BSPI_RUN5,
    S_BSPI_RUN6,
    S_BSPI_RUN7,
    S_BSPI_RUN8,
    S_BSPI_RUN9,
    S_BSPI_RUN10,
    S_BSPI_RUN11,
    S_BSPI_RUN12,
    S_BSPI_ATK1,
    S_BSPI_ATK2,
    S_BSPI_ATK3,
    S_BSPI_ATK4,
    S_BSPI_PAIN,
    S_BSPI_PAIN2,
    S_BSPI_DIE1,
    S_BSPI_DIE2,
    S_BSPI_DIE3,
    S_BSPI_DIE4,
    S_BSPI_DIE5,
    S_BSPI_DIE6,
    S_BSPI_DIE7,
    S_BSPI_RAISE1,
    S_BSPI_RAISE2,
    S_BSPI_RAISE3,
    S_BSPI_RAISE4,
    S_BSPI_RAISE5,
    S_BSPI_RAISE6,
    S_BSPI_RAISE7,
    S_ARACH_PLAZ,
    S_ARACH_PLAZ2,
    S_ARACH_PLEX,
    S_ARACH_PLEX2,
    S_ARACH_PLEX3,
    S_ARACH_PLEX4,
    S_ARACH_PLEX5,
    S_CYBER_STND,
    S_CYBER_STND2,
    S_CYBER_RUN1,
    S_CYBER_RUN2,
    S_CYBER_RUN3,
    S_CYBER_RUN4,
    S_CYBER_RUN5,
    S_CYBER_RUN6,
    S_CYBER_RUN7,
    S_CYBER_RUN8,
    S_CYBER_ATK1,
    S_CYBER_ATK2,
    S_CYBER_ATK3,
    S_CYBER_ATK4,
    S_CYBER_ATK5,
    S_CYBER_ATK6,
    S_CYBER_PAIN,
    S_CYBER_DIE1,
    S_CYBER_DIE2,
    S_CYBER_DIE3,
    S_CYBER_DIE4,
    S_CYBER_DIE5,
    S_CYBER_DIE6,
    S_CYBER_DIE7,
    S_CYBER_DIE8,
    S_CYBER_DIE9,
    S_CYBER_DIE10,
    S_PAIN_STND,
    S_PAIN_RUN1,
    S_PAIN_RUN2,
    S_PAIN_RUN3,
    S_PAIN_RUN4,
    S_PAIN_RUN5,
    S_PAIN_RUN6,
    S_PAIN_ATK1,
    S_PAIN_ATK2,
    S_PAIN_ATK3,
    S_PAIN_ATK4,
    S_PAIN_PAIN,
    S_PAIN_PAIN2,
    S_PAIN_DIE1,
    S_PAIN_DIE2,
    S_PAIN_DIE3,
    S_PAIN_DIE4,
    S_PAIN_DIE5,
    S_PAIN_DIE6,
    S_PAIN_RAISE1,
    S_PAIN_RAISE2,
    S_PAIN_RAISE3,
    S_PAIN_RAISE4,
    S_PAIN_RAISE5,
    S_PAIN_RAISE6,
    S_SSWV_STND,
    S_SSWV_STND2,
    S_SSWV_RUN1,
    S_SSWV_RUN2,
    S_SSWV_RUN3,
    S_SSWV_RUN4,
    S_SSWV_RUN5,
    S_SSWV_RUN6,
    S_SSWV_RUN7,
    S_SSWV_RUN8,
    S_SSWV_ATK1,
    S_SSWV_ATK2,
    S_SSWV_ATK3,
    S_SSWV_ATK4,
    S_SSWV_ATK5,
    S_SSWV_ATK6,
    S_SSWV_PAIN,
    S_SSWV_PAIN2,
    S_SSWV_DIE1,
    S_SSWV_DIE2,
    S_SSWV_DIE3,
    S_SSWV_DIE4,
    S_SSWV_DIE5,
    S_SSWV_XDIE1,
    S_SSWV_XDIE2,
    S_SSWV_XDIE3,
    S_SSWV_XDIE4,
    S_SSWV_XDIE5,
    S_SSWV_XDIE6,
    S_SSWV_XDIE7,
    S_SSWV_XDIE8,
    S_SSWV_XDIE9,
    S_SSWV_RAISE1,
    S_SSWV_RAISE2,
    S_SSWV_RAISE3,
    S_SSWV_RAISE4,
    S_SSWV_RAISE5,
    S_KEENSTND,
    S_COMMKEEN,
    S_COMMKEEN2,
    S_COMMKEEN3,
    S_COMMKEEN4,
    S_COMMKEEN5,
    S_COMMKEEN6,
    S_COMMKEEN7,
    S_COMMKEEN8,
    S_COMMKEEN9,
    S_COMMKEEN10,
    S_COMMKEEN11,
    S_COMMKEEN12,
    S_KEENPAIN,
    S_KEENPAIN2,
    S_BRAIN,
    S_BRAIN_PAIN,
    S_BRAIN_DIE1,
    S_BRAIN_DIE2,
    S_BRAIN_DIE3,
    S_BRAIN_DIE4,
    S_BRAINEYE,
    S_BRAINEYESEE,
    S_BRAINEYE1,
    S_SPAWN1,
    S_SPAWN2,
    S_SPAWN3,
    S_SPAWN4,
    S_SPAWNFIRE1,
    S_SPAWNFIRE2,
    S_SPAWNFIRE3,
    S_SPAWNFIRE4,
    S_SPAWNFIRE5,
    S_SPAWNFIRE6,
    S_SPAWNFIRE7,
    S_SPAWNFIRE8,
    S_BRAINEXPLODE1,
    S_BRAINEXPLODE2,
    S_BRAINEXPLODE3,
    S_ARM1,
    S_ARM1A,
    S_ARM2,
    S_ARM2A,
    S_BAR1,
    S_BAR2,
    S_BEXP,
    S_BEXP2,
    S_BEXP3,
    S_BEXP4,
    S_BEXP5,
    S_BBAR1,
    S_BBAR2,
    S_BBAR3,
    S_BON1,
    S_BON1A,
    S_BON1B,
    S_BON1C,
    S_BON1D,
    S_BON1E,
    S_BON2,
    S_BON2A,
    S_BON2B,
    S_BON2C,
    S_BON2D,
    S_BON2E,
    S_BKEY,
    S_BKEY2,
    S_RKEY,
    S_RKEY2,
    S_YKEY,
    S_YKEY2,
    S_BSKULL,
    S_BSKULL2,
    S_RSKULL,
    S_RSKULL2,
    S_YSKULL,
    S_YSKULL2,
    S_STIM,
    S_MEDI,
    S_SOUL,
    S_SOUL2,
    S_SOUL3,
    S_SOUL4,
    S_SOUL5,
    S_SOUL6,
    S_PINV,
    S_PINV2,
    S_PINV3,
    S_PINV4,
    S_PSTR,
    S_PINS,
    S_PINS2,
    S_PINS3,
    S_PINS4,
    S_MEGA,
    S_MEGA2,
    S_MEGA3,
    S_MEGA4,
    S_SUIT,
    S_PMAP,
    S_PMAP2,
    S_PMAP3,
    S_PMAP4,
    S_PMAP5,
    S_PMAP6,
    S_PVIS,
    S_PVIS2,
    S_CLIP,
    S_AMMO,
    S_ROCK,
    S_BROK,
    S_CELL,
    S_CELP,
    S_SHEL,
    S_SBOX,
    S_BPAK,
    S_BFUG,
    S_MGUN,
    S_CSAW,
    S_LAUN,
    S_PLAS,
    S_SHOT,
    S_SHOT2,
    S_COLU,
    S_STALAG,
    S_BLOODYTWITCH,
    S_BLOODYTWITCH2,
    S_BLOODYTWITCH3,
    S_BLOODYTWITCH4,
    S_DEADTORSO,
    S_DEADBOTTOM,
    S_HEADSONSTICK,
    S_GIBS,
    S_HEADONASTICK,
    S_HEADCANDLES,
    S_HEADCANDLES2,
    S_DEADSTICK,
    S_LIVESTICK,
    S_LIVESTICK2,
    S_MEAT2,
    S_MEAT3,
    S_MEAT4,
    S_MEAT5,
    S_STALAGTITE,
    S_TALLGRNCOL,
    S_SHRTGRNCOL,
    S_TALLREDCOL,
    S_SHRTREDCOL,
    S_CANDLESTIK,
    S_CANDELABRA,
    S_SKULLCOL,
    S_TORCHTREE,
    S_BIGTREE,
    S_TECHPILLAR,
    S_EVILEYE,
    S_EVILEYE2,
    S_EVILEYE3,
    S_EVILEYE4,
    S_FLOATSKULL,
    S_FLOATSKULL2,
    S_FLOATSKULL3,
    S_HEARTCOL,
    S_HEARTCOL2,
    S_BLUETORCH,
    S_BLUETORCH2,
    S_BLUETORCH3,
    S_BLUETORCH4,
    S_GREENTORCH,
    S_GREENTORCH2,
    S_GREENTORCH3,
    S_GREENTORCH4,
    S_REDTORCH,
    S_REDTORCH2,
    S_REDTORCH3,
    S_REDTORCH4,
    S_BTORCHSHRT,
    S_BTORCHSHRT2,
    S_BTORCHSHRT3,
    S_BTORCHSHRT4,
    S_GTORCHSHRT,
    S_GTORCHSHRT2,
    S_GTORCHSHRT3,
    S_GTORCHSHRT4,
    S_RTORCHSHRT,
    S_RTORCHSHRT2,
    S_RTORCHSHRT3,
    S_RTORCHSHRT4,
    S_HANGNOGUTS,
    S_HANGBNOBRAIN,
    S_HANGTLOOKDN,
    S_HANGTSKULL,
    S_HANGTLOOKUP,
    S_HANGTNOBRAIN,
    S_COLONGIBS,
    S_SMALLPOOL,
    S_BRAINSTEM,
    S_TECHLAMP,
    S_TECHLAMP2,
    S_TECHLAMP3,
    S_TECHLAMP4,
    S_TECH2LAMP,
    S_TECH2LAMP2,
    S_TECH2LAMP3,
    S_TECH2LAMP4,
    //Fab: added lava/slime damage burn smoke
    S_SMOK1,
    S_SMOK2,
    S_SMOK3,
    S_SMOK4,
    S_SMOK5,
    //Fab: added water splash
    S_SPLASH1,
    S_SPLASH2,
    S_SPLASH3,
    S_TNT1,   //SoM: 3/9/2000: add state for invisible sprite

// heretic stuff

S_FREETARGMOBJ,
S_ITEM_PTN1_1,
S_ITEM_PTN1_2,
S_ITEM_PTN1_3,
S_ITEM_SHLD1,
S_ITEM_SHD2_1,
S_ITEM_BAGH1,
S_ITEM_SPMP1,
S_HIDESPECIAL1,
S_HIDESPECIAL2,
S_HIDESPECIAL3,
S_HIDESPECIAL4,
S_HIDESPECIAL5,
S_HIDESPECIAL6,
S_HIDESPECIAL7,
S_HIDESPECIAL8,
S_HIDESPECIAL9,
S_HIDESPECIAL10,
S_HIDESPECIAL11,
S_DORMANTARTI1,
S_DORMANTARTI2,
S_DORMANTARTI3,
S_DORMANTARTI4,
S_DORMANTARTI5,
S_DORMANTARTI6,
S_DORMANTARTI7,
S_DORMANTARTI8,
S_DORMANTARTI9,
S_DORMANTARTI10,
S_DORMANTARTI11,
S_DORMANTARTI12,
S_DORMANTARTI13,
S_DORMANTARTI14,
S_DORMANTARTI15,
S_DORMANTARTI16,
S_DORMANTARTI17,
S_DORMANTARTI18,
S_DORMANTARTI19,
S_DORMANTARTI20,
S_DORMANTARTI21,
S_DEADARTI1,
S_DEADARTI2,
S_DEADARTI3,
S_DEADARTI4,
S_DEADARTI5,
S_DEADARTI6,
S_DEADARTI7,
S_DEADARTI8,
S_DEADARTI9,
S_DEADARTI10,
S_ARTI_INVS1,
S_ARTI_PTN2_1,
S_ARTI_PTN2_2,
S_ARTI_PTN2_3,
S_ARTI_SOAR1,
S_ARTI_SOAR2,
S_ARTI_SOAR3,
S_ARTI_SOAR4,
S_ARTI_INVU1,
S_ARTI_INVU2,
S_ARTI_INVU3,
S_ARTI_INVU4,
S_ARTI_PWBK1,
S_ARTI_EGGC1,
S_ARTI_EGGC2,
S_ARTI_EGGC3,
S_ARTI_EGGC4,
S_EGGFX1,
S_EGGFX2,
S_EGGFX3,
S_EGGFX4,
S_EGGFX5,
S_EGGFXI1_1,
S_EGGFXI1_2,
S_EGGFXI1_3,
S_EGGFXI1_4,
S_ARTI_SPHL1,
S_ARTI_TRCH1,
S_ARTI_TRCH2,
S_ARTI_TRCH3,
S_ARTI_FBMB1,
S_FIREBOMB1,
S_FIREBOMB2,
S_FIREBOMB3,
S_FIREBOMB4,
S_FIREBOMB5,
S_FIREBOMB6,
S_FIREBOMB7,
S_FIREBOMB8,
S_FIREBOMB9,
S_FIREBOMB10,
S_FIREBOMB11,
S_ARTI_ATLP1,
S_ARTI_ATLP2,
S_ARTI_ATLP3,
S_ARTI_ATLP4,
S_POD_WAIT1,
S_POD_PAIN1,
S_POD_DIE1,
S_POD_DIE2,
S_POD_DIE3,
S_POD_DIE4,
S_POD_GROW1,
S_POD_GROW2,
S_POD_GROW3,
S_POD_GROW4,
S_POD_GROW5,
S_POD_GROW6,
S_POD_GROW7,
S_POD_GROW8,
S_PODGOO1,
S_PODGOO2,
S_PODGOOX,
S_PODGENERATOR,
S_HSPLASH1,
S_HSPLASH2,
S_HSPLASH3,
S_HSPLASH4,
S_SPLASHX,
S_SPLASHBASE1,
S_SPLASHBASE2,
S_SPLASHBASE3,
S_SPLASHBASE4,
S_SPLASHBASE5,
S_SPLASHBASE6,
S_SPLASHBASE7,
S_LAVASPLASH1,
S_LAVASPLASH2,
S_LAVASPLASH3,
S_LAVASPLASH4,
S_LAVASPLASH5,
S_LAVASPLASH6,
S_LAVASMOKE1,
S_LAVASMOKE2,
S_LAVASMOKE3,
S_LAVASMOKE4,
S_LAVASMOKE5,
S_SLUDGECHUNK1,
S_SLUDGECHUNK2,
S_SLUDGECHUNK3,
S_SLUDGECHUNK4,
S_SLUDGECHUNKX,
S_SLUDGESPLASH1,
S_SLUDGESPLASH2,
S_SLUDGESPLASH3,
S_SLUDGESPLASH4,
S_SKULLHANG70_1,
S_SKULLHANG60_1,
S_SKULLHANG45_1,
S_SKULLHANG35_1,
S_CHANDELIER1,
S_CHANDELIER2,
S_CHANDELIER3,
S_SERPTORCH1,
S_SERPTORCH2,
S_SERPTORCH3,
S_SMALLPILLAR,
S_STALAGMITESMALL,
S_STALAGMITELARGE,
S_STALACTITESMALL,
S_STALACTITELARGE,
S_FIREBRAZIER1,
S_FIREBRAZIER2,
S_FIREBRAZIER3,
S_FIREBRAZIER4,
S_FIREBRAZIER5,
S_FIREBRAZIER6,
S_FIREBRAZIER7,
S_FIREBRAZIER8,
S_BARREL,
S_BRPILLAR,
S_MOSS1,
S_MOSS2,
S_WALLTORCH1,
S_WALLTORCH2,
S_WALLTORCH3,
S_HANGINGCORPSE,
S_KEYGIZMO1,
S_KEYGIZMO2,
S_KEYGIZMO3,
S_KGZ_START,
S_KGZ_BLUEFLOAT1,
S_KGZ_GREENFLOAT1,
S_KGZ_YELLOWFLOAT1,
S_VOLCANO1,
S_VOLCANO2,
S_VOLCANO3,
S_VOLCANO4,
S_VOLCANO5,
S_VOLCANO6,
S_VOLCANO7,
S_VOLCANO8,
S_VOLCANO9,
S_VOLCANOBALL1,
S_VOLCANOBALL2,
S_VOLCANOBALLX1,
S_VOLCANOBALLX2,
S_VOLCANOBALLX3,
S_VOLCANOBALLX4,
S_VOLCANOBALLX5,
S_VOLCANOBALLX6,
S_VOLCANOTBALL1,
S_VOLCANOTBALL2,
S_VOLCANOTBALLX1,
S_VOLCANOTBALLX2,
S_VOLCANOTBALLX3,
S_VOLCANOTBALLX4,
S_VOLCANOTBALLX5,
S_VOLCANOTBALLX6,
S_VOLCANOTBALLX7,
S_TELEGLITGEN1,
S_TELEGLITGEN2,
S_TELEGLITTER1_1,
S_TELEGLITTER1_2,
S_TELEGLITTER1_3,
S_TELEGLITTER1_4,
S_TELEGLITTER1_5,
S_TELEGLITTER2_1,
S_TELEGLITTER2_2,
S_TELEGLITTER2_3,
S_TELEGLITTER2_4,
S_TELEGLITTER2_5,
S_HTFOG1,
S_HTFOG2,
S_HTFOG3,
S_HTFOG4,
S_HTFOG5,
S_HTFOG6,
S_HTFOG7,
S_HTFOG8,
S_HTFOG9,
S_HTFOG10,
S_HTFOG11,
S_HTFOG12,
S_HTFOG13,
S_HLIGHTDONE,  // apparently unused
S_STAFFREADY,
S_STAFFDOWN,
S_STAFFUP,
S_STAFFREADY2_1,
S_STAFFREADY2_2,
S_STAFFREADY2_3,
S_STAFFDOWN2,
S_STAFFUP2,
S_STAFFATK1_1,
S_STAFFATK1_2,
S_STAFFATK1_3,
S_STAFFATK2_1,
S_STAFFATK2_2,
S_STAFFATK2_3,
S_STAFFPUFF1,
S_STAFFPUFF2,
S_STAFFPUFF3,
S_STAFFPUFF4,
S_STAFFPUFF2_1,
S_STAFFPUFF2_2,
S_STAFFPUFF2_3,
S_STAFFPUFF2_4,
S_STAFFPUFF2_5,
S_STAFFPUFF2_6,
S_BEAKREADY,
S_BEAKDOWN,
S_BEAKUP,
S_BEAKATK1_1,
S_BEAKATK2_1,
S_WGNT,
S_GAUNTLETREADY,
S_GAUNTLETDOWN,
S_GAUNTLETUP,
S_GAUNTLETREADY2_1,
S_GAUNTLETREADY2_2,
S_GAUNTLETREADY2_3,
S_GAUNTLETDOWN2,
S_GAUNTLETUP2,
S_GAUNTLETATK1_1,
S_GAUNTLETATK1_2,
S_GAUNTLETATK1_3,
S_GAUNTLETATK1_4,
S_GAUNTLETATK1_5,
S_GAUNTLETATK1_6,
S_GAUNTLETATK1_7,
S_GAUNTLETATK2_1,
S_GAUNTLETATK2_2,
S_GAUNTLETATK2_3,
S_GAUNTLETATK2_4,
S_GAUNTLETATK2_5,
S_GAUNTLETATK2_6,
S_GAUNTLETATK2_7,
S_GAUNTLETPUFF1_1,
S_GAUNTLETPUFF1_2,
S_GAUNTLETPUFF1_3,
S_GAUNTLETPUFF1_4,
S_GAUNTLETPUFF2_1,
S_GAUNTLETPUFF2_2,
S_GAUNTLETPUFF2_3,
S_GAUNTLETPUFF2_4,
S_BLSR,
S_BLASTERREADY,
S_BLASTERDOWN,
S_BLASTERUP,
S_BLASTERATK1_1,
S_BLASTERATK1_2,
S_BLASTERATK1_3,
S_BLASTERATK1_4,
S_BLASTERATK1_5,
S_BLASTERATK1_6,
S_BLASTERATK2_1,
S_BLASTERATK2_2,
S_BLASTERATK2_3,
S_BLASTERATK2_4,
S_BLASTERATK2_5,
S_BLASTERATK2_6,
S_BLASTERFX1_1,
S_BLASTERFXI1_1,
S_BLASTERFXI1_2,
S_BLASTERFXI1_3,
S_BLASTERFXI1_4,
S_BLASTERFXI1_5,
S_BLASTERFXI1_6,
S_BLASTERFXI1_7,
S_BLASTERSMOKE1,
S_BLASTERSMOKE2,
S_BLASTERSMOKE3,
S_BLASTERSMOKE4,
S_BLASTERSMOKE5,
S_RIPPER1,
S_RIPPER2,
S_RIPPERX1,
S_RIPPERX2,
S_RIPPERX3,
S_RIPPERX4,
S_RIPPERX5,
S_BLASTERPUFF1_1,
S_BLASTERPUFF1_2,
S_BLASTERPUFF1_3,
S_BLASTERPUFF1_4,
S_BLASTERPUFF1_5,
S_BLASTERPUFF2_1,
S_BLASTERPUFF2_2,
S_BLASTERPUFF2_3,
S_BLASTERPUFF2_4,
S_BLASTERPUFF2_5,
S_BLASTERPUFF2_6,
S_BLASTERPUFF2_7,
S_WMCE,
S_MACEREADY,
S_MACEDOWN,
S_MACEUP,
S_MACEATK1_1,
S_MACEATK1_2,
S_MACEATK1_3,
S_MACEATK1_4,
S_MACEATK1_5,
S_MACEATK1_6,
S_MACEATK1_7,
S_MACEATK1_8,
S_MACEATK1_9,
S_MACEATK1_10,
S_MACEATK2_1,
S_MACEATK2_2,
S_MACEATK2_3,
S_MACEATK2_4,
S_MACEFX1_1,
S_MACEFX1_2,
S_MACEFXI1_1,
S_MACEFXI1_2,
S_MACEFXI1_3,
S_MACEFXI1_4,
S_MACEFXI1_5,
S_MACEFX2_1,
S_MACEFX2_2,
S_MACEFXI2_1,
S_MACEFX3_1,
S_MACEFX3_2,
S_MACEFX4_1,
S_MACEFXI4_1,
S_WSKL,
S_HORNRODREADY,
S_HORNRODDOWN,
S_HORNRODUP,
S_HORNRODATK1_1,
S_HORNRODATK1_2,
S_HORNRODATK1_3,
S_HORNRODATK2_1,
S_HORNRODATK2_2,
S_HORNRODATK2_3,
S_HORNRODATK2_4,
S_HORNRODATK2_5,
S_HORNRODATK2_6,
S_HORNRODATK2_7,
S_HORNRODATK2_8,
S_HORNRODATK2_9,
S_HRODFX1_1,
S_HRODFX1_2,
S_HRODFXI1_1,
S_HRODFXI1_2,
S_HRODFXI1_3,
S_HRODFXI1_4,
S_HRODFXI1_5,
S_HRODFXI1_6,
S_HRODFX2_1,
S_HRODFX2_2,
S_HRODFX2_3,
S_HRODFX2_4,
S_HRODFXI2_1,
S_HRODFXI2_2,
S_HRODFXI2_3,
S_HRODFXI2_4,
S_HRODFXI2_5,
S_HRODFXI2_6,
S_HRODFXI2_7,
S_HRODFXI2_8,
S_RAINPLR1_1,
S_RAINPLR2_1,
S_RAINPLR3_1,
S_RAINPLR4_1,
S_RAINPLR1X_1,
S_RAINPLR1X_2,
S_RAINPLR1X_3,
S_RAINPLR1X_4,
S_RAINPLR1X_5,
S_RAINPLR2X_1,
S_RAINPLR2X_2,
S_RAINPLR2X_3,
S_RAINPLR2X_4,
S_RAINPLR2X_5,
S_RAINPLR3X_1,
S_RAINPLR3X_2,
S_RAINPLR3X_3,
S_RAINPLR3X_4,
S_RAINPLR3X_5,
S_RAINPLR4X_1,
S_RAINPLR4X_2,
S_RAINPLR4X_3,
S_RAINPLR4X_4,
S_RAINPLR4X_5,
S_RAINAIRXPLR1_1,
S_RAINAIRXPLR2_1,
S_RAINAIRXPLR3_1,
S_RAINAIRXPLR4_1,
S_RAINAIRXPLR1_2,
S_RAINAIRXPLR2_2,
S_RAINAIRXPLR3_2,
S_RAINAIRXPLR4_2,
S_RAINAIRXPLR1_3,
S_RAINAIRXPLR2_3,
S_RAINAIRXPLR3_3,
S_RAINAIRXPLR4_3,
S_GOLDWANDREADY,
S_GOLDWANDDOWN,
S_GOLDWANDUP,
S_GOLDWANDATK1_1,
S_GOLDWANDATK1_2,
S_GOLDWANDATK1_3,
S_GOLDWANDATK1_4,
S_GOLDWANDATK2_1,
S_GOLDWANDATK2_2,
S_GOLDWANDATK2_3,
S_GOLDWANDATK2_4,
S_GWANDFX1_1,
S_GWANDFX1_2,
S_GWANDFXI1_1,
S_GWANDFXI1_2,
S_GWANDFXI1_3,
S_GWANDFXI1_4,
S_GWANDFX2_1,
S_GWANDFX2_2,
S_GWANDPUFF1_1,
S_GWANDPUFF1_2,
S_GWANDPUFF1_3,
S_GWANDPUFF1_4,
S_GWANDPUFF1_5,
S_WPHX,
S_PHOENIXREADY,
S_PHOENIXDOWN,
S_PHOENIXUP,
S_PHOENIXATK1_1,
S_PHOENIXATK1_2,
S_PHOENIXATK1_3,
S_PHOENIXATK1_4,
S_PHOENIXATK1_5,
S_PHOENIXATK2_1,
S_PHOENIXATK2_2,
S_PHOENIXATK2_3,
S_PHOENIXATK2_4,
S_PHOENIXFX1_1,
S_PHOENIXFXI1_1,
S_PHOENIXFXI1_2,
S_PHOENIXFXI1_3,
S_PHOENIXFXI1_4,
S_PHOENIXFXI1_5,
S_PHOENIXFXI1_6,
S_PHOENIXFXI1_7,
S_PHOENIXFXI1_8,
S_PHOENIXPUFF1,
S_PHOENIXPUFF2,
S_PHOENIXPUFF3,
S_PHOENIXPUFF4,
S_PHOENIXPUFF5,
S_PHOENIXFX2_1,
S_PHOENIXFX2_2,
S_PHOENIXFX2_3,
S_PHOENIXFX2_4,
S_PHOENIXFX2_5,
S_PHOENIXFX2_6,
S_PHOENIXFX2_7,
S_PHOENIXFX2_8,
S_PHOENIXFX2_9,
S_PHOENIXFX2_10,
S_PHOENIXFXI2_1,
S_PHOENIXFXI2_2,
S_PHOENIXFXI2_3,
S_PHOENIXFXI2_4,
S_PHOENIXFXI2_5,
S_WBOW,
S_CRBOW1,
S_CRBOW2,
S_CRBOW3,
S_CRBOW4,
S_CRBOW5,
S_CRBOW6,
S_CRBOW7,
S_CRBOW8,
S_CRBOW9,
S_CRBOW10,
S_CRBOW11,
S_CRBOW12,
S_CRBOW13,
S_CRBOW14,
S_CRBOW15,
S_CRBOW16,
S_CRBOW17,
S_CRBOW18,
S_CRBOWDOWN,
S_CRBOWUP,
S_CRBOWATK1_1,
S_CRBOWATK1_2,
S_CRBOWATK1_3,
S_CRBOWATK1_4,
S_CRBOWATK1_5,
S_CRBOWATK1_6,
S_CRBOWATK1_7,
S_CRBOWATK1_8,
S_CRBOWATK2_1,
S_CRBOWATK2_2,
S_CRBOWATK2_3,
S_CRBOWATK2_4,
S_CRBOWATK2_5,
S_CRBOWATK2_6,
S_CRBOWATK2_7,
S_CRBOWATK2_8,
S_CRBOWFX1,
S_CRBOWFXI1_1,
S_CRBOWFXI1_2,
S_CRBOWFXI1_3,
S_CRBOWFX2,
S_CRBOWFX3,
S_CRBOWFXI3_1,
S_CRBOWFXI3_2,
S_CRBOWFXI3_3,
S_CRBOWFX4_1,
S_CRBOWFX4_2,
//S_HBLOOD1,
//S_HBLOOD2,
//S_HBLOOD3,
S_BLOODSPLATTER1,
S_BLOODSPLATTER2,
S_BLOODSPLATTER3,
S_BLOODSPLATTERX,
/*
S_PLAY,
S_PLAY_RUN1,
S_PLAY_RUN2,
S_PLAY_RUN3,
S_PLAY_RUN4,
S_PLAY_ATK1,
S_PLAY_ATK2,
S_PLAY_PAIN,
S_PLAY_PAIN2,
S_PLAY_DIE1,
S_PLAY_DIE2,
S_PLAY_DIE3,
S_PLAY_DIE4,
S_PLAY_DIE5,
S_PLAY_DIE6,
S_PLAY_DIE7,
S_PLAY_DIE8,
S_PLAY_DIE9,
S_PLAY_XDIE1,
S_PLAY_XDIE2,
S_PLAY_XDIE3,
S_PLAY_XDIE4,
S_PLAY_XDIE5,
S_PLAY_XDIE6,
S_PLAY_XDIE7,
S_PLAY_XDIE8,
S_PLAY_XDIE9,
S_PLAY_FDTH1,
S_PLAY_FDTH2,
S_PLAY_FDTH3,
S_PLAY_FDTH4,
S_PLAY_FDTH5,
S_PLAY_FDTH6,
S_PLAY_FDTH7,
S_PLAY_FDTH8,
S_PLAY_FDTH9,
S_PLAY_FDTH10,
S_PLAY_FDTH11,
S_PLAY_FDTH12,
S_PLAY_FDTH13,
S_PLAY_FDTH14,
S_PLAY_FDTH15,
S_PLAY_FDTH16,
S_PLAY_FDTH17,
S_PLAY_FDTH18,
S_PLAY_FDTH19,
S_PLAY_FDTH20,
*/
S_BLOODYSKULL1,
S_BLOODYSKULL2,
S_BLOODYSKULL3,
S_BLOODYSKULL4,
S_BLOODYSKULL5,
S_BLOODYSKULLX1,
S_BLOODYSKULLX2,
S_CHICPLAY,
S_CHICPLAY_RUN1,
S_CHICPLAY_RUN2,
S_CHICPLAY_RUN3,
S_CHICPLAY_RUN4,
S_CHICPLAY_ATK1,
S_CHICPLAY_PAIN,
S_CHICPLAY_PAIN2,
S_CHICKEN_LOOK1,
S_CHICKEN_LOOK2,
S_CHICKEN_WALK1,
S_CHICKEN_WALK2,
S_CHICKEN_PAIN1,
S_CHICKEN_PAIN2,
S_CHICKEN_ATK1,
S_CHICKEN_ATK2,
S_CHICKEN_DIE1,
S_CHICKEN_DIE2,
S_CHICKEN_DIE3,
S_CHICKEN_DIE4,
S_CHICKEN_DIE5,
S_CHICKEN_DIE6,
S_CHICKEN_DIE7,
S_CHICKEN_DIE8,
S_FEATHER1,
S_FEATHER2,
S_FEATHER3,
S_FEATHER4,
S_FEATHER5,
S_FEATHER6,
S_FEATHER7,
S_FEATHER8,
S_FEATHERX,
S_MUMMY_LOOK1,
S_MUMMY_LOOK2,
S_MUMMY_WALK1,
S_MUMMY_WALK2,
S_MUMMY_WALK3,
S_MUMMY_WALK4,
S_MUMMY_ATK1,
S_MUMMY_ATK2,
S_MUMMY_ATK3,
S_MUMMYL_ATK1,
S_MUMMYL_ATK2,
S_MUMMYL_ATK3,
S_MUMMYL_ATK4,
S_MUMMYL_ATK5,
S_MUMMYL_ATK6,
S_MUMMY_PAIN1,
S_MUMMY_PAIN2,
S_MUMMY_DIE1,
S_MUMMY_DIE2,
S_MUMMY_DIE3,
S_MUMMY_DIE4,
S_MUMMY_DIE5,
S_MUMMY_DIE6,
S_MUMMY_DIE7,
S_MUMMY_DIE8,
S_MUMMY_SOUL1,
S_MUMMY_SOUL2,
S_MUMMY_SOUL3,
S_MUMMY_SOUL4,
S_MUMMY_SOUL5,
S_MUMMY_SOUL6,
S_MUMMY_SOUL7,
S_MUMMYFX1_1,
S_MUMMYFX1_2,
S_MUMMYFX1_3,
S_MUMMYFX1_4,
S_MUMMYFXI1_1,
S_MUMMYFXI1_2,
S_MUMMYFXI1_3,
S_MUMMYFXI1_4,
S_BEAST_LOOK1,
S_BEAST_LOOK2,
S_BEAST_WALK1,
S_BEAST_WALK2,
S_BEAST_WALK3,
S_BEAST_WALK4,
S_BEAST_WALK5,
S_BEAST_WALK6,
S_BEAST_ATK1,
S_BEAST_ATK2,
S_BEAST_PAIN1,
S_BEAST_PAIN2,
S_BEAST_DIE1,
S_BEAST_DIE2,
S_BEAST_DIE3,
S_BEAST_DIE4,
S_BEAST_DIE5,
S_BEAST_DIE6,
S_BEAST_DIE7,
S_BEAST_DIE8,
S_BEAST_DIE9,
S_BEAST_XDIE1,
S_BEAST_XDIE2,
S_BEAST_XDIE3,
S_BEAST_XDIE4,
S_BEAST_XDIE5,
S_BEAST_XDIE6,
S_BEAST_XDIE7,
S_BEAST_XDIE8,
S_BEASTBALL1,
S_BEASTBALL2,
S_BEASTBALL3,
S_BEASTBALL4,
S_BEASTBALL5,
S_BEASTBALL6,
S_BEASTBALLX1,
S_BEASTBALLX2,
S_BEASTBALLX3,
S_BEASTBALLX4,
S_BEASTBALLX5,
S_BURNBALL1,
S_BURNBALL2,
S_BURNBALL3,
S_BURNBALL4,
S_BURNBALL5,
S_BURNBALL6,
S_BURNBALL7,
S_BURNBALL8,
S_BURNBALLFB1,
S_BURNBALLFB2,
S_BURNBALLFB3,
S_BURNBALLFB4,
S_BURNBALLFB5,
S_BURNBALLFB6,
S_BURNBALLFB7,
S_BURNBALLFB8,
S_PUFFY1,
S_PUFFY2,
S_PUFFY3,
S_PUFFY4,
S_PUFFY5,
S_SNAKE_LOOK1,
S_SNAKE_LOOK2,
S_SNAKE_WALK1,
S_SNAKE_WALK2,
S_SNAKE_WALK3,
S_SNAKE_WALK4,
S_SNAKE_ATK1,
S_SNAKE_ATK2,
S_SNAKE_ATK3,
S_SNAKE_ATK4,
S_SNAKE_ATK5,
S_SNAKE_ATK6,
S_SNAKE_ATK7,
S_SNAKE_ATK8,
S_SNAKE_ATK9,
S_SNAKE_PAIN1,
S_SNAKE_PAIN2,
S_SNAKE_DIE1,
S_SNAKE_DIE2,
S_SNAKE_DIE3,
S_SNAKE_DIE4,
S_SNAKE_DIE5,
S_SNAKE_DIE6,
S_SNAKE_DIE7,
S_SNAKE_DIE8,
S_SNAKE_DIE9,
S_SNAKE_DIE10,
S_SNAKEPRO_A1,
S_SNAKEPRO_A2,
S_SNAKEPRO_A3,
S_SNAKEPRO_A4,
S_SNAKEPRO_AX1,
S_SNAKEPRO_AX2,
S_SNAKEPRO_AX3,
S_SNAKEPRO_AX4,
S_SNAKEPRO_AX5,
S_SNAKEPRO_B1,
S_SNAKEPRO_B2,
S_SNAKEPRO_BX1,
S_SNAKEPRO_BX2,
S_SNAKEPRO_BX3,
S_SNAKEPRO_BX4,
S_HHEAD_LOOK,
S_HHEAD_FLOAT,
S_HHEAD_ATK1,
S_HHEAD_ATK2,
S_HHEAD_PAIN1,
S_HHEAD_PAIN2,
S_HHEAD_DIE1,
S_HHEAD_DIE2,
S_HHEAD_DIE3,
S_HHEAD_DIE4,
S_HHEAD_DIE5,
S_HHEAD_DIE6,
S_HHEAD_DIE7,
S_HHEADFX1_1,
S_HHEADFX1_2,
S_HHEADFX1_3,
S_HHEADFXI1_1,
S_HHEADFXI1_2,
S_HHEADFXI1_3,
S_HHEADFXI1_4,
S_HHEADFX2_1,
S_HHEADFX2_2,
S_HHEADFX2_3,
S_HHEADFXI2_1,
S_HHEADFXI2_2,
S_HHEADFXI2_3,
S_HHEADFXI2_4,
S_HHEADFX3_1,
S_HHEADFX3_2,
S_HHEADFX3_3,
S_HHEADFX3_4,
S_HHEADFX3_5,
S_HHEADFX3_6,
S_HHEADFXI3_1,
S_HHEADFXI3_2,
S_HHEADFXI3_3,
S_HHEADFXI3_4,
S_HHEADFX4_1,
S_HHEADFX4_2,
S_HHEADFX4_3,
S_HHEADFX4_4,
S_HHEADFX4_5,
S_HHEADFX4_6,
S_HHEADFX4_7,
S_HHEADFXI4_1,
S_HHEADFXI4_2,
S_HHEADFXI4_3,
S_HHEADFXI4_4,
S_CLINK_LOOK1,
S_CLINK_LOOK2,
S_CLINK_WALK1,
S_CLINK_WALK2,
S_CLINK_WALK3,
S_CLINK_WALK4,
S_CLINK_ATK1,
S_CLINK_ATK2,
S_CLINK_ATK3,
S_CLINK_PAIN1,
S_CLINK_PAIN2,
S_CLINK_DIE1,
S_CLINK_DIE2,
S_CLINK_DIE3,
S_CLINK_DIE4,
S_CLINK_DIE5,
S_CLINK_DIE6,
S_CLINK_DIE7,
S_WIZARD_LOOK1,
S_WIZARD_LOOK2,
S_WIZARD_WALK1,
S_WIZARD_WALK2,
S_WIZARD_WALK3,
S_WIZARD_WALK4,
S_WIZARD_WALK5,
S_WIZARD_WALK6,
S_WIZARD_WALK7,
S_WIZARD_WALK8,
S_WIZARD_ATK1,
S_WIZARD_ATK2,
S_WIZARD_ATK3,
S_WIZARD_ATK4,
S_WIZARD_ATK5,
S_WIZARD_ATK6,
S_WIZARD_ATK7,
S_WIZARD_ATK8,
S_WIZARD_ATK9,
S_WIZARD_PAIN1,
S_WIZARD_PAIN2,
S_WIZARD_DIE1,
S_WIZARD_DIE2,
S_WIZARD_DIE3,
S_WIZARD_DIE4,
S_WIZARD_DIE5,
S_WIZARD_DIE6,
S_WIZARD_DIE7,
S_WIZARD_DIE8,
S_WIZFX1_1,
S_WIZFX1_2,
S_WIZFXI1_1,
S_WIZFXI1_2,
S_WIZFXI1_3,
S_WIZFXI1_4,
S_WIZFXI1_5,
S_IMP_LOOK1,
S_IMP_LOOK2,
S_IMP_LOOK3,
S_IMP_LOOK4,
S_IMP_FLY1,
S_IMP_FLY2,
S_IMP_FLY3,
S_IMP_FLY4,
S_IMP_FLY5,
S_IMP_FLY6,
S_IMP_FLY7,
S_IMP_FLY8,
S_IMP_MEATK1,
S_IMP_MEATK2,
S_IMP_MEATK3,
S_IMP_MSATK1_1,
S_IMP_MSATK1_2,
S_IMP_MSATK1_3,
S_IMP_MSATK1_4,
S_IMP_MSATK1_5,
S_IMP_MSATK1_6,
S_IMP_MSATK2_1,
S_IMP_MSATK2_2,
S_IMP_MSATK2_3,
S_IMP_PAIN1,
S_IMP_PAIN2,
S_IMP_DIE1,
S_IMP_DIE2,
S_IMP_XDIE1,
S_IMP_XDIE2,
S_IMP_XDIE3,
S_IMP_XDIE4,
S_IMP_XDIE5,
S_IMP_CRASH1,
S_IMP_CRASH2,
S_IMP_CRASH3,
S_IMP_CRASH4,
S_IMP_XCRASH1,
S_IMP_XCRASH2,
S_IMP_XCRASH3,
S_IMP_CHUNKA1,
S_IMP_CHUNKA2,
S_IMP_CHUNKA3,
S_IMP_CHUNKB1,
S_IMP_CHUNKB2,
S_IMP_CHUNKB3,
S_IMPFX1,
S_IMPFX2,
S_IMPFX3,
S_IMPFXI1,
S_IMPFXI2,
S_IMPFXI3,
S_IMPFXI4,
S_KNIGHT_STND1,
S_KNIGHT_STND2,
S_KNIGHT_WALK1,
S_KNIGHT_WALK2,
S_KNIGHT_WALK3,
S_KNIGHT_WALK4,
S_KNIGHT_ATK1,
S_KNIGHT_ATK2,
S_KNIGHT_ATK3,
S_KNIGHT_ATK4,
S_KNIGHT_ATK5,
S_KNIGHT_ATK6,
S_KNIGHT_PAIN1,
S_KNIGHT_PAIN2,
S_KNIGHT_DIE1,
S_KNIGHT_DIE2,
S_KNIGHT_DIE3,
S_KNIGHT_DIE4,
S_KNIGHT_DIE5,
S_KNIGHT_DIE6,
S_KNIGHT_DIE7,
S_SPINAXE1,
S_SPINAXE2,
S_SPINAXE3,
S_SPINAXEX1,
S_SPINAXEX2,
S_SPINAXEX3,
S_REDAXE1,
S_REDAXE2,
S_REDAXEX1,
S_REDAXEX2,
S_REDAXEX3,
S_SRCR1_LOOK1,
S_SRCR1_LOOK2,
S_SRCR1_WALK1,
S_SRCR1_WALK2,
S_SRCR1_WALK3,
S_SRCR1_WALK4,
S_SRCR1_PAIN1,
S_SRCR1_ATK1,
S_SRCR1_ATK2,
S_SRCR1_ATK3,
S_SRCR1_ATK4,
S_SRCR1_ATK5,
S_SRCR1_ATK6,
S_SRCR1_ATK7,
S_SRCR1_DIE1,
S_SRCR1_DIE2,
S_SRCR1_DIE3,
S_SRCR1_DIE4,
S_SRCR1_DIE5,
S_SRCR1_DIE6,
S_SRCR1_DIE7,
S_SRCR1_DIE8,
S_SRCR1_DIE9,
S_SRCR1_DIE10,
S_SRCR1_DIE11,
S_SRCR1_DIE12,
S_SRCR1_DIE13,
S_SRCR1_DIE14,
S_SRCR1_DIE15,
S_SRCR1_DIE16,
S_SRCR1_DIE17,
S_SRCRFX1_1,
S_SRCRFX1_2,
S_SRCRFX1_3,
S_SRCRFXI1_1,
S_SRCRFXI1_2,
S_SRCRFXI1_3,
S_SRCRFXI1_4,
S_SRCRFXI1_5,
S_SOR2_RISE1,
S_SOR2_RISE2,
S_SOR2_RISE3,
S_SOR2_RISE4,
S_SOR2_RISE5,
S_SOR2_RISE6,
S_SOR2_RISE7,
S_SOR2_LOOK1,
S_SOR2_LOOK2,
S_SOR2_WALK1,
S_SOR2_WALK2,
S_SOR2_WALK3,
S_SOR2_WALK4,
S_SOR2_PAIN1,
S_SOR2_PAIN2,
S_SOR2_ATK1,
S_SOR2_ATK2,
S_SOR2_ATK3,
S_SOR2_TELE1,
S_SOR2_TELE2,
S_SOR2_TELE3,
S_SOR2_TELE4,
S_SOR2_TELE5,
S_SOR2_TELE6,
S_SOR2_DIE1,
S_SOR2_DIE2,
S_SOR2_DIE3,
S_SOR2_DIE4,
S_SOR2_DIE5,
S_SOR2_DIE6,
S_SOR2_DIE7,
S_SOR2_DIE8,
S_SOR2_DIE9,
S_SOR2_DIE10,
S_SOR2_DIE11,
S_SOR2_DIE12,
S_SOR2_DIE13,
S_SOR2_DIE14,
S_SOR2_DIE15,
S_SOR2FX1_1,
S_SOR2FX1_2,
S_SOR2FX1_3,
S_SOR2FXI1_1,
S_SOR2FXI1_2,
S_SOR2FXI1_3,
S_SOR2FXI1_4,
S_SOR2FXI1_5,
S_SOR2FXI1_6,
S_SOR2FXSPARK1,
S_SOR2FXSPARK2,
S_SOR2FXSPARK3,
S_SOR2FX2_1,
S_SOR2FX2_2,
S_SOR2FX2_3,
S_SOR2FXI2_1,
S_SOR2FXI2_2,
S_SOR2FXI2_3,
S_SOR2FXI2_4,
S_SOR2FXI2_5,
S_SOR2TELEFADE1,
S_SOR2TELEFADE2,
S_SOR2TELEFADE3,
S_SOR2TELEFADE4,
S_SOR2TELEFADE5,
S_SOR2TELEFADE6,
S_MNTR_LOOK1,
S_MNTR_LOOK2,
S_MNTR_WALK1,
S_MNTR_WALK2,
S_MNTR_WALK3,
S_MNTR_WALK4,
S_MNTR_ATK1_1,
S_MNTR_ATK1_2,
S_MNTR_ATK1_3,
S_MNTR_ATK2_1,
S_MNTR_ATK2_2,
S_MNTR_ATK2_3,
S_MNTR_ATK3_1,
S_MNTR_ATK3_2,
S_MNTR_ATK3_3,
S_MNTR_ATK3_4,
S_MNTR_ATK4_1,
S_MNTR_PAIN1,
S_MNTR_PAIN2,
S_MNTR_DIE1,
S_MNTR_DIE2,
S_MNTR_DIE3,
S_MNTR_DIE4,
S_MNTR_DIE5,
S_MNTR_DIE6,
S_MNTR_DIE7,
S_MNTR_DIE8,
S_MNTR_DIE9,
S_MNTR_DIE10,
S_MNTR_DIE11,
S_MNTR_DIE12,
S_MNTR_DIE13,
S_MNTR_DIE14,
S_MNTR_DIE15,
S_MNTRFX1_1,
S_MNTRFX1_2,
S_MNTRFXI1_1,
S_MNTRFXI1_2,
S_MNTRFXI1_3,
S_MNTRFXI1_4,
S_MNTRFXI1_5,
S_MNTRFXI1_6,
S_MNTRFX2_1,
S_MNTRFXI2_1,
S_MNTRFXI2_2,
S_MNTRFXI2_3,
S_MNTRFXI2_4,
S_MNTRFXI2_5,
S_MNTRFX3_1,
S_MNTRFX3_2,
S_MNTRFX3_3,
S_MNTRFX3_4,
S_MNTRFX3_5,
S_MNTRFX3_6,
S_MNTRFX3_7,
S_MNTRFX3_8,
S_MNTRFX3_9,
S_AKYY1,
S_AKYY2,
S_AKYY3,
S_AKYY4,
S_AKYY5,
S_AKYY6,
S_AKYY7,
S_AKYY8,
S_AKYY9,
S_AKYY10,
S_BKYY1,
S_BKYY2,
S_BKYY3,
S_BKYY4,
S_BKYY5,
S_BKYY6,
S_BKYY7,
S_BKYY8,
S_BKYY9,
S_BKYY10,
S_CKYY1,
S_CKYY2,
S_CKYY3,
S_CKYY4,
S_CKYY5,
S_CKYY6,
S_CKYY7,
S_CKYY8,
S_CKYY9,
S_AMG1,
S_AMG2_1,
S_AMG2_2,
S_AMG2_3,
S_AMM1,
S_AMM2,
S_AMC1,
S_AMC2_1,
S_AMC2_2,
S_AMC2_3,
S_AMS1_1,
S_AMS1_2,
S_AMS2_1,
S_AMS2_2,
S_AMP1_1,
S_AMP1_2,
S_AMP1_3,
S_AMP2_1,
S_AMP2_2,
S_AMP2_3,
S_AMB1_1,
S_AMB1_2,
S_AMB1_3,
S_AMB2_1,
S_AMB2_2,
S_AMB2_3,
S_SND_WIND,
S_SND_WATERFALL,

    NUMSTATES
} statenum_t;


typedef struct
{
  spritenum_t   sprite;
  long          frame;          //faB: we use the upper 16bits for translucency
                                //     and other shade effects
  long          tics;
  // void       (*action) ();
  actionf_t     action;
  statenum_t    nextstate;
//  long          misc1, misc2;
} state_t;

extern state_t  states[NUMSTATES];
extern char *sprnames[NUMSPRITES+1];



typedef enum {
    MT_PLAYER,
    MT_POSSESSED,
    MT_SHOTGUY,
    MT_VILE,
    MT_FIRE,
    MT_UNDEAD,
    MT_TRACER,
    MT_SMOKE,
    MT_FATSO,
    MT_FATSHOT,
    MT_CHAINGUY,
    MT_TROOP,
    MT_SERGEANT,
    MT_SHADOWS,
    MT_HEAD,
    MT_BRUISER,
    MT_BRUISERSHOT,
    MT_KNIGHT,
    MT_SKULL,
    MT_SPIDER,
    MT_BABY,
    MT_CYBORG,
    MT_PAIN,
    MT_WOLFSS,
    MT_KEEN,
    MT_BOSSBRAIN,
    MT_BOSSSPIT,
    MT_BOSSTARGET,
    MT_SPAWNSHOT,
    MT_SPAWNFIRE,
    MT_BARREL,
    MT_TROOPSHOT,
    MT_HEADSHOT,
    MT_ROCKET,
    MT_PLASMA,
    MT_BFG,
    MT_ARACHPLAZ,
    MT_PUFF,
    MT_BLOOD,
    MT_TFOG,
    MT_IFOG,
    MT_TELEPORTMAN,
    MT_EXTRABFG,
    MT_MISC0,
    MT_MISC1,
    MT_MISC2,
    MT_MISC3,
    MT_MISC4,
    MT_MISC5,
    MT_MISC6,
    MT_MISC7,
    MT_MISC8,
    MT_MISC9,
    MT_MISC10,
    MT_MISC11,
    MT_MISC12,
    MT_INV,
    MT_MISC13,
    MT_INS,
    MT_MISC14,
    MT_MISC15,
    MT_MISC16,
    MT_MEGA,
    MT_CLIP,
    MT_MISC17,
    MT_MISC18,
    MT_MISC19,
    MT_MISC20,
    MT_MISC21,
    MT_MISC22,
    MT_MISC23,
    MT_MISC24,
    MT_BFG9000,
    MT_CHAINGUN,
    MT_SHAINSAW,
    MT_ROCKETLAUNCH,
    MT_PLASMAGUN,
    MT_SHOTGUN,
    MT_SUPERSHOTGUN,
    MT_MISC29,
    MT_MISC30,
    MT_MISC31,
    MT_MISC32,
    MT_MISC33,
    MT_MISC34,
    MT_MISC35,
    MT_MISC36,
    MT_MISC37,
    MT_MISC38,
    MT_MISC39,
    MT_MISC40,
    MT_MISC41,
    MT_MISC42,
    MT_MISC43,
    MT_MISC44,
    MT_MISC45,
    MT_MISC46,
    MT_MISC47,
    MT_MISC48,
    MT_MISC49,
    MT_MISC50,
    MT_MISC51,
    MT_MISC52,
    MT_MISC53,
    MT_MISC54,
    MT_MISC55,
    MT_MISC56,
    MT_MISC57,
    MT_MISC58,
    MT_MISC59,
    MT_MISC60,
    MT_MISC61,
    MT_MISC62,
    MT_MISC63,
    MT_MISC64,
    MT_MISC65,
    MT_MISC66,
    MT_MISC67,
    MT_MISC68,
    MT_MISC69,
    MT_MISC70,
    MT_MISC71,
    MT_MISC72,
    MT_MISC73,
    MT_MISC74,
    MT_MISC75,
    MT_MISC76,
    MT_MISC77,
    MT_MISC78,
    MT_MISC79,
    MT_MISC80,
    MT_MISC81,
    MT_MISC82,
    MT_MISC83,
    MT_MISC84,
    MT_MISC85,
    MT_MISC86,
    MT_CHASECAM,
    MT_SPIRIT,
    MT_SMOK,        // test lave/slime damage smoke
    MT_SPLASH,      // test water splash
    MT_PUSH,    //SoM: 3/8/2000: controls push source
    MT_PULL,    //SoM: 3/8/2000: controls pull source
    MT_DOGS,    //SoM: ToDo!
    MT_PLASMA1, //SoM: Hold the place.
    MT_PLASMA2, //SoM: Hold the place.
    MT_CAMERA,  //SoM: SMMU Camera objects.
    MT_NODE,    //SoM: Level nodes...
    ENDDOOM_MT = MT_NODE,

    // heretic stuff
    BEGINHERETIC_MT,
MT_HMISC0 = BEGINHERETIC_MT,
MT_ITEMSHIELD1,
MT_ITEMSHIELD2,
MT_HMISC1,
MT_HMISC2,
MT_ARTIINVISIBILITY,
MT_HMISC3,
MT_ARTIFLY,
MT_ARTIINVULNERABILITY,
MT_ARTITOMEOFPOWER,
MT_ARTIEGG,
MT_EGGFX,
MT_ARTISUPERHEAL,
MT_HMISC4,
MT_HMISC5,
MT_FIREBOMB,
MT_ARTITELEPORT,
MT_POD,
MT_PODGOO,
MT_PODGENERATOR,
MT_HSPLASH,
MT_SPLASHBASE,
MT_LAVASPLASH,
MT_LAVASMOKE,
MT_SLUDGECHUNK,
MT_SLUDGESPLASH,
MT_SKULLHANG70,
MT_SKULLHANG60,
MT_SKULLHANG45,
MT_SKULLHANG35,
MT_CHANDELIER,
MT_SERPTORCH,
MT_SMALLPILLAR,
MT_STALAGMITESMALL,
MT_STALAGMITELARGE,
MT_STALACTITESMALL,
MT_STALACTITELARGE,
MT_HMISC6,
MT_HBARREL,
MT_HMISC7,
MT_HMISC8,
MT_HMISC9,
MT_HMISC10,
MT_HMISC11,
MT_KEYGIZMOBLUE,
MT_KEYGIZMOGREEN,
MT_KEYGIZMOYELLOW,
MT_KEYGIZMOFLOAT,
MT_HMISC12,
MT_VOLCANOBLAST,
MT_VOLCANOTBLAST,
MT_TELEGLITGEN,
MT_TELEGLITGEN2,
MT_TELEGLITTER,
MT_TELEGLITTER2,
//MT_HTFOG,
//MT_HTELEPORTMAN,
MT_STAFFPUFF,
MT_STAFFPUFF2,
MT_BEAKPUFF,
MT_HMISC13,
MT_GAUNTLETPUFF1,
MT_GAUNTLETPUFF2,
MT_HMISC14,
MT_BLASTERFX1,
MT_BLASTERSMOKE,
MT_RIPPER,
MT_BLASTERPUFF1,
MT_BLASTERPUFF2,
MT_WMACE,
MT_MACEFX1,
MT_MACEFX2,
MT_MACEFX3,
MT_MACEFX4,
MT_WSKULLROD,
MT_HORNRODFX1,
MT_HORNRODFX2,
MT_RAINPLR1,
MT_RAINPLR2,
MT_RAINPLR3,
MT_RAINPLR4,
MT_GOLDWANDFX1,
MT_GOLDWANDFX2,
MT_GOLDWANDPUFF1,
MT_GOLDWANDPUFF2,
MT_WPHOENIXROD,
MT_PHOENIXFX1,
MT_PHOENIXPUFF,
MT_PHOENIXFX2,
MT_HMISC15,
MT_CRBOWFX1,
MT_CRBOWFX2,
MT_CRBOWFX3,
MT_CRBOWFX4,
//MT_HBLOOD,
MT_BLOODSPLATTER,
//MT_PLAYER,
MT_BLOODYSKULL,
MT_CHICPLAYER,
MT_CHICKEN,
MT_FEATHER,
MT_MUMMY,
MT_MUMMYLEADER,
MT_MUMMYGHOST,
MT_MUMMYLEADERGHOST,
MT_MUMMYSOUL,
MT_MUMMYFX1,
MT_BEAST,
MT_BEASTBALL,
MT_BURNBALL,
MT_BURNBALLFB,
MT_PUFFY,
MT_SNAKE,
MT_SNAKEPRO_A,
MT_SNAKEPRO_B,
MT_HHEAD,
MT_HEADFX1,
MT_HEADFX2,
MT_HEADFX3,
MT_WHIRLWIND,
MT_CLINK,
MT_WIZARD,
MT_WIZFX1,
MT_IMP,
MT_IMPLEADER,
MT_IMPCHUNK1,
MT_IMPCHUNK2,
MT_IMPBALL,
MT_HKNIGHT,
MT_KNIGHTGHOST,
MT_KNIGHTAXE,
MT_REDAXE,
MT_SORCERER1,
MT_SRCRFX1,
MT_SORCERER2,
MT_SOR2FX1,
MT_SOR2FXSPARK,
MT_SOR2FX2,
MT_SOR2TELEFADE,
MT_MINOTAUR,
MT_MNTRFX1,
MT_MNTRFX2,
MT_MNTRFX3,
MT_AKYY,
MT_BKYY,
MT_CKEY,
MT_AMGWNDWIMPY,
MT_AMGWNDHEFTY,
MT_AMMACEWIMPY,
MT_AMMACEHEFTY,
MT_AMCBOWWIMPY,
MT_AMCBOWHEFTY,
MT_AMSKRDWIMPY,
MT_AMSKRDHEFTY,
MT_AMPHRDWIMPY,
MT_AMPHRDHEFTY,
MT_AMBLSRWIMPY,
MT_AMBLSRHEFTY,
MT_SOUNDWIND,
MT_SOUNDWATERFALL,


    NUMMOBJTYPES

} mobjtype_t;

typedef struct
{
    int doomednum;
    int spawnstate;
    int spawnhealth;
    int seestate;
    int seesound;
    int reactiontime;
    int attacksound;
    int painstate;
    int painchance;
    int painsound;
    int meleestate;
    int missilestate;
    int crashstate;   // from heretic/hexen
    int deathstate;
    int xdeathstate;
    int deathsound;
    int speed;
    int radius;
    int height;
    int mass;
    int damage;
    int activesound;
    int flags;
    int raisestate;
    int flags2;       // from heretic/hexen
} mobjinfo_t;

extern mobjinfo_t mobjinfo[NUMMOBJTYPES];

void P_PatchInfoTables( void );

#endif
