/*
 * Decompiled with CFR 0.152.
 */
package dguitar.players.sound.midi;

import dguitar.adaptors.song.SongMeasure;
import dguitar.adaptors.song.Tempo;
import dguitar.players.sound.EventSettings;
import dguitar.players.sound.EventStream;
import dguitar.players.sound.PerformanceEvent;
import dguitar.players.sound.PerformanceTimerEvent;
import dguitar.players.sound.TimerSettings;
import dguitar.players.sound.midi.MetaContainer;
import dguitar.players.sound.midi.PerformanceCore;
import java.util.List;
import java.util.Vector;
import java.util.logging.Logger;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.Track;

public class PerformanceLive
extends PerformanceCore
implements MetaContainer,
EventSettings,
TimerSettings {
    private static String className;
    private static Logger logger;
    int timerFrequency = 4;
    Track eventTrack;
    EventStream timerStream;
    List metaItems;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("dguitar.players.sound.midi.PerformanceLive");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        className = clazz.toString();
        logger = Logger.getLogger(className);
    }

    public PerformanceLive(int tracks, Tempo tempo, int resolution) throws InvalidMidiDataException {
        super(tracks + 2, tempo, resolution);
        Track[] midiTracks = this.getTracks();
        this.eventTrack = midiTracks[tracks + 1];
        this.timerStream = new EventStream(null, 0);
        this.metaItems = new Vector();
    }

    public int getTimerFrequency() {
        return this.timerFrequency;
    }

    public void setTimerFrequency(int timerFrequency) {
        this.timerFrequency = timerFrequency;
    }

    public MidiEvent create(PerformanceEvent item) {
        int location = item.getOffset();
        int key = this.metaItems.size();
        this.metaItems.add(item);
        MetaMessage mm = new MetaMessage();
        byte[] data = new byte[]{(byte)(key >> 24 & 0xFF), (byte)(key >> 16 & 0xFF), (byte)(key >> 8 & 0xFF), (byte)(key & 0xFF)};
        try {
            mm.setMessage(1, data, 4);
            MidiEvent event = new MidiEvent(mm, location);
            logger.finer("Creating new meta item for key " + key);
            return event;
        }
        catch (InvalidMidiDataException e) {
            logger.severe("Invalid midi data for meta message");
            return null;
        }
    }

    public PerformanceEvent lookup(int key) {
        if (key >= 0 && key < this.metaItems.size()) {
            return (PerformanceEvent)this.metaItems.get(key);
        }
        return null;
    }

    public void addTimerEvents(SongMeasure measure, int location) {
        if (this.timerFrequency > 0) {
            int index = measure.getIndex();
            logger.finer("adding meta events for measure " + index + " at " + location);
            int measureLength = measure.getLength();
            int measureBeats = measure.getTimeSignature().getNumerator();
            int totalEvents = measureBeats * this.timerFrequency;
            int beatindex = 0;
            int beat = 0;
            while (beat < measureBeats) {
                int subbeat = 0;
                while (subbeat < this.timerFrequency) {
                    int beatoffset = measureLength * beatindex / totalEvents;
                    PerformanceTimerEvent item = new PerformanceTimerEvent(this.timerStream, location + beatoffset, measure, beat + 1, subbeat + 1, this.timerFrequency);
                    this.recordPerformanceEvent(item);
                    ++beatindex;
                    ++subbeat;
                }
                ++beat;
            }
        }
    }

    protected void recordPerformanceEvent(PerformanceEvent item) {
        MidiEvent me = this.create(item);
        this.eventTrack.add(me);
    }

    public void enableNoteEvents(boolean enable) {
    }
}

