/*
 * Decompiled with CFR 0.152.
 */
package dguitar.codecs.guitarPro.statistics;

import common.Util;
import dguitar.codecs.guitarPro.GPMeasureTrackPair;
import dguitar.codecs.guitarPro.GPSong;
import dguitar.codecs.guitarPro.statistics.GPStats;
import dguitar.codecs.guitarPro.statistics.GPStatsMeasureTrackPair;
import java.util.List;
import java.util.Vector;

public class GPStatsPiece
extends GPStats {
    int numTracks = 0;
    int numMeasures = 0;
    GPStatsMeasureTrackPair MTPtotal = new GPStatsMeasureTrackPair();
    String pieceName = null;
    Vector MTPdetails = null;
    int numTracksWithLyrics = 0;

    public void getStats(GPSong p, String PieceName) {
        List tracks;
        this.pieceName = PieceName;
        List measures = p.getMeasures();
        if (measures != null) {
            this.numMeasures = measures.size();
        }
        if ((tracks = p.getTracks()) != null) {
            this.numTracks = tracks.size();
        }
        this.numTracksWithLyrics = p.getLyrics() != null ? 1 : 0;
        List MTPs = p.getMeasuresTracksPairs();
        int numMTPs = MTPs.size();
        this.MTPtotal = new GPStatsMeasureTrackPair();
        if (this.isDetailed()) {
            this.MTPdetails = new Vector(0, 1);
        }
        int i = 0;
        while (i < numMTPs) {
            GPMeasureTrackPair MTP = (GPMeasureTrackPair)MTPs.get(i);
            int t = i % this.numTracks;
            int m = i / this.numTracks + 1;
            GPStatsMeasureTrackPair detail = new GPStatsMeasureTrackPair(MTP, m, t);
            if (this.isDetailed() && detail.nonZero()) {
                this.MTPdetails.add(detail);
            }
            this.MTPtotal.add(detail);
            ++i;
        }
    }

    public String toString() {
        int j;
        String tabs = Util.tabs(level);
        String res = "";
        if (this.pieceName != null) {
            res = tabs;
            j = 0;
            while (j < 6) {
                res = String.valueOf(res) + "--------------------------";
                ++j;
            }
            res = String.valueOf(res) + "\n";
            if (this.MTPdetails != null) {
                res = String.valueOf(res) + tabs + "Statistics for piece '" + this.pieceName + "'\n";
            }
        }
        if (this.MTPdetails != null) {
            ++level;
            int i = 0;
            while (i < this.MTPdetails.size()) {
                GPStatsMeasureTrackPair MTPdetail = (GPStatsMeasureTrackPair)this.MTPdetails.get(i);
                res = String.valueOf(res) + MTPdetail.toString();
                ++i;
            }
            --level;
            res = String.valueOf(res) + tabs;
            j = 0;
            while (j < 3) {
                res = String.valueOf(res) + "==========================";
                ++j;
            }
            res = String.valueOf(res) + "\n";
        }
        if (this.pieceName != null) {
            res = String.valueOf(res) + tabs + "Totals for piece '" + this.pieceName + "'\n";
        }
        res = String.valueOf(res) + tabs + "\t" + this.numMeasures + " measures" + "\n";
        res = String.valueOf(res) + tabs + "\t" + this.numTracks + " tracks" + "\n";
        res = String.valueOf(res) + "\t" + this.stringFor(this.numTracksWithLyrics, "track with lyrics", this.numTracks, "tracks");
        if (this.MTPtotal != null) {
            ++level;
            res = String.valueOf(res) + this.MTPtotal.toString();
            --level;
        }
        return res;
    }

    public void add(GPStatsPiece a) {
        if (a != null) {
            this.numTracks += a.numTracks;
            this.numMeasures += a.numMeasures;
            this.numTracksWithLyrics += a.numTracksWithLyrics;
            if (this.MTPtotal != null) {
                this.MTPtotal.add(a.MTPtotal);
            }
        }
    }
}

