/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.servlet;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.util.Properties;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.HttpServletRequestWrap;
import org.apache.velocity.app.HttpServletResponseWrap;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.io.VelocityWriter;
import org.apache.velocity.runtime.Runtime;
import org.apache.velocity.util.SimplePool;

public abstract class VelocityServlet
extends HttpServlet {
    public static final String REQUEST = "req";
    public static final String RESPONSE = "res";
    public static final String CONTENT_TYPE = "default.contentType";
    public static final String DEFAULT_CONTENT_TYPE = "text/html";
    private static String encoding = null;
    private static String defaultContentType;
    private static final String INIT_PROPS_KEY = "properties";
    private static SimplePool writerPool;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        try {
            Properties props = this.loadConfiguration(config);
            Velocity.init(props);
            defaultContentType = Runtime.getString(CONTENT_TYPE, DEFAULT_CONTENT_TYPE);
            encoding = Runtime.getString("template.encoding", "8859_1");
        }
        catch (Exception e) {
            throw new ServletException("Error configuring the loader: " + e);
        }
    }

    protected Properties loadConfiguration(ServletConfig config) throws IOException, FileNotFoundException {
        String propsFile = config.getInitParameter(INIT_PROPS_KEY);
        Properties p = new Properties();
        if (propsFile != null) {
            String realPath = this.getServletContext().getRealPath(propsFile);
            if (realPath != null) {
                propsFile = realPath;
            }
            p.load(new FileInputStream(propsFile));
        }
        return p;
    }

    public final void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doRequest(request, response);
    }

    public final void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doRequest(request, response);
    }

    private void doRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            Context context = this.createContext(request, response);
            this.setContentType(request, response);
            Template template = this.handleRequest(context);
            if (template == null) {
                throw new Exception("Cannot find the template!");
            }
            this.mergeTemplate(template, context, response);
            this.requestCleanup(request, response, context);
        }
        catch (Exception e) {
            this.error(request, response, e);
        }
    }

    protected void requestCleanup(HttpServletRequest request, HttpServletResponse response, Context context) {
    }

    protected void mergeTemplate(Template template, Context context, HttpServletResponse response) throws ResourceNotFoundException, ParseErrorException, MethodInvocationException, IOException, UnsupportedEncodingException, Exception {
        ServletOutputStream output = response.getOutputStream();
        VelocityWriter vw = null;
        try {
            vw = (VelocityWriter)writerPool.get();
            if (vw == null) {
                vw = new VelocityWriter(new OutputStreamWriter((OutputStream)output, encoding), 4096, true);
            } else {
                vw.recycle(new OutputStreamWriter((OutputStream)output, encoding));
            }
            template.merge(context, vw);
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            try {
                if (vw != null) {
                    vw.flush();
                    writerPool.put(vw);
                    output.close();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            if (vw != null) {
                vw.flush();
                writerPool.put(vw);
                output.close();
            }
        }
        catch (Exception e) {}
    }

    protected void setContentType(HttpServletRequest request, HttpServletResponse response) {
        response.setContentType(defaultContentType);
    }

    protected Context createContext(HttpServletRequest request, HttpServletResponse response) {
        VelocityContext context = new VelocityContext();
        context.put(REQUEST, new HttpServletRequestWrap(request));
        context.put(RESPONSE, new HttpServletResponseWrap(response));
        return context;
    }

    public Template getTemplate(String name) throws ResourceNotFoundException, ParseErrorException, Exception {
        return Runtime.getTemplate(name);
    }

    protected abstract Template handleRequest(Context var1) throws Exception;

    protected void error(HttpServletRequest request, HttpServletResponse response, Exception cause) throws ServletException, IOException {
        StringBuffer html = new StringBuffer();
        html.append("<html>");
        html.append("<body bgcolor=\"#ffffff\">");
        html.append("<h2>VelocityServlet : Error processing the template</h2>");
        html.append(cause);
        html.append("<br>");
        StringWriter sw = new StringWriter();
        cause.printStackTrace(new PrintWriter(sw));
        html.append(sw.toString());
        html.append("</body>");
        html.append("</html>");
        response.getOutputStream().print(html.toString());
    }

    static {
        writerPool = new SimplePool(40);
    }
}

