/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.sql.SQLException;
import java.util.Vector;
import org.hsqldb.Cache;
import org.hsqldb.Channel;
import org.hsqldb.Column;
import org.hsqldb.Constraint;
import org.hsqldb.Database;
import org.hsqldb.Index;
import org.hsqldb.Log;
import org.hsqldb.Node;
import org.hsqldb.Record;
import org.hsqldb.Result;
import org.hsqldb.Row;
import org.hsqldb.Trace;
import org.hsqldb.TriggerDef;

class Table {
    private String sName;
    private Vector vColumn;
    private Vector vIndex;
    private int iVisibleColumns;
    private int iColumnCount;
    private int iPrimaryKey;
    private boolean bCached;
    private Database dDatabase;
    private Log lLog;
    private int iIndexCount;
    private int iIdentityColumn;
    private int iIdentityId;
    private Vector vConstraint;
    private int iConstraintCount;
    Cache cCache;
    Vector[] vTrigs;

    Table(Database database, boolean bl, String string, boolean bl2) {
        this.dDatabase = database;
        Log log = this.lLog = bl ? database.getLog() : null;
        if (bl2) {
            this.cCache = this.lLog.cCache;
            this.bCached = true;
        }
        this.sName = string;
        this.iPrimaryKey = -1;
        this.iIdentityColumn = -1;
        this.vColumn = new Vector();
        this.vIndex = new Vector();
        this.vConstraint = new Vector();
        this.vTrigs = new Vector[TriggerDef.numTrigs()];
        int n = 0;
        while (n < TriggerDef.numTrigs()) {
            this.vTrigs[n] = new Vector();
            ++n;
        }
    }

    void addColumn(String string, int n) throws SQLException {
        this.addColumn(string, n, true, false);
    }

    void addColumn(String string, int n, boolean bl, boolean bl2) throws SQLException {
        if (bl2) {
            Trace.check(n == 4, 15, string);
            Trace.check(this.iIdentityColumn == -1, 23, string);
            this.iIdentityColumn = this.iColumnCount;
        }
        Trace.assert(this.iPrimaryKey == -1, "Table.addColumn");
        this.vColumn.addElement(new Column(string, bl, n, bl2));
        ++this.iColumnCount;
    }

    void addColumn(Column column) throws SQLException {
        this.addColumn(column.sName, column.iType, column.isNullable(), column.isIdentity());
    }

    void addColumns(Result result) throws SQLException {
        int n = 0;
        while (n < result.getColumnCount()) {
            this.addColumn(result.sLabel[n], result.iType[n], true, false);
            ++n;
        }
    }

    void addConstraint(Constraint constraint) {
        this.vConstraint.addElement(constraint);
        ++this.iConstraintCount;
    }

    void addTrigger(TriggerDef triggerDef) {
        this.vTrigs[triggerDef.vectorIndx].addElement(triggerDef);
    }

    void checkDropIndex(String string) throws SQLException {
        int n = 0;
        while (n < this.iIndexCount) {
            if (string.equals(this.getIndex(n).getName())) {
                Trace.check(n != 0, 24);
                return;
            }
            ++n;
        }
        throw Trace.error(25, string);
    }

    void checkUpdate(int[] nArray, Result result, Result result2) throws SQLException {
        if (this.dDatabase.isReferentialIntegrity()) {
            int n = 0;
            while (n < this.iConstraintCount) {
                Constraint constraint = (Constraint)this.vConstraint.elementAt(n);
                constraint.checkUpdate(nArray, result, result2);
                ++n;
            }
        }
    }

    void createIndex(Index index) throws SQLException {
        this.createIndex(index.getColumns(), index.getName(), index.isUnique());
    }

    void createIndex(int[] nArray, String string, boolean bl) throws SQLException {
        Trace.assert(this.iPrimaryKey != -1, "createIndex");
        int n = 0;
        while (n < this.iIndexCount) {
            Index index = this.getIndex(n);
            if (string.equals(index.getName())) {
                throw Trace.error(22);
            }
            ++n;
        }
        int n2 = nArray.length;
        int[] nArray2 = new int[bl ? n2 : n2 + 1];
        int[] nArray3 = new int[bl ? n2 : n2 + 1];
        int n3 = 0;
        while (n3 < n2) {
            nArray2[n3] = nArray[n3];
            nArray3[n3] = this.getColumn((int)nArray2[n3]).iType;
            ++n3;
        }
        if (!bl) {
            nArray2[n2] = this.iPrimaryKey;
            nArray3[n2] = this.getColumn((int)this.iPrimaryKey).iType;
        }
        Index index = new Index(string, nArray2, nArray3, bl);
        if (this.iIndexCount != 0) {
            Trace.assert(this.isEmpty(), "createIndex");
        }
        this.vIndex.addElement(index);
        ++this.iIndexCount;
    }

    void createPrimaryKey() throws SQLException {
        Trace.assert(this.iPrimaryKey == -1, "Table.createPrimaryKey");
        this.addColumn("SYSTEM_ID", 4, true, true);
        this.createPrimaryKey(this.iColumnCount - 1);
        this.iVisibleColumns = this.iColumnCount - 1;
    }

    void createPrimaryKey(int n) throws SQLException {
        Trace.assert(this.iPrimaryKey == -1, "Table.createPrimaryKey(column)");
        this.iVisibleColumns = this.iColumnCount;
        this.iPrimaryKey = n;
        int[] nArray = new int[]{n};
        this.createIndex(nArray, "SYSTEM_PK", true);
    }

    void delete(Object[] objectArray, Channel channel) throws SQLException {
        this.fireAll(10, objectArray);
        if (this.dDatabase.isReferentialIntegrity()) {
            int n = 0;
            while (n < this.iConstraintCount) {
                ((Constraint)this.vConstraint.elementAt(n)).checkDelete(objectArray);
                ++n;
            }
        }
        this.deleteNoCheck(objectArray, channel);
        this.fireAll(7, objectArray);
    }

    void deleteNoCheck(Object[] objectArray, Channel channel) throws SQLException {
        this.deleteNoCheck(objectArray, channel, true);
    }

    void deleteNoCheck(Object[] objectArray, Channel channel, boolean bl) throws SQLException {
        int n = 1;
        while (n < this.iIndexCount) {
            this.getIndex(n).delete(objectArray, false);
            ++n;
        }
        this.getIndex(0).delete(objectArray, true);
        if (channel != null) {
            channel.addTransactionDelete(this, objectArray);
        }
        if (this.lLog != null) {
            this.lLog.write(channel, this.getDeleteStatement(objectArray));
        }
    }

    void fireAll(int n) {
        Object[] objectArray = new Object[]{new String("Statement-level")};
        this.fireAll(n, objectArray);
    }

    void fireAll(int n, Object[] objectArray) {
        if (!this.dDatabase.isReferentialIntegrity()) {
            return;
        }
        Vector vector = this.vTrigs[n];
        int n2 = vector.size();
        int n3 = 0;
        while (n3 < n2) {
            TriggerDef triggerDef = (TriggerDef)vector.elementAt(n3);
            triggerDef.push(objectArray);
            ++n3;
        }
    }

    Column getColumn(int n) {
        return (Column)this.vColumn.elementAt(n);
    }

    int getColumnCount() {
        return this.iVisibleColumns;
    }

    boolean getColumnIsNullable(int n) {
        return this.getColumn(n).isNullable();
    }

    String getColumnName(int n) {
        return this.getColumn((int)n).sName;
    }

    int getColumnNr(String string) throws SQLException {
        int n = this.searchColumn(string);
        if (n == -1) {
            throw Trace.error(27, string);
        }
        return n;
    }

    int getColumnType(int n) {
        return this.getColumn((int)n).iType;
    }

    Vector getConstraints() {
        return this.vConstraint;
    }

    private String getDeleteStatement(Object[] objectArray) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer("DELETE FROM ");
        stringBuffer.append(this.sName);
        stringBuffer.append(" WHERE ");
        if (this.iVisibleColumns < this.iColumnCount) {
            int n = 0;
            while (n < this.iVisibleColumns) {
                stringBuffer.append(this.getColumn((int)n).sName);
                stringBuffer.append('=');
                stringBuffer.append(Column.createString(objectArray[n], this.getColumn((int)n).iType));
                if (n < this.iVisibleColumns - 1) {
                    stringBuffer.append(" AND ");
                }
                ++n;
            }
        } else {
            stringBuffer.append(this.getColumn((int)this.iPrimaryKey).sName);
            stringBuffer.append("=");
            stringBuffer.append(Column.createString(objectArray[this.iPrimaryKey], this.getColumn((int)this.iPrimaryKey).iType));
        }
        return stringBuffer.toString();
    }

    int getIdentityColumn() {
        return this.iIdentityColumn;
    }

    private Index getIndex(int n) {
        return (Index)this.vIndex.elementAt(n);
    }

    Index getIndex(String string) {
        int n = 0;
        while (n < this.iIndexCount) {
            Index index = this.getIndex(n);
            if (string.equals(index.getName())) {
                return index;
            }
            ++n;
        }
        return null;
    }

    int getIndexCount() {
        return this.iIndexCount;
    }

    Index getIndexForColumn(int n) throws SQLException {
        int n2 = 0;
        while (n2 < this.iIndexCount) {
            Index index = this.getIndex(n2);
            if (index.getColumns()[0] == n) {
                return index;
            }
            ++n2;
        }
        return null;
    }

    Index getIndexForColumns(int[] nArray) throws SQLException {
        int n = 0;
        while (n < this.iIndexCount) {
            Index index = this.getIndex(n);
            int[] nArray2 = index.getColumns();
            int n2 = 0;
            while (n2 < nArray.length) {
                if (n2 >= nArray2.length || nArray2[n2] != nArray[n2]) break;
                ++n2;
            }
            if (n2 == nArray.length) {
                return index;
            }
            ++n;
        }
        return null;
    }

    String getIndexRoots() throws SQLException {
        Trace.assert(this.bCached, "Table.getIndexRootData");
        String string = "";
        int n = 0;
        while (n < this.iIndexCount) {
            Node node = this.getIndex(n).getRoot();
            string = node != null ? String.valueOf(string) + node.getKey() + " " : String.valueOf(string) + "-1 ";
            ++n;
        }
        string = String.valueOf(string) + this.iIdentityId;
        return string;
    }

    String getInsertStatement(Object[] objectArray) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer("INSERT INTO ");
        stringBuffer.append(this.getName());
        stringBuffer.append(" VALUES(");
        int n = 0;
        while (n < this.iVisibleColumns) {
            stringBuffer.append(Column.createString(objectArray[n], this.getColumn((int)n).iType));
            stringBuffer.append(',');
            ++n;
        }
        stringBuffer.setCharAt(stringBuffer.length() - 1, ')');
        return stringBuffer.toString();
    }

    int getInternalColumnCount() {
        return this.iColumnCount;
    }

    String getName() {
        return this.sName;
    }

    Object[] getNewRow() {
        return new Object[this.iColumnCount];
    }

    Index getNextIndex(Index index) {
        int n = 0;
        if (index != null) {
            while (n < this.iIndexCount && this.getIndex(n) != index) {
                ++n;
            }
            ++n;
        }
        if (n < this.iIndexCount) {
            return this.getIndex(n);
        }
        return null;
    }

    Index getPrimaryIndex() throws SQLException {
        if (this.iPrimaryKey == -1) {
            return null;
        }
        return this.getIndex(0);
    }

    int getType(int n) {
        return this.getColumn((int)n).iType;
    }

    void insert(Result result, Channel channel) throws SQLException {
        Record record = result.rRoot;
        int n = result.getColumnCount();
        while (record != null) {
            Object[] objectArray = this.getNewRow();
            int n2 = 0;
            while (n2 < n) {
                objectArray[n2] = record.data[n2];
                ++n2;
            }
            this.insert(objectArray, channel);
            record = record.next;
        }
    }

    void insert(Object[] objectArray, Channel channel) throws SQLException {
        this.fireAll(3, objectArray);
        if (this.dDatabase.isReferentialIntegrity()) {
            int n = 0;
            while (n < this.iConstraintCount) {
                ((Constraint)this.vConstraint.elementAt(n)).checkInsert(objectArray);
                ++n;
            }
        }
        this.insertNoCheck(objectArray, channel);
        this.fireAll(0, objectArray);
    }

    void insertNoCheck(Object[] objectArray, Channel channel) throws SQLException {
        this.insertNoCheck(objectArray, channel, true);
    }

    /*
     * Unable to fully structure code
     */
    void insertNoCheck(Object[] var1_1, Channel var2_2, boolean var3_3) throws SQLException {
        block14: {
            if (this.iIdentityColumn != -1) {
                var4_4 = (Integer)var1_1[this.iIdentityColumn];
                if (var4_4 == null) {
                    if (var2_2 != null) {
                        var2_2.setLastIdentity(this.iIdentityId);
                    }
                    var1_1[this.iIdentityColumn] = new Integer(this.iIdentityId++);
                } else {
                    var5_6 = var4_4;
                    if (this.iIdentityId <= var5_6) {
                        if (var2_2 != null) {
                            var2_2.setLastIdentity(var5_6);
                        }
                        this.iIdentityId = var5_6 + 1;
                    }
                }
            }
            var4_5 = 0;
            while (var4_5 < this.iColumnCount) {
                if (var1_1[var4_5] == null && !this.getColumn(var4_5).isNullable()) {
                    throw Trace.error(9);
                }
                ++var4_5;
            }
            var5_6 = 0;
            try {
                var6_7 = new Row(this, var1_1);
                while (var5_6 < this.iIndexCount) {
                    var7_9 = var6_7.getNode(var5_6);
                    this.getIndex(var5_6).insert(var7_9);
                    ++var5_6;
                }
                break block14;
            }
            catch (SQLException var6_8) {
                --var5_6;
                ** while (var5_6 >= 0)
            }
lbl-1000:
            // 1 sources

            {
                this.getIndex(var5_6).delete(var1_1, var5_6 == 0);
                --var5_6;
                continue;
            }
lbl34:
            // 1 sources

            throw var6_8;
        }
        if (var2_2 != null) {
            var2_2.addTransactionInsert(this, var1_1);
        }
        if (this.lLog != null) {
            this.lLog.write(var2_2, this.getInsertStatement(var1_1));
        }
    }

    boolean isCached() {
        return this.bCached;
    }

    boolean isEmpty() {
        return this.getIndex(0).getRoot() == null;
    }

    void moveData(Table table) throws SQLException {
        Object[] objectArray;
        Index index = table.getPrimaryIndex();
        Node node = index.first();
        while (node != null) {
            objectArray = node.getData();
            this.insertNoCheck(objectArray, null);
            node = index.next(node);
        }
        index = this.getPrimaryIndex();
        node = index.first();
        while (node != null) {
            objectArray = node.getData();
            table.deleteNoCheck(objectArray, null);
            node = index.next(node);
        }
    }

    Table moveDefinition(String string) throws SQLException {
        Table table = new Table(this.dDatabase, true, this.getName(), this.isCached());
        int n = 0;
        while (n < this.getColumnCount()) {
            table.addColumn(this.getColumn(n));
            ++n;
        }
        if (this.iVisibleColumns < this.iColumnCount) {
            table.createPrimaryKey();
        } else {
            table.createPrimaryKey(this.getPrimaryIndex().getColumns()[0]);
        }
        Index index = null;
        while ((index = this.getNextIndex(index)) != null) {
            if (string != null && index.getName().equals(string) || index == this.getPrimaryIndex()) continue;
            table.createIndex(index);
        }
        int n2 = 0;
        while (n2 < this.iConstraintCount) {
            Constraint constraint = (Constraint)this.vConstraint.elementAt(n2);
            constraint.replaceTable(this, table);
            ++n2;
        }
        table.vConstraint = this.vConstraint;
        return table;
    }

    int searchColumn(String string) {
        int n = 0;
        while (n < this.iColumnCount) {
            if (string.equals(((Column)this.vColumn.elementAt((int)n)).sName)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    void setIndexRoots(String string) throws SQLException {
        Trace.check(this.bCached, 21);
        int n = 0;
        int n2 = 0;
        while (n2 < this.iIndexCount) {
            int n3 = string.indexOf(32, n);
            int n4 = Integer.parseInt(string.substring(n, n3));
            if (n4 != -1) {
                Row row = this.cCache.getRow(n4, this);
                Node node = row.getNode(n2);
                this.getIndex(n2).setRoot(node);
            }
            n = n3 + 1;
            ++n2;
        }
        this.iIdentityId = Integer.parseInt(string.substring(n));
    }
}

