/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public abstract class CharacterDecoder {
    abstract int bytesPerAtom();

    abstract int bytesPerLine();

    void decodeBufferPrefix(InputStream inputStream, OutputStream outputStream) {
    }

    void decodeBufferSuffix(InputStream inputStream, OutputStream outputStream) {
    }

    int decodeLinePrefix(InputStream inputStream, OutputStream outputStream) {
        return this.bytesPerLine();
    }

    abstract void decodeLineSuffix(InputStream var1, OutputStream var2) throws EOFException, IOException;

    abstract void decodeAtom(InputStream var1, OutputStream var2, int var3) throws IOException, EOFException;

    public void decodeBuffer(InputStream inputStream, OutputStream outputStream) throws IOException {
        this.decodeBufferPrefix(inputStream, outputStream);
        try {
            while (true) {
                int n = this.decodeLinePrefix(inputStream, outputStream);
                int n2 = 0;
                while (n2 + this.bytesPerAtom() < n) {
                    this.decodeAtom(inputStream, outputStream, this.bytesPerAtom());
                    n2 += this.bytesPerAtom();
                }
                if (n2 + this.bytesPerAtom() == n) {
                    this.decodeAtom(inputStream, outputStream, this.bytesPerAtom());
                } else {
                    this.decodeAtom(inputStream, outputStream, n2 + this.bytesPerAtom() - n);
                }
                this.decodeLineSuffix(inputStream, outputStream);
            }
        }
        catch (EOFException eOFException) {
            this.decodeBufferSuffix(inputStream, outputStream);
            return;
        }
    }

    public byte[] decodeBuffer(String string) throws IOException {
        byte[] byArray = string.getBytes();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.decodeBuffer(byteArrayInputStream, byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public byte[] decodeBuffer(InputStream inputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.decodeBuffer(inputStream, byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }
}

