/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.svggen;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.Iterator;
import org.apache.batik.svggen.AbstractSVGConverter;
import org.apache.batik.svggen.DefaultImageHandler;
import org.apache.batik.svggen.GraphicContext;
import org.apache.batik.svggen.ImageHandler;
import org.apache.batik.svggen.SVGDescriptor;
import org.apache.batik.svggen.SVGIDGenerator;
import org.apache.batik.svggen.SVGPaintDescriptor;
import org.apache.batik.svggen.TestUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SVGTexturePaint
extends AbstractSVGConverter {
    public static final String ERROR_IMAGE_HANDLER_NULL = "imageHandler should not be null";
    private ImageHandler imageHandler;

    public SVGTexturePaint(Document document, ImageHandler imageHandler) {
        super(document);
        if (imageHandler == null) {
            throw new IllegalArgumentException(ERROR_IMAGE_HANDLER_NULL);
        }
        this.imageHandler = imageHandler;
    }

    public SVGDescriptor toSVG(GraphicContext graphicContext) {
        return this.toSVG((TexturePaint)graphicContext.getPaint());
    }

    public SVGPaintDescriptor toSVG(TexturePaint texturePaint) {
        SVGPaintDescriptor sVGPaintDescriptor = (SVGPaintDescriptor)this.descMap.get(texturePaint);
        if (sVGPaintDescriptor == null) {
            Rectangle2D rectangle2D = texturePaint.getAnchorRect();
            Element element = this.domFactory.createElementNS("http://www.w3.org/2000/svg", "pattern");
            element.setAttributeNS(null, "patternUnits", "userSpaceOnUse");
            element.setAttributeNS(null, "x", AbstractSVGConverter.doubleString(rectangle2D.getX()));
            element.setAttributeNS(null, "y", AbstractSVGConverter.doubleString(rectangle2D.getY()));
            element.setAttributeNS(null, "width", AbstractSVGConverter.doubleString(rectangle2D.getWidth()));
            element.setAttributeNS(null, "height", AbstractSVGConverter.doubleString(rectangle2D.getHeight()));
            BufferedImage bufferedImage = texturePaint.getImage();
            Element element2 = this.domFactory.createElementNS("http://www.w3.org/2000/svg", "image");
            if (bufferedImage.getWidth() > 0 && bufferedImage.getHeight() > 0 && ((double)bufferedImage.getWidth() != rectangle2D.getWidth() || (double)bufferedImage.getHeight() != rectangle2D.getHeight()) && rectangle2D.getWidth() > 0.0 && rectangle2D.getHeight() > 0.0) {
                double d = rectangle2D.getWidth() / (double)bufferedImage.getWidth();
                double d2 = rectangle2D.getHeight() / (double)bufferedImage.getHeight();
                BufferedImage bufferedImage2 = new BufferedImage((int)(d * (double)bufferedImage.getWidth()), (int)(d2 * (double)bufferedImage.getHeight()), 2);
                Graphics2D graphics2D = bufferedImage2.createGraphics();
                graphics2D.scale(d, d2);
                graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
                graphics2D.dispose();
                bufferedImage = bufferedImage2;
            }
            this.imageHandler.handleImage(bufferedImage, element2);
            element.appendChild(element2);
            element.setAttributeNS(null, "id", SVGIDGenerator.generateID("pattern"));
            StringBuffer stringBuffer = new StringBuffer("url(");
            stringBuffer.append("#");
            stringBuffer.append(element.getAttributeNS(null, "id"));
            stringBuffer.append(")");
            sVGPaintDescriptor = new SVGPaintDescriptor(stringBuffer.toString(), "1", element);
            this.descMap.put(texturePaint, sVGPaintDescriptor);
            this.defSet.add(element);
        }
        return sVGPaintDescriptor;
    }

    public static void main(String[] stringArray) throws Exception {
        Element element;
        Document document = TestUtil.getDocumentPrototype();
        BufferedImage bufferedImage = new BufferedImage(200, 200, 1);
        TexturePaint texturePaint = new TexturePaint(bufferedImage, new Rectangle(0, 0, 200, 200));
        SVGTexturePaint sVGTexturePaint = new SVGTexturePaint(document, new DefaultImageHandler());
        Element element2 = document.createElementNS("http://www.w3.org/2000/svg", "g");
        Element element3 = document.createElementNS("http://www.w3.org/2000/svg", "defs");
        SVGPaintDescriptor sVGPaintDescriptor = sVGTexturePaint.toSVG(texturePaint);
        Iterator iterator = sVGTexturePaint.getDefinitionSet().iterator();
        while (iterator.hasNext()) {
            element = (Element)iterator.next();
            element3.appendChild(element);
        }
        element = document.createElementNS("http://www.w3.org/2000/svg", "rect");
        element.setAttributeNS(null, "fill", sVGPaintDescriptor.getPaintValue());
        element.setAttributeNS(null, "fill-opacity", sVGPaintDescriptor.getOpacityValue());
        element2.appendChild(element3);
        element2.appendChild(element);
        TestUtil.trace(element2, System.out);
    }
}

