/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.svggen;

import java.awt.RenderingHints;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.apache.batik.svggen.AbstractSVGConverter;
import org.apache.batik.svggen.GraphicContext;
import org.apache.batik.svggen.SVGDescriptor;
import org.apache.batik.svggen.SVGHintsDescriptor;
import org.apache.batik.svggen.TestUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SVGRenderingHints
extends AbstractSVGConverter {
    public SVGDescriptor toSVG(GraphicContext graphicContext) {
        return SVGRenderingHints.toSVG(graphicContext.getRenderingHints());
    }

    public static SVGHintsDescriptor toSVG(RenderingHints renderingHints) {
        String string = "sRGB";
        String string2 = "auto";
        String string3 = "auto";
        String string4 = "auto";
        String string5 = "auto";
        if (renderingHints != null) {
            Object object = renderingHints.get(RenderingHints.KEY_RENDERING);
            if (object == RenderingHints.VALUE_RENDER_DEFAULT) {
                string = "auto";
                string2 = "auto";
                string3 = "auto";
                string4 = "auto";
                string5 = "auto";
            } else if (object == RenderingHints.VALUE_RENDER_SPEED) {
                string = "sRGB";
                string2 = "optimizeSpeed";
                string3 = "optimizeSpeed";
                string4 = "optimizeSpeed";
                string5 = "optimizeSpeed";
            } else if (object == RenderingHints.VALUE_RENDER_QUALITY) {
                string = "linearRGB";
                string2 = "optimizeQuality";
                string3 = "optimizeQuality";
                string4 = "optimizeQuality";
                string5 = "optimizeQuality";
            }
            Object object2 = renderingHints.get(RenderingHints.KEY_FRACTIONALMETRICS);
            if (object2 == RenderingHints.VALUE_FRACTIONALMETRICS_ON) {
                string3 = "optimizeQuality";
                string4 = "optimizeQuality";
            } else if (object2 == RenderingHints.VALUE_FRACTIONALMETRICS_OFF) {
                string3 = "optimizeSpeed";
                string4 = "optimizeSpeed";
            } else if (object2 == RenderingHints.VALUE_FRACTIONALMETRICS_DEFAULT) {
                string3 = "auto";
                string4 = "auto";
            }
            Object object3 = renderingHints.get(RenderingHints.KEY_ANTIALIASING);
            if (object3 == RenderingHints.VALUE_ANTIALIAS_ON) {
                string3 = "geometricPrecision";
                string4 = "geometricPrecision";
            } else if (object3 == RenderingHints.VALUE_ANTIALIAS_OFF) {
                string3 = "optimizeLegibility";
                string4 = "crispEdges";
            } else if (object3 == RenderingHints.VALUE_ANTIALIAS_DEFAULT) {
                string3 = "auto";
                string4 = "auto";
            }
            Object object4 = renderingHints.get(RenderingHints.KEY_TEXT_ANTIALIASING);
            if (object4 == RenderingHints.VALUE_TEXT_ANTIALIAS_ON) {
                string3 = "geometricPrecision";
            } else if (object4 == RenderingHints.VALUE_TEXT_ANTIALIAS_OFF) {
                string3 = "optimizeLegibility";
            } else if (object4 == RenderingHints.VALUE_TEXT_ANTIALIAS_DEFAULT) {
                string3 = "auto";
            }
            Object object5 = renderingHints.get(RenderingHints.KEY_COLOR_RENDERING);
            if (object5 == RenderingHints.VALUE_COLOR_RENDER_DEFAULT) {
                string2 = "auto";
            } else if (object5 == RenderingHints.VALUE_COLOR_RENDER_QUALITY) {
                string2 = "optimizeQuality";
            } else if (object5 == RenderingHints.VALUE_COLOR_RENDER_SPEED) {
                string2 = "optimizeSpeed";
            }
            Object object6 = renderingHints.get(RenderingHints.KEY_INTERPOLATION);
            if (object6 == RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR) {
                string5 = "optimizeSpeed";
            } else if (object6 == RenderingHints.VALUE_INTERPOLATION_BICUBIC || object6 == RenderingHints.VALUE_INTERPOLATION_BILINEAR) {
                string5 = "optimizeQuality";
            }
        }
        return new SVGHintsDescriptor(string, string2, string3, string4, string5);
    }

    public static void main(String[] stringArray) throws Exception {
        Document document = TestUtil.getDocumentPrototype();
        Element element = document.createElementNS("http://www.w3.org/2000/svg", "g");
        Hashtable<String, RenderingHints[]> hashtable = new Hashtable<String, RenderingHints[]>();
        RenderingHints renderingHints = new RenderingHints(null);
        RenderingHints[] renderingHintsArray = new RenderingHints[]{new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_DEFAULT), new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY), new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED)};
        hashtable.put("rendering", renderingHintsArray);
        RenderingHints[] renderingHintsArray2 = new RenderingHints[]{new RenderingHints(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_DEFAULT), new RenderingHints(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON), new RenderingHints(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_OFF)};
        hashtable.put("fractionalMetrics", renderingHintsArray2);
        RenderingHints[] renderingHintsArray3 = new RenderingHints[]{new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_DEFAULT), new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON), new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF)};
        hashtable.put("antialiasing", renderingHintsArray3);
        RenderingHints[] renderingHintsArray4 = new RenderingHints[]{new RenderingHints(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_DEFAULT), new RenderingHints(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_SPEED), new RenderingHints(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY)};
        hashtable.put("colorRendering", renderingHintsArray4);
        RenderingHints[] renderingHintsArray5 = new RenderingHints[]{new RenderingHints(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR), new RenderingHints(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR), new RenderingHints(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC)};
        hashtable.put("interpolation", renderingHintsArray5);
        RenderingHints[] renderingHintsArray6 = new RenderingHints[]{new RenderingHints(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_DEFAULT), new RenderingHints(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF), new RenderingHints(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON)};
        hashtable.put("textAntialiasing", renderingHintsArray6);
        RenderingHints renderingHints2 = new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_DEFAULT);
        renderingHints2.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        RenderingHints renderingHints3 = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        renderingHints3.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        RenderingHints[] renderingHintsArray7 = new RenderingHints[]{renderingHints2, renderingHints3};
        hashtable.put("mixed", renderingHintsArray7);
        Iterator iterator = hashtable.keySet().iterator();
        SVGRenderingHints sVGRenderingHints = new SVGRenderingHints();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            RenderingHints[] renderingHintsArray8 = (RenderingHints[])hashtable.get(string);
            Element element2 = document.createElementNS("http://www.w3.org/2000/svg", "g");
            element2.setAttributeNS(null, "id", string);
            int n = 0;
            while (n < renderingHintsArray8.length) {
                Element element3 = document.createElementNS("http://www.w3.org/2000/svg", "rect");
                Map map = SVGRenderingHints.toSVG(renderingHintsArray8[n]).getAttributeMap(null);
                Iterator iterator2 = map.keySet().iterator();
                while (iterator2.hasNext()) {
                    String string2 = (String)iterator2.next();
                    element3.setAttributeNS(null, string2, (String)map.get(string2));
                }
                element2.appendChild(element3);
                ++n;
            }
            element.appendChild(element2);
        }
        TestUtil.trace(element, System.out);
    }
}

