/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.svggen;

import java.awt.Polygon;
import java.awt.geom.PathIterator;
import org.apache.batik.svggen.SVGGraphicObjectConverter;
import org.apache.batik.svggen.TestUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SVGPolygon
extends SVGGraphicObjectConverter {
    public SVGPolygon(Document document) {
        super(document);
    }

    public Element toSVG(Polygon polygon) {
        Element element = this.domFactory.createElementNS("http://www.w3.org/2000/svg", "polygon");
        StringBuffer stringBuffer = new StringBuffer(" ");
        PathIterator pathIterator = polygon.getPathIterator(null);
        float[] fArray = new float[6];
        int n = 0;
        while (!pathIterator.isDone()) {
            n = pathIterator.currentSegment(fArray);
            switch (n) {
                case 0: {
                    this.appendPoint(stringBuffer, fArray[0], fArray[1]);
                    break;
                }
                case 1: {
                    this.appendPoint(stringBuffer, fArray[0], fArray[1]);
                    break;
                }
                case 4: {
                    break;
                }
                default: {
                    throw new Error();
                }
            }
            pathIterator.next();
        }
        element.setAttributeNS(null, "points", stringBuffer.substring(0, stringBuffer.length() - 1));
        return element;
    }

    private void appendPoint(StringBuffer stringBuffer, float f, float f2) {
        stringBuffer.append(SVGGraphicObjectConverter.doubleString(f));
        stringBuffer.append(" ");
        stringBuffer.append(SVGGraphicObjectConverter.doubleString(f2));
        stringBuffer.append(" ");
    }

    public static void main(String[] stringArray) throws Exception {
        Document document = TestUtil.getDocumentPrototype();
        Polygon polygon = new Polygon();
        polygon.addPoint(350, 75);
        polygon.addPoint(379, 161);
        polygon.addPoint(469, 161);
        polygon.addPoint(397, 215);
        polygon.addPoint(423, 301);
        polygon.addPoint(350, 250);
        polygon.addPoint(277, 301);
        polygon.addPoint(303, 215);
        polygon.addPoint(231, 161);
        polygon.addPoint(321, 161);
        SVGPolygon sVGPolygon = new SVGPolygon(document);
        Element element = sVGPolygon.toSVG(polygon);
        TestUtil.trace(element, System.out);
        System.out.println();
    }
}

