/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.svggen;

import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGEncodeParam;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.batik.svggen.AbstractImageHandlerEncoder;
import org.apache.batik.svggen.TestUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ImageHandlerJPEGEncoder
extends AbstractImageHandlerEncoder {
    public static final String USAGE = "java org.apache.batik.svggen.ImageHandlerJPEGEncoder <imageDir> <urlRoot>";

    public ImageHandlerJPEGEncoder(String string, String string2) {
        super(string, string2);
    }

    public final String getSuffix() {
        return ".jpg";
    }

    public final String getPrefix() {
        return "jpegImage";
    }

    public void encodeImage(BufferedImage bufferedImage, File file) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            JPEGImageEncoder jPEGImageEncoder = JPEGCodec.createJPEGEncoder((OutputStream)fileOutputStream);
            JPEGEncodeParam jPEGEncodeParam = jPEGImageEncoder.getDefaultJPEGEncodeParam(bufferedImage);
            jPEGEncodeParam.setQuality(1.0f, false);
            jPEGImageEncoder.encode(bufferedImage, jPEGEncodeParam);
            fileOutputStream.flush();
            ((OutputStream)fileOutputStream).close();
        }
        catch (IOException iOException) {
            throw new Error("Could not write imageFile: " + file.getName());
        }
    }

    public BufferedImage buildBufferedImage(Dimension dimension) {
        return new BufferedImage(dimension.width, dimension.height, 1);
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 2) {
            System.out.println(USAGE);
            System.exit(0);
        }
        String string = stringArray[0];
        String string2 = stringArray[1];
        ImageHandlerJPEGEncoder imageHandlerJPEGEncoder = new ImageHandlerJPEGEncoder(string, string2);
        Document document = TestUtil.getDocumentPrototype();
        Element element = document.createElementNS("http://www.w3.org/2000/svg", "image");
        BufferedImage bufferedImage = new BufferedImage(60, 40, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setPaint(Color.white);
        graphics2D.fillRect(0, 0, 60, 40);
        graphics2D.setPaint(Color.green);
        graphics2D.fillRect(0, 0, 20, 40);
        graphics2D.setPaint(Color.red);
        graphics2D.fillRect(40, 0, 60, 40);
        graphics2D.dispose();
        imageHandlerJPEGEncoder.handleImage(bufferedImage, element);
        System.out.println("Generated xlink:href is : " + element.getAttributeNS(null, "xlink:href"));
        System.exit(0);
    }
}

