/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom.svg;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.batik.dom.svg.LiveAttributeValue;
import org.apache.batik.dom.svg.ModificationHandler;
import org.apache.batik.parser.ParseException;
import org.apache.batik.parser.TransformListHandler;
import org.apache.batik.parser.TransformListParser;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.svg.SVGException;
import org.w3c.dom.svg.SVGMatrix;
import org.w3c.dom.svg.SVGTransform;
import org.w3c.dom.svg.SVGTransformList;

public class SVGOMTransformList
implements SVGTransformList,
LiveAttributeValue,
TransformListHandler {
    protected List list = new ArrayList();
    protected ModificationHandler modificationHandler;

    public void setModificationHandler(ModificationHandler modificationHandler) {
        this.modificationHandler = modificationHandler;
    }

    public void valueChanged(Attr attr, Attr attr2) {
        this.parseTransform(attr2.getValue());
    }

    public int getNumberOfItems() {
        return this.list.size();
    }

    public void clear() {
        this.list.clear();
        if (this.modificationHandler != null) {
            this.modificationHandler.valueChanged(this, this.toString());
        }
    }

    public SVGTransform createSVGTransformFromMatrix(SVGMatrix sVGMatrix) {
        throw new RuntimeException(" !!! TODO: SVGTransformList#createSVGTransformFromMatrix()");
    }

    public SVGTransform consolidate() {
        throw new RuntimeException(" !!! TODO: SVGTransformList#consolidate()");
    }

    public SVGTransform initialize(SVGTransform sVGTransform) throws SVGException {
        this.list.clear();
        this.list.add(sVGTransform);
        if (this.modificationHandler != null) {
            this.modificationHandler.valueChanged(this, this.toString());
        }
        return sVGTransform;
    }

    public SVGTransform getItem(int n) throws DOMException {
        if (--n < 0 || n >= this.list.size()) {
            throw this.createDOMException((short)1, "index.out.of.bounds", new Object[]{new Integer(n)});
        }
        return (SVGTransform)this.list.get(n);
    }

    public SVGTransform insertItemBefore(SVGTransform sVGTransform, int n) throws SVGException {
        if (--n < 0) {
            this.list.add(0, sVGTransform);
        } else if (n > this.list.size()) {
            this.list.add(this.list.size(), sVGTransform);
        } else {
            this.list.add(n, sVGTransform);
        }
        if (this.modificationHandler != null) {
            this.modificationHandler.valueChanged(this, this.toString());
        }
        return sVGTransform;
    }

    public SVGTransform replaceItem(SVGTransform sVGTransform, int n) throws DOMException, SVGException {
        if (--n < 0 || n >= this.list.size()) {
            throw this.createDOMException((short)1, "index.out.of.bounds", new Object[]{new Integer(n)});
        }
        this.list.set(n, sVGTransform);
        if (this.modificationHandler != null) {
            this.modificationHandler.valueChanged(this, this.toString());
        }
        return sVGTransform;
    }

    public SVGTransform removeItem(int n) throws DOMException {
        if (--n < 0 || n >= this.list.size()) {
            throw this.createDOMException((short)1, "index.out.of.bounds", new Object[]{new Integer(n)});
        }
        Object e = this.list.remove(n);
        if (this.modificationHandler != null) {
            this.modificationHandler.valueChanged(this, this.toString());
        }
        return (SVGTransform)e;
    }

    public SVGTransform appendItem(SVGTransform sVGTransform) throws SVGException {
        this.list.add(sVGTransform);
        if (this.modificationHandler != null) {
            this.modificationHandler.valueChanged(this, this.toString());
        }
        return sVGTransform;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.list.iterator();
        if (iterator.hasNext()) {
            stringBuffer.append(iterator.next().toString());
        }
        while (iterator.hasNext()) {
            stringBuffer.append(" ");
            stringBuffer.append(iterator.next().toString());
        }
        return stringBuffer.toString();
    }

    protected DOMException createDOMException(short s, String string, Object[] objectArray) {
        return new DOMException(s, string);
    }

    protected void parseTransform(String string) {
        TransformListParser transformListParser = new TransformListParser();
        transformListParser.setTransformListHandler(this);
        try {
            transformListParser.parse(new StringReader(string));
        }
        catch (ParseException parseException) {
            throw new DOMException(12, parseException.getMessage());
        }
    }

    public void startTransformList() throws ParseException {
    }

    public void matrix(float f, float f2, float f3, float f4, float f5, float f6) throws ParseException {
    }

    public void rotate(float f) throws ParseException {
    }

    public void rotate(float f, float f2, float f3) throws ParseException {
    }

    public void translate(float f) throws ParseException {
    }

    public void translate(float f, float f2) throws ParseException {
    }

    public void scale(float f) throws ParseException {
    }

    public void scale(float f, float f2) throws ParseException {
    }

    public void skewX(float f) throws ParseException {
    }

    public void skewY(float f) throws ParseException {
    }

    public void endTransformList() throws ParseException {
    }
}

