/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.awt.color.ICC_Profile;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.batik.bridge.Bridge;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.IllegalAttributeValueException;
import org.apache.batik.bridge.resources.Messages;
import org.apache.batik.dom.svg.SVGOMDocument;
import org.apache.batik.dom.util.XLinkSupport;
import org.apache.batik.ext.awt.color.ICCColorSpaceExt;
import org.apache.batik.ext.awt.color.NamedProfileCache;
import org.apache.batik.util.SVGConstants;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class SVGColorProfileElementBridge
implements Bridge,
SVGConstants {
    public NamedProfileCache cache = new NamedProfileCache();

    public ICCColorSpaceExt build(String string, BridgeContext bridgeContext, Element element) {
        Object object;
        Object object2;
        Object object3;
        ICCColorSpaceExt iCCColorSpaceExt = this.cache.request(string.toLowerCase());
        if (iCCColorSpaceExt != null) {
            return iCCColorSpaceExt;
        }
        Document document = element.getOwnerDocument();
        NodeList nodeList = document.getElementsByTagNameNS("http://www.w3.org/2000/svg", "color-profile");
        int n = nodeList.getLength();
        Element element2 = null;
        int n2 = 0;
        while (n2 < n) {
            object3 = nodeList.item(n2);
            if (object3.getNodeType() == 1 && string.equalsIgnoreCase((String)(object2 = (object = (Element)object3).getAttributeNS(null, "name")))) {
                element2 = object;
            }
            ++n2;
        }
        if (element2 == null) {
            return null;
        }
        object3 = XLinkSupport.getXLinkHref(element2);
        object = null;
        if (object3 != null) {
            try {
                object2 = ((SVGOMDocument)document).getURLObject();
                URL uRL = new URL((URL)object2, (String)object3);
                object = ICC_Profile.getInstance(uRL.openStream());
            }
            catch (MalformedURLException malformedURLException) {
                malformedURLException.printStackTrace(System.err);
                throw new IllegalAttributeValueException(Messages.formatMessage("color-profile.xlinkHref.invalid", null));
            }
            catch (IOException iOException) {
                iOException.printStackTrace(System.err);
            }
        }
        if (object == null) {
            return null;
        }
        object2 = element2.getAttributeNS(null, "rendering-intent");
        int n3 = this.convertIntent((String)object2);
        iCCColorSpaceExt = new ICCColorSpaceExt((ICC_Profile)object, n3);
        this.cache.put(string.toLowerCase(), iCCColorSpaceExt);
        return iCCColorSpaceExt;
    }

    private int convertIntent(String string) {
        if ("".equals(string)) {
            return 4;
        }
        if ("perceptual".equals(string)) {
            return 0;
        }
        if ("auto".equals(string)) {
            return 4;
        }
        if ("relative-colorimetric".equals(string)) {
            return 1;
        }
        if ("absolute-colorimetric".equals(string)) {
            return 2;
        }
        if ("saturation".equals(string)) {
            return 3;
        }
        throw new IllegalAttributeValueException(Messages.formatMessage("color-profile.intent.invalid", new Object[]{string}));
    }
}

