/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.component;

import org.apache.avalon.AbstractLoggable;
import org.apache.avalon.Component;
import org.apache.avalon.ComponentManager;
import org.apache.avalon.Context;
import org.apache.avalon.Disposable;
import org.apache.avalon.Initializable;
import org.apache.avalon.Poolable;
import org.apache.avalon.Stoppable;
import org.apache.avalon.component.DefaultComponentFactory;
import org.apache.avalon.component.DefaultComponentPool;
import org.apache.avalon.component.RoleManager;
import org.apache.avalon.configuration.Configuration;
import org.apache.log.Logger;

class DefaultComponentHandler
extends AbstractLoggable
implements Initializable,
Disposable {
    private static final int THREADSAFE = 0;
    private static final int POOLABLE = 1;
    private static final int SINGLETHREADED = 2;
    private DefaultComponentFactory m_factory;
    private DefaultComponentPool m_pool;
    private Component m_instance;
    private final int m_type;
    private boolean m_initialized = false;
    private boolean m_disposed = false;
    private static /* synthetic */ Class class$Lorg$apache$avalon$Poolable;
    private static /* synthetic */ Class class$Lorg$apache$avalon$ThreadSafe;

    public void setLogger(Logger logger) {
        if (this.m_factory != null) {
            this.m_factory.setLogger(logger);
        }
        if (this.m_pool != null) {
            this.m_pool.setLogger(logger);
        }
        super.setLogger(logger);
    }

    public void init() {
        if (this.m_initialized) {
            return;
        }
        switch (this.m_type) {
            case 0: {
                try {
                    if (this.m_instance != null) break;
                    this.m_instance = (Component)this.m_factory.newInstance();
                }
                catch (Exception exception) {
                    this.getLogger().error("Cannot use component: " + this.m_factory.getCreatedClass().getName(), (Throwable)exception);
                }
                break;
            }
            case 1: {
                try {
                    this.m_pool.init();
                }
                catch (Exception exception) {
                    this.getLogger().error("Cannot use component: " + this.m_factory.getCreatedClass().getName(), (Throwable)exception);
                }
                break;
            }
        }
        this.m_initialized = true;
    }

    public Component get() throws Exception {
        if (!this.m_initialized) {
            throw new IllegalStateException("You cannot get a component from an uninitialized holder.");
        }
        if (this.m_disposed) {
            throw new IllegalStateException("You cannot get a component from a disposed holder");
        }
        Component component = null;
        switch (this.m_type) {
            case 0: {
                component = this.m_instance;
                break;
            }
            case 1: {
                component = (Component)((Object)this.m_pool.get());
                break;
            }
            default: {
                component = (Component)this.m_factory.newInstance();
                break;
            }
        }
        return component;
    }

    public void put(Component component) {
        if (!this.m_initialized) {
            throw new IllegalStateException("You cannot put a component in an uninitialized holder.");
        }
        if (this.m_disposed) {
            throw new IllegalStateException("You cannot put a component in a disposed holder");
        }
        switch (this.m_type) {
            case 0: {
                break;
            }
            case 1: {
                this.m_pool.put((Poolable)((Object)component));
                break;
            }
            default: {
                try {
                    this.m_factory.decommission(component);
                }
                catch (Exception exception) {
                    this.getLogger().warn("Error decommissioning component: " + this.m_factory.getCreatedClass().getName(), (Throwable)exception);
                }
                break;
            }
        }
    }

    public void dispose() {
        this.m_disposed = true;
        try {
            switch (this.m_type) {
                case 0: {
                    if (this.m_factory != null) {
                        this.m_factory.decommission(this.m_instance);
                    } else {
                        if (this.m_instance instanceof Stoppable) {
                            ((Stoppable)((Object)this.m_instance)).stop();
                        }
                        if (this.m_instance instanceof Disposable) {
                            ((Disposable)((Object)this.m_instance)).dispose();
                        }
                    }
                    this.m_instance = null;
                    break;
                }
                case 1: {
                    if (this.m_pool instanceof Disposable) {
                        this.m_pool.dispose();
                    }
                    this.m_pool = null;
                    break;
                }
            }
            if (this.m_factory instanceof Disposable) {
                ((Disposable)((Object)this.m_factory)).dispose();
            }
            this.m_factory = null;
        }
        catch (Exception exception) {
            this.getLogger().warn("Error decommissioning component: " + this.m_factory.getCreatedClass().getName(), (Throwable)exception);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    DefaultComponentHandler(Class clazz, Configuration configuration, ComponentManager componentManager, Context context, RoleManager roleManager) throws Exception {
        this.m_factory = new DefaultComponentFactory(clazz, configuration, componentManager, context, roleManager);
        if ((class$Lorg$apache$avalon$Poolable != null ? class$Lorg$apache$avalon$Poolable : (class$Lorg$apache$avalon$Poolable = DefaultComponentHandler.class$("org.apache.avalon.Poolable"))).isAssignableFrom(clazz)) {
            this.m_pool = new DefaultComponentPool(this.m_factory);
            this.m_type = 1;
        } else {
            this.m_type = (class$Lorg$apache$avalon$ThreadSafe != null ? class$Lorg$apache$avalon$ThreadSafe : (class$Lorg$apache$avalon$ThreadSafe = DefaultComponentHandler.class$("org.apache.avalon.ThreadSafe"))).isAssignableFrom(clazz) ? 0 : 2;
        }
    }

    DefaultComponentHandler(Component component) throws Exception {
        this.m_type = 0;
        this.m_instance = component;
    }
}

