/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.junit;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.optional.junit.JUnitResultFormatter;
import org.apache.tools.ant.types.EnumeratedAttribute;

public class FormatterElement {
    private String classname;
    private String extension;
    private OutputStream out = System.out;
    private File outFile;
    private boolean useFile = true;

    public void setType(TypeAttribute typeAttribute) {
        if ("xml".equals(typeAttribute.getValue())) {
            this.setClassname("org.apache.tools.ant.taskdefs.optional.junit.XMLJUnitResultFormatter");
            this.setExtension(".xml");
        } else {
            this.setClassname("org.apache.tools.ant.taskdefs.optional.junit.PlainJUnitResultFormatter");
            this.setExtension(".txt");
        }
    }

    public void setClassname(String string) {
        this.classname = string;
    }

    public String getClassname() {
        return this.classname;
    }

    public void setExtension(String string) {
        this.extension = string;
    }

    public String getExtension() {
        return this.extension;
    }

    void setOutfile(File file) {
        this.outFile = file;
    }

    public void setOutput(OutputStream outputStream) {
        this.out = outputStream;
    }

    public void setUseFile(boolean bl) {
        this.useFile = bl;
    }

    boolean getUseFile() {
        return this.useFile;
    }

    JUnitResultFormatter createFormatter() throws BuildException {
        if (this.classname == null) {
            throw new BuildException("you must specify type or classname");
        }
        Class<?> clazz = null;
        try {
            clazz = Class.forName(this.classname);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new BuildException((Throwable)classNotFoundException);
        }
        Object var2_3 = null;
        try {
            var2_3 = clazz.newInstance();
        }
        catch (InstantiationException instantiationException) {
            throw new BuildException((Throwable)instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new BuildException((Throwable)illegalAccessException);
        }
        if (!(var2_3 instanceof JUnitResultFormatter)) {
            throw new BuildException(this.classname + " is not a JUnitResultFormatter");
        }
        JUnitResultFormatter jUnitResultFormatter = var2_3;
        if (this.useFile && this.outFile != null) {
            try {
                this.out = new FileOutputStream(this.outFile);
            }
            catch (IOException iOException) {
                throw new BuildException((Throwable)iOException);
            }
        }
        jUnitResultFormatter.setOutput(this.out);
        return jUnitResultFormatter;
    }

    public static class TypeAttribute
    extends EnumeratedAttribute {
        public String[] getValues() {
            return new String[]{"plain", "xml"};
        }
    }
}

