/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.resources;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.java.util.Configurations;
import org.apache.java.util.ExtendedProperties;
import org.apache.turbine.services.resources.GenericResources;

public class TurbineResources {
    public static final String MAIL_SERVER_KEY = "mail.server";
    public static final String MODULE_CACHE_KEY = "module.cache";
    public static final String ACCESS_CONTROL_KEY = "access.control";
    public static final String MODULE_PACKAGES_KEY = "module.packages";
    public static final String ACTION_CACHE_SIZE_KEY = "action.cache.size";
    public static final String LAYOUT_CACHE_SIZE_KEY = "layout.cache.size";
    public static final String NAVIGATION_CACHE_SIZE_KEY = "navigation.cache.size";
    public static final String PAGE_CACHE_SIZE_KEY = "page.cache.size";
    public static final String SCREEN_CACHE_SIZE_KEY = "screen.cache.size";
    public static final String USER_CLASS_KEY = "user.class";
    public static final String MAX_FILE_SIZE_KEY = "max.file.size.bytes";
    public static final String DB_DRIVER_KEY = "database.default.driver";
    public static final String DB_URL_KEY = "database.default.url";
    public static final String DB_USERNAME_KEY = "database.default.username";
    public static final String DB_PASSWORD_KEY = "database.default.password";
    public static final String DB_MAXCONNECTIONS_KEY = "database.maxConnections";
    public static final String DB_EXPIRYTIME_KEY = "database.expiryTime";
    public static final String UPLOADER_KEY = "file.upload.handler";
    public static final String UPLOAD_PATH_KEY = "file.upload.default.path";
    public static final String FILE_SERVER = "file.server";
    public static final String LOGIN_MESSAGE = "login.message";
    public static final String LOGIN_ERROR = "login.error";
    public static final String LOGIN_MESSAGE_NOSCREEN = "login.message.noscreen";
    public static final String LOGOUT_MESSAGE = "logout.message";
    private static String fileName = null;
    private static GenericResources generic = null;

    TurbineResources() {
    }

    public static boolean getBoolean(String name) {
        return TurbineResources.getGeneric().getBoolean(name);
    }

    public static boolean getBoolean(String name, boolean def) {
        return TurbineResources.getGeneric().getBoolean(name, def);
    }

    public static Configurations getConfig() {
        return TurbineResources.getGeneric().getConfig();
    }

    public static double getDouble(String name) {
        return TurbineResources.getGeneric().getDouble(name);
    }

    public static double getDouble(String name, double def) {
        return TurbineResources.getGeneric().getDouble(name, def);
    }

    public static float getFloat(String name) {
        return TurbineResources.getGeneric().getFloat(name);
    }

    public static float getFloat(String name, float def) {
        return TurbineResources.getGeneric().getFloat(name, def);
    }

    private static GenericResources getGeneric() {
        return generic;
    }

    public static int getInt(String name) {
        return TurbineResources.getGeneric().getInt(name);
    }

    public static int getInt(String name, int def) {
        return TurbineResources.getGeneric().getInt(name, def);
    }

    public static Integer getInteger(String name) {
        return TurbineResources.getGeneric().getInteger(name);
    }

    public static Integer getInteger(String name, int def) {
        return TurbineResources.getGeneric().getInteger(name, def);
    }

    public static Enumeration getKeys() {
        return TurbineResources.getGeneric().getKeys();
    }

    public static Enumeration getKeys(String prefix) {
        Enumeration keys = TurbineResources.getGeneric().getKeys();
        Vector matchingKeys = new Vector();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            if (!(key instanceof String) || !((String)key).startsWith(prefix)) continue;
            matchingKeys.addElement(key);
        }
        return matchingKeys.elements();
    }

    public static long getLong(String name) {
        return TurbineResources.getGeneric().getLong(name);
    }

    public static long getLong(String name, long def) {
        return TurbineResources.getGeneric().getLong(name, def);
    }

    public static String getString(String name) {
        return TurbineResources.getGeneric().getString(name);
    }

    public static String getString(String name, String def) {
        return TurbineResources.getGeneric().getString(name, def);
    }

    public static Vector getVector(String name) {
        return TurbineResources.getGeneric().getVector(name);
    }

    public static Vector getVector(String name, Vector def) {
        Vector vec = TurbineResources.getGeneric().getVector(name);
        if (vec == null) {
            return def;
        }
        return vec;
    }

    private static void init() throws IOException {
        if (fileName == null) {
            throw new IOException("TurbineResources: fileName must not be null!");
        }
        TurbineResources.init(new Configurations(new ExtendedProperties(fileName)));
    }

    private static void init(Properties props) {
        ExtendedProperties extProperties = new ExtendedProperties();
        Enumeration e = ((Hashtable)props).keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String value = (String)((Hashtable)props).get(key);
            int commaSign = value.indexOf(44);
            if (commaSign > 0) {
                StringTokenizer tokenizer = new StringTokenizer(value, ",");
                Vector<String> v = new Vector<String>(2);
                while (tokenizer.hasMoreTokens()) {
                    String token = tokenizer.nextToken();
                    v.addElement(token);
                }
                extProperties.put(key, v);
                continue;
            }
            extProperties.put(key, value);
        }
        TurbineResources.init(new Configurations(extProperties));
    }

    private static void init(Configurations confs) {
        generic = new GenericResources(confs);
    }

    static void setProperties(Properties properties) {
        TurbineResources.init(properties);
    }

    static void setPropertiesFileName(String propertiesFileName) throws IOException {
        fileName = propertiesFileName;
        TurbineResources.init();
    }
}

