/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layout;

import java.util.Vector;
import org.apache.fop.datatypes.ColorType;
import org.apache.fop.layout.Box;
import org.apache.fop.layout.DisplaySpace;
import org.apache.fop.layout.FontInfo;
import org.apache.fop.layout.FontState;
import org.apache.fop.layout.Page;

public abstract class Area
extends Box {
    protected FontState fontState;
    protected Vector children = new Vector();
    protected int maxHeight;
    protected int currentHeight = 0;
    protected int contentRectangleWidth;
    protected int allocationWidth;
    protected Page page;
    protected ColorType backgroundColor;
    protected int paddingTop;
    protected int paddingLeft;
    protected int paddingBottom;
    protected int paddingRight;
    public int borderWidthTop;
    public int borderWidthLeft;
    public int borderWidthRight;
    public int borderWidthBottom;
    public int borderStyleTop;
    public int borderStyleLeft;
    public int borderStyleRight;
    public int borderStyleBottom;
    public ColorType borderColorTop;
    public ColorType borderColorLeft;
    public ColorType borderColorRight;
    public ColorType borderColorBottom;

    public Area(FontState fontState) {
        this.fontState = fontState;
    }

    public Area(FontState fontState, int n, int n2) {
        this.fontState = fontState;
        this.allocationWidth = n;
        this.contentRectangleWidth = n;
        this.maxHeight = n2;
    }

    public void addChild(Box box) {
        this.children.addElement(box);
        box.parent = this;
    }

    public void addChildAtStart(Box box) {
        this.children.insertElementAt(box, 0);
        box.parent = this;
    }

    public void addDisplaySpace(int n) {
        this.addChild(new DisplaySpace(n));
        this.currentHeight += n;
    }

    public void end() {
    }

    public int getAllocationWidth() {
        return this.allocationWidth - this.paddingLeft - this.paddingRight - this.borderWidthLeft - this.borderWidthRight;
    }

    public ColorType getBackgroundColor() {
        return this.backgroundColor;
    }

    public Vector getChildren() {
        return this.children;
    }

    public int getContentHeight() {
        return this.currentHeight;
    }

    public int getContentWidth() {
        return this.contentRectangleWidth - this.paddingLeft - this.paddingRight - this.borderWidthLeft - this.borderWidthRight;
    }

    public FontInfo getFontInfo() {
        return this.page.getFontInfo();
    }

    public FontState getFontState() {
        return this.fontState;
    }

    public int getHeight() {
        return this.currentHeight + this.paddingTop + this.paddingBottom + this.borderWidthTop + this.borderWidthBottom;
    }

    public int getMaxHeight() {
        return this.maxHeight - this.paddingTop - this.paddingBottom - this.borderWidthTop - this.borderWidthBottom;
    }

    public int getPaddingBottom() {
        return this.paddingBottom;
    }

    public int getPaddingLeft() {
        return this.paddingLeft;
    }

    public int getPaddingRight() {
        return this.paddingRight;
    }

    public int getPaddingTop() {
        return this.paddingTop;
    }

    public Page getPage() {
        return this.page;
    }

    public Area getParent() {
        return this.parent;
    }

    public void increaseHeight(int n) {
        this.currentHeight += n;
    }

    public void remove() {
        this.parent.removeChild(this);
    }

    protected void removeChild(Area area) {
        this.currentHeight -= area.getHeight();
        this.children.removeElement(area);
    }

    public void setBackgroundColor(ColorType colorType) {
        this.backgroundColor = colorType;
    }

    public void setBorderColor(ColorType colorType, ColorType colorType2, ColorType colorType3, ColorType colorType4) {
        this.borderColorTop = colorType;
        this.borderColorLeft = colorType2;
        this.borderColorBottom = colorType3;
        this.borderColorRight = colorType4;
    }

    public void setBorderStyle(int n, int n2, int n3, int n4) {
        this.borderStyleTop = n;
        this.borderStyleLeft = n2;
        this.borderStyleBottom = n3;
        this.borderStyleRight = n4;
    }

    public void setBorderWidth(int n, int n2, int n3, int n4) {
        this.borderWidthTop = n;
        this.borderWidthLeft = n2;
        this.borderWidthBottom = n3;
        this.borderWidthRight = n4;
    }

    public void setHeight(int n) {
        if (n > this.currentHeight) {
            this.currentHeight = n;
        }
        if (this.currentHeight > this.getMaxHeight()) {
            this.currentHeight = this.getMaxHeight();
        }
    }

    public void setMaxHeight(int n) {
        this.maxHeight = n;
    }

    public void setPadding(int n, int n2, int n3, int n4) {
        this.paddingTop = n;
        this.paddingLeft = n2;
        this.paddingBottom = n3;
        this.paddingRight = n4;
    }

    public void setPage(Page page) {
        this.page = page;
    }

    public int spaceLeft() {
        return this.maxHeight - this.currentHeight;
    }

    public void start() {
    }
}

