/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo;

import java.util.Vector;
import org.apache.fop.apps.FOPException;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.Status;
import org.apache.fop.layout.Area;
import org.apache.fop.layout.LinkSet;

public abstract class FONode {
    protected FObj parent;
    protected Vector children = new Vector();
    public static final int START = -1000;
    public static final int BREAK_AFTER = -1001;
    protected int marker = -1000;
    protected boolean isInLabel = false;
    protected boolean isInListBody = false;
    protected boolean isInTableCell = false;
    protected int bodyIndent;
    protected int distanceBetweenStarts;
    protected int labelSeparation;
    protected int forcedStartOffset = 0;
    protected int forcedWidth = 0;
    protected LinkSet linkSet;

    protected FONode(FObj fObj) {
        this.parent = fObj;
    }

    protected void addChild(FONode fONode) {
        this.children.addElement(fONode);
    }

    public void forceStartOffset(int n) {
        this.forcedStartOffset = n;
        int n2 = 0;
        while (n2 < this.children.size()) {
            FONode fONode = (FONode)this.children.elementAt(n2);
            fONode.forceStartOffset(n);
            ++n2;
        }
    }

    public void forceWidth(int n) {
        this.forcedWidth = n;
        int n2 = 0;
        while (n2 < this.children.size()) {
            FONode fONode = (FONode)this.children.elementAt(n2);
            fONode.forceWidth(n);
            ++n2;
        }
    }

    public LinkSet getLinkSet() {
        return this.linkSet;
    }

    public FObj getParent() {
        return this.parent;
    }

    public abstract Status layout(Area var1) throws FOPException;

    public void removeAreas() {
    }

    public void resetMarker() {
        this.marker = -1000;
        int n = this.children.size();
        int n2 = 0;
        while (n2 < n) {
            ((FONode)this.children.elementAt(n2)).resetMarker();
            ++n2;
        }
    }

    public void setBodyIndent(int n) {
        this.bodyIndent = n;
        int n2 = 0;
        while (n2 < this.children.size()) {
            FONode fONode = (FONode)this.children.elementAt(n2);
            fONode.setBodyIndent(n);
            ++n2;
        }
    }

    public void setDistanceBetweenStarts(int n) {
        this.distanceBetweenStarts = n;
        int n2 = 0;
        while (n2 < this.children.size()) {
            FONode fONode = (FONode)this.children.elementAt(n2);
            fONode.setDistanceBetweenStarts(n);
            ++n2;
        }
    }

    public void setIsInLabel() {
        this.isInLabel = true;
        int n = 0;
        while (n < this.children.size()) {
            FONode fONode = (FONode)this.children.elementAt(n);
            fONode.setIsInLabel();
            ++n;
        }
    }

    public void setIsInListBody() {
        this.isInListBody = true;
        int n = 0;
        while (n < this.children.size()) {
            FONode fONode = (FONode)this.children.elementAt(n);
            fONode.setIsInListBody();
            ++n;
        }
    }

    public void setIsInTableCell() {
        this.isInTableCell = true;
        int n = 0;
        while (n < this.children.size()) {
            FONode fONode = (FONode)this.children.elementAt(n);
            fONode.setIsInTableCell();
            ++n;
        }
    }

    public void setLabelSeparation(int n) {
        this.labelSeparation = n;
        int n2 = 0;
        while (n2 < this.children.size()) {
            FONode fONode = (FONode)this.children.elementAt(n2);
            fONode.setLabelSeparation(n);
            ++n2;
        }
    }

    public void setLinkSet(LinkSet linkSet) {
        this.linkSet = linkSet;
    }
}

