/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.processor.xsp.language.java;

import java.io.ByteArrayOutputStream;
import java.io.File;
import org.apache.cocoon.framework.Configurable;
import org.apache.cocoon.framework.Configurations;
import org.apache.cocoon.processor.xsp.XSPPage;
import org.apache.cocoon.processor.xsp.XSPUtil;
import org.apache.cocoon.processor.xsp.language.XSPLanguageProcessor;
import org.apache.cocoon.processor.xsp.language.java.JavaCompiler;
import org.apache.cocoon.processor.xsp.language.java.XSPClassLoader;

public class XSPJavaProcessor
implements XSPLanguageProcessor,
Configurable {
    protected File repository;
    protected String encoding;
    protected XSPClassLoader classLoader;
    protected JavaCompiler javac;
    protected boolean format = false;

    public static String className(String filename) {
        return XSPUtil.normalizedBaseName(XSPUtil.fileComponent(filename));
    }

    public void compile(String filename) throws Exception {
        String repositoryName = this.repository.getCanonicalPath();
        String fullFilename = String.valueOf(repositoryName) + File.separator + filename;
        ByteArrayOutputStream err = new ByteArrayOutputStream(256);
        this.javac.setEncoding(this.encoding);
        this.javac.setClasspath(String.valueOf(repositoryName) + File.pathSeparator + System.getProperty("java.class.path"));
        this.javac.setOutputDir(repositoryName);
        this.javac.setMsgOutput(err);
        boolean compilationResult = this.javac.compile(fullFilename);
        if (!compilationResult) {
            int pos = fullFilename.length() + 1;
            StringBuffer buffer = new StringBuffer();
            String[] errorLines = XSPUtil.split(err.toString(), "\r\n");
            int i = 0;
            while (i < errorLines.length) {
                if (errorLines[i].startsWith(fullFilename)) {
                    errorLines[i] = errorLines[i].substring(pos);
                }
                buffer.append(String.valueOf(errorLines[i]) + "\n");
                ++i;
            }
            throw new Exception("XSP Java Compiler: Compilation failed for " + XSPUtil.fileComponent(filename) + "\n" + buffer.toString());
        }
    }

    public String formatCode(String code) throws Exception {
        return code;
    }

    public String getObjectExtension() {
        return "class";
    }

    public String getSourceExtension() {
        return "java";
    }

    public void init(Configurations conf) {
        String javacClassName = (String)conf.get("compiler", "org.apache.cocoon.processor.xsp.language.java.SunJavaCompiler");
        try {
            this.javac = (JavaCompiler)Class.forName(javacClassName).newInstance();
        }
        catch (Exception exception) {}
    }

    public XSPPage load(String filename) throws Exception {
        return (XSPPage)this.classLoader.loadClass(filename.substring(0, filename.lastIndexOf(".")).replace(File.separatorChar, '.')).newInstance();
    }

    public static String packageName(String filename) {
        return XSPUtil.normalizedName(XSPUtil.pathComponent(filename)).replace(File.separatorChar, '.');
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setFormatOption(boolean format) {
        this.format = format;
    }

    public void setRepository(File repository) throws Exception {
        this.repository = repository;
        this.classLoader = new XSPClassLoader(this.repository);
    }

    public String stringEncode(String string) {
        char[] chr = string.toCharArray();
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < chr.length) {
            switch (chr[i]) {
                case '\t': {
                    buffer.append("\\t");
                    break;
                }
                case '\r': {
                    buffer.append("\\r");
                    break;
                }
                case '\n': {
                    buffer.append("\\n");
                    break;
                }
                case '\"': 
                case '\\': {
                    buffer.append('\\');
                }
                default: {
                    buffer.append(chr[i]);
                    break;
                }
            }
            ++i;
        }
        return buffer.toString();
    }

    public void unload(XSPPage page) throws Exception {
        this.classLoader = new XSPClassLoader(this.repository);
    }
}

