/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.processor.xsp;

import java.util.Dictionary;
import org.apache.cocoon.parser.Parser;
import org.apache.cocoon.processor.xsp.language.XSPPreprocessor;
import org.apache.cocoon.transformer.Transformer;
import org.w3c.dom.Document;

public class XSPLogicsheet {
    protected Document stylesheet;
    protected XSPPreprocessor preprocessor;
    private Transformer transformer;
    private Parser parser;
    private String templateBase;

    public XSPLogicsheet(Transformer transformer, Parser parser, String templateBase) {
        this.transformer = transformer;
        this.parser = parser;
        this.templateBase = templateBase;
    }

    public Document apply(Document document, Dictionary parameters) throws Exception {
        if (this.preprocessor != null) {
            document = this.preprocessor.preprocess(document, parameters);
        }
        return this.transformer.transform(document, (String)parameters.get("filename"), this.stylesheet, this.templateBase, this.parser.createEmptyDocument(), parameters);
    }

    public XSPPreprocessor getPreprocessor() {
        return this.preprocessor;
    }

    public Document getStylesheet() {
        return this.stylesheet;
    }

    public void setPreprocessor(XSPPreprocessor preprocessor) {
        this.preprocessor = preprocessor;
    }

    public void setStylesheet(Document stylesheet) {
        this.stylesheet = stylesheet;
    }
}

