/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;

public abstract class MatchingTask
extends Task {
    protected Vector includeList = new Vector();
    protected Vector excludeList = new Vector();
    protected boolean useDefaultExcludes = true;

    private NameEntry addPatternToList(Vector list) {
        NameEntry result = new NameEntry();
        list.addElement(result);
        return result;
    }

    public NameEntry createExclude() {
        return this.addPatternToList(this.excludeList);
    }

    public NameEntry createInclude() {
        return this.addPatternToList(this.includeList);
    }

    protected DirectoryScanner getDirectoryScanner(File baseDir) {
        DirectoryScanner ds = new DirectoryScanner();
        ds.setBasedir(baseDir);
        ds.setIncludes(this.makeArray(this.includeList));
        ds.setExcludes(this.makeArray(this.excludeList));
        if (this.useDefaultExcludes) {
            ds.addDefaultExcludes();
        }
        ds.scan();
        return ds;
    }

    protected String getProperty(String name) {
        return this.project.getProperty(name);
    }

    private String[] makeArray(Vector list) {
        if (list.size() == 0) {
            return null;
        }
        Vector<String> tmpNames = new Vector<String>();
        Enumeration e = list.elements();
        while (e.hasMoreElements()) {
            String includes = ((NameEntry)e.nextElement()).getName();
            if (includes == null) continue;
            StringTokenizer tok = new StringTokenizer(includes, ", ", false);
            while (tok.hasMoreTokens()) {
                String pattern = tok.nextToken().trim();
                if (pattern.length() <= 0) continue;
                tmpNames.addElement(pattern);
            }
        }
        String[] result = new String[tmpNames.size()];
        int i = 0;
        while (i < tmpNames.size()) {
            result[i] = (String)tmpNames.elementAt(i);
            ++i;
        }
        return result;
    }

    private void readPatterns(File patternfile, Vector patternlist) {
        try {
            BufferedReader patternReader = new BufferedReader(new FileReader(patternfile));
            String line = patternReader.readLine();
            while (line != null) {
                if (line.length() > 0) {
                    this.addPatternToList(patternlist).setName(line);
                }
                line = patternReader.readLine();
            }
        }
        catch (IOException iOException) {
            this.log("An error occured while reading from pattern file: " + patternfile, 0);
        }
    }

    public void setDefaultexcludes(String useDefaultExcludes) {
        this.useDefaultExcludes = Project.toBoolean(useDefaultExcludes);
    }

    public void setExcludes(String excludes) {
        if (excludes != null && excludes.length() > 0) {
            this.createExclude().setName(excludes);
        }
    }

    public void setExcludesfile(String excludesfile) {
        if (excludesfile != null && excludesfile.length() > 0) {
            File excl = this.project.resolveFile(excludesfile);
            if (!excl.exists()) {
                this.log("Excludesfile " + excludesfile + " not found.", 0);
            } else {
                this.readPatterns(excl, this.excludeList);
            }
        }
    }

    public void setIgnore(String ignoreString) {
        this.log("The ignore attribute is deprecated.Please use the excludes attribute.", 1);
        if (ignoreString != null && ignoreString.length() > 0) {
            Vector tmpExcludes = new Vector();
            StringTokenizer tok = new StringTokenizer(ignoreString, ", ", false);
            while (tok.hasMoreTokens()) {
                this.createExclude().setName("**/" + tok.nextToken().trim() + "/**");
            }
        }
    }

    public void setIncludes(String includes) {
        if (includes != null && includes.length() > 0) {
            this.createInclude().setName(includes);
        }
    }

    public void setIncludesfile(String includesfile) {
        if (includesfile != null && includesfile.length() > 0) {
            File incl = this.project.resolveFile(includesfile);
            if (!incl.exists()) {
                this.log("Includesfile " + includesfile + " not found.", 0);
            } else {
                this.readPatterns(incl, this.includeList);
            }
        }
    }

    public void setItems(String itemString) {
        this.log("The items attribute is deprecated. Please use the includes attribute.", 1);
        if (itemString == null || itemString.equals("*") || itemString.equals(".")) {
            this.createInclude().setName("**");
        } else {
            StringTokenizer tok = new StringTokenizer(itemString, ", ");
            while (tok.hasMoreTokens()) {
                String pattern = tok.nextToken().trim();
                if (pattern.length() <= 0) continue;
                this.createInclude().setName(String.valueOf(pattern) + "/**");
            }
        }
    }

    public class NameEntry {
        private boolean valid = true;
        private String name;

        public String getName() {
            return this.valid ? this.name : null;
        }

        public void setIf(String name) {
            if (MatchingTask.this.getProperty(name) == null) {
                this.valid = false;
            }
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setUnless(String name) {
            if (MatchingTask.this.getProperty(name) != null) {
                this.valid = false;
            }
        }
    }
}

