/*
 * File:          sidl_DLL_jniStub.c
 * Symbol:        sidl.DLL-v0.9.1
 * Symbol Type:   class
 * Babel Version: 0.10.2
 * Release:       $Name:  $
 * Revision:      @(#) $Id: $
 * Description:   Client-side JNI glue code for sidl.DLL
 * 
 * Copyright (c) 2000-2002, The Regents of the University of California.
 * Produced at the Lawrence Livermore National Laboratory.
 * Written by the Components Team <components@llnl.gov>
 * All rights reserved.
 * 
 * This file is part of Babel. For more information, see
 * http://www.llnl.gov/CASC/components/. Please read the COPYRIGHT file
 * for Our Notice and the LICENSE file for the GNU Lesser General Public
 * License.
 * 
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License (as published by
 * the Free Software Foundation) version 2.1 dated February 1999.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the IMPLIED WARRANTY OF
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the terms and
 * conditions of the GNU Lesser General Public License for more details.
 * 
 * You should have recieved a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 * 
 * WARNING: Automatically generated; changes will be lost
 * 
 * babel-version = 0.10.2
 */

#include "sidl_Java.h"
#include "sidl_Loader.h"
#include "sidl_String.h"
#include "sidl_DLL_IOR.h"
#include "babel_config.h"

/*
 * Convert between jlong and void* pointers.
 */

#if (SIZEOF_VOID_P == 8)
#define JLONG_TO_POINTER(x) ((void*)(x))
#define POINTER_TO_JLONG(x) ((jlong)(x))
#else
#define JLONG_TO_POINTER(x) ((void*)(int32_t)(x))
#define POINTER_TO_JLONG(x) ((jlong)(int32_t)(x))
#endif

#ifndef NULL
#define NULL 0
#endif

/*
 * Function to extract IOR reference from the Java object.
 */

static struct sidl_DLL__object* _get_ior(
  JNIEnv* env,
  jobject obj)
{
  void* ptr = NULL;
  static jmethodID mid = (jmethodID) NULL;

  if (mid == (jmethodID) NULL) {
    jclass cls = (*env)->GetObjectClass(env, obj);
    mid = (*env)->GetMethodID(env, cls, "_get_ior", "()J");
    (*env)->DeleteLocalRef(env, cls);
  }

  ptr = JLONG_TO_POINTER((*env)->CallLongMethod(env, obj, mid));
  return (struct sidl_DLL__object*) ptr;
}

/*
 * External reference to IOR methods.
 */

static const struct sidl_DLL__external* s_external = NULL;

/*
 * Create object instance and return reference.
 */

static jlong jni__create_ior(
  JNIEnv* env,
  jclass  cls)
{
  (void) env;
  (void) cls;
  return POINTER_TO_JLONG((*s_external->createObject)());
}

/*
 * Load a dynamic link library using the specified URI.  The
 * URI may be of the form "main:", "lib:", "file:", "ftp:", or
 * "http:".  A URI that starts with any other protocol string
 * is assumed to be a file name.  The "main:" URI creates a
 * library that allows access to global symbols in the running
 * program's main address space.  The "lib:X" URI converts the
 * library "X" into a platform-specific name (e.g., libX.so) and
 * loads that library.  The "file:" URI opens the DLL from the
 * specified file path.  The "ftp:" and "http:" URIs copy the
 * specified library from the remote site into a local temporary
 * file and open that file.  This method returns true if the
 * DLL was loaded successfully and false otherwise.  Note that
 * the "ftp:" and "http:" protocols are valid only if the W3C
 * WWW library is available.
 * 
 * @param uri          the URI to load. This can be a .la file
 *                     (a metadata file produced by libtool) or
 *                     a shared library binary (i.e., .so,
 *                     .dll or whatever is appropriate for your
 *                     OS)
 * @param loadGlobally <code>true</code> means that the shared
 *                     library symbols will be loaded into the
 *                     global namespace; <code>false</code> 
 *                     means they will be loaded into a 
 *                     private namespace. Some operating systems
 *                     may not be able to honor the value presented
 *                     here.
 * @param loadLazy     <code>true</code> instructs the loader to
 *                     that symbols can be resolved as needed (lazy)
 *                     instead of requiring everything to be resolved
 *                     now (at load time).
 */

static jboolean
jni_loadLibrary(
  JNIEnv* env,
  jobject obj,
  jstring _arg_uri,
  jboolean _arg_loadGlobally,
  jboolean _arg_loadLazy)
{
  /*
   * Declare return and temporary variables.
   */

  struct sidl_DLL__object* _ior = NULL;
  char* _tmp_uri = (char*) NULL;
  sidl_bool _tmp_loadGlobally = FALSE;
  sidl_bool _tmp_loadLazy = FALSE;
  sidl_bool _ior_res = FALSE;
  jboolean _res = JNI_FALSE;

  /*
   * Preprocess Java types and convert into IOR.
   */

  _ior = _get_ior(env, obj);
  _tmp_uri = sidl_Java_J2I_string(env, _arg_uri);
  _tmp_loadGlobally = (sidl_bool) _arg_loadGlobally;
  _tmp_loadLazy = (sidl_bool) _arg_loadLazy;

  /*
   * Call the IOR method through the EPV.
   */

  _ior_res = (*(_ior->d_epv->f_loadLibrary))(
    _ior,
    _tmp_uri,
    _tmp_loadGlobally,
    _tmp_loadLazy);

  /*
   * Postprocess OUT, INOUT, returns, and exceptions.
   */

  sidl_String_free(_tmp_uri);
  _res = (jboolean) _ior_res;

  return _res;
}

/*
 * Get the library name.  This is the name used to load the
 * library in <code>loadLibrary</code> except that all file names
 * contain the "file:" protocol.
 */

static jstring
jni_getName(
  JNIEnv* env,
  jobject obj)
{
  /*
   * Declare return and temporary variables.
   */

  struct sidl_DLL__object* _ior = NULL;
  char* _ior_res = (char*) NULL;
  jstring _res = (jstring) NULL;

  /*
   * Preprocess Java types and convert into IOR.
   */

  _ior = _get_ior(env, obj);

  /*
   * Call the IOR method through the EPV.
   */

  _ior_res = (*(_ior->d_epv->f_getName))(
    _ior);

  /*
   * Postprocess OUT, INOUT, returns, and exceptions.
   */

  _res = sidl_Java_I2J_string(env, _ior_res);
  sidl_String_free(_ior_res);

  return _res;
}

/*
 * Unload the dynamic link library.  The library may no longer
 * be used to access symbol names.  When the library is actually
 * unloaded from the memory image depends on details of the operating
 * system.
 */

static void
jni_unloadLibrary(
  JNIEnv* env,
  jobject obj)
{
  /*
   * Declare return and temporary variables.
   */

  struct sidl_DLL__object* _ior = NULL;

  /*
   * Preprocess Java types and convert into IOR.
   */

  _ior = _get_ior(env, obj);

  /*
   * Call the IOR method through the EPV.
   */

  (*(_ior->d_epv->f_unloadLibrary))(
    _ior);

  /*
   * Postprocess OUT, INOUT, returns, and exceptions.
   */

}

/*
 * Lookup a symbol from the DLL and return the associated pointer.
 * A null value is returned if the name does not exist.
 */

static jlong
jni_lookupSymbol(
  JNIEnv* env,
  jobject obj,
  jstring _arg_linker_name)
{
  /*
   * Declare return and temporary variables.
   */

  struct sidl_DLL__object* _ior = NULL;
  char* _tmp_linker_name = (char*) NULL;
  void* _ior_res = (void*) NULL;
  jlong _res = 0;

  /*
   * Preprocess Java types and convert into IOR.
   */

  _ior = _get_ior(env, obj);
  _tmp_linker_name = sidl_Java_J2I_string(env, _arg_linker_name);

  /*
   * Call the IOR method through the EPV.
   */

  _ior_res = (*(_ior->d_epv->f_lookupSymbol))(
    _ior,
    _tmp_linker_name);

  /*
   * Postprocess OUT, INOUT, returns, and exceptions.
   */

  sidl_String_free(_tmp_linker_name);
  _res = (jlong) POINTER_TO_JLONG(_ior_res);

  return _res;
}

/*
 * Create an instance of the sidl class.  If the class constructor
 * is not defined in this DLL, then return null.
 */

static jobject
jni_createClass(
  JNIEnv* env,
  jobject obj,
  jstring _arg_sidl_name)
{
  /*
   * Declare return and temporary variables.
   */

  struct sidl_DLL__object* _ior = NULL;
  char* _tmp_sidl_name = (char*) NULL;
  struct sidl_BaseClass__object* _ior_res = (struct sidl_BaseClass__object*) 
    NULL;
  jobject _res = (jobject) NULL;

  /*
   * Preprocess Java types and convert into IOR.
   */

  _ior = _get_ior(env, obj);
  _tmp_sidl_name = sidl_Java_J2I_string(env, _arg_sidl_name);

  /*
   * Call the IOR method through the EPV.
   */

  _ior_res = (*(_ior->d_epv->f_createClass))(
    _ior,
    _tmp_sidl_name);

  /*
   * Postprocess OUT, INOUT, returns, and exceptions.
   */

  sidl_String_free(_tmp_sidl_name);
  _res = sidl_Java_I2J_cls(env, _ior_res, "sidl.BaseClass");

  return _res;
}

/*
 * Register JNI methods with the Java JVM.
 */

void sidl_DLL__register(JNIEnv* env)
{
  JNINativeMethod methods[6];
  jclass cls;

  s_external = sidl_DLL__externals();
  methods[0].name      = "_create_ior";
  methods[0].signature = "()J";
  methods[0].fnPtr     = (void *)jni__create_ior;
  methods[1].name      = "loadLibrary";
  methods[1].signature = "(Ljava/lang/String;ZZ)Z";
  methods[1].fnPtr     = (void *)jni_loadLibrary;
  methods[2].name      = "getName";
  methods[2].signature = "()Ljava/lang/String;";
  methods[2].fnPtr     = (void *)jni_getName;
  methods[3].name      = "unloadLibrary";
  methods[3].signature = "()V";
  methods[3].fnPtr     = (void *)jni_unloadLibrary;
  methods[4].name      = "lookupSymbol";
  methods[4].signature = "(Ljava/lang/String;)J";
  methods[4].fnPtr     = (void *)jni_lookupSymbol;
  methods[5].name      = "createClass";
  methods[5].signature = "(Ljava/lang/String;)Lsidl/BaseClass;";
  methods[5].fnPtr     = (void *)jni_createClass;


  cls = (*env)->FindClass(env, "sidl/DLL");
  if (cls) {
    (*env)->RegisterNatives(env, cls, methods, 6);
    (*env)->DeleteLocalRef(env, cls);
  }
}
