/*
 * File:          sidl_SIDLException_jniStub.c
 * Symbol:        sidl.SIDLException-v0.9.1
 * Symbol Type:   class
 * Babel Version: 0.10.2
 * Release:       $Name:  $
 * Revision:      @(#) $Id: $
 * Description:   Client-side JNI glue code for sidl.SIDLException
 * 
 * Copyright (c) 2000-2002, The Regents of the University of California.
 * Produced at the Lawrence Livermore National Laboratory.
 * Written by the Components Team <components@llnl.gov>
 * All rights reserved.
 * 
 * This file is part of Babel. For more information, see
 * http://www.llnl.gov/CASC/components/. Please read the COPYRIGHT file
 * for Our Notice and the LICENSE file for the GNU Lesser General Public
 * License.
 * 
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License (as published by
 * the Free Software Foundation) version 2.1 dated February 1999.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the IMPLIED WARRANTY OF
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the terms and
 * conditions of the GNU Lesser General Public License for more details.
 * 
 * You should have recieved a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 * 
 * WARNING: Automatically generated; changes will be lost
 * 
 * babel-version = 0.10.2
 */

#include "sidl_Java.h"
#include "sidl_Loader.h"
#include "sidl_String.h"
#include "sidl_SIDLException_IOR.h"
#include "babel_config.h"

/*
 * Convert between jlong and void* pointers.
 */

#if (SIZEOF_VOID_P == 8)
#define JLONG_TO_POINTER(x) ((void*)(x))
#define POINTER_TO_JLONG(x) ((jlong)(x))
#else
#define JLONG_TO_POINTER(x) ((void*)(int32_t)(x))
#define POINTER_TO_JLONG(x) ((jlong)(int32_t)(x))
#endif

#ifndef NULL
#define NULL 0
#endif

/*
 * Function to extract IOR reference from the Java object.
 */

static struct sidl_SIDLException__object* _get_ior(
  JNIEnv* env,
  jobject obj)
{
  void* ptr = NULL;
  static jmethodID mid = (jmethodID) NULL;

  if (mid == (jmethodID) NULL) {
    jclass cls = (*env)->GetObjectClass(env, obj);
    mid = (*env)->GetMethodID(env, cls, "_get_ior", "()J");
    (*env)->DeleteLocalRef(env, cls);
  }

  ptr = JLONG_TO_POINTER((*env)->CallLongMethod(env, obj, mid));
  return (struct sidl_SIDLException__object*) ptr;
}

/*
 * External reference to IOR methods.
 */

static const struct sidl_SIDLException__external* s_external = NULL;

/*
 * Create object instance and return reference.
 */

static jlong jni__create_ior(
  JNIEnv* env,
  jclass  cls)
{
  (void) env;
  (void) cls;
  return POINTER_TO_JLONG((*s_external->createObject)());
}

/*
 * Return the message associated with the exception.
 */

static jstring
jni_getNote(
  JNIEnv* env,
  jobject obj)
{
  /*
   * Declare return and temporary variables.
   */

  struct sidl_SIDLException__object* _ior = NULL;
  char* _ior_res = (char*) NULL;
  jstring _res = (jstring) NULL;

  /*
   * Preprocess Java types and convert into IOR.
   */

  _ior = _get_ior(env, obj);

  /*
   * Call the IOR method through the EPV.
   */

  _ior_res = (*(_ior->d_epv->f_getNote))(
    _ior);

  /*
   * Postprocess OUT, INOUT, returns, and exceptions.
   */

  _res = sidl_Java_I2J_string(env, _ior_res);
  sidl_String_free(_ior_res);

  return _res;
}

/*
 * Set the message associated with the exception.
 */

static void
jni_setNote(
  JNIEnv* env,
  jobject obj,
  jstring _arg_message)
{
  /*
   * Declare return and temporary variables.
   */

  struct sidl_SIDLException__object* _ior = NULL;
  char* _tmp_message = (char*) NULL;

  /*
   * Preprocess Java types and convert into IOR.
   */

  _ior = _get_ior(env, obj);
  _tmp_message = sidl_Java_J2I_string(env, _arg_message);

  /*
   * Call the IOR method through the EPV.
   */

  (*(_ior->d_epv->f_setNote))(
    _ior,
    _tmp_message);

  /*
   * Postprocess OUT, INOUT, returns, and exceptions.
   */

  sidl_String_free(_tmp_message);
}

/*
 * Returns formatted string containing the concatenation of all 
 * tracelines.
 */

static jstring
jni_getTrace(
  JNIEnv* env,
  jobject obj)
{
  /*
   * Declare return and temporary variables.
   */

  struct sidl_SIDLException__object* _ior = NULL;
  char* _ior_res = (char*) NULL;
  jstring _res = (jstring) NULL;

  /*
   * Preprocess Java types and convert into IOR.
   */

  _ior = _get_ior(env, obj);

  /*
   * Call the IOR method through the EPV.
   */

  _ior_res = (*(_ior->d_epv->f_getTrace))(
    _ior);

  /*
   * Postprocess OUT, INOUT, returns, and exceptions.
   */

  _res = sidl_Java_I2J_string(env, _ior_res);
  sidl_String_free(_ior_res);

  return _res;
}

/*
 * Adds a stringified entry/line to the stack trace.
 */

static void
jni_addLine(
  JNIEnv* env,
  jobject obj,
  jstring _arg_traceline)
{
  /*
   * Declare return and temporary variables.
   */

  struct sidl_SIDLException__object* _ior = NULL;
  char* _tmp_traceline = (char*) NULL;

  /*
   * Preprocess Java types and convert into IOR.
   */

  _ior = _get_ior(env, obj);
  _tmp_traceline = sidl_Java_J2I_string(env, _arg_traceline);

  /*
   * Call the IOR method through the EPV.
   */

  (*(_ior->d_epv->f_addLine))(
    _ior,
    _tmp_traceline);

  /*
   * Postprocess OUT, INOUT, returns, and exceptions.
   */

  sidl_String_free(_tmp_traceline);
}

/*
 * Formats and adds an entry to the stack trace based on the 
 * file name, line number, and method name.
 */

static void
jni_add(
  JNIEnv* env,
  jobject obj,
  jstring _arg_filename,
  jint _arg_lineno,
  jstring _arg_methodname)
{
  /*
   * Declare return and temporary variables.
   */

  struct sidl_SIDLException__object* _ior = NULL;
  char* _tmp_filename = (char*) NULL;
  int32_t _tmp_lineno = 0;
  char* _tmp_methodname = (char*) NULL;

  /*
   * Preprocess Java types and convert into IOR.
   */

  _ior = _get_ior(env, obj);
  _tmp_filename = sidl_Java_J2I_string(env, _arg_filename);
  _tmp_lineno = (int32_t) _arg_lineno;
  _tmp_methodname = sidl_Java_J2I_string(env, _arg_methodname);

  /*
   * Call the IOR method through the EPV.
   */

  (*(_ior->d_epv->f_add))(
    _ior,
    _tmp_filename,
    _tmp_lineno,
    _tmp_methodname);

  /*
   * Postprocess OUT, INOUT, returns, and exceptions.
   */

  sidl_String_free(_tmp_filename);
  sidl_String_free(_tmp_methodname);
}

/*
 * Register JNI methods with the Java JVM.
 */

void sidl_SIDLException__register(JNIEnv* env)
{
  JNINativeMethod methods[6];
  jclass cls;

  s_external = sidl_SIDLException__externals();
  methods[0].name      = "_create_ior";
  methods[0].signature = "()J";
  methods[0].fnPtr     = (void *)jni__create_ior;
  methods[1].name      = "getNote";
  methods[1].signature = "()Ljava/lang/String;";
  methods[1].fnPtr     = (void *)jni_getNote;
  methods[2].name      = "setNote";
  methods[2].signature = "(Ljava/lang/String;)V";
  methods[2].fnPtr     = (void *)jni_setNote;
  methods[3].name      = "getTrace";
  methods[3].signature = "()Ljava/lang/String;";
  methods[3].fnPtr     = (void *)jni_getTrace;
  methods[4].name      = "add";
  methods[4].signature = "(Ljava/lang/String;)V";
  methods[4].fnPtr     = (void *)jni_addLine;
  methods[5].name      = "add";
  methods[5].signature = "(Ljava/lang/String;ILjava/lang/String;)V";
  methods[5].fnPtr     = (void *)jni_add;


  cls = (*env)->FindClass(env, "sidl/SIDLException");
  if (cls) {
    (*env)->RegisterNatives(env, cls, methods, 6);
    (*env)->DeleteLocalRef(env, cls);
  }
}
