/* Generated By:JavaCC: Do not edit this line. Parser.java */
// Copyright (c) 1998-2004, The Regents of the University of Calfornia.
// Produced at the Lawrence Livermore National Laboratory.
// Written by the Components Team <components@llnl.gov>
// UCRL-CODE-2002-054
// All rights reserved.
// 
// This file is part of Babel. For more information, see
// http://www.llnl.gov/CASC/components/. Please read the COPYRIGHT file
// for Our Notice and the LICENSE file for the GNU Lesser General Public
// License.
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU Lesser General Public License (as published by
// the Free Software Foundation) version 2.1 dated February 1999.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the IMPLIED WARRANTY OF
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the terms and
// conditions of the GNU Lesser General Public License for more details.
// 
// You should have recieved a copy of the GNU Lesser General Public License
// along with this program; if not, write to the Free Software Foundation,
// Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

package gov.llnl.babel.parsers.sidl;

import gov.llnl.babel.BabelConfiguration;
import gov.llnl.babel.backend.Configuration;
import gov.llnl.babel.parsers.sidl.Grammar;
import gov.llnl.babel.parsers.sidl.GrammarException;
import gov.llnl.babel.parsers.sidl.ParseException;
import gov.llnl.babel.parsers.sidl.ParserConstants;
import gov.llnl.babel.parsers.sidl.SIDLException;
import gov.llnl.babel.parsers.sidl.SymbolException;
import gov.llnl.babel.parsers.sidl.Token;
import gov.llnl.babel.symbols.Argument;
import gov.llnl.babel.symbols.Assertion;
import gov.llnl.babel.symbols.AssertionException;
import gov.llnl.babel.symbols.AssertionExpression;
import gov.llnl.babel.symbols.BinaryExpression;
import gov.llnl.babel.symbols.BooleanLiteral;
import gov.llnl.babel.symbols.CharacterLiteral;
import gov.llnl.babel.symbols.Class;
import gov.llnl.babel.symbols.Comment;
import gov.llnl.babel.symbols.DComplexLiteral;
import gov.llnl.babel.symbols.DoubleLiteral;
import gov.llnl.babel.symbols.Enumeration;
import gov.llnl.babel.symbols.Extendable;
import gov.llnl.babel.symbols.FComplexLiteral;
import gov.llnl.babel.symbols.FloatLiteral;
import gov.llnl.babel.symbols.IdentifierLiteral;
import gov.llnl.babel.symbols.IntegerLiteral;
import gov.llnl.babel.symbols.Interface;
import gov.llnl.babel.symbols.LongLiteral;
import gov.llnl.babel.symbols.Method;
import gov.llnl.babel.symbols.MethodCall;
import gov.llnl.babel.symbols.Package;
import gov.llnl.babel.symbols.StringLiteral;
import gov.llnl.babel.symbols.Symbol;
import gov.llnl.babel.symbols.SymbolID;
import gov.llnl.babel.symbols.SymbolNotFoundException;
import gov.llnl.babel.symbols.SymbolRedefinitionException;
import gov.llnl.babel.symbols.SymbolTable;
import gov.llnl.babel.symbols.SymbolUtilities;
import gov.llnl.babel.symbols.Type;
import gov.llnl.babel.symbols.UnaryExpression;
import gov.llnl.babel.symbols.Version;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.Vector;

/**
 * The <code>Parser</code> class is automatically generated by the
 * <code>JavaCC</code> compiler.  The primary public method in the
 * parser is <code>beginParse</code>, which parses the SIDL code in
 * the input stream set in the parser constructor.  The other public
 * methods are <code>setSourceURL</code>, which sets the name associated
 * with the input stream, and <code>setMetadata</code>, which stores
 * metadata to be associated with symbols created from this input
 * file.
 */
public class Parser implements ParserConstants {
   private Stack      d_arg_stack;
   private HashSet    d_forward_refs;
   private Stack      d_grammar;
   private ArrayList  d_imports;
   private HashMap    d_metadata;
   private HashMap    d_reserved_words;
   private ArrayList  d_scope;
   private String     d_source_url;
   private HashSet    d_unused_imports;
   private HashSet    d_unused_versions;
   private HashMap    d_versions;
   private ArrayList  d_warnings;
   private LinkedList d_parent_stack;

   private final static String SCOPE = ".";

   private final static String EOL = "\n";

   private final static int MAX_ARRAY_DIM = 7;

   private final static String SIDL_CLASS        =
        BabelConfiguration.getBaseClass();
   private final static String SIDL_INTERFACE    =
        BabelConfiguration.getBaseInterface();
   private final static String SIDL_THROWS_CLASS     =
        BabelConfiguration.getBaseExceptionClass();
   private final static String SIDL_THROWS_INTERFACE =
        BabelConfiguration.getBaseExceptionInterface();

   /**
    * Set the source URL name.  If the source URL is not set, then
    * it is "file:unknown.sidl".
    */
   public void setSourceURL(String url) {
      d_source_url = url;
   }

   /**
    * Add metadata to be associated with symbols generated during the
    * parse of this input stream.  By default, the parser creates metadata
    * associated with the source file (keyword "source-url"), compiler
    * version (keyword "babel-version"), and source line number of the
    * symbol definition (keyword "source-line").
    */
   public void addMetadata(String key, String value) {
      if (d_metadata == null) {
         d_metadata = new HashMap();
      }
      d_metadata.put(key, value);
   }

   /**
    * Begin parsing and analysis of the SIDL grammar.  All of the exceptions
    * generated during the parse are subclasses of <code>SIDLException</code>.
    * The symbols generated during the parse are returned in the symbol table.
    * Any warnings generated during the parse are returned through the string
    * array return argument (or null if there were no warnings).
    */
   public String[] beginParse() throws SIDLException {
      d_arg_stack       = new Stack();
      d_forward_refs    = new HashSet();
      d_grammar         = new Stack();
      d_imports         = new ArrayList();
      d_reserved_words  = new HashMap();
      d_scope           = new ArrayList();
      d_unused_imports  = new HashSet();
      d_unused_versions = new HashSet();
      d_versions        = new HashMap();
      d_warnings        = new ArrayList();
      d_parent_stack    = new LinkedList();

      generateReservedWords();

      if (d_metadata == null) {
         d_metadata = new HashMap();
      }
      if (d_source_url == null) {
         d_source_url = "file:unknown.sidl";
      }

      String[] warnings = null;
      try {
         Specification();
         warnings = generateWarnings();
      } catch (ParseException ex) {
         generateGrammarException(ex);
      } finally {
         d_arg_stack       = null;
         d_forward_refs    = null;
         d_grammar         = null;
         d_imports         = null;
         d_metadata        = null;
         d_reserved_words  = null;
         d_scope           = null;
         d_unused_imports  = null;
         d_unused_versions = null;
         d_versions        = null;
         d_warnings        = null;
         d_parent_stack    = null;
      }

      return warnings;
   }

   /**
    * Generate a <code>GrammarException</code> from the information in
    * the <code>ParseException</code> class.
    */
   private void generateGrammarException(ParseException ex)
      throws GrammarException
   {
      Integer state = (Integer) d_grammar.peek();
      throw new GrammarException(ex, state.intValue());
   }

   /**
    * Generate a <code>SymbolException</code> from the information in
    * the message and the current parsing token.
    */
   private void generateSymbolException(String message)
      throws SymbolException
   {
      Integer state = (Integer) d_grammar.peek();
      throw new SymbolException(token, state.intValue(), message);
   }

   /**
    * Generate the list of reserved words that are not allowed as identifiers
    * in the SIDL input file.
    *
    * Note that, at this time, there are no reserved words for Fortran since
    * it is not clear if there are any.
    */
   private void generateReservedWords() {
      d_reserved_words.put("abstract",         "Java");
      d_reserved_words.put("and",              "C++ and Python");
      d_reserved_words.put("and_eq",           "C++");
      d_reserved_words.put("asm",              "C and C++");
      d_reserved_words.put("assert",           "Java and Python");
      d_reserved_words.put("auto",             "C and C++");
      d_reserved_words.put("bitand",           "C++");
      d_reserved_words.put("bitor",            "C++");
      d_reserved_words.put("bool",             "C++");
      d_reserved_words.put("boolean",          "Java");
      d_reserved_words.put("break",            "C, C++, Java, and Python");
      d_reserved_words.put("case",             "C, C++, and Java");
      d_reserved_words.put("catch",            "C++ and Java");
      d_reserved_words.put("char",             "C, C++, and Java");
      d_reserved_words.put("class",            "C++ and Java");
      d_reserved_words.put("compl",            "C++");
      d_reserved_words.put("const",            "C, C++, and Java");
      d_reserved_words.put("const_cast",       "C++");
      d_reserved_words.put("continue",         "C, C++, Java, and Python");
      d_reserved_words.put("def",              "Python");
      d_reserved_words.put("default",          "C, C++, and Java");
      d_reserved_words.put("del",              "Python");
      d_reserved_words.put("delete",           "C++");
      d_reserved_words.put("do",               "C, C++, and Java");
      d_reserved_words.put("double",           "C, C++, and Java");
      d_reserved_words.put("dynamic_cast",     "C++");
      d_reserved_words.put("elif",             "Python");
      d_reserved_words.put("else",             "C, C++, Java, and Python");
      d_reserved_words.put("enum",             "C, C++, and Java");
      d_reserved_words.put("except",           "Python");
      d_reserved_words.put("exec",             "Python");
      d_reserved_words.put("explicit",         "C++");
      d_reserved_words.put("export",           "C++");
      d_reserved_words.put("extends",          "Java");
      d_reserved_words.put("extern",           "C and C++");
      d_reserved_words.put("false",            "C++ and Java");
      d_reserved_words.put("final",            "Java");
      d_reserved_words.put("finally",          "Java and Python");
      d_reserved_words.put("float",            "C, C++, and Java");
      d_reserved_words.put("for",              "C, C++, Java, and Python");
      d_reserved_words.put("friend",           "C++");
      d_reserved_words.put("from",             "Python");
      d_reserved_words.put("global",           "Python");
      d_reserved_words.put("goto",             "C, C++, and Java");
      d_reserved_words.put("if",               "C, C++, Java, and Python");
      d_reserved_words.put("implements",       "Java");
      d_reserved_words.put("import",           "Java");
      d_reserved_words.put("inline",           "C++");
      d_reserved_words.put("instanceof",       "Java");
      d_reserved_words.put("int",              "C, C++, and Java");
      d_reserved_words.put("interface",        "Java");
      d_reserved_words.put("is",               "Python");
      d_reserved_words.put("lambda",           "Python");
      d_reserved_words.put("long",             "C, C++, and Java");
      d_reserved_words.put("mutable",          "C++");
      d_reserved_words.put("namespace",        "C++");
      d_reserved_words.put("native",           "Java");
      d_reserved_words.put("new",              "C++ and Java");
      d_reserved_words.put("not",              "C++ and Python");
      d_reserved_words.put("not_eq",           "C++");
      d_reserved_words.put("null",             "Java");
      d_reserved_words.put("operator",         "C++");
      d_reserved_words.put("or",               "C++ and Python");
      d_reserved_words.put("or_eq",            "C++");
      d_reserved_words.put("package",          "Java");
      d_reserved_words.put("pass",             "Python");
      d_reserved_words.put("print",            "Python");
      d_reserved_words.put("private",          "C++ and Java");
      d_reserved_words.put("protected",        "C++ and Java");
      d_reserved_words.put("public",           "C++ and Java");
      d_reserved_words.put("raise",            "Python");
      d_reserved_words.put("register",         "C and C++");
      d_reserved_words.put("reinterpret_cast", "C++");
      d_reserved_words.put("return",           "C, C++, Java, and Python");
      d_reserved_words.put("self",             "SIDL backends");
      d_reserved_words.put("short",            "C, C++, and Java");
      d_reserved_words.put("signed",           "C and C++");
      d_reserved_words.put("sizeof",           "C and C++");
      d_reserved_words.put("static",           "C, C++, and Java");
      d_reserved_words.put("static_cast",      "C++");
      d_reserved_words.put("strictfp",         "Java");
      d_reserved_words.put("struct",           "C and C++");
      d_reserved_words.put("super",            "Java");
      d_reserved_words.put("switch",           "C, C++, and Java");
      d_reserved_words.put("synchronized",     "Java");
      d_reserved_words.put("template",         "C++");
      d_reserved_words.put("this",             "C++ and Java");
      d_reserved_words.put("throw",            "C++ and Java");
      d_reserved_words.put("throws",           "Java");
      d_reserved_words.put("transient",        "Java");
      d_reserved_words.put("true",             "C++ and Java");
      d_reserved_words.put("try",              "C++, Java, and Python");
      d_reserved_words.put("typedef",          "C and C++");
      d_reserved_words.put("typeid",           "C++");
      d_reserved_words.put("typename",         "C++");
      d_reserved_words.put("union",            "C and C++");
      d_reserved_words.put("unsigned",         "C and C++");
      d_reserved_words.put("using",            "C++");
      d_reserved_words.put("virtual",          "C++");
      d_reserved_words.put("void",             "C, C++, and Java");
      d_reserved_words.put("volatile",         "C, C++, and Java");
      d_reserved_words.put("wchar_t",          "C++");
      d_reserved_words.put("while",            "C, C++, Java, and Python");
      d_reserved_words.put("xor",              "C++");
      d_reserved_words.put("xor_eq",           "C++");
   }

   /**
    * Verify that the specified identifier is not on the list of reserved
    * words.  If it is, then generate a symbol exception.
    */
   private void verifyReservedWords(String id) throws SymbolException {
     final String pre = "Parser.verifyReservedWords: ";
      String lang = (String) d_reserved_words.get(id);
      if (lang != null) {
         generateSymbolException(pre + "Illegal identifier \"" + id
           + "\" is a reserved word in " + lang + ".");
      }
   }

   /**
    * Generate a warning message if a method name (short or extended)
    * exceeds thirty one characters in length.
    */
   private void checkMethodNameLength(String shortname, String extension,
                                      Token tok)
   {
     final String pre = "Parser.checkMethodNameLength: ";
     final int extLen = ((extension != null) ? extension.length() : 0);
     if ((shortname.length() + ((extension != null) ? extension.length() : 0))
         > 31) {
       generateWarning(pre + "Method \"" + shortname
         + ((extension != null) ? ("[" + extension + "]") : "")
         + "\" at line(s) " + tok.beginLine + ":" + tok.endLine
         + " is longer than 31 characters. This will require name mangling "
         + "in FORTRAN 90/95 and potentially C.");
     }
   }

   /**
    * Set the metadata associated with this new symbol.
    */
   private void setMetadataValues(Symbol sym) {
      sym.addMetadata("babel-version", gov.llnl.babel.Version.VERSION);
      sym.addMetadata("source-url",    d_source_url);
      sym.addMetadata("source-line",   String.valueOf(token.beginLine));

      for (Iterator i = d_metadata.entrySet().iterator(); i.hasNext(); ) {
         Map.Entry e = (Map.Entry) i.next();
         sym.addMetadata((String) e.getKey(), (String) e.getValue());
      }
   }

   /**
    * Add the specified warning string to the array of parser warnings.
    */
   private void generateWarning(String warning) {
      d_warnings.add(warning);
   }

   /**
    * Return a string array of the warnings generated during the parse.
    */
   private String[] generateWarnings() {
      String[] warnings = null;

      int n = d_warnings.size();
      if (n > 0) {
         warnings = new String[n];
         for (int i = 0; i < n; i++) {
            warnings[i] = (String) d_warnings.get(i);
         }
      }

      return warnings;
   }

   /**
    * Push the specified grammar production on top of the current production
    * stack.  The stack must be popped when the parser leaves the production.
    */
   private void pushGrammarProduction(int production) {
      d_grammar.push(new Integer(production));
   }

   /**
    * Pop the grammar production.  This method must be called when leaving
    * a grammar production scope to match the appropriate push call.
    */
   private void popGrammarProduction() {
      d_grammar.pop();
   }

   /**
    * Enter the specified naming scope, which will be used to resolve
    * symbol names.
    */
   private void enterScope(String scope) {
      d_scope.add(scope);
   }

  /**
   * If the argument is a Package, return it; otherwise, throw a
   * SymbolRedefinitionException because there is a package with the same name
   * as something else.
   */
  private static Package toPackage(Symbol sym, SymbolID newID)
     throws SymbolRedefinitionException
  {
    Package p = null;
    if (sym != null) {
      if (sym instanceof Package) {
        p = (Package)sym;
      } else {
        throw new SymbolRedefinitionException(newID, sym.getSymbolID());
      }
    }
    return p;
  }

   /**
    * Leave the outer-most naming scope by removing the top of the scope
    * stack.
    */
   private void leaveScope() {
      d_scope.remove(d_scope.size()-1);
   }

   /**
    * Return the current scope as a string.  If no scope has been defined,
    * then return an empty string.
    */
   private String getScope() {
      int s = d_scope.size();
      return (s == 0 ? "" : (String) d_scope.get(s-1));
   }

   /**
    * Return the argument symbol name prepended with the current scope.
    */
   private String getScope(String name) {
      int s = d_scope.size();
      return (s == 0 ? name : ((String) d_scope.get(s-1)) + SCOPE + name);
   }

   /**
    * Generate a comment object for a documentation comment.  If a special
    * token is present in the input stream, then read special tokens until
    * a "start of comment" special token is found.
    */
   private Comment generateComment(Token t) {
      String[] comment_lines = null;

      Token special = t.specialToken;
      if (special != null) {

         /*
          * Count the number of comment lines by iterating through tokens.
          */
         int lines = 0;
         while (special.kind != ParserConstants.T_COMMENT) {
            lines++;
            special = special.specialToken;
         }

         /*
          * Allocate the string array and read comments in reverse order.
          */
         if (lines > 0) {
            comment_lines = new String[lines];
            special = t.specialToken;
            while (special.kind != ParserConstants.T_COMMENT) {
               comment_lines[--lines] = special.image;
               special = special.specialToken;
            }
         }
      }

      return new Comment(comment_lines);
   }

   /**
    * Add a fully qualified symbol name to the list of forward references.
    */
   private void addForwardReference(String fqn) {
      d_forward_refs.add(fqn);
   }

   /**
    * Remove a fully qualified symbol name from the list of forward
    * references.
    */
   private void removeForwardReference(String fqn) {
      d_forward_refs.remove(fqn);
   }

   /**
    * Verify that there are no remaining forward references and that all
    * have been defined.  If any forward references remain, then throw a
    * <code>SymbolException</code>.
    */
   private void verifyForwardReferences() throws SymbolException {
      final String pre = "Parser.verifyForwardReferences: ";
      for (Iterator i = d_forward_refs.iterator(); i.hasNext(); ) {
         generateSymbolException(pre + "Symbol name \"" + (String) i.next()
           + "\" not found or defined within package.");
      }
   }

   /**
    * Verify that the specified fully qualified symbol name is not a
    * forward reference.  Package names and enumerated types are not
    * allowed as forward references.  If the specified symbol is a
    * forward reference, then throw a <code>SymbolException</code>.
    */
   private void verifyNotForwardReference(String fqn) throws SymbolException {
      final String pre = "Parser.verifyNotForwardReference: ";
      if (d_forward_refs.contains(fqn)) {
         generateSymbolException(pre + "Forward reference \"" + fqn
           + "\" cannot be used as a package or enumerated type.");
      }
   }

   /**
    * Lookup the version for the specified fully qualified name.  If no
    * version exists, then return a null.
    */
   private Version lookupVersion(String fqn) {
     SymbolTable table = SymbolTable.getInstance();
     Version version = null;
     while ((fqn != null) && (version == null)) {
       version = (Version)d_versions.get(fqn);
       if (version == null) {
         Symbol sym = table.lookupSymbol(fqn);
         if (sym != null) {
           version = sym.getSymbolID().getVersion();
         } else {
           fqn = SymbolUtilities.getParentPackage(fqn);
         }
       } else {
         d_unused_versions.remove(fqn);
       }
     }
     return version;
   }

   /**
    * Generate a symbol exception if a version default has already been
    * specified for the package.
    */
   private void verifyVersionNotDefined(String name) throws SymbolException {
      final String pre = "Parser.verifyVersionNotDefined: ";
      if (d_versions.keySet().contains(name)) {
         generateSymbolException(pre + "Redefinition of version for package \""
           + name + "\".");
      }
   }

   /**
    * Add a new (package name, version) entry into the version hash table.
    * Also add a copy to the unused version hash set.
    */
   private void addPackageVersion(String name, Version version) {
      d_versions.put(name, version);
      d_unused_versions.add(name);
   }

   /**
    * Generate version warnings for every version entry not used to resolve
    * a symbol during the parse.
    */
   private void generateVersionWarnings() {
      final String pre = "Parser.generateVersionWarnings: ";
      for (Iterator i = d_unused_versions.iterator(); i.hasNext(); ) {
         String name = (String) i.next();
         generateWarning(pre + "Package \"" + name + "-v"
           + ((Version)d_versions.get(name)).getVersionString()
           + "\" was not used to resolve any symbols.");
      }
   }

   /**
    * Generate a symbol exception if a particular package has already been
    * included in an import statement.
    */
   private void verifyImportNotDefined(String fqn) throws SymbolException {
      final String pre = "Parser.verifyImportNotDefined: ";
      if (d_imports.contains(fqn)) {
         generateSymbolException(pre + "Redefinition of import for package \""
           + fqn + "\".");
      }
   }

   /**
    * Add a new package at the end of the package search list.  Also add a
    * copy to the unused import hash set.  Package import statements not used
    * to resolve a symbol will generate warnings at the end of the parse.
    */
   private void addToImportPath(String fqn) {
      d_imports.add(fqn);
      d_unused_imports.add(fqn);
   }

   /**
    * Mark the specified import as being used to resolve a symbol.  Unused
    * import packages will generate warnings at the end of the parse.
    */
   private void usedImportToResolveSymbol(String fqn) {
      d_unused_imports.remove(fqn);
   }

   /**
    * Generate import warnings for every import package not used to resolve
    * a symbol during the parse.
    */
   private void generateImportWarnings() {
      final String pre = "Parser.generateImportWarnings: ";
      for (Iterator i = d_unused_imports.iterator(); i.hasNext(); ) {
         generateWarning(pre + "Import statement for package \""
           + (String) i.next() + "\" not used to resolve any symbols.");
      }
   }

   /**
    * Try to resolve a symbol in the symbol table by fully qualified name.
    * If the symbol cannot be found, then return null; otherwise, return
    * the symbol.  If the symbol is a duplicate of an existing symbol in
    * the table with a different version, then return a symbol exception.
    * When we load this symbol into the symbol table, then load all of its
    * dependencies.
    */
   private Symbol tryResolveFQN(String fqn) throws SymbolException {
      final String pre = "Parser.tryResolveFQN: ";
      Symbol sym = null;

      Version version = lookupVersion(fqn);
      if (version == null) {
         sym = SymbolTable.getInstance().resolveSymbol(fqn);
      } else {
         try {
            SymbolID id = new SymbolID(fqn, version);
            sym = SymbolTable.getInstance().resolveSymbol(id);
         } catch (SymbolRedefinitionException ex) {
            generateSymbolException(pre + ex.getMessage());
         }
      }

      if (sym != null) {
         try {
            Set refs = sym.getSymbolReferences();
            SymbolTable.getInstance().generateDependencies(refs);
         } catch (SymbolRedefinitionException ex) {
            generateSymbolException(pre + ex.getMessage());
         } catch (SymbolNotFoundException ex) {
            // ignore - forward references not resolved yet...
         }
      }

      return sym;
   }

   /**
    * Resolve a symbol in the symbol table by fully qualified name.  If the
    * symbol does not exist or is a duplicate of another symbol with another
    * version, then throw a <code>SymbolException</code>.
    */
   private Symbol resolveFQN(String fqn) throws SymbolException {
      final String pre = "Parser.resolveFQN: ";
      Symbol sym = tryResolveFQN(fqn);
      if (sym == null) {
         Version v = lookupVersion(fqn);
         String  s = (v == null ? fqn : fqn + "-v" + v.getVersionString());
         generateSymbolException(pre + "Symbol \"" + s + "\" not found.");
      }
      return(sym);
   }

   /**
    * Try to resolve a symbol in the symbol table by searching through
    * the scopes and default import paths.  If ths symbol is not found,
    * then return null.  If a symbol exists in the symbol table with the
    * same name but different version, then throw a symbol exception.
    */
   private Symbol tryResolveSymbol(String name) throws SymbolException {
      Symbol sym = tryResolveFQN(name);

      for (int s = d_scope.size()-1; (s >= 0) && (sym == null); s--) {
         sym = tryResolveFQN(((String) d_scope.get(s)) + SCOPE + name);
      }

      int n = d_imports.size();
      for (int s = 0; (s < n) && (sym == null); s++) {
         String prefix = (String) d_imports.get(s);
         sym = tryResolveFQN(prefix + SCOPE + name);
         if (sym != null) {
            usedImportToResolveSymbol(prefix);
         }
      }

      return sym;
   }

   /**
    * Resolve a symbol in the symbol table by searching through the scopes
    * and default import paths.  If the symbol is not found, then throw a
    * <code>SymbolException</code>.  Otherwise, return the symbol object.
    */
   private Symbol resolveSymbol(String name) throws SymbolException {
      final String pre = "Parser.resolveSymbol: ";
      Symbol sym = tryResolveSymbol(name);
      if (sym == null) {
         generateSymbolException(pre + "Symbol \"" + name + "\" not found.");
      }
      return sym;
   }

   /**
    * Verify that the specified symbol exists and is a package.  If not,
    * then throw a <code>SymbolException</code>.
    */
   private void verifyImportIsPackage(String fqn) throws SymbolException {
      final String pre = "Parser.verifyImportIsPackage: ";
      Symbol sym = resolveFQN(fqn);
      if (sym.getSymbolType() != Symbol.PACKAGE) {
         generateSymbolException(pre + "Symbol \""
           + sym.getSymbolID().getSymbolName() + "\" is not a package.");
      }
   }

   /**
    * Verify that the specified fully qualified symbol has a version
    * associated with it and has not been already defined.  These checks
    * are required before defining any new symbol.  If the version for
    * this symbol has not been defined or if the symbol has already been
    * defined, a <code>SymbolException</code> is thrown.
    */
   private void verifySymbolCanBeDefined(SymbolID id) throws SymbolException {
      final String pre = "Parser.verifySymbolCanBeDefined: ";
      Version version = id.getVersion();
      if ((version == null) || version.isUnspecified()) {
         generateSymbolException(pre + "No version specified for the "
           + "definition of symbol \"" + id.getSymbolName() + "\".\nClasses "
           + "and interfaces cannot be defined in an unversioned package.");
      }

      try {
        Symbol sym = SymbolTable.getInstance().resolveSymbol(id);
        if (sym != null) {
          // Check if symbol is builtin, then check whether version matches
          SymbolID xid = sym.getSymbolID();
          boolean builtin = Configuration.getInstance().isBuiltinSymbol(
                                               sym.getSymbolID().getFullName());
          if (! builtin ) {
            // If the current symbol is not builtin, and target language is not
            // xml OR the input is not a SIDL package (e.g., a sidl file),
            // then throw a symbol redefintion exception, otherwise issue a 
            // warning.
            if (  xid.getSymbolName().equals(id.getSymbolName())
               && sym.getMetadata().getMetadataValue("source-url").equals(
                                                                   d_source_url)
               && BabelConfiguration.getInstance().getTargetLanguage().equals(
                                                                        "xml") )
            {
              // If generating xml, we can be reasonably sure the user 
              // means to overwrite the symbol.  In all other cases, issue 
              // a warning.
              generateWarning(pre + "Symbol \"" + xid.getSymbolName()
                + "\"exists in XML repository.");
            } else {
              generateSymbolException(pre + "Redefinition of symbol \""
                + sym.getSymbolID().getSymbolName() + "\".");
            }
          } else {
            generateSymbolException(pre + "Redefinition of symbol \""
              + sym.getSymbolID().getSymbolName() + "\".");
          }
        }
      } catch (SymbolRedefinitionException sre) {
        generateSymbolException(pre + sre.getMessage());
      }
   }

   /**
    * Add a symbol to its parent package.  This will involve creating the
    * parent package, looking up its name, and then adding the child to the
    * package.  If the symbol is a root-level package (that is, does not
    * contain a SCOPE "."), then do nothing.  Throw an exception if the
    * package is marked as read-only (e.g., was brought in from a repository
    * and may not be changed).  Mark the parent package as modified.
    */
   private void addSymbolToParentPackage(Package parent, SymbolID id, int type)
      throws SymbolException
   {
      final String pre = "Parser.addSymbolToParentPackage: ";
      if (parent != null) {
         if (parent.getSymbolType() != Symbol.PACKAGE) {
            generateSymbolException(pre + "Symbol \""
              + parent.getSymbolID().getSymbolName() + "\" is not a package.");
         }
         if (parent.getFinal()) {
            generateSymbolException(pre + "Cannot modify final package \""
              + parent.getSymbolID().getSymbolName() + "\".");
         }
         parent.addSymbol(id, type);
         SymbolTable.getInstance().markSymbolAsModified(parent.getSymbolID());
      }
   }

   /*
    * Verify that the copy modifier is set properly for an argument.  The
    * copy modifier is only valid for a symbol type that is an interface or
    * a class.  If the symbol is a forward reference, then we know that it
    * must be an interface or a class.  We know that if the type is a symbol,
    * then it must be in the symbol table or exist as a forward reference.
    */
   private void verifyCopyModifierValid(Type type) throws SymbolException {
      final String pre = "Parser.verifyCopyModifierValid: ";
      if (type.getType() != Type.SYMBOL) {
         generateSymbolException(pre + "Modifier \"copy\" is only valid for "
           + "interfaces and classes.");
      } else {
         SymbolID id = type.getSymbolID();
         Symbol symbol = SymbolTable.getInstance().lookupSymbol(id);
         if ((symbol != null) && (symbol.getSymbolType() == Symbol.ENUM)) {
            generateSymbolException(pre + "Modifier \"copy\" is not allowed "
              + "for enumerated types.");
         }
      }
   }

   /**
    * Verify that the oneway modifier is valid for this method.  The oneway
    * modifier may not be used on any method that has an inout or out argument
    * or returns a value.  If any of these conditions are violated, then an
    * exception is thrown.
    */
   private void verifyOnewayValid(Method m) throws SymbolException {
      final String pre = "Parser.verifyOnewayValid: ";
      if (m.getReturnType() != null) {
         generateSymbolException(pre + "Modifier \"oneway\" invalid for methods"
           + " that return values.");
      }
      ArrayList args = m.getArgumentList();
      for (int i = 0; i < args.size(); i++) {
         Argument arg = (Argument) args.get(i);
         if (arg.getMode() != Argument.IN) {
            generateSymbolException(pre + "Modifier \"oneway\" invalid for "
              + "methods with inout and out arguments.");
         }
      }
   }

   /**
    * Verify that the specified scoped identifer is valid in a throws
    * clause and that it does not already exist in the throws list.
    * If the identifier is valid, then add it to the throws supported
    * by the method.  A throws clause is invalid with a oneway modifier.
    * Any classes in the throws clause must extend the base SIDL throwable
    * class (unless, of course, it is the base SIDL throwable class).
    */
   private void verifyAndAddThrows(Method m, String identifier)
      throws SymbolException
   {
      final String pre = "Parser.verifyAndAddThrows: ";
      if (m.getCommunicationModifier() == Method.ONEWAY) {
         generateSymbolException(pre + "Modifier \"oneway\" invalid for "
           + "methods with a throws clause.");
      }

      Symbol symbol  = resolveSymbol(identifier);
      String symname = symbol.getFullName();
      if (m.getThrows().contains(symbol.getSymbolID())) {
         generateSymbolException(pre + "Class \"" + symbol.getFullName()
           + "\" already listed in throws clause.");
      }

      int       symtype      = symbol.getSymbolType();
      Interface throwableint = (Interface)resolveFQN(SIDL_THROWS_INTERFACE);
      SymbolID  isid         = throwableint.getSymbolID();
      if (symtype == Symbol.CLASS) {
        if (!SIDL_THROWS_CLASS.equals(symname)) {
           Class    symbolcls    = (Class) symbol;
           Class    throwablecls = (Class) resolveFQN(SIDL_THROWS_CLASS);
           SymbolID csid         = throwablecls.getSymbolID();
           if ( !(  symbolcls.hasParentClass(csid, true)
                 || symbolcls.hasParentInterface(isid, true) ) )
           {
              generateSymbolException(pre + "Class \"" + symname
                + "\" does not extend \"" + SIDL_THROWS_CLASS + "\""
                + " or implement \"" + SIDL_THROWS_INTERFACE + "\".");
           }
        }
      } else if (symtype == Symbol.INTERFACE) {
        if (!SIDL_THROWS_INTERFACE.equals(symname)) {
           Interface symbolint = (Interface)symbol;
           if ( !(symbolint.hasParentInterface(isid, true) ) ) {
              generateSymbolException(pre + "Interface \"" + symname
                + "\" does not extend \"" + SIDL_THROWS_INTERFACE + "\".");
           }
        }
      } else {
         generateSymbolException(pre + "Symbol \"" + symname
           + "\" must be a class or interface to be in a throws clause.");
      }

      m.addThrows(symbol.getSymbolID());
   }

   /**
    * Verify that the method does not already exist in the specified
    * extendable object (interface or class) with the same long name
    * or the same short name and base signature.  If one does exist, a 
    * method redefinition exception.
    */
   private void verifyMethodRedefinition(Extendable ext, Method m)
      throws SymbolException
   {
      final String pre = "Parser.verifyMethodRedefinition: ";
      /*
       * First check local method based on the long name since methods 
       * must be uniquely identified by their long names (due to languages
       * that do not support method overloading).
       */
      Method method = ext.lookupMethodByLongName(m.getLongMethodName(), false);
      if (method != null) {
         if (method.sameSignature(m)) {
            generateSymbolException(pre + "Method \"" + m.getSignature()
              + "\" has already been defined locally in \"" + ext.getFullName()
              + "\" with same signature.");
         } else {
            generateSymbolException(pre + "Method \"" + m.getSignature()
              + "\" conflicts with existing method \"" + method.getSignature()
              + "\" already defined locally in \"" + ext.getFullName() + "\".");
         }
      }

      /*
       * Now check to ensure no existing local methods with the same
       * short name and same base signature.
       */
      Collection methods = ext.lookupMethodByShortName(m.getShortMethodName(),
                                                       false);
      if (methods != null) {
         for (Iterator i = methods.iterator(); i.hasNext(); ) {
            method = (Method) i.next();
            if (method.sameBaseSignature(m)) {
               generateSymbolException(pre + "Method" + " \""
                 + m.getSignature() + "\" has already been defined locally in "
                 + "\"" + ext.getFullName() + "\" with the same short name and "
                 + "argument list.");
            }
         }
      }
   }

   /**
    * Verify that the new method may be added to the specified class.
    * Check that the method name is not the same as the class name and
    * that it does not conflict with the signature of any existing method.
    */
   private void verifyMethodSignature(Extendable ext, Method m, String definer)
      throws SymbolException
   {
      final String pre = "Parser.verifyMethodSignature: ";
      /*
       * Verify that the symbol name is not the same as the method
       * name (which would be a problem for C++ and Java since it
       * would be interpreted as a constructor).  We're going to 
       * disallow the same short _and_ long name at this time although,
       * technically, the above languages would only be concerned with
       * the short name.
       */
      if (ext.getSymbolID().getShortName().equals(m.getLongMethodName())) {
         generateSymbolException(pre + "Method \"" + m.getSignature()
           + "\" from \"" + definer + "\" cannot have same (long) name as \""
           + ext.getFullName() + "\".");
      }
      if (ext.getSymbolID().getShortName().equals(m.getShortMethodName())) {
         generateSymbolException(pre + "Method \"" + m.getSignature()
           + "\" from \"" + definer + "\" cannot have same (short) name as \""
           + ext.getFullName() + "\".");
      }

      /*
       * Check whether there is a signature conflict with any existing
       * methods in the parent class.
       */
      Method existing = ext.lookupMethodByLongName(m.getLongMethodName(), true);
      if ((existing != null) && (!m.sameSignature(existing))) {
         generateSymbolException(pre + "Signature conflict between method \""
           + m.getSignature() + "\" from \"" + definer + "\" and existing "
           + "ancestor method \"" + existing.getSignature() + "\".");
      }
   }

   /**
    * Verify that there is not a conflict due to static methods.  Neither
    * the new method nor any matching existing methods may be static, since
    * static methods cannot be re-defined.
    */
   private void verifyMethodStatic(Extendable ext, Method m, String definer)
      throws SymbolException
   {
      final String pre = "Parser.verifyMethodStatic: ";
      /*
       * First check to ensure no issues with static methods for 
       * existing/parent methods with the same long name.
       */
      Method existing = ext.lookupMethodByLongName(m.getLongMethodName(), true);
      if (existing != null) {
         if (m.isStatic()) {
            generateSymbolException(pre + "Static method \"" + m.getSignature()
              + "\" from \"" + definer + "\" cannot redefine existing ancestor "
              + "method with same long name.");
         }
         if (existing.isStatic()) {
            generateSymbolException(pre + "Method \"" + m.getSignature()
              + "\" from \"" + definer + "\" cannot redefine existing static "
              + "ancestor method with same long name.");
         }
      }

      /*
       * Now check to ensure no issues with static methods for existing/parent 
       * methods with the same short name and same base signature.
       */
      Collection methods = ext.lookupMethodByShortName(m.getShortMethodName(),
                                                       true);
      if (methods != null) {
         for (Iterator i = methods.iterator(); i.hasNext(); ) {
            existing = (Method) i.next();
            if (existing.sameBaseSignature(m)) {
               if (m.isStatic()) {
                  generateSymbolException(pre + "Static method \""
                    + m.getSignature() + "\" from \"" + definer
                    + "\" cannot redefine existing ancestor method with same "
                    + "short name and argument list.");
               }
               if (existing.isStatic()) {
                  generateSymbolException(pre + "Method \"" + m.getSignature()
                    + "\" from \"" + definer + "\" cannot redefine existing "
                    + "static ancestor method with the same short name and "
                    + "argument list.");
               }
            }
         }
      }
   }

   /**
    * Verify that the method may be added to the specified class.  There
    * is a conflict if a matching method currently exists and (a) the
    * existing method is final or (b) the new method is abstract but the
    * existing method is not abstract.
    */
   private void verifyMethodOverride(Class cls, Method m)
      throws SymbolException
   {
      final String pre = "Parser.verifyMethodOverride: ";
      /*
       * First check to make sure no conflicts with existing/parent method 
       * with same long name.
       */
      Method existing = cls.lookupMethodByLongName(m.getLongMethodName(), true);
      if (existing != null) {
         /*
          * If the existing method is final, then we cannot redefine it.
          */
         if (existing.isFinal()) {
            generateSymbolException(pre + "Method \"" + m.getSignature()
              + "\" cannot redefine existing final ancestor method \""
              + existing.getSignature() + "\" already defined in \""
              + cls.getFullName() + "\" with the same long method name.");
         }

         /*
          * If the existing method is not abstract, then the new method
          * cannot be abstract.
          */
         if (!existing.isAbstract() && m.isAbstract()) {
            generateSymbolException(pre + "Abstract method \""
              + m.getSignature()
              + "\" cannot redefine existing non-abstract ancestor method \""
              + existing.getSignature() + "\" already defined in \""
              + cls.getFullName() + "\".");
         }
      }

      /*
       * Now check to make sure no conflicts with existing/parent method 
       * with same short name and same base signature.
       */
      Collection methods = cls.lookupMethodByShortName(m.getShortMethodName(),
                                                       true);
      if (methods != null) {
         for (Iterator i = methods.iterator(); i.hasNext(); ) {
            existing = (Method) i.next();
            if (existing.sameBaseSignature(m)) {
               /*
                * If the existing method is final, then we cannot redefine it.
                */
               if (existing.isFinal()) {
                  generateSymbolException(pre + "Method \"" + m.getSignature()
                    + "\" cannot redefine existing final ancestor method \""
                    + existing.getSignature() + "\" already defined in \""
                    + cls.getFullName()
                    + "\" with the same short name and arguments.");
               }

               /*
                * If the existing method is not abstract, then the new method
                * cannot be abstract.
                */
               if (!existing.isAbstract() && m.isAbstract()) {
                  generateSymbolException(pre + "Abstract method \""
                    + m.getSignature() + "\" cannot redefine existing "
                    + "non-abstract ancestor method \""
                    + existing.getSignature() + "\" already defined in \""
                    + cls.getFullName() + "\".");
               }
            }
         }
      }
   }

   /**
    * Verify that the methods in the extending test class are compatible
    * with those in the existing class.  Since the existing class should
    * have no methods in it, we only need to do the basic signature test.
    */
   private void verifyClassInheritance(Class cls, Class test)
      throws SymbolException
   {
      final String pre = "Parser.verifyClassInheritance: ";
      /*
       * Verify that the two classes are different (OK to check that
       * the two object references point to the same object)
       */
      if (cls == test) {
         generateSymbolException(pre + "Class \"" + cls.getFullName()
           + "\" cannot extend itself.");
      }

      /*
       * Verify that each of the methods in the extending class do not have
       * the same name as the exiting interface.  Note that there should be
       * no methods in the class since class extension is done as the first
       * item in the construction of a class.
       */
      String test_name = test.getFullName();
      Iterator methods = test.getMethods(true).iterator();
      while (methods.hasNext()) {
         verifyMethodSignature(cls, (Method) methods.next(), test_name);
      }
   }

   /**
    * Verify that the methods in the new interface are compatible with
    * those in the existing extendable (class or interface).  If there
    * are any conflicts, then throw a symbol exception.  An interface
    * cannot inherit from itself.
    */
   private void verifyInterfaceInheritance(Extendable old, Interface test)
      throws SymbolException
   {
      final String pre = "Parser.verifyInterfaceInheritance: ";
      /*
       * Verify that the two interfaces are different (OK to check that
       * the two objects are the same)
       */
      if (old == ((Extendable) test)) {
         generateSymbolException(pre + "Interface \"" + old.getFullName()
           + "\" cannot inherit from itself.");
      }

      /*
       * Verify that each of the methods in the new interface (1) does not
       * have the same name as the existing interface, (2) does not conflict
       * with existing methods in signature, and (3) does not conflict with
       * an existing static method.
       */
      Iterator methods = test.getMethods(true).iterator();
      while (methods.hasNext()) {
         Method method = (Method) methods.next();
         String name = test.getFullName();
         verifyMethodSignature(old, method, name);
         verifyMethodStatic(old, method, name);
      }
   }

   /**
    * Verify that the abstract qualifier on the class matches whether the
    * class has any abstract methods.
    */
   private void verifyAbstract(Class cls, boolean ab) throws SymbolException {
      final String pre = "Parser.verifyAbstract: ";
      if (ab && !cls.isAbstract()) {
         generateSymbolException(pre + "Class \"" + cls.getFullName()
           + "\" declared abstract but contains no abstract methods.");
      }
      if (!ab && cls.isAbstract()) {
         StringBuffer msg = new StringBuffer();
         msg.append("Class \"");
         msg.append(cls.getFullName());
         msg.append("\" not declared abstract but has abstract method(s):");
         msg.append(EOL);
         Iterator m = cls.getAbstractMethods().iterator();
         while (m.hasNext()) {
            Method method = (Method) m.next();
            msg.append("   ");
            msg.append(method.getSignature());
            msg.append(EOL);
         }
         generateSymbolException(pre + msg.toString());
      }
   }

  /**
   * Return the name of the source associated with an assertion.  This 
   * will consist of the fully qualified name of the extendable plus, if a
   * method is specified, the long version of the method name.
   *
   * Assumes the extendable argument is not null.
   */
  private String getSourceName(Extendable ext, Method m) {
    String name = null;

    if (m == null) {
      name = ext.getFullName();
    } else {
      name = ext.getFullName() + SCOPE + m.getLongMethodName();
    }
    return name;
  }

  /**
   * Create as many binary expressions as necessary based on the specified
   * number of assertions on the stack and whether or not the op is on 
   * the stack.  If not, then use the specified op.
   */
  private void createBinaryExpressions(int numAsserts, boolean opOnStack,
                                       int op)
     throws SymbolException
  {
    final String pre = "Parser.createBinaryExpressions: ";
    while (numAsserts > 1) {
      AssertionExpression rhs = (AssertionExpression) d_arg_stack.pop();
      if (opOnStack) {
        op = ((Integer) d_arg_stack.pop()).intValue();
      }
      AssertionExpression lhs = (AssertionExpression) d_arg_stack.pop();
      try {
        BinaryExpression  be  = new BinaryExpression(lhs, op, rhs);
        d_arg_stack.push(be);
        /*
         * Decrement the counter based on whether the net number of 
         * of assertions expressions removed from the stack.  That is,
         * consider the fact that one expression was just added.
         */
        if (opOnStack) {
          numAsserts = numAsserts - 2;
        } else {
          numAsserts = numAsserts - 1;
        }
      } catch (AssertionException aex) {
        generateSymbolException(pre + aex.getMessage());
      }
    }
  }

/**
 * A SIDL Specification contains zero or more require productions followed
 * by zero or more import productions followed by zero or more package
 * productions followed by the end-of-file.  Before leaving the specification
 * scope, resolve all references in the symbol table.
 */
  final public void Specification() throws ParseException, SymbolException {
   pushGrammarProduction(Grammar.SPECIFICATION);
   final String pre = "Parser.Specification: ";
    label_1:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case T_REQUIRE:
        ;
        break;
      default:
        jj_la1[0] = jj_gen;
        break label_1;
      }
      Require();
    }
    label_2:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case T_IMPORT:
        ;
        break;
      default:
        jj_la1[1] = jj_gen;
        break label_2;
      }
      Import();
    }
    label_3:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case T_FINAL:
      case T_PACKAGE:
        ;
        break;
      default:
        jj_la1[2] = jj_gen;
        break label_3;
      }
      Package();
    }
    jj_consume_token(0);
      try {
         SymbolTable.getInstance().resolveAllReferences();
      } catch (SymbolNotFoundException ex) {
         generateSymbolException(pre + ex.getMessage());
      } catch (SymbolRedefinitionException ex) {
         generateSymbolException(pre + ex.getMessage());
      }
      verifyForwardReferences();
      generateVersionWarnings();
      generateImportWarnings();
      popGrammarProduction();
  }

/**
 * A SIDL Require production begins with a "require" token and is followed
 * by a scoped identifer, a "version" token, and a version number.  The 
 * scoped identifier must be not defined.  The version number is specified 
 * in the general form "V1.V2...Vn" where Vi is a non-negative integer.  
 */
  final public void Require() throws ParseException, SymbolException {
   pushGrammarProduction(Grammar.REQUIRE);
   final String pre = "Parser.Require: ";
    jj_consume_token(T_REQUIRE);
    ScopedIdentifier();
      String name = (String) d_arg_stack.pop();
      verifyVersionNotDefined(name);
    jj_consume_token(T_VERSION);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case T_VERSION_STRING:
      jj_consume_token(T_VERSION_STRING);
      break;
    case T_FLOAT_LIT:
      jj_consume_token(T_FLOAT_LIT);
      break;
    case T_UNSIGNED:
      jj_consume_token(T_UNSIGNED);
      break;
    default:
      jj_la1[3] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
      try {
         Version version = new Version(token.image);
         addPackageVersion(name, version);
      } catch (NumberFormatException ex) {
         generateSymbolException(pre + ex.getMessage());
      }
    jj_consume_token(T_SEMICOLON);
      popGrammarProduction();
  }

/**
 * A SIDL Import production begins with an "import" token and is followed
 * by a scoped identifier which is optionally followed by a "version" token
 * and a version number.  The scoped identifier must be defined and it must 
 * be a package.  The version number is specified in the general form 
 * "V1.V2...Vn" where Vi is a non-negative integer.  A particular package 
 * may only be included in one import statement.  The import package name 
 * is added to the default search path.  At the end of the parse, any import 
 * statements that were not used to resolve a symbol name are output as 
 * warnings.
 */
  final public void Import() throws ParseException, SymbolException {
   pushGrammarProduction(Grammar.IMPORT);
   final String pre = "Parser.Import: ";
   Version version = null;
    jj_consume_token(T_IMPORT);
    ScopedIdentifier();
      String fqn = (String) d_arg_stack.pop();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case T_VERSION:
      jj_consume_token(T_VERSION);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case T_VERSION_STRING:
        jj_consume_token(T_VERSION_STRING);
        break;
      case T_FLOAT_LIT:
        jj_consume_token(T_FLOAT_LIT);
        break;
      case T_UNSIGNED:
        jj_consume_token(T_UNSIGNED);
        break;
      default:
        jj_la1[4] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
       try {
         version = new Version(token.image);
       } catch (NumberFormatException nfe) {
         generateSymbolException(pre + nfe.getMessage());
       }
      break;
    default:
      jj_la1[5] = jj_gen;
      ;
    }
      if (version != null) {
        addPackageVersion(fqn, version);
      }
      verifyImportNotDefined(fqn);
      verifyImportIsPackage(fqn);
      addToImportPath(fqn);
    jj_consume_token(T_SEMICOLON);
      popGrammarProduction();
  }

/**
 * The SIDL package specification begins with a "package" token followed by
 * a scoped identifier.  The new package namespace begins with an open curly
 * brace, a set of zero or more definitions, and a close curly brace.  The
 * closing curly brace may be followed by an optional semicolon.  The package
 * identifier must have a version defined for it, and it must not have been
 * previously defined as a symbol or used as a forward reference.  The parent
 * of the package must itself be a package and must have been defined.  The
 * symbols within the curly braces will be defined within the package scope.
 */
  final public void Package() throws ParseException, SymbolException {
   pushGrammarProduction(Grammar.PACKAGE);
   final String pre = "Parser.Package: ";
   boolean declared_final = false;
   Package parent = d_parent_stack.isEmpty()
        ? null : (Package)d_parent_stack.getFirst();
   Version version = (parent != null)
        ? parent.getSymbolID().getVersion() : new Version();
   Package p = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case T_FINAL:
      jj_consume_token(T_FINAL);
     declared_final = true;
      break;
    default:
      jj_la1[6] = jj_gen;
      ;
    }
    jj_consume_token(T_PACKAGE);
     Comment comment = generateComment(token);
    ScopedIdentifier();
     String fqn = getScope((String) d_arg_stack.pop());
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case T_VERSION:
      jj_consume_token(T_VERSION);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case T_VERSION_STRING:
        jj_consume_token(T_VERSION_STRING);
        break;
      case T_FLOAT_LIT:
        jj_consume_token(T_FLOAT_LIT);
        break;
      case T_UNSIGNED:
        jj_consume_token(T_UNSIGNED);
        break;
      default:
        jj_la1[7] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
       try {
         version = new Version(token.image);
       } catch (NumberFormatException nfe) {
         generateSymbolException(pre + "VERSION: Bad version number \""
           + token.image + "\" for package " + fqn + ".");
       }
      break;
    default:
      jj_la1[8] = jj_gen;
      ;
    }
    try {
       verifyNotForwardReference(fqn); // packages cannot be forward references
       SymbolTable table = SymbolTable.getInstance();
       SymbolID id = null;
       id = new SymbolID(fqn, version);
       Symbol sym = table.resolveSymbol(id);
       p = toPackage(sym, id);
       if (p == null) {
         p = new Package(id, comment);
         p.setFinal(false); // it's not final until the curly brace closes
         p.setUserSpecified(true);
         setMetadataValues(p);
         table.putSymbol(p);
         addSymbolToParentPackage(parent, id, Symbol.PACKAGE);
       } else {
         if (p.getFinal()) { // attempt to add to non-reentrant package
           generateSymbolException(pre + "Attempt to reopen final package "
             + id.getFullName() + " version "
             + id.getVersion().getVersionString() + ".");
         } else {
           p.setComment(Comment.combineComments(p.getComment(), comment));
         }
       }
     } catch (SymbolRedefinitionException ex) {
       generateSymbolException(pre+ ex.getMessage());
     }

     enterScope(fqn);
     d_parent_stack.addFirst(p);
    jj_consume_token(T_OPEN_CURLY);
    label_4:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case T_ABSTRACT:
      case T_CLASS:
      case T_ENUM:
      case T_FINAL:
      case T_INTERFACE:
      case T_PACKAGE:
        ;
        break;
      default:
        jj_la1[9] = jj_gen;
        break label_4;
      }
      Definition();
    }
    jj_consume_token(T_CLOSE_CURLY);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case T_SEMICOLON:
      jj_consume_token(T_SEMICOLON);
      break;
    default:
      jj_la1[10] = jj_gen;
      ;
    }
     d_parent_stack.removeFirst();
     leaveScope();
     if (p != null) {
       p.setFinal(declared_final);
     }
  }

/**
 * A SIDL Definition production consists of a class, interface, enumerated
 * type, or package.
 */
  final public void Definition() throws ParseException, SymbolException {
   pushGrammarProduction(Grammar.DEFINITION);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case T_ABSTRACT:
    case T_CLASS:
      Class();
      break;
    case T_ENUM:
      Enum();
      break;
    case T_INTERFACE:
      Interface();
      break;
    case T_FINAL:
    case T_PACKAGE:
      Package();
      break;
    default:
      jj_la1[11] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
     popGrammarProduction();
  }

/**
 * A SIDL class specification begins with an optional abstract keyword
 * followed by the class token followed by an identifier.  The abstract
 * keyword is required if and only if there are abstract methods in the
 * class.  The class keyword is followed by an identifer.  The identifier
 * string may not have been previously defined, although it may have been
 * used as a forward reference.  The identifier string may be preceeded
 * by a documentation comment.  A class may optionally extend another class;
 * if no class is specified, then the class will automatically extend the
 * SIDL base class (unless it is itself the SIDL base class).  Then parse
 * the implements-all and implements clauses.  The interfaces parsed during
 * implements-all are saved in a set and then all those methods are defined
 * at the end of the class definition.  The methods block begins with an
 * open curly-brace followed by zero or more methods followed by a close
 * curly-brace and optional semicolon.
 */
  final public void Class() throws ParseException, SymbolException {
   pushGrammarProduction(Grammar.CLASS);
   final String pre = "Parser.Class: ";
   Comment   comment           = null;
   HashSet   implall           = new HashSet();
   boolean   declared_abstract = false;
   Package   parent            = (Package)d_parent_stack.getFirst();
   Version   parentVersion     = parent.getSymbolID().getVersion();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case T_ABSTRACT:
      jj_consume_token(T_ABSTRACT);
       declared_abstract = true;
       comment = generateComment(token);
      break;
    default:
      jj_la1[12] = jj_gen;
      ;
    }
    jj_consume_token(T_CLASS);
     if (comment == null) {
        comment = generateComment(token);
     }
    Identifier();
      String fqn = getScope((String) d_arg_stack.pop());
      SymbolID id = new SymbolID(fqn, parentVersion);
      verifySymbolCanBeDefined(id);
      removeForwardReference(fqn);

      Class cls = new Class(id, comment);
      setMetadataValues(cls);
      cls.setUserSpecified(true);

      try {
         SymbolTable.getInstance().putSymbol(cls);
      } catch (SymbolRedefinitionException ex) {
         generateSymbolException(pre + ex.getMessage());
      }

      addSymbolToParentPackage(parent, id, Symbol.CLASS);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case T_EXTENDS:
      jj_consume_token(T_EXTENDS);
      ScopedIdentifier();
       String identifier = (String) d_arg_stack.pop();
       Symbol symbol = resolveSymbol(identifier);

       if (symbol.getSymbolType() != Symbol.CLASS) {
         generateSymbolException(pre + "EXTENDS: Symbol \""
           + symbol.getSymbolID().getSymbolName() + "\" must be an class.");
       }

       verifyClassInheritance(cls, (Class) symbol);
       cls.setParentClass((Class) symbol);
      break;
    default:
      jj_la1[13] = jj_gen;
      ;
    }
     /*
      * If no class was specified and this is not the SIDL base class,
      * then force this class to extend the SIDL base class.
      */
      if (cls.getParentClass() == null) {
         if (!fqn.equals(SIDL_CLASS)) {
            Class base = (Class) resolveFQN(SIDL_CLASS);
            verifyClassInheritance(cls, base);
            cls.setParentClass(base);
         }
      }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case T_IMPLEMENTS_ALL:
      jj_consume_token(T_IMPLEMENTS_ALL);
      AddInterface(cls, implall);
      label_5:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case T_COMMA:
          ;
          break;
        default:
          jj_la1[14] = jj_gen;
          break label_5;
        }
        jj_consume_token(T_COMMA);
        AddInterface(cls, implall);
      }
      break;
    default:
      jj_la1[15] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case T_IMPLEMENTS:
      jj_consume_token(T_IMPLEMENTS);
      AddInterface(cls, null);
      label_6:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case T_COMMA:
          ;
          break;
        default:
          jj_la1[16] = jj_gen;
          break label_6;
        }
        jj_consume_token(T_COMMA);
        AddInterface(cls, null);
      }
      break;
    default:
      jj_la1[17] = jj_gen;
      ;
    }
    jj_consume_token(T_OPEN_CURLY);
    Invariants(cls);
    label_7:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case T_ABSTRACT:
      case T_COPY:
      case T_FINAL:
      case T_STATIC:
      case T_VOID:
      case T_ARRAY:
      case T_BOOLEAN:
      case T_CHAR:
      case T_DCOMPLEX:
      case T_DOUBLE:
      case T_FCOMPLEX:
      case T_FLOAT:
      case T_INT:
      case T_LONG:
      case T_OPAQUE:
      case T_STRING:
      case T_IDENTIFIER:
        ;
        break;
      default:
        jj_la1[18] = jj_gen;
        break label_7;
      }
      ClassMethod(cls);
    }
    jj_consume_token(T_CLOSE_CURLY);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case T_SEMICOLON:
      jj_consume_token(T_SEMICOLON);
      break;
    default:
      jj_la1[19] = jj_gen;
      ;
    }
     for (Iterator i = implall.iterator(); i.hasNext(); ) {
       Interface ifc = (Interface) i.next();
       String name = ifc.getFullName();
       for (Iterator m = ifc.getMethods(true).iterator(); m.hasNext(); ) {
         Method method = (Method) m.next();
         Method defined = cls.lookupMethodByLongName(method.getLongMethodName(),
                                                     false);
         if (defined == null) {
           Method exist = cls.lookupMethodByLongName(method.getLongMethodName(),
                                                     true);
           if (exist.isAbstract()) {
             Method clone = method.cloneMethod();
             clone.setDefinitionModifier(Method.NORMAL);
             cls.addMethod(clone);
           }
         }
       }
     }

     /*
      * Check that the class abstract qualifier matches whether there are
      * any abstract methods in the class.
      */
     verifyAbstract(cls, declared_abstract);
     popGrammarProduction();
  }

/**
 * The SIDL enumeration specification begins with an "enum" token followed by
 * an identifier.  The enumerator list begins with an open curly brace, a set
 * of one or more definitions, and a close curly brace.  The closing curly
 * brace may be followed by an optional semicolon.  The enumeration symbol
 * identifier must have a version defined for it, and it must not have been
 * previously defined as a symbol.  Forward references are not allowed for
 * enumerated types.  This routine creates the enumerated class and then
 * grabs the list of enumeration symbols and their optional values.
 */
  final public void Enum() throws ParseException, SymbolException {
   pushGrammarProduction(Grammar.ENUM);
   final String pre = "Parser.Enum: ";
   Package parent = (Package)d_parent_stack.getFirst();
   Version parentVersion = parent.getSymbolID().getVersion();
    jj_consume_token(T_ENUM);
      Comment comment = generateComment(token);
    Identifier();
      String fqn = getScope((String) d_arg_stack.pop());
      SymbolID id = new SymbolID(fqn, parentVersion);
      verifySymbolCanBeDefined(id);
      verifyNotForwardReference(fqn);

      Enumeration e = new Enumeration(id, comment);
      e.setUserSpecified(true);
      setMetadataValues(e);

      try {
         SymbolTable.getInstance().putSymbol(e);
      } catch (SymbolRedefinitionException ex) {
         generateSymbolException(pre + "Identifier: " + ex.getMessage());
      }

      addSymbolToParentPackage(parent, id, Symbol.ENUM);
    jj_consume_token(T_OPEN_CURLY);
    Enumerator(e);
    label_8:
    while (true) {
      if (jj_2_1(2)) {
        ;
      } else {
        break label_8;
      }
      jj_consume_token(T_COMMA);
      Enumerator(e);
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case T_COMMA:
      jj_consume_token(T_COMMA);
      break;
    default:
      jj_la1[20] = jj_gen;
      ;
    }
    jj_consume_token(T_CLOSE_CURLY);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case T_SEMICOLON:
      jj_consume_token(T_SEMICOLON);
      break;
    default:
      jj_la1[21] = jj_gen;
      ;
    }
      popGrammarProduction();
  }

/**
 * The SIDL enumerator specification consists of an identifier followed
 * by an optional assignment statement beginning with an equals and followed
 * by an integer value.  This routine adds the new enumeration symbol to
 * the list and then returns.
 */
  final public void Enumerator(Enumeration e) throws ParseException, SymbolException {
   pushGrammarProduction(Grammar.ENUMERATOR);
   final String pre = "Parser.Enumerator: ";
   Comment comment = null;
    Identifier();
      comment = generateComment(token);
      String name = (String) d_arg_stack.pop();
      if (e.hasEnumerator(name)) {
         generateSymbolException(pre + "Identifier: Redefinition of enumerator "
           + "\"" + name + "\".");
      }
      int     value        = 0;
      boolean user_defined = false;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case T_EQUALS:
      jj_consume_token(T_EQUALS);
      jj_consume_token(T_INTEGER);
       user_defined = true;
       try {
         value = Integer.parseInt(token.image);
       } catch (NumberFormatException ex) {
         generateSymbolException(pre + "EQUALS INTEGER: Invalid integer \""
           + token.image + "\".");
       }
      break;
    default:
      jj_la1[22] = jj_gen;
      ;
    }
      if (!user_defined) {
         e.addEnumerator(name, comment);
      } else {
         e.addEnumerator(name, value, comment);
      }
      popGrammarProduction();
  }

/**
 * A SIDL interface specification begins with the interface token followed
 * by an identifier.  An interface may have an extends block consisting of
 * a comma-separated sequence of interfaces.  The methods block begins with
 * an open curly-brace followed by zero or more methods followed by a close
 * curly-brace and optional semicolon.  Interfaces may be preceeded by a
 * documentation comment.  The identifier string may not have been previously
 * defined, although it may have been used as a forward reference.  If the
 * interface does not extend another interface, then it must extend the base
 * SIDL interface (unless, of course, this is the definition for the base
 * SIDL interface).
 */
  final public void Interface() throws ParseException, SymbolException {
   pushGrammarProduction(Grammar.INTERFACE);
   final String pre = "Parser.Interface: ";
   Package parent = (Package)d_parent_stack.getFirst();
   Version parentVersion = parent.getSymbolID().getVersion();
    jj_consume_token(T_INTERFACE);
      Comment comment = generateComment(token);
    Identifier();
      String fqn = getScope((String) d_arg_stack.pop());
      SymbolID id = new SymbolID(fqn, parentVersion);

      verifySymbolCanBeDefined(id);
      removeForwardReference(fqn);

      Interface ifc = new Interface(id, comment);
      ifc.setUserSpecified(true);
      setMetadataValues(ifc);

      try {
         SymbolTable.getInstance().putSymbol(ifc);
      } catch (SymbolRedefinitionException ex) {
         generateSymbolException(pre + "Identifier: " + ex.getMessage());
      }

      addSymbolToParentPackage(parent, id, Symbol.INTERFACE);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case T_EXTENDS:
      jj_consume_token(T_EXTENDS);
      AddInterface(ifc, null);
      label_9:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case T_COMMA:
          ;
          break;
        default:
          jj_la1[23] = jj_gen;
          break label_9;
        }
        jj_consume_token(T_COMMA);
        AddInterface(ifc, null);
      }
      break;
    default:
      jj_la1[24] = jj_gen;
      ;
    }
      if (ifc.getParentInterfaces(false).isEmpty()) {
         if (!fqn.equals(SIDL_INTERFACE)) {
            Interface base = (Interface) resolveFQN(SIDL_INTERFACE);
            verifyInterfaceInheritance(ifc, base);
            ifc.addParentInterface(base);
         }
      }
    jj_consume_token(T_OPEN_CURLY);
    Invariants(ifc);
    label_10:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case T_COPY:
      case T_VOID:
      case T_ARRAY:
      case T_BOOLEAN:
      case T_CHAR:
      case T_DCOMPLEX:
      case T_DOUBLE:
      case T_FCOMPLEX:
      case T_FLOAT:
      case T_INT:
      case T_LONG:
      case T_OPAQUE:
      case T_STRING:
      case T_IDENTIFIER:
        ;
        break;
      default:
        jj_la1[25] = jj_gen;
        break label_10;
      }
      InterfaceMethod(ifc);
    }
    jj_consume_token(T_CLOSE_CURLY);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case T_SEMICOLON:
      jj_consume_token(T_SEMICOLON);
      break;
    default:
      jj_la1[26] = jj_gen;
      ;
    }
      popGrammarProduction();
  }

/**
 * This production parses the next scoped identifier and validates that
 * the name exists and is an interface symbol.  Then each of its methods
 * are checked for validity with the existing methods.  If everything
 * checks out, then the new interface is added to the existing object.
 */
  final public void AddInterface(Extendable ext, Set set) throws ParseException, SymbolException {
   final String pre = "Parser.AddInterface: ";
    ScopedIdentifier();
      String identifier = (String) d_arg_stack.pop();
      Symbol symbol = resolveSymbol(identifier);

      if (symbol.getSymbolType() != Symbol.INTERFACE) {
         generateSymbolException(pre + "ScopedIdentifier: Symbol \""
           + symbol.getSymbolID().getSymbolName() + "\" must be an interface.");
      }

      verifyInterfaceInheritance(ext, (Interface) symbol);
      ext.addParentInterface((Interface) symbol);

      if (set != null) {
         set.add(symbol);
      }
  }

/**
 * This production parses the invariants associated with the interface 
 * or class.
 */
  final public void Invariants(Extendable ext) throws ParseException, SymbolException {
   final String pre = "Parser.Invariants: ";
   pushGrammarProduction(Grammar.INVARIANTS);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case T_INVARIANT:
      jj_consume_token(T_INVARIANT);
      Comment icomment = generateComment(token);
      Assertions(ext, null, Assertion.INVARIANT, icomment);
      break;
    default:
      jj_la1[27] = jj_gen;
      ;
    }
    popGrammarProduction();
  }

/**
 * This production parses the SIDL method description for a class method.
 * A class method may start with abstract, final, or static.  An error is
 * thrown if the method has already been defined in the class object or if
 * the method name is the same as the class name.  An error is also thrown
 * if a method has been defined in a parent class and (1) the signatures
 * do not match, (2) either of the methods is static, (3) the existing method
 * is final, or (4) the new method is abstract but the existing method was
 * not abstract.
 */
  final public void ClassMethod(Class cls) throws ParseException, SymbolException {
   pushGrammarProduction(Grammar.CLASS_METHOD);
   final String pre = "Parser.ClassMethod: ";
   Method method = new Method();
   Comment comment = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case T_ABSTRACT:
    case T_FINAL:
    case T_STATIC:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case T_ABSTRACT:
        jj_consume_token(T_ABSTRACT);
         method.setDefinitionModifier(Method.ABSTRACT);
        break;
      case T_FINAL:
        jj_consume_token(T_FINAL);
         method.setDefinitionModifier(Method.FINAL);
        break;
      case T_STATIC:
        jj_consume_token(T_STATIC);
         method.setDefinitionModifier(Method.STATIC);
        break;
      default:
        jj_la1[28] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
       comment = generateComment(token);
      break;
    default:
      jj_la1[29] = jj_gen;
      ;
    }
      if (comment == null) {
         comment = generateComment(getToken(1));
      }
      method.setComment(comment);
    Method(cls, method);
      String name = cls.getFullName();
      verifyMethodRedefinition(cls, method);
      verifyMethodSignature(cls, method, name);
      verifyMethodStatic(cls, method, name);
      verifyMethodOverride(cls, method);
      cls.addMethod(method);
      popGrammarProduction();
  }

/**
 * This method parses a SIDL method and then checks whether it can be
 * added to the interface object.  An error is thrown if the method has
 * already been added to the interface object or if the method name is
 * the same as the interface name.  An error is also thrown if a previous
 * method was defined with the same name but a different signature.
 */
  final public void InterfaceMethod(Interface ifc) throws ParseException, SymbolException {
   Method method = new Method();
   method.setComment(generateComment(getToken(1)));
    Method(ifc, method);
      method.setDefinitionModifier(Method.ABSTRACT);
      String name = ifc.getFullName();
      verifyMethodRedefinition(ifc, method);
      verifyMethodSignature(ifc, method, name);
      ifc.addMethod(method);
  }

/**
 * The SIDL method production has a return type, a method identifier,
 * an optional argument list, an optional communication modifier, and
 * an optional throws clause.  The return type may be void (no return
 * type) or any valid SIDL type.  The method is built piece by piece.
 */
  final public void Method(Extendable ext, Method m) throws ParseException, SymbolException {
   pushGrammarProduction(Grammar.METHOD);
   final String pre = "Parser.Method: ";
   Comment comment    = null;
   boolean copy       = false;
   boolean hasAsserts = false;
   int     assertType = 0;
   String  short_name = null;
   String  extension  = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case T_VOID:
      jj_consume_token(T_VOID);
       m.setReturnType(new Type(Type.VOID));
       m.setReturnCopy(false);
      break;
    case T_COPY:
    case T_ARRAY:
    case T_BOOLEAN:
    case T_CHAR:
    case T_DCOMPLEX:
    case T_DOUBLE:
    case T_FCOMPLEX:
    case T_FLOAT:
    case T_INT:
    case T_LONG:
    case T_OPAQUE:
    case T_STRING:
    case T_IDENTIFIER:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case T_COPY:
        jj_consume_token(T_COPY);
         copy = true;
        break;
      default:
        jj_la1[30] = jj_gen;
        ;
      }
      Type();
       Type t = (Type) d_arg_stack.pop();
       if (copy) {
         verifyCopyModifierValid(t);
       }
       m.setReturnType(t);
       m.setReturnCopy(copy);
      break;
    default:
      jj_la1[31] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    Identifier();
      short_name = (String) d_arg_stack.pop();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case T_OPEN_BRACE:
      jj_consume_token(T_OPEN_BRACE);
      Identifier();
       extension = (String) d_arg_stack.pop();
      jj_consume_token(T_CLOSE_BRACE);
      break;
    default:
      jj_la1[32] = jj_gen;
      ;
    }
     checkMethodNameLength(short_name, extension, token);
     if (extension != null) {
        m.setMethodName(short_name, extension);
     } else {
        m.setMethodName(short_name);
     }
    jj_consume_token(T_OPEN_PAREN);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case T_COPY:
    case T_IN:
    case T_INOUT:
    case T_OUT:
      Argument();
       m.addArgument((Argument) d_arg_stack.pop());
      label_11:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case T_COMMA:
          ;
          break;
        default:
          jj_la1[33] = jj_gen;
          break label_11;
        }
        jj_consume_token(T_COMMA);
        Argument();
         m.addArgument((Argument) d_arg_stack.pop());
      }
      break;
    default:
      jj_la1[34] = jj_gen;
      ;
    }
    jj_consume_token(T_CLOSE_PAREN);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case T_LOCAL:
    case T_ONEWAY:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case T_LOCAL:
        jj_consume_token(T_LOCAL);
       m.setCommunicationModifier(Method.LOCAL);
        break;
      case T_ONEWAY:
        jj_consume_token(T_ONEWAY);
       verifyOnewayValid(m);
       m.setCommunicationModifier(Method.ONEWAY);
        break;
      default:
        jj_la1[35] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      jj_la1[36] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case T_THROWS:
      jj_consume_token(T_THROWS);
      ScopedIdentifier();
       verifyAndAddThrows(m, (String) d_arg_stack.pop());
      label_12:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case T_COMMA:
          ;
          break;
        default:
          jj_la1[37] = jj_gen;
          break label_12;
        }
        jj_consume_token(T_COMMA);
        ScopedIdentifier();
         verifyAndAddThrows(m, (String) d_arg_stack.pop());
      }
      break;
    default:
      jj_la1[38] = jj_gen;
      ;
    }
    jj_consume_token(T_SEMICOLON);
      //Here we have a semantic check on arguments, no two arguments may have 
      //the same name.
      {
        HashSet argSet = new HashSet();
        ArrayList args = m.getArgumentList();
        for(Iterator a = args.iterator(); a.hasNext();) {
          Argument arg = (Argument)a.next();
          if(!argSet.add(arg.getFormalName().toUpperCase())) {
            generateSymbolException(pre + "Not all argument names to method "
              + m.getLongMethodName() + " are unique.");
          }
        }
      }

      // Here's where we do a semantic check on RARRAYS 	 
      ArrayList args = m.getArgumentList();
      int resolvedIndexArgs = 0;
      boolean resolvedLastIndex = false;

      //For loop puts together the set of rarray indices required
      for(Iterator i = args.iterator(); i.hasNext();) {
         Argument arg1 = (Argument) i.next();
         if(arg1.getType().isRarray()) {
            if(arg1.getMode() == Argument.OUT) {
               generateSymbolException(pre + "Rarray cannot be an OUT "
                 + "parameter, must be either IN or INOUT.");
            }
            m.addRarrayIndex(arg1.getType().getArrayIndices());
         }
      }

      if(m.hasRarray()) {
         for(Iterator indexIt = m.getRarrayIndices().iterator();
             indexIt.hasNext();)
         {
            String indexName = (String) indexIt.next();
            for(Iterator argIt = args.iterator(); argIt.hasNext();) {
               Argument arg1 = (Argument) argIt.next();
               if(indexName.compareTo((String) arg1.getFormalName()) == 0) {
                  if(!(arg1.getType().getType() == Type.INT ||
                       arg1.getType().getType() == Type.LONG)) {
                     generateSymbolException(pre + "Rarray Index arguments "
                       + "must be either of type Int or Long.");
                  }
                  if(arg1.getMode() != Argument.IN) {
                     generateSymbolException(pre + "Rarray Index arguments "
                       + "must be IN arguments.");
                  }

                  ++resolvedIndexArgs;
                  resolvedLastIndex = true;
                  break;
               }
            }
            if(resolvedLastIndex) {
               resolvedLastIndex = false;
            } else {
              generateSymbolException(pre + "Rarray Index argument "
                + indexName + " cannot be resolved, please include it in the "
                + "argument list.");
            }
         }
      }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case T_REQUIRE:
      jj_consume_token(T_REQUIRE);
       assertType = Assertion.REQUIRE;
       comment = generateComment(token);
      Assertions(ext, m, assertType, comment);
      break;
    default:
      jj_la1[39] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case T_ELSE:
      jj_consume_token(T_ELSE);
       assertType = Assertion.REQUIRE_ELSE;
      Assertions(ext, m, assertType, comment);
      break;
    default:
      jj_la1[40] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case T_ENSURE:
      jj_consume_token(T_ENSURE);
       comment = generateComment(token);
       assertType = Assertion.ENSURE;
      Assertions(ext, m, assertType, comment);
      break;
    default:
      jj_la1[41] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case T_THEN:
      jj_consume_token(T_THEN);
       assertType = Assertion.ENSURE_THEN;
      Assertions(ext, m, assertType, comment);
      break;
    default:
      jj_la1[42] = jj_gen;
      ;
    }
      popGrammarProduction();
  }

/**
 * Parse a SIDL argument.  Arguments begin with an optional copy modifier
 * followed by in, out, or inout followed by a type and a formal argument.
 * The argument is returned on the top of the argument stack.  This routine
 * also checks that the copy modifier is used only for symbol objects.  For
 * all other types, copy is redundant.
 */
  final public void Argument() throws ParseException, SymbolException {
   pushGrammarProduction(Grammar.ARGUMENT);
   boolean copy = false;
   int     mode = Argument.IN;
   String  name = null;
   Type    type = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case T_COPY:
      jj_consume_token(T_COPY);
       copy = true;
      break;
    default:
      jj_la1[43] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case T_IN:
      jj_consume_token(T_IN);
       mode = Argument.IN;
      break;
    case T_OUT:
      jj_consume_token(T_OUT);
       mode = Argument.OUT;
      break;
    case T_INOUT:
      jj_consume_token(T_INOUT);
       mode = Argument.INOUT;
      break;
    default:
      jj_la1[44] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case T_ARRAY:
    case T_BOOLEAN:
    case T_CHAR:
    case T_DCOMPLEX:
    case T_DOUBLE:
    case T_FCOMPLEX:
    case T_FLOAT:
    case T_INT:
    case T_LONG:
    case T_OPAQUE:
    case T_STRING:
    case T_IDENTIFIER:
      Type();
         type = (Type) d_arg_stack.pop();
      Identifier();
         name = (String) d_arg_stack.pop();
         if (copy) {
            verifyCopyModifierValid(type);
         }
         Argument arg = new Argument(copy, mode, type, name);
         d_arg_stack.push(arg);
         popGrammarProduction();
      break;
    case T_RARRAY:
      Rarray();
      //This is not the prettiest thing I've ever done.  In rarray we push 
      //name, then we push the Type on the stack, so we have to get them off 
      //to make the argument.
      Type rarrayType = (Type) d_arg_stack.pop();
      name = (String) d_arg_stack.pop();
      Argument arg1 = new Argument(copy, mode, rarrayType, name);
      d_arg_stack.push(arg1);
      popGrammarProduction();
      break;
    default:
      jj_la1[45] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

/**
 * A SIDL type consists of one of the standard built-in types (boolean,
 * char, dcomplex, double, fcomplex, float, int, long, opaque, and string),
 * a user-defined type (interface, class, or enum), or an array.  This
 * production parses the type and pushes the resulting type object on
 * the top of the argument stack.
 */
  final public void Type() throws ParseException, SymbolException {
   pushGrammarProduction(Grammar.TYPE);
   Type type;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case T_BOOLEAN:
      jj_consume_token(T_BOOLEAN);
       type = new Type(Type.BOOLEAN);
      break;
    case T_CHAR:
      jj_consume_token(T_CHAR);
       type = new Type(Type.CHAR);
      break;
    case T_DCOMPLEX:
      jj_consume_token(T_DCOMPLEX);
       type = new Type(Type.DCOMPLEX);
      break;
    case T_DOUBLE:
      jj_consume_token(T_DOUBLE);
       type = new Type(Type.DOUBLE);
      break;
    case T_FCOMPLEX:
      jj_consume_token(T_FCOMPLEX);
       type = new Type(Type.FCOMPLEX);
      break;
    case T_FLOAT:
      jj_consume_token(T_FLOAT);
       type = new Type(Type.FLOAT);
      break;
    case T_INT:
      jj_consume_token(T_INT);
       type = new Type(Type.INT);
      break;
    case T_LONG:
      jj_consume_token(T_LONG);
       type = new Type(Type.LONG);
      break;
    case T_OPAQUE:
      jj_consume_token(T_OPAQUE);
       type = new Type(Type.OPAQUE);
      break;
    case T_STRING:
      jj_consume_token(T_STRING);
       type = new Type(Type.STRING);
      break;
    case T_ARRAY:
      Array();
       type = (Type) d_arg_stack.pop();
      break;
    case T_IDENTIFIER:
      SymbolType();
       type = new Type((SymbolID) d_arg_stack.pop());
      break;
    default:
      jj_la1[46] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
     d_arg_stack.push(type);
     popGrammarProduction();
  }

/**
 * Parse an array construct and push the resulting type and ordering on top of 
 * the stack.  Only dimensions one through MAX_ARRAY_DIM (inclusive) are 
 * supported.
 */
  final public void Array() throws ParseException, SymbolException {
   pushGrammarProduction(Grammar.ARRAY);
   final String pre = "Parser.Array: ";
   int dim   = 1;
   int order = Type.UNSPECIFIED;
   Type arrayType = null;
    jj_consume_token(T_ARRAY);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case T_LESS_GREATER:
      jj_consume_token(T_LESS_GREATER);
        arrayType = null;  // definitely a generic array!

      break;
    case T_OPEN_ANGLE:
      jj_consume_token(T_OPEN_ANGLE);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case T_ARRAY:
      case T_BOOLEAN:
      case T_CHAR:
      case T_DCOMPLEX:
      case T_DOUBLE:
      case T_FCOMPLEX:
      case T_FLOAT:
      case T_INT:
      case T_LONG:
      case T_OPAQUE:
      case T_STRING:
      case T_IDENTIFIER:
        Type();
         arrayType = (Type)d_arg_stack.pop();
         if (arrayType.isArray()) {
            generateSymbolException(pre + "Array Type: Nested arrays are "
              + "not supported.");
         }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case T_COMMA:
          jj_consume_token(T_COMMA);
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case T_INTEGER:
            jj_consume_token(T_INTEGER);
             try {
                dim = Integer.parseInt(token.image);
             } catch (NumberFormatException e) {
                generateSymbolException(pre + "COMMA INTEGER: \""
                  + token.image + "\" is an llegal array dimension:"
                  + "NumberFormatException detected.");
             }
             if ( (dim < 1) || (MAX_ARRAY_DIM < dim) ) {
                generateSymbolException(pre + "COMMA INTEGER: \"" + token.image
                  + "\" is not in the valid array dimension range of 1.."
                  + MAX_ARRAY_DIM + ".");
             }
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case T_COMMA:
              jj_consume_token(T_COMMA);
              switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
              case T_COLUMN_MAJOR:
                jj_consume_token(T_COLUMN_MAJOR);
                 order = Type.COLUMN_MAJOR;
                break;
              case T_ROW_MAJOR:
                jj_consume_token(T_ROW_MAJOR);
                 order = Type.ROW_MAJOR;
                break;
              default:
                jj_la1[47] = jj_gen;
                jj_consume_token(-1);
                throw new ParseException();
              }
              break;
            default:
              jj_la1[48] = jj_gen;
              ;
            }
            break;
          case T_COLUMN_MAJOR:
          case T_ROW_MAJOR:
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case T_COLUMN_MAJOR:
              jj_consume_token(T_COLUMN_MAJOR);
               order = Type.COLUMN_MAJOR;
              break;
            case T_ROW_MAJOR:
              jj_consume_token(T_ROW_MAJOR);
               order = Type.ROW_MAJOR;
              break;
            default:
              jj_la1[49] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
            break;
          default:
            jj_la1[50] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          break;
        default:
          jj_la1[51] = jj_gen;
          ;
        }
        break;
      default:
        jj_la1[52] = jj_gen;
        ;
      }
      jj_consume_token(T_CLOSE_ANGLE);
      break;
    default:
      jj_la1[53] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
       if (null == arrayType) {
         dim = 0;
       }
       d_arg_stack.push(new Type(arrayType, dim, order));
       popGrammarProduction();
  }

/**
 * Parse an rarray construct and push the resulting type and ordering on top of 
 * the stack.  Only dimensions one through MAX_ARRAY_DIM (inclusive) are 
 * supported.  And don't forget the indices!
 */
  final public void Rarray() throws ParseException, SymbolException {
   pushGrammarProduction(Grammar.RARRAY);
   final String pre = "Parser.Rarray: ";
   int dim   = 1;
   int order = Type.COLUMN_MAJOR;
   Type arrayType = null; // null means a generic array
   String name = null;
   Vector indexVector = new Vector();
    jj_consume_token(T_RARRAY);
    jj_consume_token(T_OPEN_ANGLE);
    Type();
      arrayType = (Type)d_arg_stack.pop();
      int intType = arrayType.getType();
      if (arrayType.isArray()) {
         generateSymbolException(pre + "Nested arrays are not supported.");
      }
      if (intType < Type.BOOLEAN || intType > Type.OPAQUE) {
         generateSymbolException(pre + "RARRAYs may only be of basic types"
           + " (dcomplex, double, fcomplex, float, int, long, or opaque).");
      }
      if (intType == Type.BOOLEAN || intType == Type.CHAR) {
        generateSymbolException(pre + "RARRAYs may not be of type boolean or "
          + "char. Only of dcomplex, double, fcomplex, float, int, long, or "
          + "opaque.");
      }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case T_COMMA:
      jj_consume_token(T_COMMA);
      jj_consume_token(T_INTEGER);
         try {
           dim = Integer.parseInt(token.image);
         } catch (NumberFormatException e) {
           generateSymbolException(pre + "COMMA INTEGER: \""
             + token.image + "\" is an llegal array dimension:"
             + "NumberFormatException detected.");
         }
         if ( (dim < 1) || (MAX_ARRAY_DIM < dim) ) {
           generateSymbolException(pre + "COMMA INTEGER: \""
             + token.image + "\" is not in the valid array dimension range of "
             + "1.." + MAX_ARRAY_DIM + ".");
         }
      break;
    default:
      jj_la1[54] = jj_gen;
      ;
    }
    jj_consume_token(T_CLOSE_ANGLE);
     if (null == arrayType) {
       generateSymbolException(pre + "RARRAY must have a type.");
     }
    Identifier();

    jj_consume_token(T_OPEN_PAREN);
    Identifier();
     indexVector.add((String) d_arg_stack.pop());
    label_13:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case T_COMMA:
        ;
        break;
      default:
        jj_la1[55] = jj_gen;
        break label_13;
      }
      jj_consume_token(T_COMMA);
      Identifier();
       indexVector.add((String) d_arg_stack.pop());
    }
    jj_consume_token(T_CLOSE_PAREN);
     if (dim != indexVector.size()) {
       generateSymbolException(pre + "The number of index variables must "
         + "equal the dimension of the RARRAY.");
     }

     d_arg_stack.push(new Type(arrayType, dim, indexVector));
     popGrammarProduction();
  }

/**
 * This production parses a scoped identifier and verifies that it is
 * either a forward reference or a symbol that may be used as a type
 * (either an enum, an interface, or a class).
 */
  final public void SymbolType() throws ParseException, SymbolException {
   final String pre = "Parser.SymbolType: ";
    ScopedIdentifier();
      String identifier = (String) d_arg_stack.pop();
      Symbol symbol = tryResolveSymbol(identifier);

      if (symbol != null) {
         if (symbol.getSymbolType() == Symbol.PACKAGE) {
            generateSymbolException(pre + "ScopedIdentifier: Symbol \""
              + symbol.getSymbolID().getSymbolName()
              + "\" cannot be used as a SIDL type.");
         }
         d_arg_stack.push(symbol.getSymbolID());
      } else {
         String fqn = getScope(identifier);
         addForwardReference(fqn);
         d_arg_stack.push(new SymbolID(fqn, lookupVersion(fqn)));
      }
  }

/**
 * This production parses the assertions associated with the specified type.
 */
  final public void Assertions(Extendable ext, Method m, int type, Comment comment) throws ParseException, SymbolException {
  pushGrammarProduction(Grammar.ASSERTIONS);
  final String pre = "Parser.Assertions: ";
  Comment             currcomment = null;
  boolean             first       = true;
  AssertionExpression lhs         = null;
  AssertionExpression rhs         = null;
  String              tag         = null;
    label_14:
    while (true) {
      AssertionExpr();
      currcomment = generateComment(token);
      lhs         = (AssertionExpression) d_arg_stack.pop();
      tag         = null;
      rhs         = null;
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case T_COLON:
        jj_consume_token(T_COLON);
        AssertionExpr();
        rhs = (AssertionExpression) d_arg_stack.pop();
        break;
      default:
        jj_la1[56] = jj_gen;
        ;
      }
      jj_consume_token(T_SEMICOLON);
      if (first) {
        if ( (comment != null) && (currcomment == null) ) {
          currcomment = comment;
        }
        first = false;
      }

      AssertionExpression expr = null;
      String              name = getSourceName(ext, m);
      if (rhs != null) {
        String idLitName = "gov.llnl.babel.symbols.IdentifierLiteral";
        /*
         * Since the colon "operator" appears, the lhs expression had better
         * be a valid tag.  That is, it had better be an identifier literal
         * that is not a reserved identifier.
         */
        if ( !(lhs.getClass().getName().equals(idLitName)) ) {
          generateSymbolException(pre + "Invalid use of colon operator in "
            + "assertion clause of " + name + ". Tag cannot be parsed into "
            + "class \"" + lhs.getClass().getName() + "\" but must be an \""
            + idLitName + "\" instead.");
        }
        tag = ((IdentifierLiteral)lhs).getIdentifier();
        if ( ((IdentifierLiteral)lhs).isReserved() ) {
          generateSymbolException(pre + "reserved literal \"" + tag
            + "\" cannot be used as a tag in an assertion clause but found in "
            + name + "s \"" + lhs.toString() + "\".");
        }
        if ( ((IdentifierLiteral)lhs).hasParens() ) {
          generateSymbolException(pre + "parentheses are not allowed"
            + " for a tag in an assertion clause but found in " + name
            + "s \"" + lhs.toString() + "\".");
        }
        expr = rhs;
      } else {
        expr = lhs;
      }

      try {
        Assertion assertion = new Assertion(type, name, tag, currcomment);
        assertion.setExpression(expr);
        switch (type) {
          case Assertion.INVARIANT:
            ext.addInvariant(assertion);
            break;
          case Assertion.REQUIRE:
          case Assertion.REQUIRE_ELSE:
            if (m != null) {
              m.addAssertion(assertion);
            } else {
              generateSymbolException(pre + name + ": Cannot add precondition "
                + "tagged \"" + tag + "\" to a null method.");
            }
            break;
          case Assertion.ENSURE:
          case Assertion.ENSURE_THEN:
            if (m != null) {
              m.addAssertion(assertion);
            } else {
              generateSymbolException(pre + name + ": Cannot add postcondition "
                + "tagged \"" + tag + "\" to a null method.");
            }
            break;
          default:
            generateSymbolException(pre + name + ": Unrecognized assertion type"
              + " " + type + " encountered when attempting to add assertion "
              + "tagged \"" + tag + "\" to the symbol table.");
            break;
        }
      } catch (AssertionException ex) {
        generateSymbolException(pre + ex.getMessage());
      }
      if (jj_2_2(2)) {
        ;
      } else {
        break label_14;
      }
    }
    popGrammarProduction();
  }

/**
 * An assertion expression may be a unary (conditional) expression or binary 
 * (conditional ("implies" | "iff") conditional) expression.
 */
  final public void AssertionExpr() throws ParseException, SymbolException {
  pushGrammarProduction(Grammar.ASSERTION_EXPR);
  int                  op  = BinaryExpression.NOOP;
  AssertionExpression lhs  = null;
    ConditionalExpr();
    int numOnStack = 1;
    label_15:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case T_IF_AND_ONLY_IF:
      case T_IMPLIES:
        ;
        break;
      default:
        jj_la1[57] = jj_gen;
        break label_15;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case T_IMPLIES:
        jj_consume_token(T_IMPLIES);
        op = BinaryExpression.IMPLIES;
        break;
      case T_IF_AND_ONLY_IF:
        jj_consume_token(T_IF_AND_ONLY_IF);
        op = BinaryExpression.IF_AND_ONLY_IF;
        break;
      default:
        jj_la1[58] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      d_arg_stack.push(new Integer(op));
      numOnStack = numOnStack + 1;
      ConditionalExpr();
      numOnStack = numOnStack + 1;
    }
    /*
     * At this point we assume the conditional expressions separated by the
     * "implies" are at the top of the stack.  So now we just need to either
     * leave it there if there's only one OR combine them (while ensuring
     * left associativity) if there are 2 or more.
     */
    if (numOnStack > 1) {
      createBinaryExpressions(numOnStack, true, BinaryExpression.NOOP);
    }
    popGrammarProduction();
  }

/**
 * A conditional expression is simply an inclusive-OR expression.
 */
  final public void ConditionalExpr() throws ParseException, SymbolException {
  pushGrammarProduction(Grammar.CONDITIONAL_EXPR);
    InclusiveOrExpr();
    popGrammarProduction();
  }

/**
 * A inclusive-OR expression may be a unary (exclusive-OR) expression or binary
 * (inclusive-OR "or" exclusive-OR) expression.
 */
  final public void InclusiveOrExpr() throws ParseException, SymbolException {
  pushGrammarProduction(Grammar.INCLUSIVE_OR_EXPR);
  AssertionExpression lhs = null;
    ExclusiveOrExpr();
    int numOnStack = 1;
    label_16:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case T_OR:
        ;
        break;
      default:
        jj_la1[59] = jj_gen;
        break label_16;
      }
      jj_consume_token(T_OR);
      ExclusiveOrExpr();
      numOnStack = numOnStack + 1;
    }
    /*
     * At this point we assume the expressions separated by the operator
     * are at the top of the stack.  So now we just need to either leave 
     * it there if there's only one OR combine them (while ensuring
     * left associativity) if there are 2 or more.
     */
    if (numOnStack > 1) {
      createBinaryExpressions(numOnStack, false, BinaryExpression.OR);
    }
    popGrammarProduction();
  }

/**
 * A exclusive-OR expression may be a unary (AND) expression or binary
 * (exclusive-OR "xor" AND) expression.
 */
  final public void ExclusiveOrExpr() throws ParseException, SymbolException {
  pushGrammarProduction(Grammar.EXCLUSIVE_OR_EXPR);
  AssertionExpression lhs = null;
    AndExpr();
    int numOnStack = 1;
    label_17:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case T_XOR:
        ;
        break;
      default:
        jj_la1[60] = jj_gen;
        break label_17;
      }
      jj_consume_token(T_XOR);
      AndExpr();
      numOnStack = numOnStack + 1;
    }
    /*
     * At this point we assume the expressions separated by the operator
     * are at the top of the stack.  So now we just need to either leave 
     * it there if there's only one OR combine them (while ensuring
     * left associativity) if there are 2 or more.
     */
    if (numOnStack > 1) {
      createBinaryExpressions(numOnStack, false, BinaryExpression.XOR);
    }
    popGrammarProduction();
  }

/**
 * A AND-expression may be a unary (equality) expression or binary
 * (AND "and" equality) expression.
 */
  final public void AndExpr() throws ParseException, SymbolException {
  pushGrammarProduction(Grammar.AND_EXPR);
  AssertionExpression lhs = null;
    EqualityExpr();
    int numOnStack = 1;
    label_18:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case T_AND:
        ;
        break;
      default:
        jj_la1[61] = jj_gen;
        break label_18;
      }
      jj_consume_token(T_AND);
      EqualityExpr();
      numOnStack = numOnStack + 1;
    }
    /*
     * At this point we assume the expressions separated by the operator
     * are at the top of the stack.  So now we just need to either leave 
     * it there if there's only one OR combine them (while ensuring
     * left associativity) if there are 2 or more.
     */
    if (numOnStack > 1) {
      createBinaryExpressions(numOnStack, false, BinaryExpression.AND);
    }
    popGrammarProduction();
  }

/**
 * An equality expression may be a unary (relational) expression or binary
 * (equality op relational) expression, where op is "==" or "!=".
 */
  final public void EqualityExpr() throws ParseException, SymbolException {
  pushGrammarProduction(Grammar.EQUALITY_EXPR);
  int                 op  = BinaryExpression.NOOP;
  AssertionExpression lhs = null;
    RelationalExpr();
    int numOnStack = 1;
    label_19:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case T_LESS_GREATER:
      case T_EQUIVALENT:
      case T_NOT_EQUAL:
        ;
        break;
      default:
        jj_la1[62] = jj_gen;
        break label_19;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case T_EQUIVALENT:
        jj_consume_token(T_EQUIVALENT);
        op = BinaryExpression.EQUALS;
        break;
      case T_NOT_EQUAL:
        jj_consume_token(T_NOT_EQUAL);
        op = BinaryExpression.NOT_EQUAL;
        break;
      case T_LESS_GREATER:
        jj_consume_token(T_LESS_GREATER);
        op = BinaryExpression.LESS_GREATER;
        break;
      default:
        jj_la1[63] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      d_arg_stack.push(new Integer(op));
      numOnStack = numOnStack + 1;
      RelationalExpr();
      numOnStack = numOnStack + 1;
    }
    /*
     * At this point we assume the expressions separated by the operator
     * are at the top of the stack.  So now we just need to either leave 
     * it there if there's only one OR combine them (while ensuring
     * left associativity) if there are more.
     */
    if (numOnStack > 1) {
      createBinaryExpressions(numOnStack, true, BinaryExpression.NOOP);
    }
    popGrammarProduction();
  }

/**
 * An relational expression may be a unary (shift) expression or binary
 * (relational op shift) expression, where op is ">", "<", "<=", or ">=".
 */
  final public void RelationalExpr() throws ParseException, SymbolException {
  pushGrammarProduction(Grammar.RELATIONAL_EXPR);
  int                 op  = BinaryExpression.NOOP;
  AssertionExpression lhs = null;
    ShiftExpr();
    int numOnStack = 1;
    label_20:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case T_OPEN_ANGLE:
      case T_CLOSE_ANGLE:
      case T_GREATER_EQUAL:
      case T_LESS_EQUAL:
        ;
        break;
      default:
        jj_la1[64] = jj_gen;
        break label_20;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case T_OPEN_ANGLE:
        jj_consume_token(T_OPEN_ANGLE);
        op = BinaryExpression.LESS_THAN;
        break;
      case T_CLOSE_ANGLE:
        jj_consume_token(T_CLOSE_ANGLE);
        op = BinaryExpression.GREATER_THAN;
        break;
      case T_LESS_EQUAL:
        jj_consume_token(T_LESS_EQUAL);
        op = BinaryExpression.LESS_EQUAL;
        break;
      case T_GREATER_EQUAL:
        jj_consume_token(T_GREATER_EQUAL);
        op = BinaryExpression.GREATER_EQUAL;
        break;
      default:
        jj_la1[65] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      d_arg_stack.push(new Integer(op));
      numOnStack = numOnStack + 1;
      ShiftExpr();
      numOnStack = numOnStack + 1;
    }
    /*
     * At this point we assume the expressions separated by the operator
     * are at the top of the stack.  So now we just need to either leave 
     * it there if there's only one OR combine them (while ensuring
     * left associativity) if there are more.
     */
    if (numOnStack > 1) {
      createBinaryExpressions(numOnStack, true, BinaryExpression.NOOP);
    }
    popGrammarProduction();
  }

/**
 * A shift expression may be a unary (additive) expression or binary
 * (shift op additive) expression, where op is "<<" or ">>".
 */
  final public void ShiftExpr() throws ParseException, SymbolException {
  pushGrammarProduction(Grammar.SHIFT_EXPR);
  int                 op  = BinaryExpression.NOOP;
  AssertionExpression lhs = null;
    AdditiveExpr();
    int numOnStack = 1;
    label_21:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case T_SHIFT_LEFT:
      case T_SHIFT_RIGHT:
        ;
        break;
      default:
        jj_la1[66] = jj_gen;
        break label_21;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case T_SHIFT_LEFT:
        jj_consume_token(T_SHIFT_LEFT);
        op = BinaryExpression.SHIFT_LEFT;
        break;
      case T_SHIFT_RIGHT:
        jj_consume_token(T_SHIFT_RIGHT);
        op = BinaryExpression.SHIFT_RIGHT;
        break;
      default:
        jj_la1[67] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      d_arg_stack.push(new Integer(op));
      numOnStack = numOnStack + 1;
      AdditiveExpr();
      numOnStack = numOnStack + 1;
    }
    /*
     * At this point we assume the expressions separated by the operator
     * are at the top of the stack.  So now we just need to either leave 
     * it there if there's only one OR combine them (while ensuring
     * left associativity) if there are more.
     */
    if (numOnStack > 1) {
      createBinaryExpressions(numOnStack, true, BinaryExpression.NOOP);
    }
    popGrammarProduction();
  }

/**
 * An additive expression may be a unary (multiplicative) expression or binary
 * (additive op multiplicative) expression, where op is "+" or "-".
 */
  final public void AdditiveExpr() throws ParseException, SymbolException {
  pushGrammarProduction(Grammar.ADDITIVE_EXPR);
  AssertionExpression lhs = null;
  int                 op  = BinaryExpression.NOOP;
    MultiplicativeExpr();
    int numOnStack = 1;
    label_22:
    while (true) {
      if (jj_2_3(2)) {
        ;
      } else {
        break label_22;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case T_PLUS:
        jj_consume_token(T_PLUS);
        op = BinaryExpression.PLUS;
        break;
      case T_HYPHEN:
        jj_consume_token(T_HYPHEN);
        op = BinaryExpression.MINUS;
        break;
      default:
        jj_la1[68] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      d_arg_stack.push(new Integer(op));
      numOnStack = numOnStack + 1;
      MultiplicativeExpr();
      numOnStack = numOnStack + 1;
    }
    /*
     * At this point we assume the expressions separated by the operator
     * are at the top of the stack.  So now we just need to either leave 
     * it there if there's only one OR combine them (while ensuring
     * left associativity) if there are more.
     */
    if (numOnStack > 1) {
      createBinaryExpressions(numOnStack, true, BinaryExpression.NOOP);
    }
    popGrammarProduction();
  }

/**
 * A multiplicative expression may be a unary (multiplicative) expression or 
 * binary (multiplicative expression, "*" or "/" or "mod", unary) expression.
 */
  final public void MultiplicativeExpr() throws ParseException, SymbolException {
  pushGrammarProduction(Grammar.MULTIPLICATIVE_EXPR);
  AssertionExpression lhs = null;
  int                 op  = BinaryExpression.NOOP;
    PowerExpr();
    int numOnStack = 1;
    label_23:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case T_ASTERISK:
      case T_MODULUS:
      case T_REMAINDER:
      case T_SOLIDUS:
        ;
        break;
      default:
        jj_la1[69] = jj_gen;
        break label_23;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case T_ASTERISK:
        jj_consume_token(T_ASTERISK);
        op = BinaryExpression.MULTIPLY;
        break;
      case T_SOLIDUS:
        jj_consume_token(T_SOLIDUS);
        op = BinaryExpression.DIVIDE;
        break;
      case T_MODULUS:
        jj_consume_token(T_MODULUS);
        op = BinaryExpression.MODULUS;
        break;
      case T_REMAINDER:
        jj_consume_token(T_REMAINDER);
        op = BinaryExpression.REMAINDER;
        break;
      default:
        jj_la1[70] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      d_arg_stack.push(new Integer(op));
      numOnStack = numOnStack + 1;
      PowerExpr();
      numOnStack = numOnStack + 1;
    }
    /*
     * At this point we assume the expressions separated by the operator
     * are at the top of the stack.  So now we just need to either leave 
     * it there if there's only one OR combine them (while ensuring
     * left associativity) if there are more.
     */
    if (numOnStack > 1) {
      createBinaryExpressions(numOnStack, true, BinaryExpression.NOOP);
    }
    popGrammarProduction();
  }

/**
 * A multiplicative expression may be a unary (multiplicative) expression or 
 * binary (multiplicative expression, "*" or "/" or "mod", unary) expression.
 */
  final public void PowerExpr() throws ParseException, SymbolException {
  pushGrammarProduction(Grammar.MULTIPLICATIVE_EXPR);
  AssertionExpression lhs = null;
  int                 op  = BinaryExpression.NOOP;
    UnaryExpr();
    int numOnStack = 1;
    label_24:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case T_CARET:
      case T_POWER:
        ;
        break;
      default:
        jj_la1[71] = jj_gen;
        break label_24;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case T_CARET:
        jj_consume_token(T_CARET);
        op = BinaryExpression.EXPON;
        break;
      case T_POWER:
        jj_consume_token(T_POWER);
        op = BinaryExpression.POWER;
        break;
      default:
        jj_la1[72] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      d_arg_stack.push(new Integer(op));
      numOnStack = numOnStack + 1;
      UnaryExpr();
      numOnStack = numOnStack + 1;
    }
    /*
     * At this point we assume the expressions separated by the operator
     * are at the top of the stack.  So now we just need to either leave 
     * it there if there's only one OR combine them (while ensuring
     * left associativity) if there are more.
     */
    if (numOnStack > 1) {
      createBinaryExpressions(numOnStack, true, BinaryExpression.NOOP);
    }
    popGrammarProduction();
  }

/**
 * A unary expression may be a postfix or prefix expression.
 */
  final public void UnaryExpr() throws ParseException, SymbolException {
  pushGrammarProduction(Grammar.UNARY_EXPR);
  final String pre = "Parser.UnaryExpr: ";
  int op = UnaryExpression.NOOP;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case T_IS:
    case T_NOT:
    case T_TILDE:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case T_IS:
        jj_consume_token(T_IS);
        op = UnaryExpression.IS;
        break;
      case T_NOT:
        jj_consume_token(T_NOT);
        op = UnaryExpression.NOT;
        break;
      case T_TILDE:
        jj_consume_token(T_TILDE);
        op = UnaryExpression.COMPLEMENT;
        break;
      default:
        jj_la1[73] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      jj_la1[74] = jj_gen;
      ;
    }
    PostfixExpr();
    if (op != UnaryExpression.NOOP) {
      try {
        AssertionExpression expr = (AssertionExpression) d_arg_stack.pop();
        UnaryExpression     ue   = new UnaryExpression(op, expr);
        d_arg_stack.push(ue);
      } catch (AssertionException aex) {
        generateSymbolException(pre + "PostfixExpr: " + aex.getMessage());
      }
    }
    popGrammarProduction();
  }

/**
 * A postfix expression may be a primary expression or an identifier followed 
 * by an optional argument list.
 */
  final public void PostfixExpr() throws ParseException, SymbolException {
  pushGrammarProduction(Grammar.POSTFIX_EXPR);
  final String pre = "Parser.PostfixExpr: ";
  MethodCall mc = null;
    if (jj_2_4(3)) {
      Identifier();
      String id = (String) d_arg_stack.pop();
      jj_consume_token(T_OPEN_PAREN);
      try {
        mc = new MethodCall(id);
      } catch (AssertionException aex) {
        generateSymbolException(pre + "OPEN_PAREN: " + aex.getMessage());
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case T_IS:
      case T_NOT:
      case T_OPEN_CURLY:
      case T_OPEN_PAREN:
      case T_TILDE:
      case T_FALSE:
      case T_NULL:
      case T_PURE:
      case T_RESULT:
      case T_TRUE:
      case T_IDENTIFIER:
      case T_FLOAT_LIT:
      case T_INTEGER:
      case T_CHARACTER:
      case T_STRING_LIT:
        AddArguments(mc);
        break;
      default:
        jj_la1[75] = jj_gen;
        ;
      }
      jj_consume_token(T_CLOSE_PAREN);
      d_arg_stack.push(mc);
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case T_OPEN_CURLY:
      case T_OPEN_PAREN:
      case T_FALSE:
      case T_NULL:
      case T_PURE:
      case T_RESULT:
      case T_TRUE:
      case T_IDENTIFIER:
      case T_FLOAT_LIT:
      case T_INTEGER:
      case T_CHARACTER:
      case T_STRING_LIT:
        PrimaryExpr();

        break;
      default:
        jj_la1[76] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    popGrammarProduction();
  }

/**
 * A primary expression may be an identifier, literal, or conditional 
 * expression within parentheses.
 */
  final public void PrimaryExpr() throws ParseException, SymbolException {
  pushGrammarProduction(Grammar.PRIMARY_EXPR);
  final String pre = "Parser.PrimaryExpr: ";
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case T_OPEN_CURLY:
    case T_FALSE:
    case T_NULL:
    case T_PURE:
    case T_RESULT:
    case T_TRUE:
    case T_FLOAT_LIT:
    case T_INTEGER:
    case T_CHARACTER:
    case T_STRING_LIT:
      LiteralExpr();

      break;
    case T_IDENTIFIER:
      Identifier();
      String id = (String) d_arg_stack.pop();
      try {
        d_arg_stack.push(new IdentifierLiteral(id));
      } catch (AssertionException aex) {
        generateSymbolException(pre + "Identifier: " + aex.getMessage());
      } catch (Exception ex) {
        generateSymbolException(pre + "Identifier: Problem "
          + "instantiating an IdentifierLiteral for " + id + ": "
          + ex.getMessage());
      }
      break;
    case T_OPEN_PAREN:
      jj_consume_token(T_OPEN_PAREN);
      ConditionalExpr();
      jj_consume_token(T_CLOSE_PAREN);
        AssertionExpression ae = (AssertionExpression) d_arg_stack.pop();
        ae.setParens(true);
        d_arg_stack.push(ae);
      break;
    default:
      jj_la1[77] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    popGrammarProduction();
  }

/**
 * A literal expression is a literal of type: integer, character, floating
 * point, or string.
 */
  final public void LiteralExpr() throws ParseException, SymbolException {
  pushGrammarProduction(Grammar.LITERAL_EXPR);
  final String pre = "Parser.LiteralExpr: ";
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case T_NULL:
      jj_consume_token(T_NULL);
      try {
        d_arg_stack.push(new IdentifierLiteral("null"));
      } catch (AssertionException aex) {
        generateSymbolException(pre + "NULL: " + aex.getMessage());
      }
      break;
    case T_PURE:
      jj_consume_token(T_PURE);
      try {
        d_arg_stack.push(new IdentifierLiteral("pure"));
      } catch (AssertionException aex) {
        generateSymbolException(pre + "PURE: " + aex.getMessage());
      }
      break;
    case T_RESULT:
      jj_consume_token(T_RESULT);
      try {
        d_arg_stack.push(new IdentifierLiteral("result"));
      } catch (AssertionException aex) {
        generateSymbolException(pre + "RESULT: " + aex.getMessage());
      }
      break;
    case T_TRUE:
      jj_consume_token(T_TRUE);
      try {
        d_arg_stack.push(new BooleanLiteral(true));
      } catch (AssertionException aex) {
        generateSymbolException(pre + "TRUE: " + aex.getMessage());
      }
      break;
    case T_FALSE:
      jj_consume_token(T_FALSE);
      try {
        d_arg_stack.push(new BooleanLiteral(false));
      } catch (AssertionException aex) {
        generateSymbolException(pre + "FALSE: " + aex.getMessage());
      }
      break;
    case T_FLOAT_LIT:
      FloatLit();

      break;
    case T_INTEGER:
      IntegerLit();

      break;
    case T_OPEN_CURLY:
      ComplexLit();

      break;
    case T_STRING_LIT:
      jj_consume_token(T_STRING_LIT);
      try {
        int len = token.image.length();
        d_arg_stack.push(new StringLiteral(token.image.substring(1,len-1)));
      } catch (AssertionException aex) {
        generateSymbolException(pre + "STRING: " + aex.getMessage());
      }
      break;
    case T_CHARACTER:
      jj_consume_token(T_CHARACTER);
      try {
        d_arg_stack.push(new CharacterLiteral(token.image.charAt(1)));
      } catch (AssertionException aex) {
        generateSymbolException(pre + "CHARACTER: " + aex.getMessage());
      }
      break;
    default:
      jj_la1[78] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    popGrammarProduction();
  }

/**
 * Parse complex literal.
 */
  final public void ComplexLit() throws ParseException, SymbolException {
  final String pre = "Parser.ComplexLit: ";
  DoubleLiteral rD = null;
  DoubleLiteral iD = null;
  LongLiteral   rL = null;
  LongLiteral   iL = null;
    jj_consume_token(T_OPEN_CURLY);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case T_FLOAT_LIT:
      FloatLit();
      try {
        rD = (DoubleLiteral) d_arg_stack.pop();
      } catch (NumberFormatException ex) {
        generateSymbolException(pre + "double.real: Invalid floating point "
          + "number \"" + token.image + "\" detected during complex number "
          + "expression parsing.");
      }
      break;
    case T_INTEGER:
      IntegerLit();
      try {
        rL = (LongLiteral) d_arg_stack.pop();
      } catch (NumberFormatException ex) {
        generateSymbolException(pre + "float.real: Invalid floating point "
          + "number \"" + token.image + "\" detected during complex number "
          + "expression parsing.");
      }
      break;
    default:
      jj_la1[79] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(T_COMMA);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case T_FLOAT_LIT:
      FloatLit();
      try {
        iD = (DoubleLiteral) d_arg_stack.pop();
      } catch (NumberFormatException ex) {
        generateSymbolException(pre + "double.imaginary: Invalid floating "
          + "point number \"" + token.image + "\" detected during complex "
          + "number expression parsing.");
      }
      break;
    case T_INTEGER:
      IntegerLit();
      try {
        iL = (LongLiteral) d_arg_stack.pop();
      } catch (NumberFormatException ex) {
        generateSymbolException(pre + "float.imaginary: Invalid floating "
          + "point number \"" + token.image + "\" detected during complex "
          + "number expression parsing.");
      }
      break;
    default:
      jj_la1[80] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(T_CLOSE_CURLY);
    if ((rD != null) && (iD != null)) {
      try {
        d_arg_stack.push(new DComplexLiteral(rD, iD));
      } catch (AssertionException aex) {
        generateSymbolException(pre + "dcomplex: " + aex.getMessage());
      }
    } else if ((rD != null) && (iL != null)) {
      try {
        d_arg_stack.push(new DComplexLiteral(rD, iL));
      } catch (AssertionException aex) {
        generateSymbolException(pre + "dcomplex: " + aex.getMessage());
      }
    } else if ((rL != null) && (rD != null)) {
      try {
        d_arg_stack.push(new DComplexLiteral(rD, iL));
      } catch (AssertionException aex) {
        generateSymbolException(pre + "dcomplex: " + aex.getMessage());
      }
    } else if ((rL != null) && (iL != null)) {
      try {
        d_arg_stack.push(new FComplexLiteral(rL, iL));
      } catch (AssertionException aex) {
        generateSymbolException(pre + "fcomplex: " + aex.getMessage());
      }
    } else {
      generateSymbolException(pre + "complex: Unable to build a complex "
        + "literal due to unrecognized or incompatible real and/or "
        + "imaginary parts.");
    }
  }

/**
 * Parse float literal.
 */
  final public void FloatLit() throws ParseException, SymbolException {
  final String pre = "Parser.FloatLit: ";
    jj_consume_token(T_FLOAT_LIT);
    try {
      Double dValue = Double.valueOf(token.image);
      d_arg_stack.push(new DoubleLiteral(dValue, token.image));
    } catch (AssertionException aex) {
      generateSymbolException(pre + "FLOAT: " + aex.getMessage());
    } catch (NumberFormatException ex) {
      generateSymbolException(pre + "FLOAT: Invalid number \"" + token.image
        + "\" detected during expression parsing.");
    }
  }

/**
 * Parse integer literal.
 */
  final public void IntegerLit() throws ParseException, SymbolException {
  final String pre = "Parser.IntegerLit: ";
    jj_consume_token(T_INTEGER);
    try {
       Long lValue = Long.valueOf(token.image);
       d_arg_stack.push(new LongLiteral(lValue, token.image));
    } catch (AssertionException aex) {
       generateSymbolException(pre + "INTEGER: " + aex.getMessage());
    } catch (NumberFormatException ex) {
       generateSymbolException(pre + "INTEGER: Invalid number \""
         + token.image + "\" detected during expression parsing.");
    }
  }

/**
 * An argument expression list is a comma-separated list of conditional
 * expressions.
 */
  final public void AddArguments(MethodCall mc) throws ParseException, SymbolException {
  pushGrammarProduction(Grammar.ARGUMENT_EXPR_LIST);
    ConditionalExpr();
    mc.addArgument((AssertionExpression) d_arg_stack.pop());
    label_25:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case T_COMMA:
        ;
        break;
      default:
        jj_la1[81] = jj_gen;
        break label_25;
      }
      jj_consume_token(T_COMMA);
      ConditionalExpr();
      mc.addArgument((AssertionExpression) d_arg_stack.pop());
    }
    popGrammarProduction();
  }

/**
 * All SIDL scoped names are of the general form "ID ( . ID )*".  Each
 * identifier ID is a string of letters, numbers, and underscores that
 * must begin with a letter.  The scope resolution operator "." separates
 * the identifiers in a name.
 */
  final public void ScopedIdentifier() throws ParseException, SymbolException {
   pushGrammarProduction(Grammar.SCOPED_IDENTIFIER);
   StringBuffer buffer = new StringBuffer();
    Identifier();
      buffer.append((String) d_arg_stack.pop());
    label_26:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case T_SCOPE:
        ;
        break;
      default:
        jj_la1[82] = jj_gen;
        break label_26;
      }
      jj_consume_token(T_SCOPE);
      Identifier();
       buffer.append(SCOPE);
       buffer.append((String) d_arg_stack.pop());
    }
     d_arg_stack.push(buffer.toString());
     popGrammarProduction();
  }

/**
 * A SIDL identifier must start with a letter and may be followed by any
 * number of letters, numbers, or underscores.  It may not be a reserved
 * word in any of the SIDL implementation languages (e.g., C or C++).
 */
  final public void Identifier() throws ParseException, SymbolException {
    jj_consume_token(T_IDENTIFIER);
      verifyReservedWords(token.image);
      d_arg_stack.push(token.image);
  }

  final private boolean jj_2_1(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_1();
    jj_save(0, xla);
    return retval;
  }

  final private boolean jj_2_2(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_2();
    jj_save(1, xla);
    return retval;
  }

  final private boolean jj_2_3(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_3();
    jj_save(2, xla);
    return retval;
  }

  final private boolean jj_2_4(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_4();
    jj_save(3, xla);
    return retval;
  }

  final private boolean jj_3R_28() {
    if (jj_3R_35()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_36()) { jj_scanpos = xsp; break; }
      if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    }
    return false;
  }

  final private boolean jj_3R_74() {
    if (jj_scan_token(T_PURE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_73() {
    if (jj_scan_token(T_NULL)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_93() {
    if (jj_scan_token(T_REMAINDER)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_66() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_73()) {
    jj_scanpos = xsp;
    if (jj_3R_74()) {
    jj_scanpos = xsp;
    if (jj_3R_75()) {
    jj_scanpos = xsp;
    if (jj_3R_76()) {
    jj_scanpos = xsp;
    if (jj_3R_77()) {
    jj_scanpos = xsp;
    if (jj_3R_78()) {
    jj_scanpos = xsp;
    if (jj_3R_79()) {
    jj_scanpos = xsp;
    if (jj_3R_80()) {
    jj_scanpos = xsp;
    if (jj_3R_81()) {
    jj_scanpos = xsp;
    if (jj_3R_82()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_86() {
    if (jj_scan_token(T_INTEGER)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_92() {
    if (jj_scan_token(T_MODULUS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_91() {
    if (jj_scan_token(T_SOLIDUS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_65() {
    if (jj_scan_token(T_LESS_GREATER)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_90() {
    if (jj_scan_token(T_ASTERISK)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_64() {
    if (jj_scan_token(T_NOT_EQUAL)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_88() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_90()) {
    jj_scanpos = xsp;
    if (jj_3R_91()) {
    jj_scanpos = xsp;
    if (jj_3R_92()) {
    jj_scanpos = xsp;
    if (jj_3R_93()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_63() {
    if (jj_scan_token(T_EQUIVALENT)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_57() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_63()) {
    jj_scanpos = xsp;
    if (jj_3R_64()) {
    jj_scanpos = xsp;
    if (jj_3R_65()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_32() {
    if (jj_3R_37()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_88()) { jj_scanpos = xsp; break; }
      if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    }
    return false;
  }

  final private boolean jj_3R_60() {
    if (jj_scan_token(T_OPEN_PAREN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_35()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_85() {
    if (jj_scan_token(T_FLOAT_LIT)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_53() {
    if (jj_3R_56()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_57()) { jj_scanpos = xsp; break; }
      if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    }
    return false;
  }

  final private boolean jj_3R_59() {
    if (jj_3R_33()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_58() {
    if (jj_3R_66()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_55() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_58()) {
    jj_scanpos = xsp;
    if (jj_3R_59()) {
    jj_scanpos = xsp;
    if (jj_3R_60()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_54() {
    if (jj_scan_token(T_AND)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_31() {
    if (jj_scan_token(T_HYPHEN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_30() {
    if (jj_scan_token(T_PLUS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_52() {
    if (jj_3R_55()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_47() {
    if (jj_3R_53()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_54()) { jj_scanpos = xsp; break; }
      if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    }
    return false;
  }

  final private boolean jj_3R_34() {
    if (jj_3R_38()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_3() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_30()) {
    jj_scanpos = xsp;
    if (jj_3R_31()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_32()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_67() {
    if (jj_3R_32()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_3()) { jj_scanpos = xsp; break; }
      if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    }
    return false;
  }

  final private boolean jj_3_4() {
    if (jj_3R_33()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(T_OPEN_PAREN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_34()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(T_CLOSE_PAREN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_29() {
    if (jj_scan_token(T_COLON)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_46() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_4()) {
    jj_scanpos = xsp;
    if (jj_3R_52()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_48() {
    if (jj_scan_token(T_XOR)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_2() {
    if (jj_3R_28()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_29()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(T_SEMICOLON)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_43() {
    if (jj_3R_47()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_48()) { jj_scanpos = xsp; break; }
      if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    }
    return false;
  }

  final private boolean jj_3R_97() {
    if (jj_3R_86()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_84() {
    if (jj_scan_token(T_SHIFT_RIGHT)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_51() {
    if (jj_scan_token(T_TILDE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_96() {
    if (jj_3R_85()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_83() {
    if (jj_scan_token(T_SHIFT_LEFT)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_68() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_83()) {
    jj_scanpos = xsp;
    if (jj_3R_84()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_50() {
    if (jj_scan_token(T_NOT)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_87() {
    if (jj_scan_token(T_OPEN_CURLY)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_96()) {
    jj_scanpos = xsp;
    if (jj_3R_97()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_49() {
    if (jj_scan_token(T_IS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_27() {
    if (jj_3R_33()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_44() {
    if (jj_scan_token(T_OR)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_61() {
    if (jj_3R_67()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_68()) { jj_scanpos = xsp; break; }
      if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    }
    return false;
  }

  final private boolean jj_3R_45() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_49()) {
    jj_scanpos = xsp;
    if (jj_3R_50()) {
    jj_scanpos = xsp;
    if (jj_3R_51()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_42() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_45()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_46()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_39() {
    if (jj_3R_43()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_44()) { jj_scanpos = xsp; break; }
      if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    }
    return false;
  }

  final private boolean jj_3R_33() {
    if (jj_scan_token(T_IDENTIFIER)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_82() {
    if (jj_scan_token(T_CHARACTER)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_35() {
    if (jj_3R_39()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_1() {
    if (jj_scan_token(T_COMMA)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_27()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_81() {
    if (jj_scan_token(T_STRING_LIT)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_80() {
    if (jj_3R_87()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_72() {
    if (jj_scan_token(T_GREATER_EQUAL)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_79() {
    if (jj_3R_86()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_95() {
    if (jj_scan_token(T_POWER)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_71() {
    if (jj_scan_token(T_LESS_EQUAL)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_78() {
    if (jj_3R_85()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_94() {
    if (jj_scan_token(T_CARET)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_70() {
    if (jj_scan_token(T_CLOSE_ANGLE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_89() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_94()) {
    jj_scanpos = xsp;
    if (jj_3R_95()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_69() {
    if (jj_scan_token(T_OPEN_ANGLE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_77() {
    if (jj_scan_token(T_FALSE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_62() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_69()) {
    jj_scanpos = xsp;
    if (jj_3R_70()) {
    jj_scanpos = xsp;
    if (jj_3R_71()) {
    jj_scanpos = xsp;
    if (jj_3R_72()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_37() {
    if (jj_3R_42()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_89()) { jj_scanpos = xsp; break; }
      if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    }
    return false;
  }

  final private boolean jj_3R_41() {
    if (jj_scan_token(T_IF_AND_ONLY_IF)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_76() {
    if (jj_scan_token(T_TRUE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_40() {
    if (jj_scan_token(T_IMPLIES)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_56() {
    if (jj_3R_61()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_62()) { jj_scanpos = xsp; break; }
      if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    }
    return false;
  }

  final private boolean jj_3R_36() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_40()) {
    jj_scanpos = xsp;
    if (jj_3R_41()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_75() {
    if (jj_scan_token(T_RESULT)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_38() {
    if (jj_3R_35()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  public ParserTokenManager token_source;
  SimpleCharStream jj_input_stream;
  public Token token, jj_nt;
  private int jj_ntk;
  private Token jj_scanpos, jj_lastpos;
  private int jj_la;
  public boolean lookingAhead = false;
  private boolean jj_semLA;
  private int jj_gen;
  final private int[] jj_la1 = new int[83];
  final private int[] jj_la1_0 = {0x0,0x20000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8c00000,0x0,0x8c00000,0x400000,0x10000000,0x0,0x0,0x0,0x0,0x1400000,0x0,0x0,0x0,0x0,0x0,0x10000000,0x1000000,0x0,0x0,0x400000,0x400000,0x1000000,0x1000000,0x0,0x0,0xc1000000,0x0,0x0,0x0,0x0,0x0,0x2000000,0x4000000,0x0,0x1000000,0xc0000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,};
  final private int[] jj_la1_1 = {0x400,0x0,0x201,0x0,0x0,0x4000,0x1,0x0,0x4000,0x209,0x0,0x209,0x0,0x0,0x0,0x4,0x0,0x2,0xffd8801,0x0,0x0,0x0,0x0,0x0,0x0,0xffd8000,0x0,0x10,0x801,0x801,0x0,0xffd8000,0x0,0x0,0x100,0x60,0x60,0x0,0x2000,0x400,0x0,0x0,0x1000,0x0,0x100,0xfff0000,0xffd0000,0x0,0x0,0x0,0x0,0x0,0xffd0000,0x50000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xc0000000,0xc0000000,0x30000000,0x30000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,};
  final private int[] jj_la1_2 = {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4000000,0x0,0x0,0x0,0x100,0x0,0x100,0x0,0x0,0x4000000,0x100,0x4000000,0x1,0x100,0x0,0x0,0x4000000,0x0,0x0,0x0,0x0,0x0,0x40000,0x100,0x0,0x0,0x0,0x100,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x100,0x0,0x0,0x100,0x0,0x0,0x100,0x100,0x80,0x1800,0x1800,0x200000,0x80000000,0x2,0x20000,0x20000,0x4200,0x4200,0x18000000,0x18000000,0x800400,0x21008004,0x21008004,0x400008,0x400008,0x40012000,0x40012000,0x40192000,0x180000,0x180000,0x80000,0x0,0x0,0x100,0x2000000,};
  final private int[] jj_la1_3 = {0x0,0x0,0x0,0x2c0,0x2c0,0x0,0x0,0x2c0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20,0x0,0x0,0x0,0x0,0x0,0x0,0x20,0x0,0x0,0x0,0x0,0x0,0x20,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20,0x20,0xc000,0x0,0xc000,0xc100,0x0,0x20,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x31bf,0x31bf,0x31bf,0x319f,0x180,0x180,0x0,0x0,};
  final private JJCalls[] jj_2_rtns = new JJCalls[4];
  private boolean jj_rescan = false;
  private int jj_gc = 0;

  public Parser(java.io.InputStream stream) {
    jj_input_stream = new SimpleCharStream(stream, 1, 1);
    token_source = new ParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 83; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public void ReInit(java.io.InputStream stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 83; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public Parser(java.io.Reader stream) {
    jj_input_stream = new SimpleCharStream(stream, 1, 1);
    token_source = new ParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 83; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public void ReInit(java.io.Reader stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 83; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public Parser(ParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 83; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public void ReInit(ParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 83; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  final private Token jj_consume_token(int kind) throws ParseException {
    Token oldToken;
    if ((oldToken = token).next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    if (token.kind == kind) {
      jj_gen++;
      if (++jj_gc > 100) {
        jj_gc = 0;
        for (int i = 0; i < jj_2_rtns.length; i++) {
          JJCalls c = jj_2_rtns[i];
          while (c != null) {
            if (c.gen < jj_gen) c.first = null;
            c = c.next;
          }
        }
      }
      return token;
    }
    token = oldToken;
    jj_kind = kind;
    throw generateParseException();
  }

  final private boolean jj_scan_token(int kind) {
    if (jj_scanpos == jj_lastpos) {
      jj_la--;
      if (jj_scanpos.next == null) {
        jj_lastpos = jj_scanpos = jj_scanpos.next = token_source.getNextToken();
      } else {
        jj_lastpos = jj_scanpos = jj_scanpos.next;
      }
    } else {
      jj_scanpos = jj_scanpos.next;
    }
    if (jj_rescan) {
      int i = 0; Token tok = token;
      while (tok != null && tok != jj_scanpos) { i++; tok = tok.next; }
      if (tok != null) jj_add_error_token(kind, i);
    }
    return (jj_scanpos.kind != kind);
  }

  final public Token getNextToken() {
    if (token.next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    jj_gen++;
    return token;
  }

  final public Token getToken(int index) {
    Token t = lookingAhead ? jj_scanpos : token;
    for (int i = 0; i < index; i++) {
      if (t.next != null) t = t.next;
      else t = t.next = token_source.getNextToken();
    }
    return t;
  }

  final private int jj_ntk() {
    if ((jj_nt=token.next) == null)
      return (jj_ntk = (token.next=token_source.getNextToken()).kind);
    else
      return (jj_ntk = jj_nt.kind);
  }

  private java.util.Vector jj_expentries = new java.util.Vector();
  private int[] jj_expentry;
  private int jj_kind = -1;
  private int[] jj_lasttokens = new int[100];
  private int jj_endpos;

  private void jj_add_error_token(int kind, int pos) {
    if (pos >= 100) return;
    if (pos == jj_endpos + 1) {
      jj_lasttokens[jj_endpos++] = kind;
    } else if (jj_endpos != 0) {
      jj_expentry = new int[jj_endpos];
      for (int i = 0; i < jj_endpos; i++) {
        jj_expentry[i] = jj_lasttokens[i];
      }
      boolean exists = false;
      for (java.util.Enumeration enum = jj_expentries.elements(); enum.hasMoreElements();) {
        int[] oldentry = (int[])(enum.nextElement());
        if (oldentry.length == jj_expentry.length) {
          exists = true;
          for (int i = 0; i < jj_expentry.length; i++) {
            if (oldentry[i] != jj_expentry[i]) {
              exists = false;
              break;
            }
          }
          if (exists) break;
        }
      }
      if (!exists) jj_expentries.addElement(jj_expentry);
      if (pos != 0) jj_lasttokens[(jj_endpos = pos) - 1] = kind;
    }
  }

  final public ParseException generateParseException() {
    jj_expentries.removeAllElements();
    boolean[] la1tokens = new boolean[113];
    for (int i = 0; i < 113; i++) {
      la1tokens[i] = false;
    }
    if (jj_kind >= 0) {
      la1tokens[jj_kind] = true;
      jj_kind = -1;
    }
    for (int i = 0; i < 83; i++) {
      if (jj_la1[i] == jj_gen) {
        for (int j = 0; j < 32; j++) {
          if ((jj_la1_0[i] & (1<<j)) != 0) {
            la1tokens[j] = true;
          }
          if ((jj_la1_1[i] & (1<<j)) != 0) {
            la1tokens[32+j] = true;
          }
          if ((jj_la1_2[i] & (1<<j)) != 0) {
            la1tokens[64+j] = true;
          }
          if ((jj_la1_3[i] & (1<<j)) != 0) {
            la1tokens[96+j] = true;
          }
        }
      }
    }
    for (int i = 0; i < 113; i++) {
      if (la1tokens[i]) {
        jj_expentry = new int[1];
        jj_expentry[0] = i;
        jj_expentries.addElement(jj_expentry);
      }
    }
    jj_endpos = 0;
    jj_rescan_token();
    jj_add_error_token(0, 0);
    int[][] exptokseq = new int[jj_expentries.size()][];
    for (int i = 0; i < jj_expentries.size(); i++) {
      exptokseq[i] = (int[])jj_expentries.elementAt(i);
    }
    return new ParseException(token, exptokseq, tokenImage);
  }

  final public void enable_tracing() {
  }

  final public void disable_tracing() {
  }

  final private void jj_rescan_token() {
    jj_rescan = true;
    for (int i = 0; i < 4; i++) {
      JJCalls p = jj_2_rtns[i];
      do {
        if (p.gen > jj_gen) {
          jj_la = p.arg; jj_lastpos = jj_scanpos = p.first;
          switch (i) {
            case 0: jj_3_1(); break;
            case 1: jj_3_2(); break;
            case 2: jj_3_3(); break;
            case 3: jj_3_4(); break;
          }
        }
        p = p.next;
      } while (p != null);
    }
    jj_rescan = false;
  }

  final private void jj_save(int index, int xla) {
    JJCalls p = jj_2_rtns[index];
    while (p.gen > jj_gen) {
      if (p.next == null) { p = p.next = new JJCalls(); break; }
      p = p.next;
    }
    p.gen = jj_gen + xla - jj_la; p.first = token; p.arg = xla;
  }

  static final class JJCalls {
    int gen;
    Token first;
    int arg;
    JJCalls next;
  }

}
