/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.serialize;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import org.apache.xerces.util.EncodingMap;
import sun.io.CharToByteConverter;

public class EncodingInfo {
    String ianaName;
    String javaName;
    int lastPrintable;
    CharToByteConverter fCToB = null;
    boolean fHaveTriedCToB = false;

    public EncodingInfo(String string, String string2, int n) {
        this.ianaName = string;
        this.javaName = EncodingMap.getIANA2JavaMapping(string);
        this.lastPrintable = n;
    }

    public String getIANAName() {
        return this.ianaName;
    }

    public Writer getWriter(OutputStream outputStream) throws UnsupportedEncodingException {
        if (this.javaName != null) {
            return new OutputStreamWriter(outputStream, this.javaName);
        }
        this.javaName = EncodingMap.getIANA2JavaMapping(this.ianaName);
        if (this.javaName == null) {
            return new OutputStreamWriter(outputStream, "UTF8");
        }
        return new OutputStreamWriter(outputStream, this.javaName);
    }

    public boolean isPrintable(char c) {
        if (c <= this.lastPrintable) {
            return true;
        }
        if (this.fCToB == null) {
            if (this.fHaveTriedCToB) {
                return false;
            }
            try {
                this.fCToB = CharToByteConverter.getConverter((String)this.javaName);
            }
            catch (Exception exception) {
                this.fHaveTriedCToB = true;
                return false;
            }
        }
        try {
            return this.fCToB.canConvert(c);
        }
        catch (Exception exception) {
            this.fCToB = null;
            this.fHaveTriedCToB = false;
            return false;
        }
    }

    public static void testJavaEncodingName(String string) throws UnsupportedEncodingException {
        byte[] byArray = new byte[]{118, 97, 108, 105, 100};
        String string2 = new String(byArray, string);
    }
}

