/*
 * Decompiled with CFR 0.152.
 */
package gov.llnl.babel.url.cookie;

import gov.llnl.babel.url.cookie.LexicalException;
import gov.llnl.babel.url.cookie.Token;
import java.io.IOException;
import java.io.Reader;

public class Lexer {
    private static final int s_BETWEEN = 0;
    private static final int s_TOKEN = 1;
    private static final int s_STRING = 2;
    private static final int s_STRING_QUOTE = 3;
    private static final int s_STRING_CR = 4;
    private static final int s_STRING_NL = 5;
    private Reader d_charSource = null;
    private int d_state = 0;
    private char[] d_text;
    private int d_charCount = 0;
    private int d_pushBack;
    private boolean d_pushed = false;

    public Lexer(Reader charSource) {
        this.d_charSource = charSource;
        this.d_text = new char[256];
    }

    private void pushBack(int ch) {
        this.d_pushBack = ch;
        this.d_pushed = true;
        --this.d_charCount;
    }

    private void reset() {
        this.d_charCount = 0;
        this.d_state = 0;
    }

    private int getNextChar() throws IOException {
        int ch;
        if (this.d_pushed) {
            ch = this.d_pushBack;
            this.d_pushed = false;
        } else {
            ch = this.d_charSource.read();
        }
        if (ch >= 0) {
            if (this.d_charCount >= this.d_text.length) {
                char[] newarray = new char[this.d_text.length + (this.d_text.length >> 1)];
                System.arraycopy(this.d_text, 0, newarray, 0, this.d_text.length);
                this.d_text = newarray;
            }
            this.d_text[this.d_charCount++] = (char)ch;
        }
        return ch;
    }

    public static boolean validTokenChar(char ch) {
        return !(ch >= '\u007f' || ch < ' ' || ch >= ':' && ch <= '@' || ch >= '[' && ch <= ']' || ch == '(' || ch == ')' || ch == ',' || ch == '\"' || ch == '/' || ch == '{' || ch == '}' || Character.isWhitespace(ch));
    }

    public Token nextToken() throws IOException, LexicalException {
        this.reset();
        block8: while (true) {
            int ch = this.getNextChar();
            switch (this.d_state) {
                case 0: {
                    if (ch == 61 || ch == 44 || ch == 59) {
                        return new Token(ch, new String(this.d_text, this.d_charCount - 1, 1));
                    }
                    if (ch == 34) {
                        --this.d_charCount;
                        this.d_state = 2;
                        continue block8;
                    }
                    if (Character.isWhitespace((char)ch)) {
                        --this.d_charCount;
                        continue block8;
                    }
                    if (Lexer.validTokenChar((char)ch)) {
                        this.d_state = 1;
                        continue block8;
                    }
                    if (ch == -1) {
                        return new Token(0, "");
                    }
                    throw new LexicalException("Unacceptable character in cookie stream '" + ch + "'  '\\u" + Integer.toHexString(ch) + "'");
                }
                case 1: {
                    if (Lexer.validTokenChar((char)ch)) continue block8;
                    this.pushBack(ch);
                    return new Token(1, new String(this.d_text, 0, this.d_charCount));
                }
                case 2: {
                    if (ch == 92) {
                        this.d_state = 3;
                        continue block8;
                    }
                    if (ch == 34) {
                        return new Token(2, new String(this.d_text, 0, this.d_charCount - 1));
                    }
                    if (ch == 13) {
                        this.d_state = 4;
                        continue block8;
                    }
                    if (Character.isISOControl((char)ch) && ch != 9) {
                        throw new LexicalException("Unacceptable character in quoted string '" + ch + "' '\\u" + Integer.toHexString(ch) + "'");
                    }
                    if (ch != -1) continue block8;
                    throw new LexicalException("Unterminated quoted string end of string encountered");
                }
                case 3: {
                    if (ch >= 0 && ch <= 127) {
                        this.d_state = 2;
                        continue block8;
                    }
                    throw new LexicalException("Bad character following backslash in quoted string.");
                }
                case 4: {
                    if (ch == 10) {
                        this.d_state = 5;
                        continue block8;
                    }
                    throw new LexicalException("Unquoted carriage return without newline following.");
                }
                case 5: {
                    if (ch == 9 || ch == 32) {
                        this.d_state = 2;
                        continue block8;
                    }
                    throw new LexicalException("Unquoted carriage return newline without tab or space following");
                }
            }
            break;
        }
        throw new LexicalException("Unexpected state in cookie lexer = " + this.d_state);
    }
}

