/*
 * Decompiled with CFR 0.152.
 */
package gov.llnl.babel.backend.rmi2;

import gov.llnl.babel.backend.CodeGenerationException;
import gov.llnl.babel.backend.IOR;
import gov.llnl.babel.backend.rmi2.Cxx;
import gov.llnl.babel.backend.writers.LanguageWriterForCxx;
import gov.llnl.babel.symbols.Extendable;
import gov.llnl.babel.symbols.Method;
import gov.llnl.babel.symbols.SymbolID;
import java.util.Iterator;

public class CxxStubHeader {
    private Extendable d_ext = null;
    private LanguageWriterForCxx d_writer = null;

    public CxxStubHeader(Extendable ext) {
        this.d_ext = ext;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void generateCode() throws CodeGenerationException {
        String filename = Cxx.generateFilename(this.d_ext.getSymbolID(), 3, 1);
        try {
            try {
                this.d_writer = Cxx.createHeader(this.d_ext, 3, "STUBHDRS");
                this.d_writer.println();
                this.d_writer.openHeaderGuard(filename);
                this.writeClassDeclaration();
                Cxx.generateDependencyIncludes(this.d_writer, this.d_ext, true);
                Cxx.nestPackagesInNamespaces(this.d_writer, this.d_ext);
                this.writeClassBegin();
                this.writeUserDefinedMethods();
                this.writeTypedefs();
                this.writeConstructors();
                this.writeCastingOperators();
                this.writeBindingSpecificMethods();
                this.writeClassEnd();
                Cxx.unnestPackagesInNamespaces(this.d_writer, this.d_ext);
                this.writeArrayDefinition();
                this.d_writer.closeHeaderGuard();
            }
            catch (Exception ex) {
                throw new CodeGenerationException("Exception : " + ex.getMessage());
            }
            Object var4_2 = null;
            if (this.d_writer == null) return;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            if (this.d_writer == null) throw throwable;
            this.d_writer.close();
            this.d_writer = null;
            throw throwable;
        }
        this.d_writer.close();
        this.d_writer = null;
    }

    private void writeClassDeclaration() {
        SymbolID id = this.d_ext.getSymbolID();
        String name = id.getShortName();
        this.d_writer.writeCommentLine("declare class before #includes");
        this.d_writer.writeCommentLine("(this alleviates circular #include guard problems)[BUG#393]");
        Cxx.nestPackagesInNamespaces(this.d_writer, this.d_ext);
        this.d_writer.println("class " + name + ";");
        Cxx.unnestPackagesInNamespaces(this.d_writer, this.d_ext);
        this.d_writer.writeCommentLine("Some compilers need to define array template before the specializations");
        this.d_writer.generateInclude("sidl_cxx.hh", true);
        this.d_writer.println("namespace sidl {");
        this.d_writer.tab();
        this.d_writer.println("template<>");
        this.d_writer.println("class array< " + Cxx.getObjectName(id) + " >;");
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.println();
    }

    private void writeClassBegin() {
        SymbolID id = this.d_ext.getSymbolID();
        String name = id.getShortName();
        this.d_writer.writeComment(this.d_ext, true);
        this.d_writer.println("class " + name + " : public ::sidl::StubBase {");
        this.d_writer.tab();
    }

    private void writeUserDefinedMethods() throws CodeGenerationException {
        Method method;
        this.d_writer.beginBoldComment();
        this.d_writer.println("User Defined Methods");
        this.d_writer.endBoldComment();
        this.d_writer.backTab();
        this.d_writer.println("public:");
        this.d_writer.tab();
        Iterator m = null;
        m = this.d_ext.getStaticMethods(true).iterator();
        while (m.hasNext()) {
            method = (Method)m.next();
            Cxx.generateMethodSignature(this.d_writer, method, "user defined static method", 3);
            this.d_writer.println();
        }
        m = this.d_ext.getNonstaticMethods(true).iterator();
        while (m.hasNext()) {
            method = (Method)m.next();
            Cxx.generateMethodSignature(this.d_writer, method, "user defined non-static method.", 3);
            this.d_writer.println();
        }
        this.d_writer.beginBoldComment();
        this.d_writer.println("End User Defined Methods");
        this.d_writer.println("(everything else in this file is specific to");
        this.d_writer.println(" Babel's C++ bindings)");
        this.d_writer.endBoldComment();
    }

    private void writeTypedefs() {
        SymbolID id = this.d_ext.getSymbolID();
        this.d_writer.backTab();
        this.d_writer.println("public:");
        this.d_writer.tab();
        this.d_writer.println("typedef " + IOR.getObjectName(id) + " ior_t;");
        this.d_writer.println("typedef " + IOR.getExternalName(id) + " ext_t;");
        this.d_writer.println("typedef " + IOR.getSEPVName(id) + " sepv_t;");
        this.d_writer.println();
    }

    private void writeConstructors() {
        SymbolID id = this.d_ext.getSymbolID();
        String ior_ptr = "ior_t*";
        String name = id.getShortName();
        this.d_writer.writeCommentLine("default constructor");
        this.d_writer.println(name + "() : d_self(0), d_weak_reference(false) { }");
        this.d_writer.println();
        if (!this.d_ext.isAbstract()) {
            this.d_writer.writeCommentLine("static constructor");
            this.d_writer.println("static " + Cxx.getObjectName(id) + " _create();");
            this.d_writer.println();
        }
        this.d_writer.writeCommentLine("default destructor");
        this.d_writer.println("virtual ~" + name + " ();");
        this.d_writer.println();
        this.d_writer.writeCommentLine("copy constructor");
        this.d_writer.println(name + " ( const " + name + "& original );");
        this.d_writer.println();
        this.d_writer.writeCommentLine("assignment operator");
        this.d_writer.println(name + "& operator= ( const " + name + "& rhs );");
        this.d_writer.println();
    }

    private void writeCastingOperators() {
        SymbolID id = this.d_ext.getSymbolID();
        String name = id.getShortName();
        String ior_ptr = "ior_t*";
        this.d_writer.writeCommentLine("conversion from ior to C++ class");
        this.d_writer.println(name + " ( " + name + "::ior_t* ior );");
        this.d_writer.println();
        this.d_writer.writeCommentLine("Alternate constructor: does not call addRef()");
        this.d_writer.writeCommentLine("(sets d_weak_reference=isWeak)");
        this.d_writer.writeCommentLine("For internal use by Impls (fixes bug#275)");
        this.d_writer.println(name + " ( " + name + "::ior_t* ior, bool isWeak );");
        this.d_writer.println();
        this.d_writer.writeCommentLine("conversion from a StubBase");
        this.d_writer.println(name + " ( const ::sidl::StubBase& base );");
        this.d_writer.println();
    }

    private void writeBindingSpecificMethods() {
        SymbolID id = this.d_ext.getSymbolID();
        String name = id.getShortName();
        String ior_ptr = "ior_t*";
        this.d_writer.println(ior_ptr + " _get_ior() { return d_self; }");
        this.d_writer.println();
        this.d_writer.println("const " + ior_ptr + " _get_ior() const { return d_self; }");
        this.d_writer.println();
        this.d_writer.println("void _set_ior( " + ior_ptr + " ptr ) { d_self = ptr; }");
        this.d_writer.println();
        this.d_writer.println("bool _is_nil() const { return (d_self==0); }");
        this.d_writer.println();
        this.d_writer.println("bool _not_nil() const { return (d_self!=0); }");
        this.d_writer.println();
        this.d_writer.println("bool operator !() const { return (d_self==0); }");
        this.d_writer.println();
        this.d_writer.backTab();
        this.d_writer.println("protected:");
        this.d_writer.tab();
        this.d_writer.println("virtual void* _cast(const char* type) const;");
        this.d_writer.println();
        this.d_writer.backTab();
        this.d_writer.println("private:");
        this.d_writer.tab();
        this.d_writer.writeCommentLine("Pointer to sidl's IOR type (one per instance)");
        this.d_writer.println("ior_t * d_self;");
        this.d_writer.println();
        this.d_writer.writeCommentLine("Weak references (used by Impl's only) don't add/deleteRef()");
        this.d_writer.println("bool d_weak_reference;");
        this.d_writer.println();
        this.d_writer.writeCommentLine("Pointer to external (DLL loadable) symbols (shared among instances)");
        this.d_writer.println("static const ext_t * s_ext;");
        this.d_writer.println();
        this.d_writer.backTab();
        this.d_writer.println("public:");
        this.d_writer.tab();
        this.d_writer.println("static const ext_t * _get_ext() throw ( ::sidl::NullIORException );");
        this.d_writer.println();
        if (this.d_ext.hasStaticMethod(true)) {
            this.d_writer.println("static const sepv_t * _get_sepv() {");
            this.d_writer.tab();
            this.d_writer.println("return (*(_get_ext()->getStaticEPV))();");
            this.d_writer.backTab();
            this.d_writer.println("}");
            this.d_writer.println();
        }
    }

    private void writeClassEnd() {
        String name = this.d_ext.getSymbolID().getShortName();
        this.d_writer.backTab();
        this.d_writer.println("}; // end class " + name);
    }

    private void writeArrayDefinition() {
        SymbolID id = this.d_ext.getSymbolID();
        String cxx_item_t = Cxx.getObjectName(id);
        String cxx_array_t = "array< " + cxx_item_t + " >";
        String ior_item_t = IOR.getObjectName(id);
        String ior_array_t = IOR.getArrayName(id);
        String array_traits = "array_traits< " + cxx_item_t + " >";
        this.d_writer.println("namespace sidl {");
        this.d_writer.tab();
        this.d_writer.writeCommentLine("traits specialization");
        this.d_writer.println("template<>");
        this.d_writer.println("struct " + array_traits + " {");
        this.d_writer.tab();
        this.d_writer.println("typedef " + cxx_array_t + " cxx_array_t;");
        this.d_writer.println("typedef " + cxx_item_t + " cxx_item_t;");
        this.d_writer.println("typedef " + ior_array_t + " ior_array_t;");
        this.d_writer.println("typedef sidl_interface__array ior_array_internal_t;");
        this.d_writer.println("typedef " + ior_item_t + " ior_item_t;");
        this.d_writer.println("typedef cxx_item_t value_type;");
        this.d_writer.println("typedef value_type reference;");
        this.d_writer.println("typedef value_type* pointer;");
        this.d_writer.println("typedef const value_type const_reference;");
        this.d_writer.println("typedef const value_type* const_pointer;");
        this.d_writer.println("typedef array_iter< " + array_traits + " > iterator;");
        this.d_writer.println("typedef const_array_iter< " + array_traits + " > const_iterator;");
        this.d_writer.backTab();
        this.d_writer.println("};");
        this.d_writer.println();
        this.d_writer.writeCommentLine("array specialization");
        this.d_writer.println("template<>");
        this.d_writer.println("class " + cxx_array_t + ": public interface_array< " + array_traits + " > {");
        this.d_writer.println("public:");
        this.d_writer.tab();
        this.d_writer.println("typedef interface_array< " + array_traits + " > Base;");
        this.d_writer.println("typedef " + array_traits + "::cxx_array_t          cxx_array_t;");
        this.d_writer.println("typedef " + array_traits + "::cxx_item_t           cxx_item_t;");
        this.d_writer.println("typedef " + array_traits + "::ior_array_t          ior_array_t;");
        this.d_writer.println("typedef " + array_traits + "::ior_array_internal_t ior_array_internal_t;");
        this.d_writer.println("typedef " + array_traits + "::ior_item_t           ior_item_t;");
        this.d_writer.println();
        this.d_writer.beginBlockComment(true);
        this.d_writer.println("conversion from ior to C++ class");
        this.d_writer.println("(constructor/casting operator)");
        this.d_writer.endBlockComment(true);
        this.d_writer.println("array( " + ior_array_t + "* src = 0) : Base(src) {}");
        this.d_writer.println();
        this.d_writer.beginBlockComment(true);
        this.d_writer.println("copy constructor");
        this.d_writer.endBlockComment(true);
        this.d_writer.println("array( const " + cxx_array_t + "&src) {");
        this.d_writer.tab();
        this.d_writer.println("d_array = src.d_array;");
        this.d_writer.println("if (d_array) addRef();");
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.println();
        this.d_writer.beginBlockComment(true);
        this.d_writer.println("assignment");
        this.d_writer.endBlockComment(true);
        this.d_writer.println(cxx_array_t + "&");
        this.d_writer.println("operator =( const " + cxx_array_t + "&rhs ) { ");
        this.d_writer.tab();
        this.d_writer.println("if (d_array != rhs.d_array) {");
        this.d_writer.tab();
        this.d_writer.println("if (d_array) deleteRef();");
        this.d_writer.println("d_array = rhs.d_array;");
        this.d_writer.println("if (d_array) addRef();");
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.println("return *this;");
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.println();
        this.d_writer.backTab();
        this.d_writer.println("};");
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.println();
    }
}

