/*
 * Decompiled with CFR 0.152.
 */
package gov.llnl.babel.backend.fortran;

import gov.llnl.babel.BabelConfiguration;
import gov.llnl.babel.CommandLineDriver;
import gov.llnl.babel.ResourceLoader;
import gov.llnl.babel.backend.CodeGenerationException;
import gov.llnl.babel.backend.CodeGenerator;
import gov.llnl.babel.backend.FileManager;
import gov.llnl.babel.backend.fortran.AbbrevHeader;
import gov.llnl.babel.backend.fortran.ArrayModule;
import gov.llnl.babel.backend.fortran.Fortran;
import gov.llnl.babel.backend.fortran.ModuleSource;
import gov.llnl.babel.backend.fortran.StubDoc;
import gov.llnl.babel.backend.fortran.StubSource;
import gov.llnl.babel.backend.fortran.TypeModule;
import gov.llnl.babel.backend.writers.LanguageWriterForC;
import gov.llnl.babel.backend.writers.LanguageWriterForFortran;
import gov.llnl.babel.symbols.Symbol;
import gov.llnl.babel.symbols.SymbolID;
import gov.llnl.babel.symbols.SymbolTable;
import gov.llnl.babel.symbols.Type;
import gov.llnl.babel.symbols.Version;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;

public class GenerateClient
implements CodeGenerator {
    private static final int[] s_basic_array_types = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10};
    private boolean d_writeBasicArrayStubs = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyArrayStub(String typeName, Writer out) throws CodeGenerationException {
        boolean isF90 = Fortran.isFortran90();
        String context = "gov/llnl/babel/backend/fortran/" + BabelConfiguration.getInstance().getTargetLanguage();
        ResourceLoader rl = new ResourceLoader();
        InputStream in = null;
        byte[] buffer = new byte[1024];
        try {
            try {
                int count;
                in = rl.getResourceStream(context + "/sidl_" + typeName + "_fStub.c");
                while ((count = in.read(buffer)) >= 0) {
                    String str = new String(buffer, 0, count);
                    out.write(str);
                }
            }
            finally {
                if (in != null) {
                    in.close();
                }
            }
        }
        catch (IOException ioe) {
            throw new CodeGenerationException(ioe.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyArrayAbbrev(String typeName, Writer out) throws CodeGenerationException {
        String context = "gov/llnl/babel/backend/fortran/" + BabelConfiguration.getInstance().getTargetLanguage();
        ResourceLoader rl = new ResourceLoader();
        InputStream in = null;
        byte[] buffer = new byte[1024];
        try {
            try {
                int count;
                in = rl.getResourceStream(context + "/sidl_" + typeName + "_fAbbrev.h");
                while ((count = in.read(buffer)) >= 0) {
                    String str = new String(buffer, 0, count);
                    out.write(str);
                }
            }
            finally {
                if (in != null) {
                    in.close();
                }
            }
        }
        catch (IOException ioe) {
            throw new CodeGenerationException(ioe.getMessage());
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void generateBasicArrayStubs() throws CodeGenerationException {
        Writer w;
        PrintWriter pw;
        block15: {
            BabelConfiguration config = BabelConfiguration.getInstance();
            pw = null;
            w = null;
            LanguageWriterForFortran forWriter = null;
            boolean isF90 = Fortran.isFortran90();
            boolean includeExternal = !config.excludeExternal();
            for (int i = 0; i < s_basic_array_types.length; ++i) {
                int type = s_basic_array_types[i];
                String typeName = new Type(type).getTypeString();
                SymbolID id = new SymbolID("sidl." + typeName, new Version());
                if (!includeExternal && !CommandLineDriver.isIncluded(id) || !CommandLineDriver.notExcluded(id)) continue;
                if (isF90) {
                    String filename = Fortran.getArrayFile(id);
                    pw = FileManager.getInstance().createFile(id, type, "ARRAYMODULESRCS", filename);
                    forWriter = new LanguageWriterForFortran(pw);
                    ArrayModule am = new ArrayModule(id, type, forWriter);
                    am.generateStub();
                    forWriter.close();
                }
                w = FileManager.getInstance().createFile(id, type, "STUBSRCS", Fortran.getStubFile(id));
                this.copyArrayStub(typeName, w);
                w.close();
                if (!Fortran.needsAbbrev()) continue;
                w = FileManager.getInstance().createFile(id, type, "STUBHDRS", Fortran.getStubNameFile(id));
                this.copyArrayAbbrev(typeName, w);
                w.flush();
                w.close();
            }
            if (!includeExternal) break block15;
            this.generateGenericArray();
        }
        Object var14_14 = null;
        try {
            if (w == null) return;
            w.close();
            return;
        }
        catch (IOException ioe) {
            throw new CodeGenerationException(ioe.getMessage());
        }
        finally {
            if (pw != null) {
                pw.close();
            }
        }
        {
            catch (IOException ioe) {
                throw new CodeGenerationException(ioe.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var14_15 = null;
            try {
                if (w != null) {
                    w.close();
                }
                if (pw == null) throw throwable;
                pw.close();
                throw throwable;
            }
            catch (IOException ioe) {
                try {}
                catch (Throwable throwable2) {
                    if (pw == null) throw throwable2;
                    pw.close();
                    throw throwable2;
                }
                throw new CodeGenerationException(ioe.getMessage());
            }
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void generateGenericArray() throws CodeGenerationException {
        Writer w;
        PrintWriter pw;
        block14: {
            pw = null;
            w = null;
            LanguageWriterForFortran forWriter = null;
            int type = 16;
            String typeName = "array";
            SymbolID id = new SymbolID("sidl.array", new Version());
            if (Fortran.isFortran90()) {
                String filename = "sidl_array_array.F90";
                pw = FileManager.getInstance().createFile(id, 16, "ARRAYMODULESRCS", filename);
                forWriter = new LanguageWriterForFortran(pw);
                ArrayModule am = new ArrayModule(forWriter);
                am.generateStub();
                forWriter.close();
                filename = "sidl_array_type.F90";
                pw = FileManager.getInstance().createFile(id, 16, "TYPEMODULESRCS", filename);
                forWriter = new LanguageWriterForFortran(pw);
                TypeModule.generateCode(null, forWriter);
                forWriter.close();
            }
            w = FileManager.getInstance().createFile(id, 16, "STUBSRCS", Fortran.getStubFile(id));
            this.copyArrayStub("array", w);
            w.close();
            if (!Fortran.needsAbbrev()) break block14;
            w = FileManager.getInstance().createFile(id, 16, "STUBHDRS", "sidl_array_fAbbrev.h");
            this.copyArrayAbbrev("array", w);
            w.flush();
            w.close();
        }
        Object var11_9 = null;
        try {
            if (w == null) return;
            w.close();
            return;
        }
        catch (IOException ioe) {
            throw new CodeGenerationException(ioe.getMessage());
        }
        finally {
            if (pw != null) {
                pw.close();
            }
        }
        {
            catch (IOException ioe) {
                throw new CodeGenerationException(ioe.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var11_10 = null;
            try {
                if (w != null) {
                    w.close();
                }
                if (pw == null) throw throwable;
                pw.close();
                throw throwable;
            }
            catch (IOException ioe) {
                try {}
                catch (Throwable throwable2) {
                    if (pw == null) throw throwable2;
                    pw.close();
                    throw throwable2;
                }
                throw new CodeGenerationException(ioe.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateStubSource(Symbol symbol) throws CodeGenerationException {
        PrintWriter pw = null;
        PrintWriter dw = null;
        PrintWriter nw = null;
        PrintWriter mw = null;
        SymbolID id = symbol.getSymbolID();
        int type = symbol.getSymbolType();
        boolean isF90 = Fortran.isFortran90();
        switch (type) {
            case 12: 
            case 13: {
                try {
                    String f = Fortran.getStubFile(id);
                    pw = FileManager.getInstance().createFile(id, type, "STUBSRCS", f);
                    LanguageWriterForC writer = new LanguageWriterForC(pw);
                    StubSource.generateCode(symbol, writer);
                    this.d_writeBasicArrayStubs = true;
                    if (Fortran.needsAbbrev()) {
                        String nf = Fortran.getStubNameFile(id);
                        nw = FileManager.getInstance().createFile(id, type, "STUBHDRS", nf);
                        writer = new LanguageWriterForC(nw);
                        AbbrevHeader.generateCode(symbol, writer);
                        writer.close();
                    }
                    if (isF90) {
                        String mf = Fortran.getModuleFile(id);
                        mw = FileManager.getInstance().createFile(id, type, "STUBMODULESRCS", mf);
                        LanguageWriterForFortran forWriter = new LanguageWriterForFortran(mw);
                        forWriter.writeBanner(symbol, mf, false, "Client-side module for " + symbol.getFullName());
                        ModuleSource.generateCode(symbol, forWriter);
                        ArrayModule am = new ArrayModule(id, type, forWriter);
                        am.generateStub();
                        forWriter.close();
                        String tf = Fortran.getTypeFile(id);
                        mw = FileManager.getInstance().createFile(id, type, "TYPEMODULESRCS", tf);
                        forWriter = new LanguageWriterForFortran(mw);
                        TypeModule.generateCode(symbol, forWriter);
                        forWriter.close();
                    } else {
                        String df = Fortran.getStubDocFile(id);
                        dw = FileManager.getInstance().createFile(id, type, "STUBDOCS", df);
                        LanguageWriterForFortran forWriter = new LanguageWriterForFortran(dw);
                        StubDoc.generateCode(symbol, forWriter);
                    }
                    Object var16_23 = null;
                    if (pw != null) {
                        pw.close();
                    }
                    if (dw != null) {
                        dw.close();
                    }
                    if (nw != null) {
                        nw.close();
                    }
                    if (mw == null) break;
                    mw.close();
                    break;
                }
                catch (Throwable throwable) {
                    Object var16_24 = null;
                    if (pw != null) {
                        pw.close();
                    }
                    if (dw != null) {
                        dw.close();
                    }
                    if (nw != null) {
                        nw.close();
                    }
                    if (mw != null) {
                        mw.close();
                    }
                    throw throwable;
                }
            }
            case 11: {
                try {
                    String nf = Fortran.getStubNameFile(id);
                    String f = Fortran.getEnumStubImpl(id);
                    this.d_writeBasicArrayStubs = true;
                    pw = FileManager.getInstance().createFile(id, type, "STUBSRCS", f);
                    LanguageWriterForC clw = new LanguageWriterForC(pw);
                    StubSource.generateCode(symbol, clw);
                    clw.close();
                    if (Fortran.needsAbbrev()) {
                        nw = FileManager.getInstance().createFile(id, type, "STUBHDRS", nf);
                        clw = new LanguageWriterForC(nw);
                        AbbrevHeader.generateCode(symbol, clw);
                        clw.close();
                    }
                    if (isF90) {
                        String mf = Fortran.getModuleFile(id);
                        mw = FileManager.getInstance().createFile(id, type, "STUBMODULESRCS", mf);
                        LanguageWriterForFortran forWriter = new LanguageWriterForFortran(mw);
                        ArrayModule am = new ArrayModule(id, type, forWriter);
                        forWriter.writeBanner(symbol, mf, false, "Client-side module for " + symbol.getFullName());
                        ModuleSource.generateCode(symbol, forWriter);
                        am.generateStub();
                        forWriter.close();
                        String tf = Fortran.getTypeFile(id);
                        mw = FileManager.getInstance().createFile(id, type, "TYPEMODULESRCS", tf);
                        forWriter = new LanguageWriterForFortran(mw);
                        TypeModule.generateCode(symbol, forWriter);
                    } else {
                        f = Fortran.getEnumStubFile(id);
                        pw = FileManager.getInstance().createFile(id, type, "STUBFORTRANINC", f);
                        LanguageWriterForFortran writer = new LanguageWriterForFortran(pw);
                        StubSource.generateCode(symbol, writer);
                        writer.close();
                    }
                    Object var18_27 = null;
                    if (pw != null) {
                        pw.close();
                    }
                    if (nw != null) {
                        nw.close();
                    }
                    if (mw == null) break;
                    mw.close();
                    break;
                }
                catch (Throwable throwable) {
                    Object var18_28 = null;
                    if (pw != null) {
                        pw.close();
                    }
                    if (nw != null) {
                        nw.close();
                    }
                    if (mw != null) {
                        mw.close();
                    }
                    throw throwable;
                }
            }
        }
    }

    public void generateCode(Set symbols) throws CodeGenerationException {
        Iterator i = symbols.iterator();
        SymbolTable table = SymbolTable.getInstance();
        while (i.hasNext()) {
            SymbolID id = (SymbolID)i.next();
            Symbol symbol = table.lookupSymbol(id);
            if (symbol == null) continue;
            this.generateStubSource(symbol);
        }
        if (this.d_writeBasicArrayStubs) {
            this.generateBasicArrayStubs();
        }
    }

    public String getType() {
        return "stub";
    }

    public boolean getUserSymbolsOnly() {
        return false;
    }

    public Set getLanguages() {
        TreeSet<String> result = new TreeSet<String>();
        result.add("f77");
        result.add("f77_31");
        result.add("f90");
        return result;
    }
}

