/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.webplugin.remoteui.xml.server;

import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.Iterator;
import java.util.Map;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.xml.simpleparser.SimpleXMLParserDocumentFactory;
import org.gudy.azureus2.core3.xml.util.XUXmlWriter;
import org.gudy.azureus2.plugins.utils.xml.simpleparser.SimpleXMLParserDocument;
import org.gudy.azureus2.plugins.utils.xml.simpleparser.SimpleXMLParserDocumentAttribute;
import org.gudy.azureus2.plugins.utils.xml.simpleparser.SimpleXMLParserDocumentException;
import org.gudy.azureus2.plugins.utils.xml.simpleparser.SimpleXMLParserDocumentNode;
import org.gudy.azureus2.pluginsimpl.remote.RPException;
import org.gudy.azureus2.pluginsimpl.remote.RPObject;
import org.gudy.azureus2.pluginsimpl.remote.RPReply;
import org.gudy.azureus2.pluginsimpl.remote.RPRequest;
import org.gudy.azureus2.pluginsimpl.remote.RPRequestAccessController;
import org.gudy.azureus2.pluginsimpl.remote.RPRequestHandler;

public class XMLRequestProcessor
extends XUXmlWriter {
    protected RPRequestHandler request_handler;
    protected SimpleXMLParserDocument request;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;
    static /* synthetic */ Class class$8;
    static /* synthetic */ Class class$9;
    static /* synthetic */ Class class$10;
    static /* synthetic */ Class class$11;
    static /* synthetic */ Class class$12;

    protected XMLRequestProcessor(RPRequestHandler _request_handler, RPRequestAccessController _access_controller, String _client_ip, InputStream _request, OutputStream _reply) {
        block6: {
            super(_reply);
            this.request_handler = _request_handler;
            this.writeLineRaw("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            try {
                try {
                    this.writeLineRaw("<RESPONSE>");
                    this.indent();
                    this.request = SimpleXMLParserDocumentFactory.create(_request);
                    this.process(_client_ip, _access_controller);
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                    if (e instanceof SimpleXMLParserDocumentException) {
                        this.writeTag("ERROR", "Invalid XML Plugin request received - " + this.exceptionToString(e));
                        break block6;
                    }
                    this.writeTag("ERROR", e);
                }
            }
            finally {
                this.exdent();
                this.writeLineRaw("</RESPONSE>");
                this.flushOutputStream();
            }
        }
    }

    protected void process(String client_ip, RPRequestAccessController access_controller) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.gudy.azureus2.pluginsimpl.remote.RPRequest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        RPRequest req_obj = (RPRequest)this.deserialiseObject(this.request, clazz, "");
        req_obj.setClientIP(client_ip);
        RPReply reply = this.request_handler.processRequest(req_obj, access_controller);
        if (reply != null) {
            Map props = reply.getProperties();
            Iterator it = props.keySet().iterator();
            while (it.hasNext()) {
                String name = (String)it.next();
                String value = (String)props.get(name);
                this.writeTag(name, value);
            }
            try {
                Object response = reply.getResponse();
                if (response != null) {
                    this.serialiseObject(response, "", -1);
                }
            }
            catch (RPException e) {
                Debug.printStackTrace(e);
                this.writeTag("ERROR", e);
            }
        }
    }

    protected void writeTag(String tag, Throwable e) {
        this.writeLineRaw("<ERROR>");
        this.writeLineEscaped(this.exceptionToString(e));
        if (e instanceof RPException && e.getCause() != null) {
            e = e.getCause();
        }
        this.serialiseObject(e, "    ", -3);
        this.writeLineRaw("</ERROR>");
    }

    protected String exceptionToString(Throwable e) {
        Throwable cause = e.getCause();
        if (cause != null) {
            String m = cause.getMessage();
            if (m != null) {
                return m;
            }
            return cause.toString();
        }
        String m = e.getMessage();
        if (m != null) {
            return m;
        }
        return e.toString();
    }

    protected Object deserialiseObject(SimpleXMLParserDocumentNode node, Class cla, String indent) {
        String request_method = null;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.gudy.azureus2.pluginsimpl.remote.RPRequest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (cla == clazz) {
            request_method = node.getChild("METHOD").getValue().trim();
        }
        try {
            Object obj = cla.newInstance();
            Field[] fields = cla.getDeclaredFields();
            int i = 0;
            while (i < fields.length) {
                Field field = fields[i];
                int modifiers = field.getModifiers();
                if ((modifiers & 0x88) == 0) {
                    String name = field.getName();
                    Class<?> type = field.getType();
                    SimpleXMLParserDocumentNode child = node.getChild(name);
                    if (child != null) {
                        if (type.isArray()) {
                            Class<?> sub_type = type.getComponentType();
                            SimpleXMLParserDocumentNode[] entries = child.getChildren();
                            Object array = Array.newInstance(sub_type, entries.length);
                            if (request_method != null) {
                                String[] bits = new String[entries.length];
                                int method_pos = request_method.indexOf(91) + 1;
                                int j = 0;
                                while (j < entries.length) {
                                    int p1 = request_method.indexOf(44, method_pos);
                                    if (p1 == -1) {
                                        bits[j] = request_method.substring(method_pos, request_method.length() - 1).toLowerCase();
                                        break;
                                    }
                                    bits[j] = request_method.substring(method_pos, p1).toLowerCase();
                                    method_pos = p1 + 1;
                                    ++j;
                                }
                                j = 0;
                                while (j < entries.length) {
                                    SimpleXMLParserDocumentNode array_child = entries[j];
                                    SimpleXMLParserDocumentAttribute index_attr = array_child.getAttribute("index");
                                    String index_str = index_attr == null ? null : index_attr.getValue().trim();
                                    int array_index = index_str == null ? j : Integer.parseInt(index_str);
                                    String bit = bits[array_index];
                                    String sub_value = array_child.getValue().trim();
                                    if (bit.equals("string")) {
                                        Array.set(array, array_index, sub_value);
                                    } else if (bit.equals("int")) {
                                        Array.set(array, array_index, Integer.valueOf(sub_value));
                                    } else if (bit.equals("boolean")) {
                                        Array.set(array, array_index, Boolean.valueOf(sub_value));
                                    } else if (bit.equals("url")) {
                                        Array.set(array, array_index, new URL(sub_value));
                                    } else if (bit.equals("byte[]")) {
                                        Array.set(array, array_index, ByteFormatter.decodeString(sub_value));
                                    } else {
                                        SimpleXMLParserDocumentNode obj_node = array_child.getChild("OBJECT");
                                        if (obj_node != null) {
                                            String oid_str = obj_node.getChild("_object_id").getValue().trim();
                                            long oid = Long.parseLong(oid_str);
                                            RPObject local_obj = RPObject._lookupLocal(oid);
                                            Array.set(array, array_index, local_obj);
                                        } else {
                                            throw new RuntimeException("not implemented");
                                        }
                                    }
                                    ++j;
                                }
                            } else {
                                int j = 0;
                                while (j < entries.length) {
                                    SimpleXMLParserDocumentNode array_child = entries[j];
                                    Class<?> clazz2 = class$1;
                                    if (clazz2 == null) {
                                        try {
                                            clazz2 = Class.forName("java.lang.String");
                                        }
                                        catch (ClassNotFoundException classNotFoundException) {
                                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                        }
                                    }
                                    if (sub_type != clazz2) {
                                        throw new RuntimeException("not implemented");
                                    }
                                    Array.set(array, j, child.getValue().trim());
                                    ++j;
                                }
                            }
                            field.set(obj, array);
                        } else {
                            String value = child.getValue().trim();
                            Class<?> clazz3 = class$1;
                            if (clazz3 == null) {
                                try {
                                    clazz3 = Class.forName("java.lang.String");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            if (type == clazz3) {
                                field.set(obj, value);
                            } else if (type == Long.TYPE) {
                                field.setLong(obj, Long.parseLong(value));
                            } else {
                                if (type == Boolean.TYPE) {
                                    throw new RuntimeException("not implemented");
                                }
                                if (type == Byte.TYPE) {
                                    throw new RuntimeException("not implemented");
                                }
                                if (type == Character.TYPE) {
                                    field.setChar(obj, value.charAt(0));
                                } else if (type == Double.TYPE) {
                                    field.setDouble(obj, Double.parseDouble(value));
                                } else if (type == Float.TYPE) {
                                    field.setFloat(obj, Float.parseFloat(value));
                                } else if (type == Integer.TYPE) {
                                    field.setInt(obj, Integer.parseInt(value));
                                } else if (type == Short.TYPE) {
                                    field.setShort(obj, Short.parseShort(value));
                                } else {
                                    Class<?> clazz4 = class$10;
                                    if (clazz4 == null) {
                                        try {
                                            clazz4 = Class.forName("java.lang.Long");
                                        }
                                        catch (ClassNotFoundException classNotFoundException) {
                                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                        }
                                    }
                                    if (type == clazz4 || type == Long.TYPE) {
                                        field.set(obj, new Long(Long.parseLong(value)));
                                    } else {
                                        field.set(obj, this.deserialiseObject(child, type, String.valueOf(indent) + "    "));
                                    }
                                }
                            }
                        }
                    }
                }
                ++i;
            }
            return obj;
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
            throw new RuntimeException(e.toString());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void serialiseObject(Object obj, String indent, int original_modifier_filter) {
        int modifier_filter = original_modifier_filter & 0xFFFFFF77;
        Class<?> cla = obj.getClass();
        if (cla.isArray()) {
            int len = Array.getLength(obj);
            if (cla.getComponentType() == Byte.TYPE) {
                byte[] data = (byte[])obj;
                this.writeLineEscaped(ByteFormatter.nicePrint(data, true));
                return;
            }
            int i = 0;
            while (true) {
                if (i >= len) {
                    return;
                }
                Object entry2 = Array.get(obj, i);
                try {
                    this.writeLineRaw("<ENTRY index=\"" + i + "\">");
                    this.indent();
                    this.serialiseObject(entry2, String.valueOf(indent) + "  ", original_modifier_filter);
                }
                finally {
                    this.exdent();
                    this.writeLineRaw("</ENTRY>");
                }
                ++i;
            }
        }
        Class<?> clazz = class$1;
        if (clazz == null) {
            Class<?> clazz2;
            try {
                clazz2 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            clazz = class$1 = clazz2;
        }
        if (cla == clazz) {
            this.writeLineEscaped((String)obj);
            return;
        }
        Class<?> clazz3 = class$11;
        if (clazz3 == null) {
            Class<?> clazz4;
            try {
                clazz4 = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            clazz3 = class$11 = clazz4;
        }
        if (cla == clazz3) {
            this.writeLineEscaped("" + (Integer)obj);
            return;
        }
        Class<?> clazz5 = class$12;
        if (clazz5 == null) {
            Class<?> clazz6;
            try {
                clazz6 = Class.forName("java.lang.Boolean");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            clazz5 = class$12 = clazz6;
        }
        if (cla == clazz5) {
            this.writeLineEscaped("" + (Boolean)obj);
            return;
        }
        while (cla != null) {
            try {
                Field[] fields = cla.getDeclaredFields();
                int i = 0;
                while (i < fields.length) {
                    block54: {
                        Field field = fields[i];
                        int modifiers = field.getModifiers();
                        if ((modifiers | modifier_filter) == modifier_filter) {
                            String name = field.getName();
                            Class<?> type = field.getType();
                            try {
                                this.writeLineRaw("<" + name + ">");
                                this.indent();
                                Class<?> clazz7 = class$1;
                                if (clazz7 == null) {
                                    try {
                                        clazz7 = Class.forName("java.lang.String");
                                    }
                                    catch (ClassNotFoundException classNotFoundException) {
                                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                    }
                                }
                                if (type == clazz7) {
                                    this.writeLineEscaped((String)field.get(obj));
                                    break block54;
                                }
                                Class<?> clazz8 = class$11;
                                if (clazz8 == null) {
                                    try {
                                        clazz8 = Class.forName("java.lang.Integer");
                                    }
                                    catch (ClassNotFoundException classNotFoundException) {
                                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                    }
                                }
                                if (type == clazz8) {
                                    this.writeLineEscaped("" + (Integer)field.get(obj));
                                    break block54;
                                }
                                Class<?> clazz9 = class$12;
                                if (clazz9 == null) {
                                    try {
                                        clazz9 = Class.forName("java.lang.Boolean");
                                    }
                                    catch (ClassNotFoundException classNotFoundException) {
                                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                    }
                                }
                                if (type == clazz9) {
                                    this.writeLineEscaped("" + (Boolean)field.get(obj));
                                    break block54;
                                }
                                if (type == Long.TYPE) {
                                    this.writeLineEscaped("" + field.getLong(obj));
                                    break block54;
                                }
                                if (type == Boolean.TYPE) {
                                    this.writeLineEscaped("" + field.getBoolean(obj));
                                    break block54;
                                }
                                if (type == Byte.TYPE) {
                                    this.writeLineEscaped("" + field.getByte(obj));
                                    break block54;
                                }
                                if (type == Character.TYPE) {
                                    this.writeLineEscaped("" + field.getChar(obj));
                                    break block54;
                                }
                                if (type == Double.TYPE) {
                                    this.writeLineEscaped("" + field.getDouble(obj));
                                    break block54;
                                }
                                if (type == Float.TYPE) {
                                    this.writeLineEscaped("" + field.getFloat(obj));
                                    break block54;
                                }
                                if (type == Integer.TYPE) {
                                    this.writeLineEscaped("" + field.getInt(obj));
                                    break block54;
                                }
                                if (type == Short.TYPE) {
                                    this.writeLineEscaped("" + field.getShort(obj));
                                    break block54;
                                }
                                Class<?> clazz10 = class$10;
                                if (clazz10 == null) {
                                    try {
                                        clazz10 = Class.forName("java.lang.Long");
                                    }
                                    catch (ClassNotFoundException classNotFoundException) {
                                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                    }
                                }
                                if (type == clazz10) {
                                    this.writeLineEscaped("" + field.get(obj));
                                } else {
                                    this.serialiseObject(field.get(obj), String.valueOf(indent) + "    ", original_modifier_filter);
                                }
                            }
                            finally {
                                this.exdent();
                                this.writeLineRaw("</" + name + ">");
                            }
                        }
                    }
                    ++i;
                }
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
                throw new RuntimeException(e.toString());
            }
            cla = cla.getSuperclass();
        }
        return;
    }
}

