/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.tableitems.files;

import org.gudy.azureus2.core3.disk.DiskManagerFileInfo;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.ui.swt.views.table.utils.CoreTableColumn;

public class PercentItem
extends CoreTableColumn
implements TableCellRefreshListener {
    public PercentItem() {
        super("%", 2, -2, 60, "Files");
        this.setRefreshInterval(-2);
    }

    public void refresh(TableCell cell) {
        DiskManagerFileInfo fileInfo2 = (DiskManagerFileInfo)cell.getDataSource();
        long percent = 0L;
        if (fileInfo2 != null && fileInfo2.getLength() != 0L) {
            percent = 1000L * fileInfo2.getDownloaded() / fileInfo2.getLength();
        }
        if (!cell.setSortValue(percent) && cell.isValid()) {
            return;
        }
        cell.setText(String.valueOf(percent / 10L) + "." + percent % 10L + "%");
    }
}

