/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.tableitems.files;

import java.io.File;
import java.io.IOException;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfo;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.ui.swt.views.FilesView;
import org.gudy.azureus2.ui.swt.views.table.utils.CoreTableColumn;

public class PathItem
extends CoreTableColumn
implements TableCellRefreshListener {
    public PathItem() {
        super("path", 1, -2, 200, "Files");
    }

    public void refresh(TableCell cell) {
        DiskManagerFileInfo fileInfo2 = (DiskManagerFileInfo)cell.getDataSource();
        String path = "";
        if (fileInfo2 != null) {
            if (FilesView.show_full_path) {
                try {
                    path = String.valueOf(fileInfo2.getFile().getParentFile().getCanonicalPath()) + File.separator;
                }
                catch (IOException e) {
                    path = String.valueOf(fileInfo2.getFile().getParentFile().getAbsolutePath()) + File.separator;
                }
            } else {
                int pos;
                DownloadManager dm = fileInfo2.getDiskManager().getDownloadManager();
                String root = dm.getTorrentSaveDir();
                if (!dm.getTorrent().isSimpleTorrent()) {
                    root = String.valueOf(root) + File.separator + dm.getTorrentSaveFile();
                }
                if ((pos = fileInfo2.getPath().indexOf(root)) >= 0) {
                    path = fileInfo2.getPath().substring(pos + root.length());
                }
            }
        }
        cell.setText(path);
    }
}

