/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views;

import com.aelitis.azureus.core.AzureusCore;
import java.io.File;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.category.Category;
import org.gudy.azureus2.core3.category.CategoryListener;
import org.gudy.azureus2.core3.category.CategoryManager;
import org.gudy.azureus2.core3.category.CategoryManagerListener;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.download.DownloadManagerListener;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.global.GlobalManagerDownloadRemovalVetoException;
import org.gudy.azureus2.core3.global.GlobalManagerListener;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.tracker.client.TRTrackerClient;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.gudy.azureus2.ui.swt.Alerts;
import org.gudy.azureus2.ui.swt.CategoryAdderWindow;
import org.gudy.azureus2.ui.swt.ImageRepository;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.MinimizedWindow;
import org.gudy.azureus2.ui.swt.TrackerChangerWindow;
import org.gudy.azureus2.ui.swt.URLTransfer;
import org.gudy.azureus2.ui.swt.exporttorrent.wizard.ExportTorrentWizard;
import org.gudy.azureus2.ui.swt.help.HealthHelpWindow;
import org.gudy.azureus2.ui.swt.mainwindow.MainWindow;
import org.gudy.azureus2.ui.swt.mainwindow.TorrentOpener;
import org.gudy.azureus2.ui.swt.maketorrent.MultiTrackerEditor;
import org.gudy.azureus2.ui.swt.maketorrent.TrackerEditorListener;
import org.gudy.azureus2.ui.swt.views.TableView;
import org.gudy.azureus2.ui.swt.views.table.TableColumnCore;
import org.gudy.azureus2.ui.swt.views.table.TableRowCore;
import org.gudy.azureus2.ui.swt.views.utils.ManagerUtils;

public class MyTorrentsView
extends TableView
implements GlobalManagerListener,
ParameterListener,
DownloadManagerListener,
CategoryManagerListener,
CategoryListener {
    private AzureusCore azureus_core;
    private GlobalManager globalManager;
    private boolean isSeedingView;
    private Composite cTablePanel;
    private Font fontButton = null;
    private Composite cCategories;
    private Menu menuCategory;
    private MenuItem menuItemChangeDir = null;
    private Map downloadBars;
    private AEMonitor downloadBars_mon = new AEMonitor("MyTorrentsView:DL");
    private Category currentCategory;
    private boolean skipDMAdding = true;
    private int drag_drop_line_start = -1;
    private boolean confirmDataDelete = COConfigurationManager.getBooleanParameter("Confirm Data Delete", true);
    private boolean top;
    private boolean bottom;
    private boolean up;
    private boolean down;
    private boolean run;
    private boolean host;
    private boolean publish;
    private boolean start;
    private boolean stop;
    private boolean remove;

    public MyTorrentsView(AzureusCore _azureus_core, boolean isSeedingView, TableColumnCore[] basicItems) {
        super(isSeedingView ? "MySeeders" : "MyTorrents", "MyTorrentsView", basicItems, "#", 67586);
        this.ptIconSize = new Point(16, 16);
        this.azureus_core = _azureus_core;
        this.globalManager = this.azureus_core.getGlobalManager();
        this.isSeedingView = isSeedingView;
        this.downloadBars = MainWindow.getWindow().getDownloadBars();
        this.currentCategory = CategoryManager.getCategory(1);
    }

    public void initialize(Composite composite0) {
        if (this.cTablePanel != null) {
            return;
        }
        super.initialize(composite0);
        this.createTabs();
        this.createDragDrop();
        COConfigurationManager.addParameterListener("Confirm Data Delete", this);
        this.activateCategory(this.currentCategory);
        CategoryManager.addCategoryManagerListener(this);
        this.skipDMAdding = true;
        this.globalManager.addListener(this);
        this.skipDMAdding = false;
    }

    public void tableStructureChanged() {
        super.tableStructureChanged();
        this.createDragDrop();
        this.activateCategory(this.currentCategory);
    }

    public Composite createMainPanel(Composite composite) {
        Composite panel = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        panel.setLayout((Layout)layout);
        panel.setLayoutData((Object)new GridData(768));
        this.cTablePanel = new Composite(panel, 0);
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = 2;
        this.cTablePanel.setLayoutData((Object)gridData);
        layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        this.cTablePanel.setLayout((Layout)layout);
        return panel;
    }

    private void createTabs() {
        Object[] categories = CategoryManager.getCategories();
        Arrays.sort(categories);
        if (categories.length > 0) {
            if (this.cCategories == null) {
                this.cCategories = new Composite(this.getComposite(), 0);
                GridData gridData = new GridData(128);
                this.cCategories.setLayoutData((Object)gridData);
                RowLayout rowLayout = new RowLayout();
                rowLayout.marginTop = 0;
                rowLayout.marginBottom = 0;
                rowLayout.marginLeft = 0;
                rowLayout.marginRight = 0;
                rowLayout.spacing = 0;
                rowLayout.wrap = true;
                this.cCategories.setLayout((Layout)rowLayout);
                Label l = new Label(this.getComposite(), 64);
                gridData = new GridData();
                gridData.horizontalIndent = 3;
                l.setLayoutData((Object)gridData);
                Messages.setLanguageText((Widget)l, String.valueOf(this.sTableID) + "View.header");
                this.cCategories.moveAbove(null);
                l.moveAbove(null);
            } else {
                Control[] controls = this.cCategories.getChildren();
                int i = 0;
                while (i < controls.length) {
                    controls[i].dispose();
                    ++i;
                }
            }
            int iFontPixelsHeight = 11;
            int iFontPointHeight = iFontPixelsHeight * 72 / this.cCategories.getDisplay().getDPI().y;
            int i = 0;
            while (i < categories.length) {
                final Button catButton = new Button(this.cCategories, 2);
                if (i == 0 && this.fontButton == null) {
                    Font f = catButton.getFont();
                    FontData fd = f.getFontData()[0];
                    fd.setHeight(iFontPointHeight);
                    this.fontButton = new Font((Device)this.cCategories.getDisplay(), fd);
                }
                catButton.setText("|");
                catButton.setFont(this.fontButton);
                catButton.pack(true);
                if (catButton.computeSize((int)100, (int)-1).y > 0) {
                    RowData rd = new RowData();
                    rd.height = catButton.computeSize((int)100, (int)-1).y - 3 + catButton.getBorderWidth() * 2;
                    catButton.setLayoutData((Object)rd);
                }
                String name = categories[i].getName();
                if (categories[i].getType() == 0) {
                    catButton.setText(name);
                } else {
                    Messages.setLanguageText((Widget)catButton, name);
                }
                catButton.setData("Category", categories[i]);
                if (categories[i] == this.currentCategory) {
                    catButton.setSelection(true);
                }
                catButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        Button curButton = (Button)e.widget;
                        boolean isEnabled = curButton.getSelection();
                        Control[] controls = MyTorrentsView.this.cCategories.getChildren();
                        if (!isEnabled) {
                            curButton = (Button)controls[0];
                        }
                        int i = 0;
                        while (i < controls.length) {
                            Button b = (Button)controls[i];
                            if (b != curButton && b.getSelection()) {
                                b.setSelection(false);
                            } else if (b == curButton && !b.getSelection()) {
                                b.setSelection(true);
                            }
                            ++i;
                        }
                        MyTorrentsView.this.activateCategory((Category)curButton.getData("Category"));
                    }
                });
                DropTarget tabDropTarget = new DropTarget((Control)catButton, 23);
                Transfer[] types = new Transfer[]{TextTransfer.getInstance()};
                tabDropTarget.setTransfer(types);
                tabDropTarget.addDropListener((DropTargetListener)new DropTargetAdapter(){

                    public void dragOver(DropTargetEvent e) {
                        e.detail = MyTorrentsView.this.drag_drop_line_start >= 0 ? 2 : 0;
                    }

                    public void drop(DropTargetEvent e) {
                        e.detail = 0;
                        if (MyTorrentsView.this.drag_drop_line_start >= 0) {
                            MyTorrentsView.this.drag_drop_line_start = -1;
                            MyTorrentsView.this.assignSelectedToCategory((Category)catButton.getData("Category"));
                        }
                    }
                });
                if (categories[i].getType() == 0) {
                    Menu menu = new Menu((Decorations)this.getComposite().getShell(), 8);
                    MenuItem itemDelete = new MenuItem(menu, 8);
                    Messages.setLanguageText((Widget)itemDelete, "MyTorrentsView.menu.category.delete");
                    menu.setDefaultItem(itemDelete);
                    itemDelete.addListener(13, new Listener(){

                        public void handleEvent(Event event) {
                            Category catToDelete = (Category)catButton.getData("Category");
                            if (catToDelete != null) {
                                List managers = catToDelete.getDownloadManagers();
                                DownloadManager[] dms = managers.toArray(new DownloadManager[managers.size()]);
                                int i = 0;
                                while (i < dms.length) {
                                    dms[i].getDownloadState().setCategory(null);
                                    ++i;
                                }
                                if (MyTorrentsView.this.currentCategory == catToDelete) {
                                    MyTorrentsView.this.activateCategory(CategoryManager.getCategory(1));
                                }
                                CategoryManager.removeCategory(catToDelete);
                            }
                        }
                    });
                    catButton.setMenu(menu);
                }
                ++i;
            }
            this.cCategories.layout();
            this.getComposite().layout();
        }
    }

    public Table createTable() {
        this.bSkipFirstColumn = true;
        Table table = new Table(this.cTablePanel, 67586);
        table.setLayoutData((Object)new GridData(1808));
        table.addKeyListener(this.createKeyListener());
        table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                DownloadManager dm = (DownloadManager)MyTorrentsView.this.getFirstSelectedDataSource();
                if (dm != null) {
                    MainWindow.getWindow().openManagerView(dm);
                }
            }
        });
        this.cTablePanel.layout();
        return table;
    }

    public void fillMenu(final Menu menu) {
        final MenuItem itemDetails = new MenuItem(menu, 8);
        Messages.setLanguageText((Widget)itemDetails, "MyTorrentsView.menu.showdetails");
        menu.setDefaultItem(itemDetails);
        itemDetails.setImage(ImageRepository.getImage("details"));
        final MenuItem itemBar = new MenuItem(menu, 32);
        Messages.setLanguageText((Widget)itemBar, "MyTorrentsView.menu.showdownloadbar");
        itemBar.setImage(ImageRepository.getImage("downloadBar"));
        new MenuItem(menu, 2);
        final MenuItem itemOpen = new MenuItem(menu, 8);
        Messages.setLanguageText((Widget)itemOpen, "MyTorrentsView.menu.open");
        itemOpen.setImage(ImageRepository.getImage("run"));
        final MenuItem itemExport = new MenuItem(menu, 8);
        Messages.setLanguageText((Widget)itemExport, "MyTorrentsView.menu.export");
        itemExport.setImage(ImageRepository.getImage("export"));
        final MenuItem itemHost = new MenuItem(menu, 8);
        Messages.setLanguageText((Widget)itemHost, "MyTorrentsView.menu.host");
        itemHost.setImage(ImageRepository.getImage("host"));
        final MenuItem itemPublish = new MenuItem(menu, 8);
        Messages.setLanguageText((Widget)itemPublish, "MyTorrentsView.menu.publish");
        itemPublish.setImage(ImageRepository.getImage("publish"));
        new MenuItem(menu, 2);
        final MenuItem itemMove = new MenuItem(menu, 64);
        Messages.setLanguageText((Widget)itemMove, "MyTorrentsView.menu.move");
        itemMove.setImage(ImageRepository.getImage("move"));
        Menu menuMove = new Menu((Decorations)this.getComposite().getShell(), 4);
        itemMove.setMenu(menuMove);
        final MenuItem itemMoveTop = new MenuItem(menuMove, 8);
        Messages.setLanguageText((Widget)itemMoveTop, "MyTorrentsView.menu.moveTop");
        itemMoveTop.setImage(ImageRepository.getImage("top"));
        MenuItem itemMoveUp = new MenuItem(menuMove, 8);
        Messages.setLanguageText((Widget)itemMoveUp, "MyTorrentsView.menu.moveUp");
        itemMoveUp.setImage(ImageRepository.getImage("up"));
        MenuItem itemMoveDown = new MenuItem(menuMove, 8);
        Messages.setLanguageText((Widget)itemMoveDown, "MyTorrentsView.menu.moveDown");
        itemMoveDown.setImage(ImageRepository.getImage("down"));
        final MenuItem itemMoveEnd = new MenuItem(menuMove, 8);
        Messages.setLanguageText((Widget)itemMoveEnd, "MyTorrentsView.menu.moveEnd");
        itemMoveEnd.setImage(ImageRepository.getImage("bottom"));
        MenuItem itemSpeed = new MenuItem(menu, 64);
        Messages.setLanguageText((Widget)itemSpeed, "MyTorrentsView.menu.setSpeed");
        itemSpeed.setImage(ImageRepository.getImage("speed"));
        Menu menuSpeed = new Menu((Decorations)this.getComposite().getShell(), 4);
        itemSpeed.setMenu(menuSpeed);
        final MenuItem itemCurrentSpeed = new MenuItem(menuSpeed, 8);
        itemCurrentSpeed.setEnabled(false);
        new MenuItem(menuSpeed, 2);
        final MenuItem[] itemsSpeed = new MenuItem[12];
        Listener itemsSpeedListener = new Listener(){

            public void handleEvent(Event e) {
                if (e.widget != null && e.widget instanceof MenuItem) {
                    MenuItem item = (MenuItem)e.widget;
                    int speed = item.getData("maxul") == null ? 0 : (Integer)item.getData("maxul");
                    MyTorrentsView.this.setSelectedTorrentsSpeed(speed);
                }
            }
        };
        itemsSpeed[1] = new MenuItem(menuSpeed, 8);
        Messages.setLanguageText((Widget)itemsSpeed[1], "MyTorrentsView.menu.setSpeed.unlimit");
        itemsSpeed[1].setData("maxul", (Object)new Integer(0));
        itemsSpeed[1].addListener(13, itemsSpeedListener);
        int i = 2;
        while (i < 12) {
            itemsSpeed[i] = new MenuItem(menuSpeed, 8);
            itemsSpeed[i].addListener(13, itemsSpeedListener);
            ++i;
        }
        this.menuCategory = new Menu((Decorations)this.getComposite().getShell(), 4);
        MenuItem itemCategory = new MenuItem(menu, 64);
        Messages.setLanguageText((Widget)itemCategory, "MyTorrentsView.menu.setCategory");
        itemCategory.setMenu(this.menuCategory);
        this.addCategorySubMenu();
        Menu menuTracker = new Menu((Decorations)this.getComposite().getShell(), 4);
        MenuItem itemTracker = new MenuItem(menu, 64);
        Messages.setLanguageText((Widget)itemTracker, "MyTorrentsView.menu.tracker");
        itemTracker.setMenu(menuTracker);
        final MenuItem itemChangeTracker = new MenuItem(menuTracker, 8);
        Messages.setLanguageText((Widget)itemChangeTracker, "MyTorrentsView.menu.changeTracker");
        itemChangeTracker.setImage(ImageRepository.getImage("add_tracker"));
        final MenuItem itemEditTracker = new MenuItem(menuTracker, 8);
        Messages.setLanguageText((Widget)itemEditTracker, "MyTorrentsView.menu.editTracker");
        itemEditTracker.setImage(ImageRepository.getImage("edit_trackers"));
        final MenuItem itemManualUpdate = new MenuItem(menuTracker, 8);
        Messages.setLanguageText((Widget)itemManualUpdate, "GeneralView.label.trackerurlupdate");
        new MenuItem(menu, 2);
        final MenuItem itemQueue = new MenuItem(menu, 8);
        Messages.setLanguageText((Widget)itemQueue, "MyTorrentsView.menu.queue");
        itemQueue.setImage(ImageRepository.getImage("start"));
        final MenuItem itemForceStart = new MenuItem(menu, 32);
        Messages.setLanguageText((Widget)itemForceStart, "MyTorrentsView.menu.forceStart");
        itemForceStart.setImage(ImageRepository.getImage("forcestart"));
        final MenuItem itemStop = new MenuItem(menu, 8);
        Messages.setLanguageText((Widget)itemStop, "MyTorrentsView.menu.stop");
        itemStop.setImage(ImageRepository.getImage("stop"));
        final MenuItem itemRemove = new MenuItem(menu, 8);
        Messages.setLanguageText((Widget)itemRemove, "MyTorrentsView.menu.remove");
        itemRemove.setImage(ImageRepository.getImage("delete"));
        final MenuItem itemRemoveAnd = new MenuItem(menu, 64);
        Messages.setLanguageText((Widget)itemRemoveAnd, "MyTorrentsView.menu.removeand");
        itemRemoveAnd.setImage(ImageRepository.getImage("delete"));
        Menu menuRemove = new Menu((Decorations)this.getComposite().getShell(), 4);
        itemRemoveAnd.setMenu(menuRemove);
        MenuItem itemDeleteTorrent = new MenuItem(menuRemove, 8);
        Messages.setLanguageText((Widget)itemDeleteTorrent, "MyTorrentsView.menu.removeand.deletetorrent");
        MenuItem itemDeleteData = new MenuItem(menuRemove, 8);
        Messages.setLanguageText((Widget)itemDeleteData, "MyTorrentsView.menu.removeand.deletedata");
        MenuItem itemDeleteBoth = new MenuItem(menuRemove, 8);
        Messages.setLanguageText((Widget)itemDeleteBoth, "MyTorrentsView.menu.removeand.deleteboth");
        final MenuItem itemRecheck = new MenuItem(menu, 8);
        Messages.setLanguageText((Widget)itemRecheck, "MyTorrentsView.menu.recheck");
        itemRecheck.setImage(ImageRepository.getImage("recheck"));
        new MenuItem(menu, 2);
        super.fillMenu(menu);
        menu.addListener(22, new Listener(){

            public void handleEvent(Event e) {
                Object[] dms = MyTorrentsView.this.getSelectedDataSources();
                boolean hasSelection = dms.length > 0;
                itemDetails.setEnabled(hasSelection);
                itemOpen.setEnabled(hasSelection);
                itemExport.setEnabled(hasSelection);
                itemHost.setEnabled(hasSelection);
                itemPublish.setEnabled(hasSelection);
                itemMove.setEnabled(hasSelection);
                itemBar.setEnabled(hasSelection);
                itemManualUpdate.setEnabled(hasSelection);
                boolean bChangeDir = false;
                if (hasSelection) {
                    bChangeDir = true;
                    boolean changeSpeed = true;
                    boolean manualUpdate = true;
                    boolean barsOpened = true;
                    boolean changeUrl = true;
                    boolean moveDown = true;
                    boolean moveUp = true;
                    boolean stop = false;
                    boolean start = false;
                    boolean recheck = false;
                    boolean forceStartEnabled = false;
                    boolean forceStart = false;
                    long totalSpeed = 0L;
                    boolean speedUnlimited = false;
                    boolean speedDisabled = false;
                    int i = 0;
                    while (i < dms.length) {
                        TRTrackerClient trackerClient;
                        DownloadManager dm = (DownloadManager)dms[i];
                        try {
                            int maxul = dm.getStats().getUploadRateLimitBytesPerSecond();
                            if (maxul == 0) {
                                speedUnlimited = true;
                            }
                            if (maxul == -1) {
                                maxul = 0;
                                speedDisabled = true;
                            }
                            totalSpeed += (long)maxul;
                        }
                        catch (NullPointerException ex) {
                            changeSpeed = false;
                        }
                        catch (Exception ex) {
                            Debug.printStackTrace(ex);
                        }
                        if (dm.getTrackerClient() == null) {
                            changeUrl = false;
                        }
                        if (!MyTorrentsView.this.downloadBars.containsKey(dm)) {
                            barsOpened = false;
                        }
                        stop = stop || ManagerUtils.isStopable(dm);
                        start = start || ManagerUtils.isStartable(dm);
                        recheck = recheck || dm.canForceRecheck();
                        forceStartEnabled = forceStartEnabled || ManagerUtils.isForceStartable(dm);
                        boolean bl = forceStart = forceStart || dm.isForceStart();
                        if (!dm.isMoveableDown()) {
                            moveDown = false;
                        }
                        if (!dm.isMoveableUp()) {
                            moveUp = false;
                        }
                        if ((trackerClient = dm.getTrackerClient()) != null) {
                            boolean update_state = SystemTime.getCurrentTime() / 1000L - (long)trackerClient.getLastUpdateTime() >= 60L;
                            manualUpdate &= update_state;
                        }
                        bChangeDir &= dm.getState() == 100 && !dm.filesExist();
                        ++i;
                    }
                    itemBar.setSelection(barsOpened);
                    itemMoveTop.setEnabled(moveUp);
                    itemMoveEnd.setEnabled(moveDown);
                    itemForceStart.setSelection(forceStart);
                    itemForceStart.setEnabled(forceStartEnabled);
                    itemQueue.setEnabled(start);
                    itemStop.setEnabled(stop);
                    itemRemove.setEnabled(true);
                    itemRemoveAnd.setEnabled(true);
                    StringBuffer speedText = new StringBuffer();
                    String separator = "";
                    if (speedDisabled) {
                        speedText.append(MessageText.getString("MyTorrentsView.menu.setSpeed.disabled"));
                        separator = " / ";
                    }
                    if (speedUnlimited) {
                        speedText.append(separator);
                        speedText.append(MessageText.getString("MyTorrentsView.menu.setSpeed.unlimited"));
                        separator = " / ";
                    }
                    if (totalSpeed > 0L) {
                        speedText.append(separator);
                        speedText.append(DisplayFormatters.formatByteCountToKiBEtcPerSec(totalSpeed));
                    }
                    itemCurrentSpeed.setText(speedText.toString());
                    int maxUpload = COConfigurationManager.getIntParameter("Max Upload Speed KBs", 0) * 1024;
                    if (maxUpload == 0) {
                        maxUpload = 0x100000;
                    }
                    if (dms.length > 0) {
                        int i2 = 2;
                        while (i2 < 12) {
                            int limit = maxUpload / (10 * dms.length) * (12 - i2);
                            StringBuffer speed = new StringBuffer();
                            speed.append(DisplayFormatters.formatByteCountToKiBEtcPerSec(limit * dms.length));
                            if (dms.length > 1) {
                                speed.append(" ");
                                speed.append(MessageText.getString("MyTorrentsView.menu.setSpeed.in"));
                                speed.append(" ");
                                speed.append(dms.length);
                                speed.append(" ");
                                speed.append(MessageText.getString("MyTorrentsView.menu.setSpeed.slots"));
                                speed.append(" ");
                                speed.append(DisplayFormatters.formatByteCountToKiBEtcPerSec(limit));
                            }
                            itemsSpeed[i2].setText(speed.toString());
                            itemsSpeed[i2].setData("maxul", (Object)new Integer(limit));
                            ++i2;
                        }
                    }
                    itemEditTracker.setEnabled(true);
                    itemChangeTracker.setEnabled(changeUrl);
                    itemRecheck.setEnabled(recheck);
                    itemManualUpdate.setEnabled(manualUpdate);
                } else {
                    itemBar.setSelection(false);
                    itemForceStart.setEnabled(false);
                    itemForceStart.setSelection(false);
                    itemQueue.setEnabled(false);
                    itemStop.setEnabled(false);
                    itemRemove.setEnabled(false);
                    itemRemoveAnd.setEnabled(false);
                    itemEditTracker.setEnabled(false);
                    itemChangeTracker.setEnabled(false);
                    itemRecheck.setEnabled(false);
                }
                if (MyTorrentsView.this.menuItemChangeDir != null && !MyTorrentsView.this.menuItemChangeDir.isDisposed()) {
                    MyTorrentsView.this.menuItemChangeDir.dispose();
                }
                if (bChangeDir) {
                    MyTorrentsView.this.menuItemChangeDir = new MenuItem(menu, 8, 0);
                    Messages.setLanguageText((Widget)MyTorrentsView.this.menuItemChangeDir, "MyTorrentsView.menu.changeDirectory");
                    MyTorrentsView.this.menuItemChangeDir.addListener(13, new Listener(this){
                        final /* synthetic */ 6 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public void handleEvent(Event e) {
                            MyTorrentsView.access$10(6.access$0(this.this$1));
                        }
                    });
                }
            }

            static /* synthetic */ MyTorrentsView access$0(6 var0) {
                return var0.MyTorrentsView.this;
            }
        });
        itemQueue.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                MyTorrentsView.this.queueSelectedTorrents();
            }
        });
        itemStop.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                MyTorrentsView.this.stopSelectedTorrents();
            }
        });
        itemRemove.addListener(13, (Listener)new TableView.SelectedTableRowsListener(this){

            public void run(TableRowCore row) {
                MyTorrentsView.this.removeTorrent((DownloadManager)row.getDataSource(true), false, false);
            }
        });
        itemDeleteTorrent.addListener(13, (Listener)new TableView.SelectedTableRowsListener(this){

            public void run(TableRowCore row) {
                MyTorrentsView.this.removeTorrent((DownloadManager)row.getDataSource(true), true, false);
            }
        });
        itemDeleteData.addListener(13, (Listener)new TableView.SelectedTableRowsListener(this){

            public void run(TableRowCore row) {
                MyTorrentsView.this.removeTorrent((DownloadManager)row.getDataSource(true), false, true);
            }
        });
        itemDeleteBoth.addListener(13, (Listener)new TableView.SelectedTableRowsListener(this){

            public void run(TableRowCore row) {
                MyTorrentsView.this.removeTorrent((DownloadManager)row.getDataSource(true), true, true);
            }
        });
        itemChangeTracker.addListener(13, (Listener)new TableView.SelectedTableRowsListener(this){

            public void run(TableRowCore row) {
                TRTrackerClient tc = ((DownloadManager)row.getDataSource(true)).getTrackerClient();
                if (tc != null) {
                    new TrackerChangerWindow(MainWindow.getWindow().getDisplay(), tc);
                }
            }
        });
        itemEditTracker.addListener(13, (Listener)new TableView.SelectedTableRowsListener(this){

            public void run(TableRowCore row) {
                DownloadManager dm = (DownloadManager)row.getDataSource(true);
                if (dm.getTorrent() != null) {
                    TOTorrent torrent = dm.getTorrent();
                    List group = TorrentUtils.announceGroupsToList(torrent);
                    new MultiTrackerEditor(null, group, new TrackerEditorListener(this, torrent, dm){
                        final /* synthetic */ 15 this$1;
                        private final /* synthetic */ TOTorrent val$torrent;
                        private final /* synthetic */ DownloadManager val$dm;
                        {
                            this.this$1 = var1_1;
                            this.val$torrent = tOTorrent;
                            this.val$dm = downloadManager;
                        }

                        public void trackersChanged(String str, String str2, List group) {
                            TorrentUtils.listToAnnounceGroups(group, this.val$torrent);
                            try {
                                TorrentUtils.writeToFile(this.val$torrent);
                            }
                            catch (Throwable e) {
                                Debug.printStackTrace(e);
                            }
                            if (this.val$dm.getTrackerClient() != null) {
                                this.val$dm.getTrackerClient().resetTrackerUrl(true);
                            }
                        }
                    }, true);
                }
            }
        });
        itemManualUpdate.addListener(13, (Listener)new TableView.SelectedTableRowsListener(this){

            public void run(TableRowCore row) {
                ((DownloadManager)row.getDataSource(true)).checkTracker();
            }
        });
        itemDetails.addListener(13, (Listener)new TableView.SelectedTableRowsListener(this){

            public void run(TableRowCore row) {
                MainWindow.getWindow().openManagerView((DownloadManager)row.getDataSource(true));
            }
        });
        itemOpen.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                MyTorrentsView.this.runSelectedTorrents();
            }
        });
        itemExport.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                DownloadManager dm = (DownloadManager)MyTorrentsView.this.getFirstSelectedDataSource();
                if (dm != null) {
                    new ExportTorrentWizard(MyTorrentsView.this.azureus_core, itemExport.getDisplay(), dm);
                }
            }
        });
        itemHost.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                MyTorrentsView.this.hostSelectedTorrents();
            }
        });
        itemPublish.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                MyTorrentsView.this.publishSelectedTorrents();
            }
        });
        itemBar.addListener(13, (Listener)new TableView.SelectedTableRowsListener(this){

            public void run(TableRowCore row) {
                DownloadManager dm = (DownloadManager)row.getDataSource(true);
                try {
                    MyTorrentsView.this.downloadBars_mon.enter();
                    if (MyTorrentsView.this.downloadBars.containsKey(dm)) {
                        MinimizedWindow mw = (MinimizedWindow)MyTorrentsView.this.downloadBars.remove(dm);
                        mw.close();
                    } else {
                        MinimizedWindow mw = new MinimizedWindow(dm, MyTorrentsView.this.cTablePanel.getShell());
                        MyTorrentsView.this.downloadBars.put(dm, mw);
                    }
                }
                finally {
                    MyTorrentsView.this.downloadBars_mon.exit();
                }
            }
        });
        itemMoveDown.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                MyTorrentsView.this.moveSelectedTorrentsDown();
            }
        });
        itemMoveUp.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                MyTorrentsView.this.moveSelectedTorrentsUp();
            }
        });
        itemMoveTop.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                MyTorrentsView.this.moveSelectedTorrentsTop();
            }
        });
        itemMoveEnd.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                MyTorrentsView.this.moveSelectedTorrentsEnd();
            }
        });
        itemForceStart.addListener(13, (Listener)new TableView.SelectedTableRowsListener(this){

            public void run(TableRowCore row) {
                DownloadManager dm = (DownloadManager)row.getDataSource(true);
                if (ManagerUtils.isForceStartable(dm)) {
                    dm.setForceStart(itemForceStart.getSelection());
                }
            }
        });
        itemRecheck.addListener(13, (Listener)new TableView.SelectedTableRowsListener(this){

            public void run(TableRowCore row) {
                DownloadManager dm = (DownloadManager)row.getDataSource(true);
                if (dm.canForceRecheck()) {
                    dm.forceRecheck();
                }
            }
        });
    }

    private void addCategorySubMenu() {
        MenuItem[] items = this.menuCategory.getItems();
        int i = 0;
        while (i < items.length) {
            items[i].dispose();
            ++i;
        }
        Object[] categories = CategoryManager.getCategories();
        Arrays.sort(categories);
        if (categories.length > 0) {
            MenuItem itemCategory;
            Category catUncat = CategoryManager.getCategory(2);
            if (catUncat != null) {
                itemCategory = new MenuItem(this.menuCategory, 8);
                Messages.setLanguageText((Widget)itemCategory, catUncat.getName());
                itemCategory.setData("Category", (Object)catUncat);
                itemCategory.addListener(13, new Listener(){

                    public void handleEvent(Event event) {
                        MenuItem item = (MenuItem)event.widget;
                        MyTorrentsView.this.assignSelectedToCategory((Category)item.getData("Category"));
                    }
                });
                new MenuItem(this.menuCategory, 2);
            }
            i = 0;
            while (i < categories.length) {
                if (categories[i].getType() == 0) {
                    itemCategory = new MenuItem(this.menuCategory, 8);
                    itemCategory.setText(categories[i].getName());
                    itemCategory.setData("Category", categories[i]);
                    itemCategory.addListener(13, new Listener(){

                        public void handleEvent(Event event) {
                            MenuItem item = (MenuItem)event.widget;
                            MyTorrentsView.this.assignSelectedToCategory((Category)item.getData("Category"));
                        }
                    });
                }
                ++i;
            }
            new MenuItem(this.menuCategory, 2);
        }
        MenuItem itemAddCategory = new MenuItem(this.menuCategory, 8);
        Messages.setLanguageText((Widget)itemAddCategory, "MyTorrentsView.menu.setCategory.add");
        itemAddCategory.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                MyTorrentsView.this.addCategory();
            }
        });
    }

    public void addThisColumnSubMenu(String sColumnName, Menu menuThisColumn) {
        final Table table = this.getTable();
        if (sColumnName.equals("health")) {
            MenuItem item = new MenuItem(menuThisColumn, 8);
            Messages.setLanguageText((Widget)item, "MyTorrentsView.menu.health");
            item.setImage(ImageRepository.getImage("st_explain"));
            item.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    HealthHelpWindow.show(table.getDisplay());
                }
            });
        } else if (sColumnName.equals("maxuploads")) {
            int iStart = COConfigurationManager.getIntParameter("Max Uploads") - 2;
            if (iStart < 2) {
                iStart = 2;
            }
            int i = iStart;
            while (i < iStart + 6) {
                MenuItem item = new MenuItem(menuThisColumn, 8);
                item.setText(String.valueOf(i));
                item.setData("MaxUploads", (Object)new Long(i));
                item.addListener(13, (Listener)new TableView.SelectedTableRowsListener(this){

                    public void run(TableRowCore row) {
                        DownloadManager dm = (DownloadManager)row.getDataSource(true);
                        MenuItem item = (MenuItem)this.event.widget;
                        if (item != null) {
                            int value = ((Long)item.getData("MaxUploads")).intValue();
                            dm.getStats().setMaxUploads(value);
                        }
                    }
                });
                ++i;
            }
        }
    }

    private void createDragDrop() {
        Transfer[] types = new Transfer[]{TextTransfer.getInstance()};
        DragSource dragSource = new DragSource((Control)this.getTable(), 2);
        dragSource.setTransfer(types);
        dragSource.addDragListener((DragSourceListener)new DragSourceAdapter(){

            public void dragStart(DragSourceEvent event) {
                Table table = MyTorrentsView.this.getTable();
                if (table.getSelectionCount() != 0 && table.getSelectionCount() != table.getItemCount()) {
                    event.doit = true;
                    MyTorrentsView.this.drag_drop_line_start = table.getSelectionIndex();
                } else {
                    event.doit = false;
                    MyTorrentsView.this.drag_drop_line_start = -1;
                }
            }
        });
        DropTarget dropTarget = new DropTarget((Control)this.getTable(), 31);
        dropTarget.setTransfer(new Transfer[]{URLTransfer.getInstance(), FileTransfer.getInstance(), TextTransfer.getInstance()});
        dropTarget.addDropListener((DropTargetListener)new DropTargetAdapter(){

            public void dragOver(DropTargetEvent event) {
                if (MyTorrentsView.this.drag_drop_line_start < 0) {
                    if (event.detail != 1) {
                        event.detail = 4;
                    }
                } else if (TextTransfer.getInstance().isSupportedType(event.currentDataType)) {
                    event.feedback = 31;
                    event.detail = event.item == null ? 0 : 2;
                }
            }

            public void drop(DropTargetEvent event) {
                if (MyTorrentsView.this.drag_drop_line_start >= 0) {
                    event.detail = 0;
                    if (event.item == null) {
                        return;
                    }
                    int drag_drop_line_end = MyTorrentsView.this.getTable().indexOf((TableItem)event.item);
                    MyTorrentsView.this.moveSelectedTorrents(MyTorrentsView.this.drag_drop_line_start, drag_drop_line_end);
                    MyTorrentsView.this.drag_drop_line_start = -1;
                } else {
                    TorrentOpener.openDroppedTorrents(MyTorrentsView.this.azureus_core, event);
                }
            }
        });
    }

    private void moveSelectedTorrents(int drag_drop_line_start, int drag_drop_line_end) {
        if (drag_drop_line_end == drag_drop_line_start) {
            return;
        }
        List list = this.getSelectedRowsList();
        if (list.size() == 0) {
            return;
        }
        TableItem ti = this.getTable().getItem(drag_drop_line_end);
        TableRowCore row = (TableRowCore)ti.getData("TableRow");
        DownloadManager dm = (DownloadManager)row.getDataSource(true);
        int iNewPos = dm.getPosition();
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            row = (TableRowCore)iter.next();
            dm = (DownloadManager)row.getDataSource(true);
            int iOldPos = dm.getPosition();
            this.globalManager.moveTo(dm, iNewPos);
            if (this.sorter.isAscending()) {
                if (iOldPos <= iNewPos) continue;
                ++iNewPos;
                continue;
            }
            if (iOldPos >= iNewPos) continue;
            --iNewPos;
        }
        if (this.sorter.getLastField().equals("#")) {
            this.sorter.sortColumn(true);
        }
    }

    public void refresh() {
        if (this.getComposite() == null || this.getComposite().isDisposed()) {
            return;
        }
        this.computePossibleActions();
        MainWindow.getWindow().refreshIconBar();
        super.refresh();
    }

    public void delete() {
        super.delete();
        if (this.fontButton != null && !this.fontButton.isDisposed()) {
            this.fontButton.dispose();
            this.fontButton = null;
        }
        CategoryManager.removeCategoryManagerListener(this);
        this.globalManager.removeListener(this);
        COConfigurationManager.removeParameterListener("Confirm Data Delete", this);
    }

    private KeyListener createKeyListener() {
        return new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.stateMask == 393216) {
                    if (e.character == '\u0013') {
                        MyTorrentsView.this.globalManager.stopAllDownloads();
                    }
                } else if (e.stateMask == 262144) {
                    if (e.keyCode == 0x1000001) {
                        MyTorrentsView.this.moveSelectedTorrentsUp();
                    } else if (e.keyCode == 0x1000002) {
                        MyTorrentsView.this.moveSelectedTorrentsDown();
                    } else if (e.keyCode == 0x1000007) {
                        MyTorrentsView.this.moveSelectedTorrentsTop();
                    } else if (e.keyCode == 0x1000008) {
                        MyTorrentsView.this.moveSelectedTorrentsEnd();
                    } else if (e.character == '\u0001') {
                        MyTorrentsView.this.getTable().selectAll();
                    } else if (e.character == '\u0003') {
                        MyTorrentsView.this.clipboardSelected();
                    } else if (e.character == '\u0012') {
                        MyTorrentsView.this.resumeSelectedTorrents();
                    } else if (e.character == '\u0013') {
                        MyTorrentsView.this.stopSelectedTorrents();
                    }
                } else if (e.stateMask == 0) {
                    if (e.keyCode == 127) {
                        MyTorrentsView.this.removeSelectedTorrents();
                    } else {
                        TableItem[] items = MyTorrentsView.this.getTable().getSelection();
                        int lastSelectedIndex = items.length == 0 ? -1 : MyTorrentsView.this.getTable().indexOf(items[items.length - 1]);
                        int nextIndex = MyTorrentsView.this.globalManager.getNextIndexForCharacter(e.character, lastSelectedIndex);
                        if (nextIndex >= 0) {
                            MyTorrentsView.this.getTable().setSelection(nextIndex);
                        }
                    }
                }
            }
        };
    }

    private void changeDirSelectedTorrents() {
        File f;
        String sDefPath;
        Object[] dataSources = this.getSelectedDataSources();
        if (dataSources.length <= 0) {
            return;
        }
        String string = sDefPath = COConfigurationManager.getBooleanParameter("Use default data dir") ? COConfigurationManager.getStringParameter("Default save path", "") : "";
        if (sDefPath.length() > 0 && !(f = new File(sDefPath)).exists()) {
            f.mkdirs();
        }
        DirectoryDialog dDialog = new DirectoryDialog(this.cTablePanel.getShell(), 131072);
        dDialog.setFilterPath(sDefPath);
        dDialog.setMessage(MessageText.getString("MainWindow.dialog.choose.savepath"));
        String sSavePath = dDialog.open();
        if (sSavePath != null) {
            int i = 0;
            while (i < dataSources.length) {
                DownloadManager dm = (DownloadManager)dataSources[i];
                if (dm.getState() == 100) {
                    dm.setTorrentSaveDir(sSavePath);
                    if (dm.filesExist()) {
                        dm.setState(70);
                        ManagerUtils.queue(dm, this.cTablePanel);
                    }
                }
                ++i;
            }
        }
    }

    private void removeTorrent(DownloadManager dm, boolean bDeleteTorrent, boolean bDeleteData) {
        int choice;
        if (COConfigurationManager.getBooleanParameter("confirm_torrent_removal")) {
            MessageBox mb = new MessageBox(this.cTablePanel.getShell(), 200);
            mb.setText(MessageText.getString("deletedata.title"));
            mb.setMessage(String.valueOf(MessageText.getString("deletetorrent.message1")) + dm.getDisplayName() + " :\n" + dm.getTorrentFileName() + MessageText.getString("deletetorrent.message2"));
            if (mb.open() == 128) {
                return;
            }
        }
        if (this.confirmDataDelete && bDeleteData) {
            String path = dm.getTorrentSaveDirAndFile();
            MessageBox mb = new MessageBox(this.cTablePanel.getShell(), 200);
            mb.setText(MessageText.getString("deletedata.title"));
            mb.setMessage(String.valueOf(MessageText.getString("deletedata.message1")) + dm.getDisplayName() + " :\n" + path + MessageText.getString("deletedata.message2"));
            choice = mb.open();
        } else {
            choice = 64;
        }
        if (choice == 64) {
            try {
                dm.stopIt(70, bDeleteTorrent, bDeleteData);
                dm.getGlobalManager().removeDownloadManager(dm);
            }
            catch (GlobalManagerDownloadRemovalVetoException f) {
                Alerts.showErrorMessageBoxUsingResourceString("globalmanager.download.remove.veto", f);
            }
            catch (Exception ex) {
                Debug.printStackTrace(ex);
            }
        }
    }

    private void removeSelectedTorrents() {
        this.runForSelectedRows(new TableView.GroupTableRowRunner(this){

            public void run(TableRowCore row) {
                MyTorrentsView.this.removeTorrent((DownloadManager)row.getDataSource(true), false, false);
            }
        });
    }

    private void stopSelectedTorrents() {
        this.runForSelectedRows(new TableView.GroupTableRowRunner(this){

            public void run(TableRowCore row) {
                ManagerUtils.stop((DownloadManager)row.getDataSource(true), MyTorrentsView.this.cTablePanel);
            }
        });
    }

    private void queueSelectedTorrents() {
        this.runForSelectedRows(new TableView.GroupTableRowRunner(this){

            public void run(TableRowCore row) {
                ManagerUtils.queue((DownloadManager)row.getDataSource(true), MyTorrentsView.this.cTablePanel);
            }
        });
    }

    private void resumeSelectedTorrents() {
        this.runForSelectedRows(new TableView.GroupTableRowRunner(this){

            public void run(TableRowCore row) {
                ManagerUtils.start((DownloadManager)row.getDataSource(true));
            }
        });
    }

    private void hostSelectedTorrents() {
        this.runForSelectedRows(new TableView.GroupTableRowRunner(this){

            public void run(TableRowCore row) {
                ManagerUtils.host(MyTorrentsView.this.azureus_core, (DownloadManager)row.getDataSource(true), MyTorrentsView.this.cTablePanel);
            }
        });
        MainWindow.getWindow().showMyTracker();
    }

    private void publishSelectedTorrents() {
        this.runForSelectedRows(new TableView.GroupTableRowRunner(this){

            public void run(TableRowCore row) {
                ManagerUtils.publish(MyTorrentsView.this.azureus_core, (DownloadManager)row.getDataSource(true), MyTorrentsView.this.cTablePanel);
            }
        });
        MainWindow.getWindow().showMyTracker();
    }

    private void runSelectedTorrents() {
        DownloadManager dm = (DownloadManager)this.getFirstSelectedDataSource();
        if (dm != null) {
            ManagerUtils.run(dm);
        }
    }

    private void moveSelectedTorrentsDown() {
        Object[] dataSources = this.getSelectedDataSources();
        Arrays.sort(dataSources, new Comparator(){

            public int compare(Object a, Object b) {
                return ((DownloadManager)a).getPosition() - ((DownloadManager)b).getPosition();
            }
        });
        int i = dataSources.length - 1;
        while (i >= 0) {
            DownloadManager dm = (DownloadManager)dataSources[i];
            if (dm.isMoveableDown()) {
                dm.moveDown();
            }
            --i;
        }
        if (this.sorter.getLastField().equals("#")) {
            this.sorter.sortColumn(true);
        }
    }

    private void moveSelectedTorrentsUp() {
        Object[] dataSources = this.getSelectedDataSources();
        Arrays.sort(dataSources, new Comparator(){

            public int compare(Object a, Object b) {
                return ((DownloadManager)a).getPosition() - ((DownloadManager)b).getPosition();
            }
        });
        int i = 0;
        while (i < dataSources.length) {
            DownloadManager dm = (DownloadManager)dataSources[i];
            if (dm.isMoveableUp()) {
                dm.moveUp();
            }
            ++i;
        }
        if (this.sorter.getLastField().equals("#")) {
            this.sorter.sortColumn(true);
        }
    }

    private void moveSelectedTorrentsTop() {
        this.moveSelectedTorrentsTopOrEnd(true);
    }

    private void moveSelectedTorrentsEnd() {
        this.moveSelectedTorrentsTopOrEnd(false);
    }

    private void moveSelectedTorrentsTopOrEnd(boolean moveToTop) {
        DownloadManager[] downloadManagers = (DownloadManager[])this.getSelectedDataSources(new DownloadManager[0]);
        if (downloadManagers.length == 0) {
            return;
        }
        if (moveToTop) {
            this.globalManager.moveTop(downloadManagers);
        } else {
            this.globalManager.moveEnd(downloadManagers);
        }
        if (this.sorter.getLastField().equals("#")) {
            this.sorter.sortColumn(true);
        }
    }

    public void parameterChanged(String parameterName) {
        super.parameterChanged(parameterName);
        this.confirmDataDelete = COConfigurationManager.getBooleanParameter("Confirm Data Delete", true);
    }

    private void computePossibleActions() {
        Object[] dataSources = this.getSelectedDataSources();
        this.remove = dataSources.length > 0;
        this.publish = this.remove;
        this.host = this.remove;
        this.run = this.remove;
        this.down = this.remove;
        this.up = this.remove;
        this.stop = false;
        this.start = false;
        this.bottom = false;
        this.top = false;
        int i = 0;
        while (i < dataSources.length) {
            DownloadManager dm = (DownloadManager)dataSources[i];
            if (!this.start && ManagerUtils.isStartable(dm)) {
                this.start = true;
            }
            if (!this.stop && ManagerUtils.isStopable(dm)) {
                this.stop = true;
            }
            if (!this.top && dm.isMoveableUp()) {
                this.top = true;
            }
            if (!this.bottom && dm.isMoveableDown()) {
                this.bottom = true;
            }
            ++i;
        }
    }

    public boolean isEnabled(String itemKey) {
        if (itemKey.equals("run")) {
            return this.run;
        }
        if (itemKey.equals("host")) {
            return this.host;
        }
        if (itemKey.equals("publish")) {
            return this.publish;
        }
        if (itemKey.equals("start")) {
            return this.start;
        }
        if (itemKey.equals("stop")) {
            return this.stop;
        }
        if (itemKey.equals("remove")) {
            return this.remove;
        }
        if (itemKey.equals("top")) {
            return this.top;
        }
        if (itemKey.equals("bottom")) {
            return this.bottom;
        }
        if (itemKey.equals("up")) {
            return this.up;
        }
        if (itemKey.equals("down")) {
            return this.down;
        }
        return false;
    }

    public void itemActivated(String itemKey) {
        if (itemKey.equals("top")) {
            this.moveSelectedTorrentsTop();
            return;
        }
        if (itemKey.equals("bottom")) {
            this.moveSelectedTorrentsEnd();
            return;
        }
        if (itemKey.equals("up")) {
            this.moveSelectedTorrentsUp();
            return;
        }
        if (itemKey.equals("down")) {
            this.moveSelectedTorrentsDown();
            return;
        }
        if (itemKey.equals("run")) {
            this.runSelectedTorrents();
            return;
        }
        if (itemKey.equals("host")) {
            this.hostSelectedTorrents();
            return;
        }
        if (itemKey.equals("publish")) {
            this.publishSelectedTorrents();
            return;
        }
        if (itemKey.equals("start")) {
            this.queueSelectedTorrents();
            return;
        }
        if (itemKey.equals("stop")) {
            this.stopSelectedTorrents();
            return;
        }
        if (itemKey.equals("remove")) {
            this.removeSelectedTorrents();
            return;
        }
    }

    public void removeDownloadBar(DownloadManager dm) {
        try {
            this.downloadBars_mon.enter();
            this.downloadBars.remove(dm);
        }
        finally {
            this.downloadBars_mon.exit();
        }
    }

    private void addCategory() {
        CategoryAdderWindow adderWindow = new CategoryAdderWindow(MainWindow.getWindow().getDisplay());
        Category newCategory = adderWindow.getNewCategory();
        if (newCategory != null) {
            this.assignSelectedToCategory(newCategory);
        }
    }

    public void downloadManagerAdded(Category category, DownloadManager manager) {
        boolean bCompleted;
        boolean bl = bCompleted = manager.getStats().getDownloadCompleted(false) == 1000;
        if (bCompleted && this.isSeedingView || !bCompleted && !this.isSeedingView) {
            this.addDataSource(manager);
        }
    }

    public void downloadManagerRemoved(Category category, DownloadManager removed) {
        this.removeDataSource(removed);
    }

    public void stateChanged(DownloadManager manager, int state) {
    }

    public void positionChanged(DownloadManager download, int oldPosition, int newPosition) {
    }

    public void completionChanged(DownloadManager manager, boolean bCompleted) {
        if (this.isSeedingView && bCompleted || !this.isSeedingView && !bCompleted) {
            this.addDataSource(manager);
        } else if (this.isSeedingView && !bCompleted || !this.isSeedingView && bCompleted) {
            this.removeDataSource(manager);
        }
    }

    public void downloadComplete(DownloadManager manager) {
    }

    private void assignSelectedToCategory(final Category category) {
        this.runForSelectedRows(new TableView.GroupTableRowRunner(this){

            public void run(TableRowCore row) {
                ((DownloadManager)row.getDataSource(true)).getDownloadState().setCategory(category);
            }
        });
    }

    private void activateCategory(Category category) {
        if (this.currentCategory != null) {
            this.currentCategory.removeCategoryListener(this);
        }
        if (category != null) {
            category.addCategoryListener(this);
        }
        this.currentCategory = category;
        int catType = this.currentCategory == null ? 1 : this.currentCategory.getType();
        List managers = catType == 0 ? this.currentCategory.getDownloadManagers() : this.globalManager.getDownloadManagers();
        this.removeAllTableRows();
        if (catType == 2) {
            int i = 0;
            while (i < managers.size()) {
                DownloadManager manager = (DownloadManager)managers.get(i);
                if (manager.getDownloadState().getCategory() == null) {
                    this.downloadManagerAdded(this.currentCategory, manager);
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < managers.size()) {
                this.downloadManagerAdded(this.currentCategory, (DownloadManager)managers.get(i));
                ++i;
            }
        }
    }

    public void categoryAdded(Category category) {
        MainWindow.getWindow().getDisplay().asyncExec((Runnable)new AERunnable(){

            public void runSupport() {
                MyTorrentsView.this.createTabs();
                MyTorrentsView.this.addCategorySubMenu();
            }
        });
    }

    public void categoryRemoved(Category category) {
        MainWindow.getWindow().getDisplay().asyncExec((Runnable)new AERunnable(){

            public void runSupport() {
                MyTorrentsView.this.createTabs();
                MyTorrentsView.this.addCategorySubMenu();
            }
        });
    }

    public void downloadManagerAdded(DownloadManager dm) {
        dm.addListener(this);
        if (this.skipDMAdding || this.currentCategory != null && this.currentCategory.getType() == 0) {
            return;
        }
        Category cat = dm.getDownloadState().getCategory();
        if (cat == null) {
            this.downloadManagerAdded(null, dm);
        }
    }

    public void downloadManagerRemoved(DownloadManager dm) {
        dm.removeListener(this);
        MinimizedWindow mw = (MinimizedWindow)this.downloadBars.remove(dm);
        if (mw != null) {
            mw.close();
        }
        if (this.skipDMAdding || this.currentCategory != null && this.currentCategory.getType() == 0) {
            return;
        }
        this.downloadManagerRemoved(null, dm);
    }

    public void destroyInitiated() {
    }

    public void destroyed() {
    }

    private void setSelectedTorrentsSpeed(int speed) {
        Object[] dms = this.getSelectedDataSources();
        if (dms.length > 0) {
            int i = 0;
            while (i < dms.length) {
                try {
                    DownloadManager dm = (DownloadManager)dms[i];
                    dm.getStats().setUploadRateLimitBytesPerSecond(speed);
                }
                catch (Exception e) {
                    Debug.printStackTrace(e);
                }
                ++i;
            }
        }
    }

    static /* synthetic */ void access$10(MyTorrentsView myTorrentsView) {
        myTorrentsView.changeDirSelectedTorrents();
    }
}

