/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views;

import com.aelitis.azureus.core.AzureusCore;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.download.DownloadManagerListener;
import org.gudy.azureus2.core3.global.GlobalManagerDownloadRemovalVetoException;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.ui.swt.Alerts;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.mainwindow.Colors;
import org.gudy.azureus2.ui.swt.mainwindow.MainWindow;
import org.gudy.azureus2.ui.swt.views.AbstractIView;
import org.gudy.azureus2.ui.swt.views.FilesView;
import org.gudy.azureus2.ui.swt.views.GeneralView;
import org.gudy.azureus2.ui.swt.views.IView;
import org.gudy.azureus2.ui.swt.views.PeersView;
import org.gudy.azureus2.ui.swt.views.PiecesView;
import org.gudy.azureus2.ui.swt.views.utils.ManagerUtils;

public class ManagerView
extends AbstractIView
implements DownloadManagerListener {
    AzureusCore azureus_core;
    DownloadManager manager;
    TabFolder folder;
    TabItem itemGeneral;
    TabItem itemDetails;
    TabItem itemGraphic;
    TabItem itemPieces;
    TabItem itemFiles;
    IView viewGeneral;
    IView viewDetails;
    IView viewGraphic;
    IView viewPieces;
    IView viewFiles;

    public ManagerView(AzureusCore _azureus_core, DownloadManager manager) {
        this.azureus_core = _azureus_core;
        this.manager = manager;
        manager.addListener(this);
    }

    public void delete() {
        MainWindow.getWindow().removeManagerView(this.manager);
        this.manager.removeListener(this);
        if (Constants.isOSX && this.folder != null && !this.folder.isDisposed()) {
            TabItem[] items = this.folder.getItems();
            int i = 0;
            while (i < items.length) {
                if (!items[i].isDisposed()) {
                    items[i].dispose();
                }
                ++i;
            }
        }
        if (this.viewGeneral != null) {
            this.viewGeneral.delete();
        }
        if (this.viewDetails != null) {
            this.viewDetails.delete();
        }
        if (this.viewGraphic != null) {
            this.viewGraphic.delete();
        }
        if (this.viewPieces != null) {
            this.viewPieces.delete();
        }
        if (this.viewFiles != null) {
            this.viewFiles.delete();
        }
        if (this.folder != null && !this.folder.isDisposed()) {
            this.folder.dispose();
        }
    }

    public Composite getComposite() {
        return this.folder;
    }

    public String getFullTitle() {
        int completed = this.manager.getStats().getCompleted();
        return String.valueOf(completed / 10).concat(".").concat(String.valueOf(completed % 10)).concat("% : ").concat(this.manager.getDisplayName());
    }

    public void initialize(Composite composite) {
        if (this.folder == null) {
            this.folder = new TabFolder(composite, 16384);
            this.folder.setBackground(Colors.background);
        } else {
            System.out.println("ManagerView::initialize : folder isn't null !!!");
        }
        this.itemGeneral = new TabItem(this.folder, 0);
        this.itemDetails = new TabItem(this.folder, 0);
        this.itemPieces = new TabItem(this.folder, 0);
        this.itemFiles = new TabItem(this.folder, 0);
        this.viewGeneral = new GeneralView(this.manager);
        this.viewDetails = new PeersView(this.manager);
        this.viewPieces = new PiecesView(this.manager);
        this.viewFiles = new FilesView(this.manager);
        Messages.setLanguageText((Widget)this.itemGeneral, this.viewGeneral.getData());
        Messages.setLanguageText((Widget)this.itemDetails, this.viewDetails.getData());
        Messages.setLanguageText((Widget)this.itemPieces, this.viewPieces.getData());
        Messages.setLanguageText((Widget)this.itemFiles, this.viewFiles.getData());
        TabItem[] items = new TabItem[]{this.itemGeneral};
        this.folder.setSelection(items);
        this.viewGeneral.initialize((Composite)this.folder);
        this.itemGeneral.setControl((Control)this.viewGeneral.getComposite());
        this.viewDetails.initialize((Composite)this.folder);
        this.itemDetails.setControl((Control)this.viewDetails.getComposite());
        this.viewPieces.initialize((Composite)this.folder);
        this.itemPieces.setControl((Control)this.viewPieces.getComposite());
        this.viewFiles.initialize((Composite)this.folder);
        this.itemFiles.setControl((Control)this.viewFiles.getComposite());
        this.folder.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ManagerView.this.refresh();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.refresh();
        this.viewGeneral.getComposite().layout(true);
    }

    public void refresh() {
        if (this.getComposite() == null || this.getComposite().isDisposed()) {
            return;
        }
        try {
            switch (this.folder.getSelectionIndex()) {
                case 0: {
                    if (this.viewGeneral == null || this.itemGeneral.isDisposed()) break;
                    this.viewGeneral.refresh();
                    break;
                }
                case 1: {
                    if (this.viewDetails == null || this.itemDetails.isDisposed()) break;
                    this.viewDetails.refresh();
                    break;
                }
                case 2: {
                    if (this.viewPieces == null || this.itemPieces.isDisposed()) break;
                    this.viewPieces.refresh();
                    break;
                }
                case 3: {
                    if (this.viewFiles == null || this.itemFiles.isDisposed()) break;
                    this.viewFiles.refresh();
                }
            }
        }
        catch (Exception e) {
            Debug.printStackTrace(e);
        }
    }

    public boolean isEnabled(String itemKey) {
        if (itemKey.equals("run")) {
            return true;
        }
        if (itemKey.equals("start")) {
            return ManagerUtils.isStartable(this.manager);
        }
        if (itemKey.equals("stop")) {
            return ManagerUtils.isStopable(this.manager);
        }
        if (itemKey.equals("host")) {
            return true;
        }
        if (itemKey.equals("publish")) {
            return true;
        }
        return itemKey.equals("remove");
    }

    public void itemActivated(String itemKey) {
        if (itemKey.equals("run")) {
            ManagerUtils.run(this.manager);
            return;
        }
        if (itemKey.equals("start")) {
            ManagerUtils.queue(this.manager, (Composite)this.folder);
            return;
        }
        if (itemKey.equals("stop")) {
            ManagerUtils.stop(this.manager, (Composite)this.folder);
            return;
        }
        if (itemKey.equals("host")) {
            ManagerUtils.host(this.azureus_core, this.manager, (Composite)this.folder);
            MainWindow.getWindow().showMyTracker();
            return;
        }
        if (itemKey.equals("publish")) {
            ManagerUtils.publish(this.azureus_core, this.manager, (Composite)this.folder);
            MainWindow.getWindow().showMyTracker();
            return;
        }
        if (itemKey.equals("remove")) {
            try {
                if (COConfigurationManager.getBooleanParameter("confirm_torrent_removal")) {
                    MessageBox mb = new MessageBox(this.folder.getShell(), 200);
                    mb.setText(MessageText.getString("deletedata.title"));
                    mb.setMessage(String.valueOf(MessageText.getString("MyTorrentsView.confirm_torrent_removal")) + this.manager.getDisplayName());
                    if (mb.open() == 128) {
                        return;
                    }
                }
                this.manager.stopIt(70, false, false);
                this.manager.getGlobalManager().removeDownloadManager(this.manager);
            }
            catch (GlobalManagerDownloadRemovalVetoException e) {
                Alerts.showErrorMessageBoxUsingResourceString("globalmanager.download.remove.veto", e);
            }
            return;
        }
    }

    public void downloadComplete(DownloadManager manager) {
    }

    public void completionChanged(DownloadManager manager, boolean bCompleted) {
    }

    public void stateChanged(DownloadManager manager, int state) {
        if (this.folder == null || this.folder.isDisposed()) {
            return;
        }
        Display display = this.folder.getDisplay();
        if (display == null || display.isDisposed()) {
            return;
        }
        display.asyncExec((Runnable)new AERunnable(){

            public void runSupport() {
                MainWindow.getWindow().refreshIconBar();
            }
        });
    }

    public void positionChanged(DownloadManager download, int oldPosition, int newPosition) {
    }
}

