/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views;

import com.aelitis.azureus.core.AzureusCore;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.logging.LGLogger;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.ui.config.ConfigSection;
import org.gudy.azureus2.plugins.ui.config.ConfigSectionSWT;
import org.gudy.azureus2.plugins.ui.config.Parameter;
import org.gudy.azureus2.pluginsimpl.local.ui.config.BooleanParameterImpl;
import org.gudy.azureus2.pluginsimpl.local.ui.config.ConfigSectionRepository;
import org.gudy.azureus2.pluginsimpl.local.ui.config.ParameterRepository;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.config.DualChangeSelectionActionPerformer;
import org.gudy.azureus2.ui.swt.config.plugins.PluginParameter;
import org.gudy.azureus2.ui.swt.mainwindow.Colors;
import org.gudy.azureus2.ui.swt.mainwindow.Cursors;
import org.gudy.azureus2.ui.swt.mainwindow.MainWindow;
import org.gudy.azureus2.ui.swt.views.AbstractIView;
import org.gudy.azureus2.ui.swt.views.configsections.ConfigSectionConnection;
import org.gudy.azureus2.ui.swt.views.configsections.ConfigSectionFile;
import org.gudy.azureus2.ui.swt.views.configsections.ConfigSectionFilePerformance;
import org.gudy.azureus2.ui.swt.views.configsections.ConfigSectionFileTorrents;
import org.gudy.azureus2.ui.swt.views.configsections.ConfigSectionIPFilter;
import org.gudy.azureus2.ui.swt.views.configsections.ConfigSectionInterface;
import org.gudy.azureus2.ui.swt.views.configsections.ConfigSectionInterfaceDisplay;
import org.gudy.azureus2.ui.swt.views.configsections.ConfigSectionInterfaceLanguage;
import org.gudy.azureus2.ui.swt.views.configsections.ConfigSectionInterfaceStart;
import org.gudy.azureus2.ui.swt.views.configsections.ConfigSectionLogging;
import org.gudy.azureus2.ui.swt.views.configsections.ConfigSectionSecurity;
import org.gudy.azureus2.ui.swt.views.configsections.ConfigSectionSharing;
import org.gudy.azureus2.ui.swt.views.configsections.ConfigSectionStats;
import org.gudy.azureus2.ui.swt.views.configsections.ConfigSectionTracker;
import org.gudy.azureus2.ui.swt.views.configsections.ConfigSectionTrackerClient;
import org.gudy.azureus2.ui.swt.views.configsections.ConfigSectionTrackerServer;
import org.gudy.azureus2.ui.swt.views.configsections.ConfigSectionTransfer;

public class ConfigView
extends AbstractIView {
    private static final String sSectionPrefix = "ConfigView.section.";
    AzureusCore azureus_core;
    Composite cConfig;
    Composite cConfigSection;
    StackLayout layoutConfigSection;
    Label lHeader;
    Font headerFont;
    Tree tree;
    TreeItem treePlugins;
    ArrayList pluginSections;

    public ConfigView(AzureusCore _azureus_core) {
        this.azureus_core = _azureus_core;
    }

    public void initialize(Composite composite) {
        try {
            this.cConfig = new Composite(composite, 0);
            GridLayout configLayout = new GridLayout();
            configLayout.marginHeight = 0;
            configLayout.marginWidth = 0;
            this.cConfig.setLayout((Layout)configLayout);
            GridData gridData = new GridData(1808);
            this.cConfig.setLayoutData((Object)gridData);
            SashForm form = new SashForm(this.cConfig, 256);
            gridData = new GridData(1808);
            form.setLayoutData((Object)gridData);
            this.tree = new Tree((Composite)form, 2048);
            this.tree.setLayout((Layout)new FillLayout());
            Composite cRightSide = new Composite((Composite)form, 0);
            configLayout = new GridLayout();
            configLayout.marginHeight = 3;
            configLayout.marginWidth = 0;
            cRightSide.setLayout((Layout)configLayout);
            Composite cHeader = new Composite(cRightSide, 2048);
            configLayout = new GridLayout();
            configLayout.marginHeight = 3;
            configLayout.marginWidth = 0;
            cHeader.setLayout((Layout)configLayout);
            gridData = new GridData(772);
            cHeader.setLayoutData((Object)gridData);
            Display d = cRightSide.getDisplay();
            cHeader.setBackground(d.getSystemColor(26));
            cHeader.setForeground(d.getSystemColor(27));
            this.lHeader = new Label(cHeader, 0);
            this.lHeader.setBackground(d.getSystemColor(26));
            this.lHeader.setForeground(d.getSystemColor(27));
            FontData[] fontData = this.lHeader.getFont().getFontData();
            fontData[0].setStyle(1);
            int fontHeight = (int)((double)fontData[0].getHeight() * 1.2);
            fontData[0].setHeight(fontHeight);
            this.headerFont = new Font((Device)d, fontData);
            this.lHeader.setFont(this.headerFont);
            gridData = new GridData(772);
            this.lHeader.setLayoutData((Object)gridData);
            this.cConfigSection = new Composite(cRightSide, 0);
            this.layoutConfigSection = new StackLayout();
            this.cConfigSection.setLayout((Layout)this.layoutConfigSection);
            gridData = new GridData(1808);
            this.cConfigSection.setLayoutData((Object)gridData);
            form.setWeights(new int[]{20, 80});
            this.tree.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Tree tree = (Tree)e.getSource();
                    if (tree.getSelection().length > 0) {
                        ConfigView.this.showSection(tree.getSelection()[0]);
                    }
                }
            });
            this.tree.addListener(14, new Listener(){

                public void handleEvent(Event e) {
                    TreeItem item = (TreeItem)e.item;
                    if (item != null) {
                        item.setExpanded(!item.getExpanded());
                    }
                }
            });
        }
        catch (Exception e) {
            LGLogger.log(3, "Error initializing ConfigView");
            Debug.printStackTrace(e);
        }
        this.pluginSections = ConfigSectionRepository.getInstance().getList();
        ConfigSection[] internalSections = new ConfigSection[]{new ConfigSectionConnection(), new ConfigSectionTransfer(), new ConfigSectionFile(), new ConfigSectionFileTorrents(), new ConfigSectionFilePerformance(), new ConfigSectionInterface(), new ConfigSectionInterfaceLanguage(), new ConfigSectionInterfaceStart(), new ConfigSectionInterfaceDisplay(), new ConfigSectionIPFilter(this.azureus_core), new ConfigSectionStats(), new ConfigSectionTracker(this.azureus_core), new ConfigSectionTrackerClient(), new ConfigSectionTrackerServer(this.azureus_core), new ConfigSectionSecurity(), new ConfigSectionSharing(), new ConfigSectionLogging()};
        this.pluginSections.addAll(0, Arrays.asList(internalSections));
        int i = 0;
        while (i < this.pluginSections.size()) {
            ConfigSection section;
            boolean plugin_section;
            boolean bl = plugin_section = i >= internalSections.length;
            if (i == internalSections.length) {
                try {
                    this.initGroupPlugins();
                }
                catch (Exception e) {
                    LGLogger.log(3, "Error initializing ConfigView.Plugins");
                    Debug.printStackTrace(e);
                }
            }
            if ((section = (ConfigSection)this.pluginSections.get(i)) instanceof ConfigSectionSWT) {
                String name;
                try {
                    name = section.configSectionGetName();
                }
                catch (Exception e) {
                    LGLogger.log(3, "A ConfigSection plugin caused an error while trying to call its configSectionGetName function");
                    name = "Bad Plugin";
                    Debug.printStackTrace(e);
                }
                try {
                    TreeItem treeItemFound;
                    TreeItem treeItem = null;
                    String location = section.configSectionGetParentSection();
                    if (location.equalsIgnoreCase("root")) {
                        treeItem = new TreeItem(this.tree, 0);
                    } else if (location != "" && (treeItemFound = this.findTreeItem(this.tree, location)) != null) {
                        treeItem = new TreeItem(treeItemFound, 0);
                    }
                    if (treeItem == null) {
                        treeItem = new TreeItem(this.treePlugins, 0);
                    }
                    ScrolledComposite sc = new ScrolledComposite(this.cConfigSection, 768);
                    sc.setExpandHorizontal(true);
                    sc.setExpandVertical(true);
                    sc.setLayoutData((Object)new GridData(1808));
                    String section_key = name;
                    if (plugin_section) {
                        if (!MessageText.keyExists(section_key)) {
                            section_key = sSectionPrefix + name;
                        }
                    } else {
                        section_key = sSectionPrefix + name;
                    }
                    Messages.setLanguageText((Widget)treeItem, section_key);
                    treeItem.setData("Panel", (Object)sc);
                    treeItem.setData("ID", (Object)name);
                    treeItem.setData("ConfigSectionSWT", (Object)section);
                }
                catch (Exception e) {
                    LGLogger.log(3, "ConfigSection plugin '" + name + "' caused an error");
                    Debug.printStackTrace(e);
                }
            }
            ++i;
        }
        this.initSaveButton();
        TreeItem[] items = new TreeItem[]{this.tree.getItems()[0]};
        this.tree.setSelection(items);
        this.showSection(items[0]);
    }

    private void showSection(TreeItem section) {
        ScrolledComposite item = (ScrolledComposite)section.getData("Panel");
        if (item != null) {
            ConfigSectionSWT configSection = (ConfigSectionSWT)section.getData("ConfigSectionSWT");
            if (configSection != null) {
                Composite c = configSection.configSectionCreate((Composite)item);
                item.setContent((Control)c);
                c.layout();
                section.setData("ConfigSectionSWT", null);
            }
            this.layoutConfigSection.topControl = item;
            ScrolledComposite sc = item;
            Composite c = (Composite)sc.getContent();
            sc.setMinSize(c.computeSize(-1, -1));
            this.cConfigSection.layout();
            this.updateHeader(section);
        }
    }

    private void updateHeader(TreeItem section) {
        if (section == null) {
            return;
        }
        String sHeader = section.getText();
        section = section.getParentItem();
        while (section != null) {
            sHeader = String.valueOf(section.getText()) + " : " + sHeader;
            section = section.getParentItem();
        }
        this.lHeader.setText(" " + sHeader);
    }

    private Composite createConfigSection(String sNameID) {
        return this.createConfigSection(null, sNameID, -1, true);
    }

    private Composite createConfigSection(String sNameID, int position) {
        return this.createConfigSection(null, sNameID, position, true);
    }

    private Composite createConfigSection(TreeItem treeItemParent, String sNameID, int position, boolean bPrefix) {
        ScrolledComposite sc = new ScrolledComposite(this.cConfigSection, 768);
        sc.setExpandHorizontal(true);
        sc.setExpandVertical(true);
        sc.setLayoutData((Object)new GridData(1808));
        Composite cConfigSection = new Composite((Composite)sc, 0);
        TreeItem treeItem = treeItemParent == null ? (position >= 0 ? new TreeItem(this.tree, 0, position) : new TreeItem(this.tree, 0)) : (position >= 0 ? new TreeItem(treeItemParent, 0, position) : new TreeItem(treeItemParent, 0));
        Messages.setLanguageText((Widget)treeItem, String.valueOf(bPrefix ? sSectionPrefix : "") + sNameID);
        treeItem.setData("Panel", (Object)sc);
        treeItem.setData("ID", (Object)sNameID);
        sc.setContent((Control)cConfigSection);
        return cConfigSection;
    }

    private TreeItem findTreeItem(Tree tree, String ID) {
        TreeItem[] items = tree.getItems();
        int i = 0;
        while (i < items.length) {
            String itemID = (String)items[i].getData("ID");
            if (itemID != null && itemID.equalsIgnoreCase(ID)) {
                return items[i];
            }
            TreeItem itemFound = this.findTreeItem(items[i], ID);
            if (itemFound != null) {
                return itemFound;
            }
            ++i;
        }
        return null;
    }

    private TreeItem findTreeItem(TreeItem item, String ID) {
        TreeItem[] subItems = item.getItems();
        int i = 0;
        while (i < subItems.length) {
            String itemID = (String)subItems[i].getData("ID");
            if (itemID != null && itemID.equalsIgnoreCase(ID)) {
                return subItems[i];
            }
            TreeItem itemFound = this.findTreeItem(subItems[i], ID);
            if (itemFound != null) {
                return itemFound;
            }
            ++i;
        }
        return null;
    }

    private void initSaveButton() {
        Button save = new Button(this.cConfig, 8);
        Messages.setLanguageText((Widget)save, "ConfigView.button.save");
        GridData gridData = new GridData(32);
        gridData.horizontalSpan = 2;
        gridData.widthHint = 80;
        save.setLayoutData((Object)gridData);
        save.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                COConfigurationManager.setParameter("updated", 1);
                COConfigurationManager.save();
                int i = 0;
                while (i < ConfigView.this.pluginSections.size()) {
                    ((ConfigSection)ConfigView.this.pluginSections.get(i)).configSectionSave();
                    ++i;
                }
            }
        });
    }

    private void initGroupPlugins() {
        PluginInterface pluginIF;
        String sAppPluginDir;
        Composite infoGroup = this.createConfigSection("plugins", 6);
        TreeItem treePlugins = this.findTreeItem(this.tree, "plugins");
        infoGroup.setLayout((Layout)new GridLayout());
        infoGroup.addControlListener((ControlListener)new Utils.LabelWrapControlListener());
        String sep = System.getProperty("file.separator");
        String sUserPluginDir = FileUtil.getUserFile("plugins").toString();
        if (!sUserPluginDir.endsWith(sep)) {
            sUserPluginDir = String.valueOf(sUserPluginDir) + sep;
        }
        if (!(sAppPluginDir = FileUtil.getApplicationFile("plugins").toString()).endsWith(sep)) {
            sAppPluginDir = String.valueOf(sAppPluginDir) + sep;
        }
        Label label = new Label(infoGroup, 64);
        label.setLayoutData((Object)new GridData(768));
        Messages.setLanguageText((Widget)label, "ConfigView.pluginlist.whereToPut");
        label = new Label(infoGroup, 64);
        GridData gridData = new GridData(768);
        gridData.horizontalIndent = 10;
        label.setLayoutData((Object)gridData);
        label.setText(sUserPluginDir);
        label.setForeground(Colors.blue);
        label.setCursor(Cursors.handCursor);
        final String _sUserPluginDir = sUserPluginDir;
        label.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent arg0) {
                if (_sUserPluginDir.endsWith("/plugins/") || _sUserPluginDir.endsWith("\\plugins\\")) {
                    File f = new File(_sUserPluginDir);
                    if (f.exists() && f.isDirectory()) {
                        Program.launch((String)_sUserPluginDir);
                    } else {
                        String azureusDir = _sUserPluginDir.substring(0, _sUserPluginDir.length() - 9);
                        System.out.println(azureusDir);
                        Program.launch((String)azureusDir);
                    }
                }
            }
        });
        label = new Label(infoGroup, 64);
        label.setLayoutData((Object)new GridData(768));
        Messages.setLanguageText((Widget)label, "ConfigView.pluginlist.whereToPutOr");
        label = new Label(infoGroup, 64);
        gridData = new GridData(768);
        gridData.horizontalIndent = 10;
        label.setLayoutData((Object)gridData);
        label.setText(sAppPluginDir);
        label.setForeground(Colors.blue);
        label.setCursor(Cursors.handCursor);
        final String _sAppPluginDir = sAppPluginDir;
        label.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent arg0) {
                if (_sAppPluginDir.endsWith("/plugins/") || _sAppPluginDir.endsWith("\\plugins\\")) {
                    File f = new File(_sAppPluginDir);
                    if (f.exists() && f.isDirectory()) {
                        Program.launch((String)_sAppPluginDir);
                    } else {
                        String azureusDir = _sAppPluginDir.substring(0, _sAppPluginDir.length() - 9);
                        System.out.println(azureusDir);
                        Program.launch((String)azureusDir);
                    }
                }
            }
        });
        List<PluginInterface> pluginIFs = Arrays.asList(this.azureus_core.getPluginManager().getPlugins());
        Collections.sort(pluginIFs, new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((PluginInterface)o1).getPluginName().compareToIgnoreCase(((PluginInterface)o2).getPluginName());
            }
        });
        Label labelInfo = new Label(infoGroup, 64);
        labelInfo.setLayoutData((Object)new GridData(768));
        int numPlugins = 0;
        int i = 0;
        while (i < pluginIFs.size()) {
            pluginIF = pluginIFs.get(i);
            Properties p = pluginIF.getPluginProperties();
            String plugin_name = pluginIF.getPluginName();
            String plugin_version = pluginIF.getPluginVersion();
            String sDirName = pluginIF.getPluginDirectoryName();
            boolean user_plugin = false;
            if (sDirName.length() > sUserPluginDir.length() && sDirName.substring(0, sUserPluginDir.length()).equals(sUserPluginDir)) {
                sDirName = sDirName.substring(sUserPluginDir.length());
                user_plugin = true;
            } else if (sDirName.length() > sAppPluginDir.length() && sDirName.substring(0, sAppPluginDir.length()).equals(sAppPluginDir)) {
                sDirName = sDirName.substring(sAppPluginDir.length());
            }
            if (!sDirName.equals("")) {
                label = new Label(infoGroup, 0);
                String broken_str = pluginIF.isOperational() ? "" : " - " + MessageText.getString("ConfigView.pluginlist.broken");
                String shared_str = user_plugin ? "" : " [" + MessageText.getString("ConfigView.pluginlist.shared") + "]";
                label.setText(" - " + plugin_name + (plugin_version == null ? "" : " " + plugin_version) + " (" + sDirName + ")" + broken_str + shared_str);
                ++numPlugins;
            }
            ++i;
        }
        Messages.setLanguageText((Widget)labelInfo, numPlugins == 0 ? "ConfigView.pluginlist.noplugins" : "ConfigView.pluginlist.info");
        label = new Label(infoGroup, 0);
        Messages.setLanguageText((Widget)label, "ConfigView.pluginlist.coreplugins");
        i = 0;
        while (i < pluginIFs.size()) {
            pluginIF = pluginIFs.get(i);
            String plugin_name = pluginIF.getPluginName();
            String version = pluginIF.getPluginVersion();
            if (pluginIF.isBuiltIn()) {
                label = new Label(infoGroup, 0);
                label.setText(" - " + plugin_name + (version == null ? "" : " " + version));
            }
            ++i;
        }
        ParameterRepository repository = ParameterRepository.getInstance();
        Object[] names = repository.getNames();
        Arrays.sort(names);
        int i2 = 0;
        while (i2 < names.length) {
            Parameter parameter;
            Object pluginName = names[i2];
            Parameter[] parameters = repository.getParameterBlock((String)pluginName);
            boolean bUsePrefix = MessageText.keyExists("ConfigView.section.plugins." + (String)pluginName);
            Composite pluginGroup = this.createConfigSection(treePlugins, (String)pluginName, -1, bUsePrefix);
            GridLayout pluginLayout = new GridLayout();
            pluginLayout.numColumns = 3;
            pluginGroup.setLayout((Layout)pluginLayout);
            HashMap<Parameter, PluginParameter> parameterToPluginParameter = new HashMap<Parameter, PluginParameter>();
            int j = 0;
            while (j < parameters.length) {
                parameter = parameters[j];
                parameterToPluginParameter.put(parameter, new PluginParameter(pluginGroup, parameter));
                ++j;
            }
            j = 0;
            while (j < parameters.length) {
                parameter = parameters[j];
                if (parameter instanceof BooleanParameterImpl) {
                    Control[] cd;
                    List parametersToEnable = ((BooleanParameterImpl)parameter).getEnabledOnSelectionParameters();
                    ArrayList<Control> controlsToEnable = new ArrayList<Control>();
                    Iterator iter = parametersToEnable.iterator();
                    while (iter.hasNext()) {
                        Parameter parameterToEnable = (Parameter)iter.next();
                        PluginParameter pp = (PluginParameter)parameterToPluginParameter.get(parameterToEnable);
                        Control[] controls = pp.getControls();
                        int k = 0;
                        while (k < controls.length) {
                            controlsToEnable.add(controls[k]);
                            ++k;
                        }
                    }
                    List parametersToDisable = ((BooleanParameterImpl)parameter).getDisabledOnSelectionParameters();
                    ArrayList<Control> controlsToDisable = new ArrayList<Control>();
                    iter = parametersToDisable.iterator();
                    while (iter.hasNext()) {
                        Parameter parameterToDisable = (Parameter)iter.next();
                        PluginParameter pp = (PluginParameter)parameterToPluginParameter.get(parameterToDisable);
                        Control[] controls = pp.getControls();
                        int k = 0;
                        while (k < controls.length) {
                            controlsToDisable.add(controls[k]);
                            ++k;
                        }
                    }
                    Control[] ce = new Control[controlsToEnable.size()];
                    if (ce.length + (cd = new Control[controlsToDisable.size()]).length > 0) {
                        DualChangeSelectionActionPerformer ap = new DualChangeSelectionActionPerformer(controlsToEnable.toArray(ce), controlsToDisable.toArray(cd));
                        PluginParameter pp = (PluginParameter)parameterToPluginParameter.get(parameter);
                        pp.setAdditionalActionPerfomer(ap);
                    }
                }
                ++j;
            }
            ++i2;
        }
    }

    public Composite getComposite() {
        return this.cConfig;
    }

    public void refresh() {
    }

    public void updateLanguage() {
        super.updateLanguage();
        this.updateHeader(this.tree.getSelection()[0]);
    }

    public void delete() {
        MainWindow.getWindow().setConfig(null);
        int i = 0;
        while (i < this.pluginSections.size()) {
            ((ConfigSection)this.pluginSections.get(i)).configSectionDelete();
            ++i;
        }
        this.pluginSections.clear();
        if (!this.tree.isDisposed()) {
            TreeItem[] items = this.tree.getItems();
            int i2 = 0;
            while (i2 < items.length) {
                Composite c = (Composite)items[i2].getData("Panel");
                Utils.disposeComposite(c);
                items[i2].setData("Panel", null);
                items[i2].setData("ConfigSectionSWT", null);
                ++i2;
            }
        }
        Utils.disposeComposite(this.cConfig);
        if (this.headerFont != null && !this.headerFont.isDisposed()) {
            this.headerFont.dispose();
            this.headerFont = null;
        }
    }

    public String getFullTitle() {
        return MessageText.getString("ConfigView.title.full");
    }
}

