/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.auth;

import java.net.PasswordAuthentication;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.security.SEPasswordListener;
import org.gudy.azureus2.core3.security.SESecurityManager;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.gudy.azureus2.ui.swt.ImageRepository;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.mainwindow.SWTThread;
import sun.misc.BASE64Encoder;

public class AuthenticatorWindow
implements SEPasswordListener {
    protected Map auth_cache = new HashMap();
    protected AEMonitor this_mon = new AEMonitor("AuthWind");

    public AuthenticatorWindow() {
        SESecurityManager.addPasswordListener(this);
    }

    public PasswordAuthentication getAuthentication(String realm, URL tracker) {
        try {
            this.this_mon.enter();
            PasswordAuthentication passwordAuthentication = this.getAuthentication(realm, tracker.getProtocol(), tracker.getHost(), tracker.getPort());
            this.this_mon.exit();
            return passwordAuthentication;
        }
        catch (Throwable throwable) {
            this.this_mon.exit();
            throw throwable;
        }
    }

    public void setAuthenticationOutcome(String realm, URL tracker, boolean success) {
        try {
            this.this_mon.enter();
            this.setAuthenticationOutcome(realm, tracker.getProtocol(), tracker.getHost(), tracker.getPort(), success);
        }
        finally {
            this.this_mon.exit();
        }
    }

    public void setAuthenticationOutcome(String realm, String protocol, String host, int port, boolean success) {
        try {
            this.this_mon.enter();
            String tracker = String.valueOf(protocol) + "://" + host + ":" + port + "/";
            String auth_key = String.valueOf(realm) + ":" + tracker;
            authCache cache = (authCache)this.auth_cache.get(auth_key);
            if (cache != null) {
                cache.setOutcome(success);
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PasswordAuthentication getAuthentication(String realm, String protocol, String host, int port) {
        try {
            PasswordAuthentication auth;
            String auth_key;
            authCache cache;
            this.this_mon.enter();
            String tracker = String.valueOf(protocol) + "://" + host + ":" + port + "/";
            String bind_ip = COConfigurationManager.getStringParameter("Bind IP", "");
            String self_addr = bind_ip.length() < 7 ? "127.0.0.1" : bind_ip;
            if (host.equals(self_addr) || host.equals(COConfigurationManager.getStringParameter("Tracker IP", ""))) {
                try {
                    byte[] pw = COConfigurationManager.getByteParameter("Tracker Password", new byte[0]);
                    String str_pw = new BASE64Encoder().encode(pw);
                    PasswordAuthentication passwordAuthentication = new PasswordAuthentication("<internal>", str_pw.toCharArray());
                    this.this_mon.exit();
                    return passwordAuthentication;
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
            if ((cache = (authCache)this.auth_cache.get(auth_key = String.valueOf(realm) + ":" + tracker)) != null && (auth = cache.getAuth()) != null) {
                PasswordAuthentication passwordAuthentication = auth;
                this.this_mon.exit();
                return passwordAuthentication;
            }
            String[] res = this.getAuthenticationDialog(realm, tracker);
            if (res == null) {
                PasswordAuthentication passwordAuthentication = null;
                this.this_mon.exit();
                return passwordAuthentication;
            }
            PasswordAuthentication auth2 = new PasswordAuthentication(res[0], res[1].toCharArray());
            this.auth_cache.put(auth_key, new authCache(auth2));
            PasswordAuthentication passwordAuthentication = auth2;
            this.this_mon.exit();
            return passwordAuthentication;
        }
        catch (Throwable throwable) {
            this.this_mon.exit();
            throw throwable;
        }
    }

    protected String[] getAuthenticationDialog(final String realm, final String tracker) {
        final Display display = SWTThread.getInstance().getDisplay();
        if (display.isDisposed()) {
            return null;
        }
        final AESemaphore sem = new AESemaphore("SWTAuth");
        final authDialog[] dialog = new authDialog[1];
        TOTorrent torrent = TorrentUtils.getTLSTorrent();
        final String torrent_name = torrent == null ? null : TorrentUtils.getLocalisedName(torrent);
        try {
            display.asyncExec((Runnable)new AERunnable(){

                public void runSupport() {
                    dialog[0] = new authDialog(sem, display, realm, tracker, torrent_name);
                }
            });
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
            return null;
        }
        sem.reserve();
        String user = dialog[0].getUsername();
        String pw = dialog[0].getPassword();
        if (user == null) {
            return null;
        }
        return new String[]{user, pw == null ? "" : pw};
    }

    protected class authDialog {
        protected Shell shell;
        protected AESemaphore sem;
        protected String username;
        protected String password;

        protected authDialog(AESemaphore _sem, Display display, String realm, String tracker, String torrent_name) {
            this.sem = _sem;
            if (display.isDisposed()) {
                this.sem.release();
                return;
            }
            this.shell = new Shell(display, 67680);
            if (!Constants.isOSX) {
                this.shell.setImage(ImageRepository.getImage("azureus"));
            }
            this.shell.setText(MessageText.getString("authenticator.title"));
            GridLayout layout = new GridLayout();
            layout.numColumns = 3;
            this.shell.setLayout((Layout)layout);
            Label realm_label = new Label((Composite)this.shell, 0);
            realm_label.setText(MessageText.getString("authenticator.realm"));
            GridData gridData = new GridData(1808);
            gridData.horizontalSpan = 1;
            realm_label.setLayoutData((Object)gridData);
            Label realm_value = new Label((Composite)this.shell, 0);
            realm_value.setText(realm);
            gridData = new GridData(1808);
            gridData.horizontalSpan = 2;
            realm_value.setLayoutData((Object)gridData);
            Label tracker_label = new Label((Composite)this.shell, 0);
            tracker_label.setText(MessageText.getString("authenticator.tracker"));
            gridData = new GridData(1808);
            gridData.horizontalSpan = 1;
            tracker_label.setLayoutData((Object)gridData);
            Label tracker_value = new Label((Composite)this.shell, 0);
            tracker_value.setText(tracker);
            gridData = new GridData(1808);
            gridData.horizontalSpan = 2;
            tracker_value.setLayoutData((Object)gridData);
            if (torrent_name != null) {
                Label torrent_label = new Label((Composite)this.shell, 0);
                torrent_label.setText(MessageText.getString("authenticator.torrent"));
                gridData = new GridData(1808);
                gridData.horizontalSpan = 1;
                torrent_label.setLayoutData((Object)gridData);
                Label torrent_value = new Label((Composite)this.shell, 0);
                torrent_value.setText(torrent_name);
                gridData = new GridData(1808);
                gridData.horizontalSpan = 2;
                torrent_value.setLayoutData((Object)gridData);
            }
            Label user_label = new Label((Composite)this.shell, 0);
            user_label.setText(MessageText.getString("authenticator.user"));
            gridData = new GridData(1808);
            gridData.horizontalSpan = 1;
            user_label.setLayoutData((Object)gridData);
            Text user_value = new Text((Composite)this.shell, 2048);
            user_value.setText("");
            gridData = new GridData(1808);
            gridData.horizontalSpan = 2;
            user_value.setLayoutData((Object)gridData);
            user_value.addListener(24, new Listener(this, user_value){
                final /* synthetic */ authDialog this$1;
                private final /* synthetic */ Text val$user_value;
                {
                    this.this$1 = authDialog2;
                    this.val$user_value = text;
                }

                public void handleEvent(Event event) {
                    this.this$1.username = this.val$user_value.getText();
                }
            });
            Label password_label = new Label((Composite)this.shell, 0);
            password_label.setText(MessageText.getString("authenticator.password"));
            gridData = new GridData(1808);
            gridData.horizontalSpan = 1;
            password_label.setLayoutData((Object)gridData);
            Text password_value = new Text((Composite)this.shell, 2048);
            password_value.setEchoChar('*');
            password_value.setText("");
            gridData = new GridData(1808);
            gridData.horizontalSpan = 2;
            password_value.setLayoutData((Object)gridData);
            password_value.addListener(24, new Listener(this, password_value){
                final /* synthetic */ authDialog this$1;
                private final /* synthetic */ Text val$password_value;
                {
                    this.this$1 = authDialog2;
                    this.val$password_value = text;
                }

                public void handleEvent(Event event) {
                    this.this$1.password = this.val$password_value.getText();
                }
            });
            Label labelSeparator = new Label((Composite)this.shell, 258);
            gridData = new GridData(768);
            gridData.horizontalSpan = 3;
            labelSeparator.setLayoutData((Object)gridData);
            new Label((Composite)this.shell, 0);
            Button bOk = new Button((Composite)this.shell, 8);
            bOk.setText(MessageText.getString("Button.ok"));
            gridData = new GridData(896);
            gridData.grabExcessHorizontalSpace = true;
            gridData.widthHint = 70;
            bOk.setLayoutData((Object)gridData);
            bOk.addListener(13, new Listener(this){
                final /* synthetic */ authDialog this$1;
                {
                    this.this$1 = authDialog2;
                }

                public void handleEvent(Event e) {
                    this.this$1.close(true);
                }
            });
            Button bCancel = new Button((Composite)this.shell, 8);
            bCancel.setText(MessageText.getString("Button.cancel"));
            gridData = new GridData(128);
            gridData.grabExcessHorizontalSpace = false;
            gridData.widthHint = 70;
            bCancel.setLayoutData((Object)gridData);
            bCancel.addListener(13, new Listener(this){
                final /* synthetic */ authDialog this$1;
                {
                    this.this$1 = authDialog2;
                }

                public void handleEvent(Event e) {
                    this.this$1.close(false);
                }
            });
            this.shell.setDefaultButton(bOk);
            this.shell.addListener(31, new Listener(this){
                final /* synthetic */ authDialog this$1;
                {
                    this.this$1 = authDialog2;
                }

                public void handleEvent(Event e) {
                    if (e.character == '\u001b') {
                        this.this$1.close(false);
                    }
                }
            });
            this.shell.pack();
            Utils.centreWindow(this.shell);
            this.shell.open();
        }

        protected void close(boolean ok) {
            if (!ok) {
                this.username = null;
                this.password = null;
            }
            this.shell.dispose();
            this.sem.release();
        }

        protected String getUsername() {
            return this.username;
        }

        protected String getPassword() {
            return this.password;
        }
    }

    protected class authCache {
        protected PasswordAuthentication auth;
        protected int life = 5;
        protected boolean succeeded;

        protected authCache(PasswordAuthentication _auth) {
            this.auth = _auth;
        }

        protected void setOutcome(boolean success) {
            if (success) {
                this.succeeded = true;
            } else if (!this.succeeded) {
                this.auth = null;
            }
        }

        protected PasswordAuthentication getAuth() {
            if (this.succeeded) {
                return this.auth;
            }
            --this.life;
            if (this.life >= 0) {
                return this.auth;
            }
            return null;
        }
    }
}

