/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt;

import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.PluginView;
import org.gudy.azureus2.ui.swt.mainwindow.MainWindow;
import org.gudy.azureus2.ui.swt.views.IView;
import org.gudy.azureus2.ui.swt.views.ManagerView;
import org.gudy.azureus2.ui.swt.views.MySharesView;
import org.gudy.azureus2.ui.swt.views.MyTorrentsSuperView;
import org.gudy.azureus2.ui.swt.views.MyTrackerView;

public class Tab {
    private static HashMap tabs;
    private static AEMonitor class_mon;
    private boolean useCustomTab = MainWindow.getWindow().isUseCustomTab();
    private static Composite _folder;
    private Composite folder;
    private Item tabItem;
    private static boolean eventCloseAllowed;
    private static Item selectedItem;
    private Composite composite;
    private IView view;
    public static KeyAdapter defaultListener;

    static {
        class_mon = new AEMonitor("Tab:class");
        eventCloseAllowed = true;
        selectedItem = null;
        tabs = new HashMap();
    }

    public Item getTabItem() {
        return this.tabItem;
    }

    public Tab(IView _view) {
        this.view = _view;
        this.folder = _folder;
        this.tabItem = _view instanceof MyTorrentsSuperView ? (this.useCustomTab ? new CTabItem((CTabFolder)this.folder, 0, 0) : new TabItem((TabFolder)this.folder, 0, 0)) : (this.useCustomTab ? new CTabItem((CTabFolder)this.folder, 0) : new TabItem((TabFolder)this.folder, 0));
        if (this.useCustomTab) {
            this.folder.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDown(MouseEvent arg0) {
                    if (arg0.button == 2) {
                        Rectangle rectangle;
                        if (eventCloseAllowed && (rectangle = ((CTabItem)Tab.this.tabItem).getBounds()).contains(arg0.x, arg0.y)) {
                            eventCloseAllowed = false;
                            Tab.this.folder.removeMouseListener((MouseListener)this);
                            Tab.closed(Tab.this.tabItem);
                        }
                    } else {
                        selectedItem = (Item)((CTabFolder)Tab.this.folder).getSelection();
                    }
                }

                public void mouseUp(MouseEvent arg0) {
                    eventCloseAllowed = true;
                    if (selectedItem != null && _folder instanceof CTabFolder) {
                        ((CTabFolder)_folder).setSelection((CTabItem)selectedItem);
                    }
                }
            });
        }
        if (!(_view instanceof MyTorrentsSuperView || _view instanceof MyTrackerView || _view instanceof MySharesView)) {
            this.composite = new Composite(this.folder, 0);
            GridLayout layout = new GridLayout();
            layout.numColumns = 1;
            layout.horizontalSpacing = 0;
            layout.verticalSpacing = 0;
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            this.composite.setLayout((Layout)layout);
            GridData gridData = new GridData(1808);
            try {
                _view.initialize(this.composite);
                _view.setTabListener();
                _view.getComposite().setLayoutData((Object)gridData);
                if (this.useCustomTab) {
                    ((CTabItem)this.tabItem).setControl((Control)this.composite);
                    ((CTabFolder)this.folder).setSelection((CTabItem)this.tabItem);
                } else {
                    ((TabItem)this.tabItem).setControl((Control)this.composite);
                    TabItem[] items = new TabItem[]{(TabItem)this.tabItem};
                    ((TabFolder)this.folder).setSelection(items);
                }
                this.tabItem.setText(this.view.getShortTitle());
                tabs.put(this.tabItem, this.view);
            }
            catch (Exception e) {
                Debug.printStackTrace(e);
            }
        } else {
            try {
                _view.initialize(this.folder);
                _view.setTabListener();
                this.tabItem.setText(this.view.getShortTitle());
                if (this.useCustomTab) {
                    ((CTabItem)this.tabItem).setControl((Control)_view.getComposite());
                    ((CTabItem)this.tabItem).setToolTipText(this.view.getFullTitle());
                    ((CTabFolder)this.folder).setSelection((CTabItem)this.tabItem);
                } else {
                    ((TabItem)this.tabItem).setControl((Control)_view.getComposite());
                    ((TabItem)this.tabItem).setToolTipText(this.view.getFullTitle());
                    TabItem[] items = new TabItem[]{(TabItem)this.tabItem};
                    ((TabFolder)this.folder).setSelection(items);
                }
                tabs.put(this.tabItem, this.view);
            }
            catch (Exception e) {
                Debug.printStackTrace(e);
            }
        }
        MainWindow.getWindow().refreshIconBar();
        selectedItem = this.tabItem;
    }

    public static IView getView(Item item) {
        return (IView)tabs.get(item);
    }

    public static void refresh() {
        try {
            class_mon.enter();
            Iterator iter = tabs.keySet().iterator();
            while (iter.hasNext()) {
                Item item = (Item)iter.next();
                IView view = (IView)tabs.get(item);
                try {
                    String newToolTip;
                    String lastToolTip;
                    if (item.isDisposed()) continue;
                    String lastTitle = item.getText();
                    String newTitle = view.getShortTitle();
                    if (lastTitle == null || !lastTitle.equals(newTitle)) {
                        item.setText(newTitle);
                    }
                    if (item instanceof CTabItem) {
                        lastToolTip = ((CTabItem)item).getToolTipText();
                        newToolTip = view.getFullTitle();
                        if (lastToolTip != null && lastToolTip.equals(newToolTip)) continue;
                        ((CTabItem)item).setToolTipText(newToolTip);
                        continue;
                    }
                    if (!(item instanceof TabItem)) continue;
                    lastToolTip = ((TabItem)item).getToolTipText();
                    newToolTip = String.valueOf(view.getFullTitle()) + " " + MessageText.getString("Tab.closeHint");
                    if (lastToolTip != null && lastToolTip.equals(newToolTip)) continue;
                    ((TabItem)item).setToolTipText(newToolTip);
                }
                catch (Exception e) {
                    Debug.printStackTrace(e);
                }
            }
        }
        finally {
            class_mon.exit();
        }
    }

    public static void updateLanguage() {
        IView[] views;
        try {
            class_mon.enter();
            views = tabs.values().toArray(new IView[tabs.size()]);
        }
        finally {
            class_mon.exit();
        }
        int i = 0;
        while (i < views.length) {
            IView view = views[i];
            try {
                view.updateLanguage();
                view.refresh();
            }
            catch (Exception e) {
                Debug.printStackTrace(e);
            }
            ++i;
        }
    }

    public static void closeAllTabs() {
        Item[] tab_items;
        try {
            class_mon.enter();
            tab_items = tabs.keySet().toArray(new Item[tabs.size()]);
        }
        finally {
            class_mon.exit();
        }
        int i = 0;
        while (i < tab_items.length) {
            Tab.closed(tab_items[i]);
            ++i;
        }
    }

    public static void closeAllDetails() {
        Item[] tab_items;
        try {
            class_mon.enter();
            tab_items = tabs.keySet().toArray(new Item[tabs.size()]);
        }
        finally {
            class_mon.exit();
        }
        int i = 0;
        while (i < tab_items.length) {
            IView view = (IView)tabs.get(tab_items[i]);
            if (view instanceof ManagerView) {
                Tab.closed(tab_items[i]);
            }
            ++i;
        }
    }

    public static void closeCurrent() {
        if (_folder == null || _folder.isDisposed()) {
            return;
        }
        if (_folder instanceof TabFolder) {
            TabItem[] items = ((TabFolder)_folder).getSelection();
            if (items.length == 1) {
                Tab.closed((Item)items[0]);
            }
        } else {
            Tab.closed((Item)((CTabFolder)_folder).getSelection());
        }
    }

    public static void selectNextTab(boolean selectNext) {
        int nextOrPrevious;
        if (_folder == null || _folder.isDisposed()) {
            return;
        }
        int n = nextOrPrevious = selectNext ? 1 : -1;
        if (_folder instanceof TabFolder) {
            TabFolder tabFolder = (TabFolder)_folder;
            int index = tabFolder.getSelectionIndex() + nextOrPrevious;
            if (index == 0 && selectNext || index == -2 || tabFolder.getItemCount() < 2) {
                return;
            }
            if (index == tabFolder.getItemCount()) {
                index = 0;
            } else if (index < 0) {
                index = tabFolder.getItemCount() - 1;
            }
            tabFolder.setSelection(index);
        } else {
            CTabFolder tabFolder = (CTabFolder)_folder;
            int index = tabFolder.getSelectionIndex() + nextOrPrevious;
            if (index == 0 && selectNext || index == -2 || tabFolder.getItemCount() < 2) {
                return;
            }
            if (index == tabFolder.getItemCount()) {
                index = 0;
            } else if (index < 0) {
                index = tabFolder.getItemCount() - 1;
            }
            tabFolder.setSelection(index);
        }
    }

    public static void setFolder(Composite folder) {
        _folder = folder;
    }

    public static void closed(Item item) {
        IView view = null;
        try {
            class_mon.enter();
            view = (IView)tabs.remove(item);
        }
        finally {
            class_mon.exit();
        }
        if (view != null) {
            try {
                if (view instanceof PluginView) {
                    MainWindow.getWindow().removeActivePluginView((PluginView)view);
                }
                view.delete();
            }
            catch (Exception e) {
                Debug.printStackTrace(e);
            }
            if (view instanceof MyTorrentsSuperView) {
                MainWindow.getWindow().setMytorrents(null);
                item.dispose();
                return;
            }
            if (view instanceof MyTrackerView) {
                MainWindow.getWindow().setMyTracker(null);
                item.dispose();
                return;
            }
            if (view instanceof MySharesView) {
                MainWindow.getWindow().setMyShares(null);
                item.dispose();
                return;
            }
        }
        try {
            item.dispose();
        }
        catch (Exception e) {
            Debug.printStackTrace(e);
        }
    }

    public void setFocus() {
        if (this.folder != null && !this.folder.isDisposed()) {
            if (this.useCustomTab) {
                ((CTabFolder)this.folder).setSelection((CTabItem)this.tabItem);
            } else {
                TabItem[] items = new TabItem[]{(TabItem)this.tabItem};
                ((TabFolder)this.folder).setSelection(items);
            }
        }
    }

    public void dispose() {
        IView localView = null;
        try {
            class_mon.enter();
            localView = (IView)tabs.get(this.tabItem);
            tabs.remove(this.tabItem);
        }
        finally {
            class_mon.exit();
        }
        try {
            if (localView != null) {
                if (localView instanceof PluginView) {
                    MainWindow.getWindow().removeActivePluginView((PluginView)localView);
                }
                localView.delete();
            }
            this.tabItem.dispose();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.composite != null && !this.composite.isDisposed()) {
            this.composite.dispose();
        }
    }

    public static KeyAdapter createTabKeyListener() {
        return new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                if (keyEvent.character == '\u001b' || keyEvent.keyCode == 0x100000D && keyEvent.stateMask == 262144) {
                    eventCloseAllowed = false;
                    Tab.closeCurrent();
                }
                if (keyEvent.keyCode == 0x100000F) {
                    if (keyEvent.stateMask == 0) {
                        Tab.selectNextTab(true);
                    } else if (keyEvent.stateMask == 131072) {
                        Tab.selectNextTab(false);
                    }
                }
            }

            public void keyPressed(KeyEvent keyEvent) {
                eventCloseAllowed = true;
            }
        };
    }

    public static void addTabKeyListenerToComposite(Composite folder) {
        try {
            class_mon.enter();
            if (folder == null) {
                class_mon.exit();
                return;
            }
            if (defaultListener == null) {
                defaultListener = Tab.createTabKeyListener();
            }
            Tab.addTabKeyListenerToComposite((KeyListener)defaultListener, folder);
        }
        finally {
            class_mon.exit();
        }
    }

    public static void addTabKeyListenerToComposite(KeyListener listener, Composite folder) {
        folder.removeKeyListener(listener);
        folder.addKeyListener(listener);
        Control[] children = folder.getChildren();
        int i = 0;
        while (i < children.length) {
            if (children[i] instanceof Composite) {
                Tab.addTabKeyListenerToComposite(listener, (Composite)children[i]);
            } else {
                children[i].removeKeyListener(listener);
                children[i].addKeyListener(listener);
            }
            ++i;
        }
    }
}

