/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.update;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.zip.ZipInputStream;
import org.gudy.azureus2.core3.html.HTMLUtils;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.plugins.Plugin;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.logging.LoggerChannel;
import org.gudy.azureus2.plugins.logging.LoggerChannelListener;
import org.gudy.azureus2.plugins.ui.UIManager;
import org.gudy.azureus2.plugins.ui.model.BasicPluginConfigModel;
import org.gudy.azureus2.plugins.ui.model.BasicPluginViewModel;
import org.gudy.azureus2.plugins.update.UpdatableComponent;
import org.gudy.azureus2.plugins.update.Update;
import org.gudy.azureus2.plugins.update.UpdateCheckInstance;
import org.gudy.azureus2.plugins.update.UpdateChecker;
import org.gudy.azureus2.plugins.update.UpdateManager;
import org.gudy.azureus2.plugins.update.UpdateManagerListener;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloader;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderAdapter;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderFactory;
import org.gudy.azureus2.pluginsimpl.PluginUtils;
import org.gudy.azureus2.pluginsimpl.update.sf.SFPluginDetails;
import org.gudy.azureus2.pluginsimpl.update.sf.SFPluginDetailsLoader;
import org.gudy.azureus2.pluginsimpl.update.sf.SFPluginDetailsLoaderFactory;
import org.gudy.azureus2.pluginsimpl.update.sf.SFPluginDetailsLoaderListener;

public class PluginUpdatePlugin
implements Plugin {
    public static final int RD_SIZE_RETRIES = 3;
    public static final int RD_SIZE_TIMEOUT = 10000;
    protected PluginInterface plugin_interface;
    protected SFPluginDetailsLoader loader;
    protected LoggerChannel log;

    public void initialize(PluginInterface _plugin_interface) {
        this.plugin_interface = _plugin_interface;
        this.plugin_interface.getPluginProperties().setProperty("plugin.name", "Plugin Updater");
        this.log = this.plugin_interface.getLogger().getChannel("Plugin Update");
        UIManager ui_manager = this.plugin_interface.getUIManager();
        final BasicPluginViewModel model = ui_manager.createBasicPluginViewModel("Plugin Update");
        boolean enabled = this.plugin_interface.getPluginconfig().getPluginBooleanParameter("enable.update", true);
        model.getStatus().setText(enabled ? "Running" : "Optional checks disabled");
        model.getActivity().setVisible(false);
        model.getProgress().setVisible(false);
        this.log.addListener(new LoggerChannelListener(){

            public void messageLogged(int type, String message) {
                model.getLogArea().appendText(String.valueOf(message) + "\n");
            }

            public void messageLogged(String str, Throwable error) {
                model.getLogArea().appendText(String.valueOf(error.toString()) + "\n");
            }
        });
        this.loader = SFPluginDetailsLoaderFactory.getSingleton();
        this.loader.addListener(new SFPluginDetailsLoaderListener(){

            public void log(String str) {
                PluginUpdatePlugin.this.log.log(1, "[" + str + "]");
            }
        });
        BasicPluginConfigModel config = ui_manager.createBasicPluginConfigModel("plugins", "plugins.update");
        config.addBooleanParameter2("enable.update", "Plugin.pluginupdate.enablecheck", true);
        UpdateManager update_manager = this.plugin_interface.getUpdateManager();
        update_manager.addListener(new UpdateManagerListener(){

            public void checkInstanceCreated(UpdateCheckInstance inst) {
                SFPluginDetailsLoaderFactory.getSingleton().reset();
            }
        });
        PluginInterface[] plugins = this.plugin_interface.getPluginManager().getPlugins();
        int mandatory_count = 0;
        int non_mandatory_count = 0;
        int i = 0;
        while (i < plugins.length) {
            PluginInterface pi = plugins[i];
            boolean pi_mandatory = pi.isMandatory();
            String id = pi.getPluginID();
            String version = pi.getPluginVersion();
            if (version != null && !id.startsWith("<")) {
                if (pi_mandatory) {
                    ++mandatory_count;
                } else {
                    ++non_mandatory_count;
                }
            }
            ++i;
        }
        final int f_non_mandatory_count = non_mandatory_count;
        final int f_mandatory_count = mandatory_count;
        update_manager.registerUpdatableComponent(new UpdatableComponent(){

            public String getName() {
                return "Non-mandatory plugins";
            }

            public int getMaximumCheckTime() {
                return f_non_mandatory_count * 30;
            }

            public void checkForUpdate(UpdateChecker checker) {
                PluginUpdatePlugin.this.checkForUpdateSupport(checker, null, false);
            }
        }, false);
        update_manager.registerUpdatableComponent(new UpdatableComponent(){

            public String getName() {
                return "Mandatory plugins";
            }

            public int getMaximumCheckTime() {
                return f_mandatory_count * 30;
            }

            public void checkForUpdate(UpdateChecker checker) {
                PluginUpdatePlugin.this.checkForUpdateSupport(checker, null, true);
            }
        }, true);
    }

    public UpdatableComponent getCustomUpdateableComponent(final String id, final boolean mandatory) {
        return new UpdatableComponent(){

            public String getName() {
                return "Installation of '" + id + "'";
            }

            public int getMaximumCheckTime() {
                return 30;
            }

            public void checkForUpdate(UpdateChecker checker) {
                PluginUpdatePlugin.this.checkForUpdateSupport(checker, new String[]{id}, mandatory);
            }
        };
    }

    protected void checkForUpdateSupport(UpdateChecker checker, String[] ids_to_check, boolean mandatory) {
        try {
            try {
                if (!mandatory && ids_to_check == null && !this.plugin_interface.getPluginconfig().getPluginBooleanParameter("enable.update", true)) {
                    checker.completed();
                    return;
                }
                PluginInterface[] plugins = this.plugin_interface.getPluginManager().getPlugins();
                this.log.log(1, "Currently loaded " + (mandatory ? "mandatory " : "non-mandatory") + " plugins:");
                ArrayList<PluginInterface> plugins_to_check = new ArrayList<PluginInterface>();
                ArrayList<String> plugins_to_check_ids = new ArrayList<String>();
                HashMap<String, Boolean> plugins_to_check_unloadable = new HashMap<String, Boolean>();
                HashMap<String, String> plugins_to_check_names = new HashMap<String, String>();
                int i = 0;
                while (i < plugins.length) {
                    block34: {
                        String name;
                        String version;
                        String id;
                        PluginInterface pi;
                        block35: {
                            boolean pi_mandatory;
                            pi = plugins[i];
                            String mand = pi.getPluginProperties().getProperty("plugin.mandatory");
                            boolean bl = pi_mandatory = mand != null && mand.trim().toLowerCase().equals("true");
                            if (pi_mandatory != mandatory) break block34;
                            id = pi.getPluginID();
                            version = pi.getPluginVersion();
                            name = pi.getPluginName();
                            if (ids_to_check == null) break block35;
                            boolean id_selected = false;
                            int j = 0;
                            while (j < ids_to_check.length) {
                                if (ids_to_check[j].equals(id)) {
                                    id_selected = true;
                                    break;
                                }
                                ++j;
                            }
                            if (!id_selected) break block34;
                        }
                        if (version != null && !id.startsWith("<")) {
                            if (plugins_to_check_ids.contains(id)) {
                                String s = (String)plugins_to_check_names.get(id);
                                if (!name.equals(id)) {
                                    plugins_to_check_names.put(id, String.valueOf(s) + "," + name);
                                }
                                Boolean old_unloadable = (Boolean)plugins_to_check_unloadable.get(id);
                                plugins_to_check_unloadable.put(id, new Boolean(pi.isUnloadable() && old_unloadable != false));
                            } else {
                                plugins_to_check_ids.add(id);
                                plugins_to_check.add(pi);
                                plugins_to_check_names.put(id, name.equals(id) ? "" : name);
                                plugins_to_check_unloadable.put(id, new Boolean(pi.isUnloadable()));
                            }
                        }
                        this.log.log(1, "    " + pi.getPluginName() + ", id = " + id + (version == null ? "" : ", version = " + pi.getPluginVersion()));
                    }
                    ++i;
                }
                String[] ids = this.loader.getPluginIDs();
                String id_list = "";
                int i2 = 0;
                while (i2 < ids.length) {
                    id_list = String.valueOf(id_list) + (i2 == 0 ? "" : ",") + ids[i2];
                    ++i2;
                }
                this.log.log(1, "Downloaded plugin ids = " + id_list);
                i2 = 0;
                while (i2 < plugins_to_check.size()) {
                    if (checker.getCheckInstance().isCancelled()) {
                        throw new Exception("Update check cancelled");
                    }
                    PluginInterface pi_being_checked = (PluginInterface)plugins_to_check.get(i2);
                    String plugin_id = pi_being_checked.getPluginID();
                    checker.reportProgress("Loading details for " + plugin_id + "/" + pi_being_checked.getPluginName());
                    boolean found = false;
                    int j = 0;
                    while (j < ids.length) {
                        if (ids[j].equalsIgnoreCase(plugin_id)) {
                            found = true;
                            break;
                        }
                        ++j;
                    }
                    if (!found) {
                        this.log.log(1, "Skipping " + plugin_id + " as not listed on web site");
                    } else {
                        String plugin_names = (String)plugins_to_check_names.get(plugin_id);
                        boolean plugin_unloadable = (Boolean)plugins_to_check_unloadable.get(plugin_id);
                        this.log.log(1, "Checking " + plugin_id);
                        try {
                            String sf_cvs_version;
                            String sf_plugin_version;
                            SFPluginDetails details = this.loader.getPluginDetails(plugin_id);
                            if (plugin_names.length() == 0) {
                                plugin_names = details.getName();
                            }
                            boolean az_cvs = this.plugin_interface.getUtilities().isCVSVersion();
                            String pi_version_info = pi_being_checked.getPluginProperties().getProperty("plugin.version.info");
                            String az_plugin_version = pi_being_checked.getPluginVersion();
                            String sf_comp_version = sf_plugin_version = details.getVersion();
                            if (az_cvs && (sf_cvs_version = details.getCVSVersion()).length() > 0) {
                                sf_plugin_version = sf_cvs_version;
                                sf_comp_version = sf_plugin_version.substring(0, sf_plugin_version.length() - 4);
                            }
                            if (sf_comp_version.length() == 0 || !Character.isDigit(sf_comp_version.charAt(0))) {
                                this.log.log(1, "Skipping " + plugin_id + " as no valid version to check");
                            } else {
                                int comp = PluginUtils.comparePluginVersions(az_plugin_version, sf_comp_version);
                                this.log.log(1, "    Current: " + az_plugin_version + (comp == 0 && sf_plugin_version.endsWith("_CVS") ? "_CVS" : "") + ", Latest: " + sf_plugin_version + (pi_version_info == null ? "" : " [" + pi_version_info + "]"));
                                if (comp < 0 && !(pi_being_checked.getPlugin() instanceof UpdatableComponent)) {
                                    String sf_cvs_version2;
                                    String sf_plugin_download = details.getDownloadURL();
                                    if (az_cvs && (sf_cvs_version2 = details.getCVSVersion()).length() > 0) {
                                        sf_plugin_download = details.getCVSDownloadURL();
                                    }
                                    this.log.log(1, "    Description:");
                                    ArrayList update_desc = new ArrayList();
                                    List desc_lines = HTMLUtils.convertHTMLToText("", details.getDescription());
                                    this.logMultiLine("        ", desc_lines);
                                    update_desc.addAll(desc_lines);
                                    this.log.log(1, "    Comment:");
                                    List comment_lines = HTMLUtils.convertHTMLToText("    ", details.getComment());
                                    this.logMultiLine("    ", comment_lines);
                                    update_desc.addAll(comment_lines);
                                    String msg = "A newer version (version " + sf_plugin_version + ") of plugin '" + plugin_id + "' " + (plugin_names.length() == 0 ? "" : "(" + plugin_names + ") ") + "is available. ";
                                    this.log.log(1, "");
                                    this.log.log(1, "        " + msg + "Download from " + sf_plugin_download);
                                    ResourceDownloaderFactory rdf = this.plugin_interface.getUtilities().getResourceDownloaderFactory();
                                    ResourceDownloader direct_rdl = rdf.create(new URL(sf_plugin_download));
                                    String torrent_download = "http://play.aelitis.com/torrents/";
                                    int slash_pos = sf_plugin_download.lastIndexOf("/");
                                    torrent_download = slash_pos == -1 ? String.valueOf(torrent_download) + sf_plugin_download : String.valueOf(torrent_download) + sf_plugin_download.substring(slash_pos + 1);
                                    torrent_download = String.valueOf(torrent_download) + ".torrent";
                                    ResourceDownloader torrent_rdl = rdf.create(new URL(torrent_download));
                                    torrent_rdl = rdf.getSuffixBasedDownloader(torrent_rdl);
                                    ResourceDownloader alternate_rdl = rdf.getAlternateDownloader(new ResourceDownloader[]{torrent_rdl, direct_rdl});
                                    rdf.getTimeoutDownloader(rdf.getRetryDownloader(alternate_rdl, 3), 10000).getSize();
                                    String[] update_d = new String[update_desc.size()];
                                    update_desc.toArray(update_d);
                                    this.addUpdate(pi_being_checked, checker, String.valueOf(plugin_id) + "/" + plugin_names, update_d, sf_plugin_version, alternate_rdl, sf_plugin_download.toLowerCase().endsWith(".jar"), plugin_unloadable ? 1 : 2);
                                }
                            }
                        }
                        catch (Throwable e) {
                            this.log.log("    Plugin check failed", e);
                        }
                    }
                    ++i2;
                }
            }
            catch (Throwable e) {
                this.log.log("Failed to load plugin details", e);
                checker.failed();
            }
        }
        finally {
            checker.completed();
        }
    }

    public void addUpdate(final PluginInterface pi_for_update, UpdateChecker checker, String update_name, String[] update_details, final String version, ResourceDownloader resource_downloader, final boolean is_jar, final int restart_type) {
        final Update update = checker.addUpdate(update_name, update_details, version, resource_downloader, restart_type);
        update.setUserObject(pi_for_update);
        resource_downloader.addListener(new ResourceDownloaderAdapter(){

            public boolean completed(ResourceDownloader downloader, InputStream data) {
                LoggerChannelListener list = new LoggerChannelListener(this, downloader){
                    final /* synthetic */ 7 this$1;
                    private final /* synthetic */ ResourceDownloader val$downloader;
                    {
                        this.this$1 = var1_1;
                        this.val$downloader = resourceDownloader;
                    }

                    public void messageLogged(int type, String content) {
                        this.val$downloader.reportActivity(content);
                    }

                    public void messageLogged(String str, Throwable error) {
                        this.val$downloader.reportActivity(str);
                    }
                };
                try {
                    PluginUpdatePlugin.this.log.addListener(list);
                    PluginUpdatePlugin.this.installUpdate(update, pi_for_update, restart_type == 1, is_jar, version, data);
                    PluginUpdatePlugin.this.log.removeListener(list);
                    return true;
                }
                catch (Throwable throwable) {
                    PluginUpdatePlugin.this.log.removeListener(list);
                    throw throwable;
                }
            }
        });
    }

    /*
     * Unable to fully structure code
     */
    protected void installUpdate(Update update, PluginInterface plugin, boolean unloadable, boolean is_jar, String version, InputStream data) {
        this.log.log(1, "Installing plugin " + plugin.getPluginID() + ", version " + version);
        target_version = version.endsWith("_CVS") != false ? version.substring(0, version.length() - 4) : version;
        try {
            try {
                block73: {
                    block72: {
                        update_txt_found = false;
                        target = String.valueOf(plugin.getPluginDirectoryName()) + File.separator + plugin.getPluginID() + "_" + target_version + (is_jar != false ? ".jar" : ".zip");
                        FileUtil.copyFile(data, new FileOutputStream(target));
                        if (is_jar) break block73;
                        zis = new ZipInputStream(new BufferedInputStream(new FileInputStream(target)));
                        common_prefix = null;
                        try {
                            block28: do {
                                if ((entry = zis.getNextEntry()) == null) {
                                    break block72;
                                }
                                name = entry.getName();
                                if (!name.endsWith("/")) {
                                    if (common_prefix == null) {
                                        common_prefix = name;
                                    } else {
                                        len = 0;
                                        i = 0;
                                        while (i < Math.min(common_prefix.length(), name.length())) {
                                            if (common_prefix.charAt(i) != name.charAt(i)) break;
                                            ++len;
                                            ++i;
                                        }
                                        common_prefix = common_prefix.substring(0, len);
                                    }
                                }
                                rem = entry.getSize();
                                buffer = new byte[65536];
                                while (rem > 0L) {
                                    len = zis.read(buffer, 0, (long)buffer.length > rem ? (int)rem : buffer.length);
                                    if (len <= 0) continue block28;
                                    rem -= (long)len;
                                }
                            } while (rem == 0L);
                            throw new Exception("Invalid ZIP file");
                        }
                        finally {
                            zis.close();
                        }
                    }
                    if (common_prefix == null) break block73;
                    pos = common_prefix.lastIndexOf("/");
                    common_prefix = pos == -1 ? "" : common_prefix.substring(0, pos + 1);
                    zis = new ZipInputStream(new BufferedInputStream(new FileInputStream(target)));
                    block31: while (true) {
                        while (true) lbl-1000:
                        // 6 sources

                        {
                            if ((entry = zis.getNextEntry()) == null) {
                                break block73;
                            }
                            name = entry.getName();
                            entry_os = null;
                            initial_target = null;
                            final_target = null;
                            is_plugin_properties = false;
                            try {
                                if (name.length() >= common_prefix.length() && !name.endsWith("/")) {
                                    file_name = entry.getName().substring(common_prefix.length());
                                    final_target = initial_target = new File(String.valueOf(plugin.getPluginDirectoryName()) + File.separator + file_name);
                                    if (initial_target.exists()) {
                                        if (file_name.toLowerCase().endsWith(".properties") || file_name.toLowerCase().endsWith(".config")) {
                                            is_plugin_properties = file_name.toLowerCase().equals("plugin.properties");
                                            old_file_name = file_name;
                                            file_name = String.valueOf(file_name) + "_" + target_version;
                                            final_target = new File(String.valueOf(plugin.getPluginDirectoryName()) + File.separator + file_name);
                                            this.log.log(1, "saving new file '" + old_file_name + "'as '" + file_name + "'");
                                        } else {
                                            this.log.log(1, "overwriting '" + file_name + "'");
                                            backup = new File(initial_target.getParentFile(), String.valueOf(initial_target.getName()) + ".bak");
                                            if (backup.exists()) {
                                                backup.delete();
                                            }
                                            initial_target.renameTo(backup);
                                        }
                                    }
                                    final_target.getParentFile().mkdirs();
                                    entry_os = new FileOutputStream(final_target);
                                }
                                rem = entry.getSize();
                                buffer = new byte[65536];
                                while (rem > 0L) {
                                    len = zis.read(buffer, 0, (long)buffer.length > rem ? (int)rem : buffer.length);
                                    if (len <= 0) {
                                        break;
                                    }
                                    rem -= (long)len;
                                    if (entry_os == null) continue;
                                    entry_os.write(buffer, 0, len);
                                }
                            }
                            finally {
                                if (entry_os != null) {
                                    entry_os.close();
                                }
                            }
                            if (is_plugin_properties) {
                                old_props = new Properties();
                                new_props = new Properties();
                                props_to_delete = new ArrayList<String>();
                                props_to_replace = new HashMap<String, String>();
                                props_to_insert = new HashMap<String, String>();
                                try {
                                    fis = new FileInputStream(initial_target);
                                    old_props.load(fis);
                                    try {
                                        fis.close();
                                    }
                                    catch (Throwable var25_43) {
                                        // empty catch block
                                    }
                                    fis = new FileInputStream(final_target);
                                    new_props.load(fis);
                                    try {
                                        fis.close();
                                    }
                                    catch (Throwable e) {}
                                }
                                catch (Throwable e) {
                                    Debug.printStackTrace(e);
                                }
                                new_props.put("plugin.version", target_version);
                                prop_names = new String[]{"plugin.name", "plugin.names", "plugin.class", "plugin.classes", "plugin.version", "plugin.langfile"};
                                z = 0;
                                while (z < prop_names.length) {
                                    prop_name = prop_names[z];
                                    old_name = old_props.getProperty(prop_name);
                                    new_name = new_props.getProperty(prop_name);
                                    if (new_name != null) {
                                        if (prop_name.equals("plugin.name")) {
                                            props_to_delete.add("plugin.names");
                                        } else if (prop_name.equals("plugin.names")) {
                                            props_to_delete.add("plugin.name");
                                        } else if (prop_name.equals("plugin.class")) {
                                            props_to_delete.add("plugin.classes");
                                        } else if (prop_name.equals("plugin.classes")) {
                                            props_to_delete.add("plugin.class");
                                        }
                                        if (old_name == null) {
                                            props_to_insert.put(prop_name, new_name);
                                        } else if (!new_name.equals(old_name)) {
                                            props_to_replace.put(prop_name, new_name);
                                        }
                                    }
                                    ++z;
                                }
                                tmp_file = new File(String.valueOf(initial_target.toString()) + ".tmp");
                                bak_file = new File(String.valueOf(initial_target.toString()) + ".bak");
                                lnr = null;
                                tmp = null;
                                try {
                                    lnr = new LineNumberReader(new FileReader(initial_target));
                                    tmp = new PrintWriter(new FileWriter(tmp_file));
                                    it = props_to_insert.keySet().iterator();
                                    while (it.hasNext()) {
                                        pn = (String)it.next();
                                        pv = (String)props_to_insert.get(pn);
                                        this.log.log("    Inserting property:" + pn + "=" + pv);
                                        tmp.println(String.valueOf(pn) + "=" + pv);
                                    }
                                    while (true) {
                                        if ((line = lnr.readLine()) == null) {
                                            break;
                                        }
                                        ep = line.indexOf(61);
                                        if (ep != -1) {
                                            pn = line.substring(0, ep).trim();
                                            if (props_to_delete.contains(pn)) {
                                                this.log.log("    Deleting property:" + pn);
                                                continue;
                                            }
                                            rv = (String)props_to_replace.get(pn);
                                            if (rv != null) {
                                                this.log.log("    Replacing property:" + pn + " with " + rv);
                                                tmp.println(String.valueOf(pn) + "=" + rv);
                                                continue;
                                            }
                                            tmp.println(line);
                                            continue;
                                        }
                                        tmp.println(line);
                                    }
                                }
                                finally {
                                    lnr.close();
                                    if (tmp != null) {
                                        tmp.close();
                                    }
                                }
                                if (bak_file.exists()) {
                                    bak_file.delete();
                                }
                                if (!initial_target.renameTo(bak_file)) {
                                    throw new IOException("Failed to rename '" + initial_target.toString() + "' to '" + bak_file.toString() + "'");
                                }
                                if (!tmp_file.renameTo(initial_target)) {
                                    bak_file.renameTo(initial_target);
                                    throw new IOException("Failed to rename '" + tmp_file.toString() + "' to '" + initial_target.toString() + "'");
                                }
                                bak_file.delete();
                                continue;
                            }
                            if (final_target == null || !final_target.getName().equalsIgnoreCase("update.txt")) continue;
                            update_txt_found = true;
                            lnr = null;
                            try {
                                try {
                                    lnr = new LineNumberReader(new FileReader(final_target));
                                    while (true) {
                                        if ((line = lnr.readLine()) == null) ** GOTO lbl-1000
                                        this.log.log(1, line);
                                    }
                                }
                                catch (Throwable e) {
                                    Debug.printStackTrace(e);
                                }
                            }
                            finally {
                                if (lnr == null) continue block31;
                                lnr.close();
                                continue;
                            }
                            break;
                        }
                        break;
                    }
                    ** GOTO lbl-1000
                    finally {
                        zis.close();
                    }
                }
                if (unloadable) {
                    this.log.log("Plugin initialising, please wait... ");
                    plugin.reload();
                    this.log.log("... initialisation complete.");
                }
                msg = "Version " + version + " of plugin '" + plugin.getPluginID() + "' " + "installed successfully";
                if (update_txt_found) {
                    msg = String.valueOf(msg) + " - See update log for details";
                }
                this.log.logAlert(update_txt_found != false ? 2 : 1, msg);
            }
            catch (Throwable e) {
                msg = "Version " + version + " of plugin '" + plugin.getPluginID() + "' " + "failed to install - " + e.getMessage();
                this.log.log(msg, e);
                this.log.logAlert(3, msg);
            }
        }
        finally {
            update.complete();
        }
    }

    protected void logMultiLine(String indent, List lines) {
        int i = 0;
        while (i < lines.size()) {
            this.log.log(1, String.valueOf(indent) + (String)lines.get(i));
            ++i;
        }
    }
}

