/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.ui;

import org.eclipse.swt.SWT;
import org.gudy.azureus2.plugins.PluginConfig;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.PluginView;
import org.gudy.azureus2.plugins.ui.SWT.SWTManager;
import org.gudy.azureus2.plugins.ui.UIException;
import org.gudy.azureus2.plugins.ui.UIManager;
import org.gudy.azureus2.plugins.ui.config.ActionParameter;
import org.gudy.azureus2.plugins.ui.config.BooleanParameter;
import org.gudy.azureus2.plugins.ui.config.DirectoryParameter;
import org.gudy.azureus2.plugins.ui.config.IntParameter;
import org.gudy.azureus2.plugins.ui.config.LabelParameter;
import org.gudy.azureus2.plugins.ui.config.PasswordParameter;
import org.gudy.azureus2.plugins.ui.config.StringListParameter;
import org.gudy.azureus2.plugins.ui.config.StringParameter;
import org.gudy.azureus2.plugins.ui.model.BasicPluginConfigModel;
import org.gudy.azureus2.plugins.ui.model.BasicPluginViewModel;
import org.gudy.azureus2.plugins.ui.model.PluginViewModel;
import org.gudy.azureus2.plugins.ui.tables.TableManager;
import org.gudy.azureus2.pluginsimpl.local.ui.SWT.SWTManagerImpl;
import org.gudy.azureus2.pluginsimpl.local.ui.config.ActionParameterImpl;
import org.gudy.azureus2.pluginsimpl.local.ui.config.BooleanParameterImpl;
import org.gudy.azureus2.pluginsimpl.local.ui.config.DirectoryParameterImpl;
import org.gudy.azureus2.pluginsimpl.local.ui.config.IntParameterImpl;
import org.gudy.azureus2.pluginsimpl.local.ui.config.LabelParameterImpl;
import org.gudy.azureus2.pluginsimpl.local.ui.config.PasswordParameterImpl;
import org.gudy.azureus2.pluginsimpl.local.ui.config.StringListParameterImpl;
import org.gudy.azureus2.pluginsimpl.local.ui.config.StringParameterImpl;
import org.gudy.azureus2.pluginsimpl.local.ui.model.BasicPluginConfigModelImpl;
import org.gudy.azureus2.pluginsimpl.local.ui.model.BasicPluginViewModelImpl;
import org.gudy.azureus2.pluginsimpl.local.ui.tables.TableManagerImpl;
import org.gudy.azureus2.pluginsimpl.local.ui.view.BasicPluginViewImpl;
import org.gudy.azureus2.ui.swt.mainwindow.ClipboardCopy;

public class UIManagerImpl
implements UIManager {
    protected PluginInterface pi;
    protected PluginConfig plugin_config;
    protected String key_prefix;

    public UIManagerImpl(PluginInterface _pi) {
        this.pi = _pi;
        this.plugin_config = this.pi.getPluginconfig();
        this.key_prefix = this.plugin_config.getPluginConfigKeyPrefix();
    }

    protected boolean isSWTAvailable() {
        try {
            SWT.getVersion();
            return true;
        }
        catch (Throwable e) {
            return false;
        }
    }

    public BasicPluginViewModel getBasicPluginViewModel(String name) {
        return new BasicPluginViewModelImpl(name);
    }

    public PluginView createPluginView(PluginViewModel model) {
        if (this.isSWTAvailable()) {
            if (model instanceof BasicPluginViewModel) {
                return new BasicPluginViewImpl((BasicPluginViewModel)model);
            }
            return null;
        }
        return null;
    }

    public BasicPluginViewModel createBasicPluginViewModel(String name) {
        BasicPluginViewModel model = this.getBasicPluginViewModel(name);
        PluginView pv = this.createPluginView(model);
        if (pv != null) {
            this.pi.getUIManager().getSWTManager().addView(pv);
        }
        return model;
    }

    public BasicPluginConfigModel createBasicPluginConfigModel(String section_name) {
        if (this.isSWTAvailable()) {
            return new BasicPluginConfigModelImpl(this.pi, null, section_name);
        }
        return new dummyConfigModel();
    }

    public BasicPluginConfigModel createBasicPluginConfigModel(String parent_section, String section_name) {
        if (this.isSWTAvailable()) {
            return new BasicPluginConfigModelImpl(this.pi, parent_section, section_name);
        }
        return new dummyConfigModel();
    }

    public void copyToClipBoard(String data) throws UIException {
        if (this.isSWTAvailable()) {
            try {
                ClipboardCopy.copyToClipBoard(data);
            }
            catch (Throwable e) {
                throw new UIException("Failed to copy to clipboard", e);
            }
        }
    }

    public TableManager getTableManager() {
        return TableManagerImpl.getSingleton();
    }

    public SWTManager getSWTManager() {
        return SWTManagerImpl.getSingleton();
    }

    protected class dummyConfigModel
    implements BasicPluginConfigModel {
        protected dummyConfigModel() {
        }

        public void addBooleanParameter(String key, String resource_name, boolean defaultValue) {
            this.addBooleanParameter2(key, resource_name, defaultValue);
        }

        public BooleanParameter addBooleanParameter2(String key, String resource_name, boolean defaultValue) {
            return new BooleanParameterImpl(UIManagerImpl.this.plugin_config, String.valueOf(UIManagerImpl.this.key_prefix) + key, resource_name, defaultValue);
        }

        public void addStringParameter(String key, String resource_name, String defaultValue) {
            this.addStringParameter2(key, resource_name, defaultValue);
        }

        public StringParameter addStringParameter2(String key, String resource_name, String defaultValue) {
            return new StringParameterImpl(UIManagerImpl.this.plugin_config, String.valueOf(UIManagerImpl.this.key_prefix) + key, resource_name, defaultValue);
        }

        public StringListParameter addStringListParameter2(String key, String resource_name, String[] values, String defaultValue) {
            return new StringListParameterImpl(UIManagerImpl.this.plugin_config, String.valueOf(UIManagerImpl.this.key_prefix) + key, resource_name, defaultValue, values, values);
        }

        public PasswordParameter addPasswordParameter2(String key, String resource_name, int encoding_type, byte[] defaultValue) {
            return new PasswordParameterImpl(UIManagerImpl.this.plugin_config, String.valueOf(UIManagerImpl.this.key_prefix) + key, resource_name, encoding_type, defaultValue);
        }

        public IntParameter addIntParameter2(String key, String resource_name, int defaultValue) {
            return new IntParameterImpl(UIManagerImpl.this.plugin_config, String.valueOf(UIManagerImpl.this.key_prefix) + key, resource_name, defaultValue);
        }

        public LabelParameter addLabelParameter2(String resource_name) {
            return new LabelParameterImpl(UIManagerImpl.this.plugin_config, UIManagerImpl.this.key_prefix, resource_name);
        }

        public DirectoryParameter addDirectoryParameter2(String key, String resource_name, String defaultValue) {
            return new DirectoryParameterImpl(UIManagerImpl.this.plugin_config, String.valueOf(UIManagerImpl.this.key_prefix) + key, resource_name, defaultValue);
        }

        public ActionParameter addActionParameter2(String label_resource_name, String action_resource_name) {
            return new ActionParameterImpl(UIManagerImpl.this.plugin_config, label_resource_name, action_resource_name);
        }
    }
}

