/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.peers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.disk.DiskManagerReadRequest;
import org.gudy.azureus2.core3.peer.PEPeerManager;
import org.gudy.azureus2.core3.peer.PEPeerStats;
import org.gudy.azureus2.core3.peer.impl.PEPeerControl;
import org.gudy.azureus2.core3.peer.impl.PEPeerTransport;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.plugins.peers.Peer;
import org.gudy.azureus2.pluginsimpl.local.disk.DiskManagerImpl;
import org.gudy.azureus2.pluginsimpl.local.disk.DiskManagerRequestImpl;
import org.gudy.azureus2.pluginsimpl.local.peers.PeerManagerImpl;
import org.gudy.azureus2.pluginsimpl.local.peers.PeerStatsImpl;

public class PeerForeignDelegate
implements PEPeerTransport {
    protected PeerManagerImpl manager;
    protected Peer foreign;
    protected Map data;
    protected AEMonitor this_mon = new AEMonitor("PeerForeignDelegate");

    protected PeerForeignDelegate(PeerManagerImpl _manager, Peer _foreign) {
        this.manager = _manager;
        this.foreign = _foreign;
    }

    public PEPeerTransport getRealTransport() {
        this.foreign.initialize();
        this.manager.peerAdded(this.foreign);
        return this;
    }

    public void sendChoke() {
    }

    public void sendHave(int piece) {
    }

    public void sendUnChoke() {
    }

    public boolean transferAvailable() {
        return true;
    }

    public void sendCancel(DiskManagerReadRequest request2) {
        this.foreign.cancelRequest(((DiskManagerImpl)this.manager.getDiskManager()).lookupRequest(request2));
    }

    public boolean request(int pieceNumber, int pieceOffset, int pieceLength) {
        return this.foreign.addRequest(pieceNumber, pieceOffset, pieceLength);
    }

    public void closeAll(String reason, boolean closedOnError, boolean attemptReconnect) {
        this.foreign.close(reason, closedOnError, attemptReconnect);
        this.manager.peerRemoved(this.foreign);
    }

    public boolean isReadyToRequest() {
        return true;
    }

    public List getExpiredRequests() {
        DiskManagerImpl dm = (DiskManagerImpl)this.manager.getDiskManager();
        List reqs = this.foreign.getExpiredRequests();
        if (reqs == null) {
            return null;
        }
        ArrayList<DiskManagerReadRequest> res = new ArrayList<DiskManagerReadRequest>();
        int i = 0;
        while (i < reqs.size()) {
            DiskManagerRequestImpl dmr = (DiskManagerRequestImpl)reqs.get(i);
            res.add(dmr.getDelegate());
            ++i;
        }
        return res;
    }

    public int getNbRequests() {
        return this.foreign.getNumberOfRequests();
    }

    public PEPeerControl getControl() {
        return (PEPeerControl)this.manager.getDelegate();
    }

    public int processRead() {
        return 0;
    }

    public int getConnectionState() {
        return 0;
    }

    public int getReadSleepTime() {
        return 0;
    }

    public long getLastReadTime() {
        return 0L;
    }

    public void setReadSleepTime(int time) {
    }

    public void setLastReadTime(long time) {
    }

    public void doKeepAliveCheck() {
    }

    public boolean doTimeoutChecks() {
        return false;
    }

    public long getTimeSinceConnectionEstablished() {
        return 0L;
    }

    public long getTimeSinceLastDataMessageReceived() {
        return 0L;
    }

    public PEPeerManager getManager() {
        return this.manager.getDelegate();
    }

    public int getState() {
        return this.foreign.getState();
    }

    public byte[] getId() {
        return this.foreign.getId();
    }

    public String getIp() {
        return this.foreign.getIp();
    }

    public String getIPHostName() {
        return this.foreign.getIp();
    }

    public int getPort() {
        return this.foreign.getPort();
    }

    public boolean[] getAvailable() {
        return this.foreign.getAvailable();
    }

    public void setSnubbed(boolean b) {
        this.foreign.setSnubbed(b);
    }

    public boolean isChokingMe() {
        return this.foreign.isChoked();
    }

    public boolean isChokedByMe() {
        return this.foreign.isChoking();
    }

    public boolean isInterestingToMe() {
        return this.foreign.isInterested();
    }

    public boolean isInterestedInMe() {
        return this.foreign.isInteresting();
    }

    public boolean isSeed() {
        return this.foreign.isSeed();
    }

    public boolean isSnubbed() {
        return this.foreign.isSnubbed();
    }

    public PEPeerStats getStats() {
        return ((PeerStatsImpl)this.foreign.getStats()).getDelegate();
    }

    public boolean isIncoming() {
        return this.foreign.isIncoming();
    }

    public int getPercentDoneInThousandNotation() {
        return this.foreign.getPercentDone();
    }

    public String getClient() {
        return this.foreign.getClient();
    }

    public boolean isOptimisticUnchoke() {
        return this.foreign.isOptimisticUnchoke();
    }

    public void hasSentABadChunk() {
        this.foreign.hasSentABadChunk();
    }

    public int getNbBadChunks() {
        return this.foreign.getNumberOfBadChunks();
    }

    public void resetNbBadChunks() {
        this.foreign.resetNbBadChunks();
    }

    public int getUniqueAnnounce() {
        return -1;
    }

    public int getUploadHint() {
        return 0;
    }

    public void setUniqueAnnounce(int uniquePieceNumber) {
    }

    public void setUploadHint(int timeToSpread) {
    }

    public Object getData(String key) {
        if (this.data == null) {
            return null;
        }
        return this.data.get(key);
    }

    public void setData(String key, Object value) {
        try {
            this.this_mon.enter();
            if (this.data == null) {
                this.data = new HashMap();
            }
            if (value == null) {
                if (this.data.containsKey(key)) {
                    this.data.remove(key);
                }
            } else {
                this.data.put(key, value);
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    public boolean equals(Object other) {
        if (other instanceof PeerForeignDelegate) {
            return this.foreign.equals(((PeerForeignDelegate)other).foreign);
        }
        return false;
    }

    public int hashCode() {
        return this.foreign.hashCode();
    }
}

