/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.WeakHashMap;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.disk.DiskManagerFactory;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.download.DownloadManagerState;
import org.gudy.azureus2.core3.internat.LocaleUtil;
import org.gudy.azureus2.core3.internat.LocaleUtilDecoder;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentAnnounceURLGroup;
import org.gudy.azureus2.core3.torrent.TOTorrentAnnounceURLSet;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.torrent.TOTorrentFactory;
import org.gudy.azureus2.core3.torrent.TOTorrentFile;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.HashWrapper;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;

public class TorrentUtils {
    private static ThreadLocal tls = new ThreadLocal(){

        public Object initialValue() {
            return new HashMap();
        }
    };
    private static final int PIECE_HASH_TIMEOUT = 180000;
    private static Map torrent_delegates = new WeakHashMap();

    static {
        SimpleTimer.addPeriodicEvent(90000L, new TimerEventPerformer(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void perform(TimerEvent event) {
                long now = SystemTime.getCurrentTime();
                Map map = torrent_delegates;
                synchronized (map) {
                    Iterator it = torrent_delegates.keySet().iterator();
                    while (it.hasNext()) {
                        ((torrentDelegate)it.next()).checkTimeout(now);
                    }
                }
            }
        });
    }

    public static TOTorrent readFromFile(File file, boolean create_delegate) throws TOTorrentException {
        TOTorrent torrent;
        try {
            File torrent_file_bak;
            torrent = TOTorrentFactory.deserialiseFromBEncodedFile(file);
            if (COConfigurationManager.getBooleanParameter("Save Torrent Backup", false) && !(torrent_file_bak = new File(file.getParent(), String.valueOf(file.getName()) + ".bak")).exists()) {
                try {
                    torrent.serialiseToBEncodedFile(torrent_file_bak);
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
        }
        catch (TOTorrentException e) {
            Debug.printStackTrace(e);
            File torrentBackup = new File(file.getParent(), String.valueOf(file.getName()) + ".bak");
            if (torrentBackup.exists()) {
                torrent = TOTorrentFactory.deserialiseFromBEncodedFile(torrentBackup);
            }
            throw e;
        }
        torrent.setAdditionalStringProperty("torrent filename", file.toString());
        if (create_delegate) {
            return new torrentDelegate(torrent, file);
        }
        return torrent;
    }

    public static void writeToFile(TOTorrent torrent) throws TOTorrentException {
        TorrentUtils.writeToFile(torrent, false);
    }

    public static void writeToFile(TOTorrent torrent, boolean force_backup) throws TOTorrentException {
        try {
            torrent.getMonitor().enter();
            torrent.getPieces();
            String str = torrent.getAdditionalStringProperty("torrent filename");
            if (str == null) {
                throw new TOTorrentException("TorrentUtils::writeToFile: no 'torrent filename' attribute defined", 1);
            }
            File torrent_file = new File(str);
            if ((force_backup || COConfigurationManager.getBooleanParameter("Save Torrent Backup", false)) && torrent_file.exists()) {
                File torrent_file_bak = new File(String.valueOf(str) + ".bak");
                try {
                    if (torrent_file_bak.exists()) {
                        torrent_file_bak.delete();
                    }
                    torrent_file.renameTo(torrent_file_bak);
                }
                catch (SecurityException e) {
                    Debug.printStackTrace(e);
                }
            }
            torrent.serialiseToBEncodedFile(torrent_file);
        }
        finally {
            torrent.getMonitor().exit();
        }
    }

    public static void writeToFile(TOTorrent torrent, File file) throws TOTorrentException {
        TorrentUtils.writeToFile(torrent, file, false);
    }

    public static void writeToFile(TOTorrent torrent, File file, boolean force_backup) throws TOTorrentException {
        torrent.setAdditionalStringProperty("torrent filename", file.toString());
        TorrentUtils.writeToFile(torrent, force_backup);
    }

    public static void copyToFile(TOTorrent torrent, File file) throws TOTorrentException {
        try {
            torrent.getMonitor().enter();
            torrent.getPieces();
            torrent.serialiseToBEncodedFile(file);
        }
        finally {
            torrent.getMonitor().exit();
        }
    }

    public static void delete(TOTorrent torrent) throws TOTorrentException {
        try {
            torrent.getMonitor().enter();
            String str = torrent.getAdditionalStringProperty("torrent filename");
            if (str == null) {
                throw new TOTorrentException("TorrentUtils::delete: no 'torrent filename' attribute defined", 1);
            }
            if (!new File(str).delete()) {
                throw new TOTorrentException("TorrentUtils::delete: failed to delete '" + str + "'", 5);
            }
            new File(String.valueOf(str) + ".bak").delete();
        }
        finally {
            torrent.getMonitor().exit();
        }
    }

    public static void delete(File torrent_file) {
        if (!torrent_file.delete()) {
            Debug.out("TorrentUtils::delete: failed to delete '" + torrent_file + "'");
        }
        new File(String.valueOf(torrent_file.toString()) + ".bak").delete();
    }

    public static boolean move(File from_torrent, File to_torrent) {
        if (!FileUtil.renameFile(from_torrent, to_torrent)) {
            return false;
        }
        if (new File(String.valueOf(from_torrent.toString()) + ".bak").exists()) {
            FileUtil.renameFile(new File(String.valueOf(from_torrent.toString()) + ".bak"), new File(String.valueOf(to_torrent.toString()) + ".bak"));
        }
        return true;
    }

    public static String exceptionToText(TOTorrentException e) {
        return TorrentUtils.exceptionToText(e, false);
    }

    public static String exceptionToText(TOTorrentException e, boolean verbose) {
        int reason = e.getReason();
        String errorDetail = reason == 1 ? MessageText.getString("DownloadManager.error.filenotfound") : (reason == 2 ? MessageText.getString("DownloadManager.error.fileempty") : (reason == 3 ? MessageText.getString("DownloadManager.error.filetoobig") : (reason == 6 ? String.valueOf(MessageText.getString("DownloadManager.error.filewithouttorrentinfo")) + " (" + e.getMessage() + ")" : (reason == 7 ? MessageText.getString("DownloadManager.error.unsupportedencoding") : (reason == 4 ? MessageText.getString("DownloadManager.error.ioerror") : (reason == 8 ? MessageText.getString("DownloadManager.error.sha1") : (reason == 9 ? MessageText.getString("DownloadManager.error.operationcancancelled") : e.getMessage())))))));
        if (verbose) {
            errorDetail = String.valueOf(errorDetail) + "(" + e.getMessage() + ")";
        }
        return errorDetail;
    }

    public static List announceGroupsToList(TOTorrent torrent) {
        ArrayList groups = new ArrayList();
        TOTorrentAnnounceURLGroup group = torrent.getAnnounceURLGroup();
        TOTorrentAnnounceURLSet[] sets = group.getAnnounceURLSets();
        if (sets.length == 0) {
            ArrayList<String> s = new ArrayList<String>();
            s.add(torrent.getAnnounceURL().toString());
            groups.add(s);
        } else {
            int i = 0;
            while (i < sets.length) {
                ArrayList<String> s = new ArrayList<String>();
                TOTorrentAnnounceURLSet set = sets[i];
                URL[] urls = set.getAnnounceURLs();
                int j = 0;
                while (j < urls.length) {
                    s.add(urls[j].toString());
                    ++j;
                }
                if (s.size() > 0) {
                    groups.add(s);
                }
                ++i;
            }
        }
        return groups;
    }

    public static void listToAnnounceGroups(List groups, TOTorrent torrent) {
        try {
            List set;
            TOTorrentAnnounceURLGroup tg = torrent.getAnnounceURLGroup();
            if (groups.size() == 1 && (set = (List)groups.get(0)).size() == 1) {
                torrent.setAnnounceURL(new URL((String)set.get(0)));
                tg.setAnnounceURLSets(new TOTorrentAnnounceURLSet[0]);
                return;
            }
            Vector<TOTorrentAnnounceURLSet> g = new Vector<TOTorrentAnnounceURLSet>();
            int i = 0;
            while (i < groups.size()) {
                List set2 = (List)groups.get(i);
                URL[] urls = new URL[set2.size()];
                int j = 0;
                while (j < set2.size()) {
                    urls[j] = new URL((String)set2.get(j));
                    ++j;
                }
                if (urls.length > 0) {
                    g.add(tg.createAnnounceURLSet(urls));
                }
                ++i;
            }
            Object[] sets = new TOTorrentAnnounceURLSet[g.size()];
            g.copyInto(sets);
            tg.setAnnounceURLSets((TOTorrentAnnounceURLSet[])sets);
            if (sets.length == 0) {
                torrent.setAnnounceURL(new URL("http://no.valid.urls.defined/announce"));
            }
        }
        catch (MalformedURLException e) {
            Debug.printStackTrace(e);
        }
    }

    public static void announceGroupsInsertFirst(TOTorrent torrent, String first_url) {
        try {
            TorrentUtils.announceGroupsInsertFirst(torrent, new URL(first_url));
        }
        catch (MalformedURLException e) {
            Debug.printStackTrace(e);
        }
    }

    public static void announceGroupsInsertFirst(TOTorrent torrent, URL first_url) {
        TorrentUtils.announceGroupsInsertFirst(torrent, new URL[]{first_url});
    }

    public static void announceGroupsInsertFirst(TOTorrent torrent, URL[] first_urls) {
        TOTorrentAnnounceURLGroup group = torrent.getAnnounceURLGroup();
        TOTorrentAnnounceURLSet[] sets = group.getAnnounceURLSets();
        TOTorrentAnnounceURLSet set1 = group.createAnnounceURLSet(first_urls);
        if (sets.length > 0) {
            TOTorrentAnnounceURLSet[] new_sets = new TOTorrentAnnounceURLSet[sets.length + 1];
            new_sets[0] = set1;
            System.arraycopy(sets, 0, new_sets, 1, sets.length);
            group.setAnnounceURLSets(new_sets);
        } else {
            TOTorrentAnnounceURLSet set2 = group.createAnnounceURLSet(new URL[]{torrent.getAnnounceURL()});
            group.setAnnounceURLSets(new TOTorrentAnnounceURLSet[]{set1, set2});
        }
    }

    public static void announceGroupsInsertLast(TOTorrent torrent, URL[] first_urls) {
        TOTorrentAnnounceURLGroup group = torrent.getAnnounceURLGroup();
        TOTorrentAnnounceURLSet[] sets = group.getAnnounceURLSets();
        TOTorrentAnnounceURLSet set1 = group.createAnnounceURLSet(first_urls);
        if (sets.length > 0) {
            TOTorrentAnnounceURLSet[] new_sets = new TOTorrentAnnounceURLSet[sets.length + 1];
            new_sets[sets.length] = set1;
            System.arraycopy(sets, 0, new_sets, 0, sets.length);
            group.setAnnounceURLSets(new_sets);
        } else {
            TOTorrentAnnounceURLSet set2 = group.createAnnounceURLSet(new URL[]{torrent.getAnnounceURL()});
            group.setAnnounceURLSets(new TOTorrentAnnounceURLSet[]{set2, set1});
        }
    }

    public static void announceGroupsSetFirst(TOTorrent torrent, String first_url) {
        List groups = TorrentUtils.announceGroupsToList(torrent);
        boolean found = false;
        int i = 0;
        block0: while (i < groups.size()) {
            List set = (List)groups.get(i);
            int j = 0;
            while (j < set.size()) {
                if (first_url.equals(set.get(j))) {
                    set.remove(j);
                    set.add(0, first_url);
                    groups.remove(set);
                    groups.add(0, set);
                    found = true;
                    break block0;
                }
                ++j;
            }
            ++i;
        }
        if (!found) {
            System.out.println("TorrentUtils::announceGroupsSetFirst - failed to find '" + first_url + "'");
        }
        TorrentUtils.listToAnnounceGroups(groups, torrent);
    }

    public static boolean mergeAnnounceURLs(TOTorrent new_torrent, TOTorrent dest_torrent) {
        if (new_torrent == null || dest_torrent == null) {
            return false;
        }
        List new_groups = TorrentUtils.announceGroupsToList(new_torrent);
        List dest_groups = TorrentUtils.announceGroupsToList(dest_torrent);
        ArrayList<List> groups_to_add = new ArrayList<List>();
        int i = 0;
        while (i < new_groups.size()) {
            List new_set = (List)new_groups.get(i);
            boolean match = false;
            int j = 0;
            while (j < dest_groups.size()) {
                boolean same;
                List dest_set = (List)dest_groups.get(j);
                boolean bl = same = new_set.size() == dest_set.size();
                if (same) {
                    int k = 0;
                    while (k < new_set.size()) {
                        String new_url = (String)new_set.get(k);
                        if (!dest_set.contains(new_url)) {
                            same = false;
                            break;
                        }
                        ++k;
                    }
                }
                if (same) {
                    match = true;
                    break;
                }
                ++j;
            }
            if (!match) {
                groups_to_add.add(new_set);
            }
            ++i;
        }
        if (groups_to_add.size() == 0) {
            return false;
        }
        i = 0;
        while (i < groups_to_add.size()) {
            dest_groups.add(i, groups_to_add.get(i));
            ++i;
        }
        TorrentUtils.listToAnnounceGroups(dest_groups, dest_torrent);
        return true;
    }

    public static void setResumeDataCompletelyValid(DownloadManagerState download_manager_state, String data_location) {
        DiskManagerFactory.setResumeDataCompletelyValid(download_manager_state, data_location);
    }

    public static String getLocalisedName(TOTorrent torrent) {
        try {
            LocaleUtilDecoder decoder = LocaleUtil.getSingleton().getTorrentEncodingIfAvailable(torrent);
            if (decoder == null) {
                return new String(torrent.getName(), "UTF8");
            }
            return decoder.decodeString(torrent.getName());
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
            return new String(torrent.getName());
        }
    }

    public static void setTLSTorrentHash(byte[] hash) {
        ((Map)tls.get()).put("hash", hash);
    }

    public static TOTorrent getTLSTorrent() {
        byte[] hash = (byte[])((Map)tls.get()).get("hash");
        if (hash != null) {
            try {
                AzureusCore core = AzureusCoreFactory.getSingleton();
                List managers = core.getGlobalManager().getDownloadManagers();
                int i = 0;
                while (i < managers.size()) {
                    DownloadManager dm = (DownloadManager)managers.get(i);
                    TOTorrent torrent = dm.getTorrent();
                    if (torrent != null && Arrays.equals(torrent.getHash(), hash)) {
                        return torrent;
                    }
                    ++i;
                }
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
        return null;
    }

    protected static class torrentDelegate
    implements TOTorrent {
        protected TOTorrent delegate;
        protected File file;
        protected long last_pieces_read_time = SystemTime.getCurrentTime();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected torrentDelegate(TOTorrent _delegate, File _file) {
            this.delegate = _delegate;
            this.file = _file;
            Map map = torrent_delegates;
            synchronized (map) {
                torrent_delegates.put(this, null);
            }
        }

        public byte[] getName() {
            return this.delegate.getName();
        }

        public boolean isSimpleTorrent() {
            return this.delegate.isSimpleTorrent();
        }

        public byte[] getComment() {
            return this.delegate.getComment();
        }

        public void setComment(String comment) {
            this.delegate.setComment(comment);
        }

        public long getCreationDate() {
            return this.delegate.getCreationDate();
        }

        public void setCreationDate(long date) {
            this.delegate.setCreationDate(date);
        }

        public byte[] getCreatedBy() {
            return this.delegate.getCreatedBy();
        }

        public URL getAnnounceURL() {
            return this.delegate.getAnnounceURL();
        }

        public void setAnnounceURL(URL url) {
            this.delegate.setAnnounceURL(url);
        }

        public TOTorrentAnnounceURLGroup getAnnounceURLGroup() {
            return this.delegate.getAnnounceURLGroup();
        }

        protected void checkTimeout(long now) {
            block7: {
                if (now < this.last_pieces_read_time) {
                    this.last_pieces_read_time = now;
                } else {
                    try {
                        if (now - this.last_pieces_read_time <= 180000L || this.delegate.getPieces() == null) break block7;
                        try {
                            this.getMonitor().enter();
                            this.delegate.setPieces(null);
                        }
                        finally {
                            this.getMonitor().exit();
                        }
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                    }
                }
            }
        }

        public byte[][] getPieces() throws TOTorrentException {
            byte[][] res = this.delegate.getPieces();
            this.last_pieces_read_time = SystemTime.getCurrentTime();
            if (res == null) {
                try {
                    this.getMonitor().enter();
                    TOTorrent temp = TorrentUtils.readFromFile(this.file, false);
                    res = temp.getPieces();
                    this.delegate.setPieces(res);
                }
                finally {
                    this.getMonitor().exit();
                }
            }
            return res;
        }

        public void setPieces(byte[][] pieces) throws TOTorrentException {
            throw new TOTorrentException("Unsupported Operation", 5);
        }

        public long getPieceLength() {
            return this.delegate.getPieceLength();
        }

        public int getNumberOfPieces() {
            return this.delegate.getNumberOfPieces();
        }

        public long getSize() {
            return this.delegate.getSize();
        }

        public TOTorrentFile[] getFiles() {
            return this.delegate.getFiles();
        }

        public byte[] getHash() throws TOTorrentException {
            return this.delegate.getHash();
        }

        public HashWrapper getHashWrapper() throws TOTorrentException {
            return this.delegate.getHashWrapper();
        }

        public boolean hasSameHashAs(TOTorrent other) {
            return this.delegate.hasSameHashAs(other);
        }

        public void setAdditionalStringProperty(String name, String value) {
            this.delegate.setAdditionalStringProperty(name, value);
        }

        public String getAdditionalStringProperty(String name) {
            return this.delegate.getAdditionalStringProperty(name);
        }

        public void setAdditionalByteArrayProperty(String name, byte[] value) {
            this.delegate.setAdditionalByteArrayProperty(name, value);
        }

        public byte[] getAdditionalByteArrayProperty(String name) {
            return this.delegate.getAdditionalByteArrayProperty(name);
        }

        public void setAdditionalLongProperty(String name, Long value) {
            this.delegate.setAdditionalLongProperty(name, value);
        }

        public Long getAdditionalLongProperty(String name) {
            return this.delegate.getAdditionalLongProperty(name);
        }

        public void setAdditionalListProperty(String name, List value) {
            this.delegate.setAdditionalListProperty(name, value);
        }

        public List getAdditionalListProperty(String name) {
            return this.delegate.getAdditionalListProperty(name);
        }

        public void setAdditionalMapProperty(String name, Map value) {
            this.delegate.setAdditionalMapProperty(name, value);
        }

        public Map getAdditionalMapProperty(String name) {
            return this.delegate.getAdditionalMapProperty(name);
        }

        public Object getAdditionalProperty(String name) {
            return this.delegate.getAdditionalProperty(name);
        }

        public void setAdditionalProperty(String name, Object value) {
            this.delegate.setAdditionalProperty(name, value);
        }

        public void removeAdditionalProperty(String name) {
            this.delegate.removeAdditionalProperty(name);
        }

        public void removeAdditionalProperties() {
            this.delegate.removeAdditionalProperties();
        }

        public void serialiseToBEncodedFile(File target_file) throws TOTorrentException {
            try {
                this.getMonitor().enter();
                this.getPieces();
                this.delegate.serialiseToBEncodedFile(target_file);
            }
            finally {
                this.getMonitor().exit();
            }
        }

        public Map serialiseToMap() throws TOTorrentException {
            try {
                this.getMonitor().enter();
                this.getPieces();
                Map map = this.delegate.serialiseToMap();
                this.getMonitor().exit();
                return map;
            }
            catch (Throwable throwable) {
                this.getMonitor().exit();
                throw throwable;
            }
        }

        public void serialiseToXMLFile(File target_file) throws TOTorrentException {
            try {
                this.getMonitor().enter();
                this.getPieces();
                this.delegate.serialiseToXMLFile(target_file);
            }
            finally {
                this.getMonitor().exit();
            }
        }

        public AEMonitor getMonitor() {
            return this.delegate.getMonitor();
        }

        public void print() {
            this.delegate.print();
        }
    }
}

