/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.util.Properties;
import org.gudy.azureus2.core3.internat.LocaleUtil;
import org.gudy.azureus2.core3.logging.LGLogger;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.platform.PlatformManagerFactory;

public class SystemProperties {
    public static final String SYS_PROP_CONFIG_OVERRIDE = "azureus.config.path";
    public static final String SEP = System.getProperty("file.separator");
    private static final String AZ_DIR = "Azureus";
    private static final String WIN_DEFAULT = "Application Data";
    private static final String OSX_DEFAULT = "Library" + SEP + "Application Support";
    private static String user_path = null;

    public static String getUserPath() {
        if (user_path != null) {
            return user_path;
        }
        user_path = System.getProperty(SYS_PROP_CONFIG_OVERRIDE);
        if (user_path != null) {
            File dir;
            if (!user_path.endsWith(SEP)) {
                user_path = String.valueOf(user_path) + SEP;
            }
            if (!(dir = new File(user_path)).exists()) {
                dir.mkdirs();
            }
            LGLogger.log(10, "SystemProperties::getUserPath(Custom): user_path = " + user_path);
            return user_path;
        }
        String userhome = System.getProperty("user.home");
        if (Constants.isWindows) {
            try {
                user_path = PlatformManagerFactory.getPlatformManager().getUserDataDirectory();
                LGLogger.log(10, "Using user config path from registry: " + user_path);
            }
            catch (Throwable e) {
                LGLogger.log(10, "Unable to retrieve user config path from registry. Make sure aereg.dll is present.");
                user_path = SystemProperties.getEnvironmentalVariable("APPDATA");
                if (user_path != null && user_path.length() > 0) {
                    LGLogger.log(10, "Using user config path from APPDATA env var instead: " + user_path);
                }
                user_path = String.valueOf(userhome) + SEP + WIN_DEFAULT;
                LGLogger.log(10, "Using user config path from java user.home var instead: " + user_path);
            }
            user_path = String.valueOf(user_path) + SEP + AZ_DIR + SEP;
            LGLogger.log(10, "SystemProperties::getUserPath(Win): user_path = " + user_path);
        } else if (Constants.isOSX) {
            user_path = String.valueOf(userhome) + SEP + OSX_DEFAULT + SEP + AZ_DIR + SEP;
            LGLogger.log(10, "SystemProperties::getUserPath(Mac): user_path = " + user_path);
        } else {
            user_path = String.valueOf(userhome) + SEP + "." + AZ_DIR + SEP;
            LGLogger.log(10, "SystemProperties::getUserPath(Unix): user_path = " + user_path);
        }
        File dir = new File(user_path);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        return user_path;
    }

    public static String getApplicationPath() {
        String sDir = System.getProperty("azureus.install.path", System.getProperty("user.dir"));
        if (sDir.endsWith(SEP)) {
            return sDir;
        }
        return String.valueOf(sDir) + SEP;
    }

    public static boolean isJavaWebStartInstance() {
        try {
            String java_ws_prop = System.getProperty("azureus.javaws");
            return java_ws_prop != null && java_ws_prop.equals("true");
        }
        catch (Throwable e) {
            return false;
        }
    }

    public static String getEnvironmentalVariable(String _var) {
        Properties envVars;
        block6: {
            Process p = null;
            envVars = new Properties();
            Runtime r = Runtime.getRuntime();
            BufferedReader br = null;
            if (Constants.isWindows9598ME) {
                return "";
            }
            try {
                String line;
                p = Constants.isWindows ? r.exec("cmd.exe /c set") : r.exec("env");
                String system_encoding = LocaleUtil.getSingleton().getSystemEncoding();
                LGLogger.log(10, "SystemProperties::getEnvironmentalVariable - " + _var + ", system encoding = " + system_encoding);
                br = new BufferedReader(new InputStreamReader(p.getInputStream(), system_encoding), 8192);
                while ((line = br.readLine()) != null) {
                    int idx = line.indexOf(61);
                    if (idx < 0) continue;
                    String key = line.substring(0, idx);
                    String value = line.substring(idx + 1);
                    envVars.setProperty(key, value);
                }
                br.close();
            }
            catch (Throwable t) {
                if (br == null) break block6;
                try {
                    br.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return envVars.getProperty(_var, "");
    }
}

