/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.tracker.server.impl;

import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.logging.LGLogger;
import org.gudy.azureus2.core3.tracker.server.impl.TRTrackerServerNatCheckerListener;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.ThreadPool;
import org.gudy.azureus2.core3.util.ThreadPoolTask;

public class TRTrackerServerNATChecker {
    protected static TRTrackerServerNATChecker singleton = new TRTrackerServerNATChecker();
    protected static final int THREAD_POOL_SIZE = 32;
    protected static final int CHECK_QUEUE_LIMIT = 2048;
    protected static int check_timeout = 15000;
    protected boolean enabled;
    protected ThreadPool thread_pool;
    protected List check_queue = new ArrayList();
    protected AESemaphore check_queue_sem = new AESemaphore("TracerServerNATChecker");
    protected AEMonitor check_queue_mon = new AEMonitor("TRTrackerServerNATChecker:Q");
    protected AEMonitor this_mon = new AEMonitor("TRTrackerServerNATChecker");

    protected static TRTrackerServerNATChecker getSingleton() {
        return singleton;
    }

    protected TRTrackerServerNATChecker() {
        String enable_param = "Tracker NAT Check Enable";
        String timeout_param = "Tracker NAT Check Timeout";
        String[] params = new String[]{"Tracker NAT Check Enable", "Tracker NAT Check Timeout"};
        int i = 0;
        while (i < params.length) {
            COConfigurationManager.addParameterListener(params[i], new ParameterListener(){

                public void parameterChanged(String parameter_name) {
                    TRTrackerServerNATChecker.this.checkConfig("Tracker NAT Check Enable", "Tracker NAT Check Timeout");
                }
            });
            ++i;
        }
        this.checkConfig("Tracker NAT Check Enable", "Tracker NAT Check Timeout");
    }

    protected boolean isEnabled() {
        return this.enabled;
    }

    protected void checkConfig(String enable_param, String timeout_param) {
        try {
            this.this_mon.enter();
            this.enabled = COConfigurationManager.getBooleanParameter(enable_param);
            check_timeout = COConfigurationManager.getIntParameter(timeout_param) * 1000;
            if (check_timeout < 1000) {
                Debug.out("NAT check timeout too small - " + check_timeout);
                check_timeout = 1000;
            }
            if (this.thread_pool == null) {
                this.thread_pool = new ThreadPool("Tracker NAT Checker", 32);
                this.thread_pool.setExecutionLimit(check_timeout);
                AEThread dispatcher_thread = new AEThread("Tracker NAT Checker Dispatcher"){

                    public void runSupport() {
                        while (true) {
                            ThreadPoolTask task;
                            TRTrackerServerNATChecker.this.check_queue_sem.reserve();
                            try {
                                TRTrackerServerNATChecker.this.check_queue_mon.enter();
                                task = (ThreadPoolTask)TRTrackerServerNATChecker.this.check_queue.remove(0);
                            }
                            finally {
                                TRTrackerServerNATChecker.this.check_queue_mon.exit();
                            }
                            try {
                                TRTrackerServerNATChecker.this.thread_pool.run(task);
                                continue;
                            }
                            catch (Throwable e) {
                                Debug.printStackTrace(e);
                                continue;
                            }
                            break;
                        }
                    }
                };
                dispatcher_thread.setDaemon(true);
                dispatcher_thread.start();
            } else {
                this.thread_pool.setExecutionLimit(check_timeout);
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    protected boolean addNATCheckRequest(final String host, final int port, final TRTrackerServerNatCheckerListener listener) {
        if (!this.enabled || this.thread_pool == null) {
            return false;
        }
        try {
            this.check_queue_mon.enter();
            if (this.check_queue.size() > 2048) {
                LGLogger.log("NAT Check queue size too large, check for '" + host + ":" + port + "' skipped");
                listener.NATCheckComplete(true);
            } else {
                this.check_queue.add(new ThreadPoolTask(){
                    protected Socket socket;

                    public void runSupport() {
                        boolean ok = false;
                        try {
                            try {
                                InetSocketAddress address = new InetSocketAddress(host, port);
                                this.socket = new Socket();
                                this.socket.connect(address, check_timeout);
                                ok = true;
                                this.socket.close();
                                this.socket = null;
                            }
                            catch (Throwable throwable) {}
                        }
                        finally {
                            listener.NATCheckComplete(ok);
                            if (this.socket != null) {
                                try {
                                    this.socket.close();
                                }
                                catch (Throwable throwable) {}
                            }
                        }
                    }

                    public void interruptTask() {
                        if (this.socket != null) {
                            try {
                                this.socket.close();
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }
                    }
                });
                this.check_queue_sem.release();
            }
        }
        finally {
            this.check_queue_mon.exit();
        }
        return true;
    }
}

