/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.tracker.client.classic;

import java.net.URL;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.tracker.client.TRTrackerClient;
import org.gudy.azureus2.core3.tracker.client.TRTrackerScraper;
import org.gudy.azureus2.core3.tracker.client.TRTrackerScraperClientResolver;
import org.gudy.azureus2.core3.tracker.client.TRTrackerScraperListener;
import org.gudy.azureus2.core3.tracker.client.TRTrackerScraperResponse;
import org.gudy.azureus2.core3.tracker.client.classic.TRTrackerScraperResponseImpl;
import org.gudy.azureus2.core3.tracker.client.classic.TrackerChecker;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.ListenerManager;
import org.gudy.azureus2.core3.util.ListenerManagerDispatcher;

public class TRTrackerScraperImpl
implements TRTrackerScraper {
    protected static TRTrackerScraperImpl singleton;
    protected static AEMonitor class_mon;
    protected TrackerChecker tracker_checker;
    protected TRTrackerScraperClientResolver client_resolver;
    private static final int LDT_SCRAPE_RECEIVED = 1;
    private ListenerManager listeners = ListenerManager.createManager("TrackerScraper:ListenDispatcher", new ListenerManagerDispatcher(){

        public void dispatch(Object _listener, int type, Object value) {
            TRTrackerScraperListener listener = (TRTrackerScraperListener)_listener;
            listener.scrapeReceived((TRTrackerScraperResponse)value);
        }
    });

    static {
        class_mon = new AEMonitor("TRTrackerScraper");
    }

    public static TRTrackerScraperImpl create() {
        try {
            class_mon.enter();
            if (singleton == null) {
                singleton = new TRTrackerScraperImpl();
            }
            TRTrackerScraperImpl tRTrackerScraperImpl = singleton;
            class_mon.exit();
            return tRTrackerScraperImpl;
        }
        catch (Throwable throwable) {
            class_mon.exit();
            throw throwable;
        }
    }

    protected TRTrackerScraperImpl() {
        this.tracker_checker = new TrackerChecker(this);
    }

    public TRTrackerScraperResponse scrape(TOTorrent torrent) {
        return this.scrape(torrent, false);
    }

    public TRTrackerScraperResponse scrape(TOTorrent torrent, URL target_url) {
        return this.scrape(torrent, target_url, false);
    }

    public TRTrackerScraperResponse scrape(TOTorrent torrent, boolean force) {
        return this.scrape(torrent, null, force);
    }

    public TRTrackerScraperResponse scrape(TOTorrent torrent, URL target_url, boolean force) {
        if (torrent == null) {
            return null;
        }
        if (force) {
            this.tracker_checker.syncUpdate(torrent, target_url);
        }
        TRTrackerScraperResponseImpl res = this.tracker_checker.getHashData(torrent, target_url);
        return res;
    }

    public TRTrackerScraperResponse scrape(TRTrackerClient tracker_client) {
        TRTrackerScraperResponseImpl res = this.tracker_checker.getHashData(tracker_client);
        return res;
    }

    public void remove(TOTorrent torrent) {
        this.tracker_checker.removeHash(torrent);
    }

    protected void scrapeReceived(TRTrackerScraperResponse response) {
        this.listeners.dispatch(1, response);
    }

    public void setClientResolver(TRTrackerScraperClientResolver resolver) {
        this.client_resolver = resolver;
    }

    protected boolean isTorrentDownloading(byte[] hash) {
        if (this.client_resolver == null) {
            return false;
        }
        return this.client_resolver.getClient(hash) != null;
    }

    public void addListener(TRTrackerScraperListener l) {
        this.listeners.addListener(l);
    }

    public void removeListener(TRTrackerScraperListener l) {
        this.listeners.removeListener(l);
    }
}

