/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.peer.util;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.gudy.azureus2.core3.peer.util.PeerIdentityDataID;
import org.gudy.azureus2.core3.util.AEMonitor;

public class PeerIdentityManager {
    private static final AEMonitor class_mon = new AEMonitor("PeerIdentityManager:class");
    private static final Map dataMap = new HashMap();
    private static int totalIDs = 0;

    public static PeerIdentityDataID createDataID(byte[] data) {
        HashMap peerMap;
        PeerIdentityDataID data_id = new PeerIdentityDataID(data);
        try {
            class_mon.enter();
            peerMap = (HashMap)dataMap.get(data_id);
            if (peerMap == null) {
                peerMap = new HashMap();
                dataMap.put(data_id, peerMap);
            }
        }
        finally {
            class_mon.exit();
        }
        data_id.setPeerMap(peerMap);
        return data_id;
    }

    public static void addIdentity(PeerIdentityDataID data_id, byte[] peer_id, String ip) {
        PeerIdentity peerID = new PeerIdentity(peer_id);
        try {
            String old;
            class_mon.enter();
            HashMap<PeerIdentity, String> peerMap = (HashMap<PeerIdentity, String>)dataMap.get(data_id);
            if (peerMap == null) {
                peerMap = new HashMap<PeerIdentity, String>();
                dataMap.put(data_id, peerMap);
            }
            if ((old = peerMap.put(peerID, ip)) == null) {
                ++totalIDs;
            }
        }
        finally {
            class_mon.exit();
        }
    }

    public static void removeIdentity(PeerIdentityDataID data_id, byte[] peer_id) {
        try {
            PeerIdentity peerID;
            Object old;
            class_mon.enter();
            Map peerMap = (Map)dataMap.get(data_id);
            if (peerMap != null && (old = peerMap.remove(peerID = new PeerIdentity(peer_id))) != null) {
                --totalIDs;
            }
        }
        finally {
            class_mon.exit();
        }
    }

    public static boolean containsIdentity(PeerIdentityDataID data_id, byte[] peer_id) {
        PeerIdentity peerID = new PeerIdentity(peer_id);
        try {
            class_mon.enter();
            Map peerMap = (Map)dataMap.get(data_id);
            if (peerMap != null && peerMap.containsKey(peerID)) {
                class_mon.exit();
                return true;
            }
        }
        finally {
            class_mon.exit();
        }
        return false;
    }

    public static int getTotalIdentityCount() {
        return totalIDs;
    }

    public static int getIdentityCount(PeerIdentityDataID data_id) {
        return data_id.getPeerMap().size();
    }

    public static boolean containsIPAddress(PeerIdentityDataID data_id, String ip) {
        try {
            class_mon.enter();
            Map peerMap = (Map)dataMap.get(data_id);
            if (peerMap != null && peerMap.containsValue(ip)) {
                class_mon.exit();
                return true;
            }
        }
        finally {
            class_mon.exit();
        }
        return false;
    }

    private static class PeerIdentity {
        private final byte[] id;
        private final int hashcode;

        PeerIdentity(byte[] _id) {
            this.id = _id;
            this.hashcode = new String(this.id).hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj != null && obj instanceof PeerIdentity) {
                PeerIdentity other = (PeerIdentity)obj;
                return Arrays.equals(this.id, other.id);
            }
            return false;
        }

        public int hashCode() {
            return this.hashcode;
        }
    }
}

